/*
 * Decompiled with CFR 0.152.
 */
package javaxt.encryption;

import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AES256 {
    private static String err = "Please install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files.";

    private AES256() {
    }

    public static byte[] encrypt(String text, String password) throws Exception {
        try {
            SecureRandom rand = new SecureRandom();
            byte[] salt = new byte[32];
            rand.nextBytes(salt);
            SecretKey secret = AES256.getSecretKey(password, salt);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] b = cipher.doFinal(text.getBytes("UTF-8"));
            byte[] ret = new byte[salt.length + iv.length + b.length];
            System.arraycopy(salt, 0, ret, 0, salt.length);
            System.arraycopy(iv, 0, ret, salt.length, iv.length);
            System.arraycopy(b, 0, ret, salt.length + iv.length, b.length);
            return ret;
        }
        catch (InvalidKeyException e) {
            if (e.getMessage().equals("Illegal key size")) {
                throw new InvalidKeyException(err);
            }
            throw e;
        }
    }

    public static String decrypt(byte[] bytes, String password) throws Exception {
        try {
            byte[] salt = new byte[32];
            byte[] iv = new byte[16];
            byte[] b = new byte[bytes.length - salt.length - iv.length];
            System.arraycopy(bytes, 0, salt, 0, salt.length);
            System.arraycopy(bytes, 32, iv, 0, iv.length);
            System.arraycopy(bytes, 48, b, 0, b.length);
            SecretKey secret = AES256.getSecretKey(password, salt);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return new String(cipher.doFinal(b), "UTF-8");
        }
        catch (InvalidKeyException e) {
            if (e.getMessage().equals("Illegal key size")) {
                throw new InvalidKeyException(err);
            }
            throw e;
        }
    }

    private static SecretKey getSecretKey(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException, UnsupportedEncodingException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }
}

