/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javaxt.html.Input;
import javaxt.http.Response;
import javaxt.io.File;
import javaxt.utils.Base64;
import javaxt.utils.URL;

public class Request {
    private URLConnection conn = null;
    private Proxy HttpProxy;
    private java.net.URL url;
    private java.net.URL orgURL;
    private int connectionTimeout = 0;
    protected int readTimeout = 0;
    private boolean useCache = false;
    private int maxRedirects = 5;
    private String username;
    private String password;
    private String method;
    private Map<String, List<String>> requestHeaders = null;
    private HashMap<String, List<String>> RequestProperties = new HashMap();
    private Map<String, List<String>> headers = null;
    private String protocol;
    private String version;
    private int responseCode;
    private String message;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private boolean validateCertificates = true;

    public Request clone() {
        Request request = new Request(this.orgURL);
        request.HttpProxy = this.HttpProxy;
        request.connectionTimeout = this.connectionTimeout;
        request.readTimeout = this.readTimeout;
        request.useCache = this.useCache;
        request.maxRedirects = this.maxRedirects;
        request.username = this.username;
        request.password = this.password;
        request.requestHeaders = this.requestHeaders;
        request.RequestProperties = this.RequestProperties;
        request.method = this.method;
        return request;
    }

    public Request(String url) {
        this(url, null);
    }

    public Request(String url, String httpProxy) {
        this(Request.getURL(url), httpProxy);
    }

    public Request(java.net.URL url) {
        this(url, null);
    }

    public Request(java.net.URL url, String httpProxy) {
        this.url = this.orgURL = url;
        this.setProxy(httpProxy);
        this.initHeaders();
    }

    private static java.net.URL getURL(String url) {
        try {
            return new java.net.URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void initHeaders() {
        this.setUseCache(false);
        this.setHeader("Accept", "*/*");
        this.setHeader("Accept-Encoding", "gzip,deflate");
        this.setHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        this.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:60.0) Gecko/20100101 Firefox/60.0");
    }

    public void setURL(java.net.URL url) {
        this.url = url;
        this.orgURL = url;
    }

    public java.net.URL getURL() {
        return this.url;
    }

    public java.net.URL getInitialURL() {
        return this.orgURL;
    }

    public void setRequestMethod(String method) {
        if (method != null) {
            if ((method = method.trim()).equalsIgnoreCase("DELETE")) {
                method = "DELETE";
            } else if (method.equalsIgnoreCase("PUT")) {
                method = "PUT";
            }
            this.method = method;
        }
    }

    public Response getResponse() {
        if (this.conn == null) {
            this.conn = this.getConnection(false);
        }
        return new Response(this, this.conn);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void validateSSLCertificates(boolean validateCertificates) {
        this.validateCertificates = validateCertificates;
    }

    public void setNumRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private String getCredentials() throws Exception {
        if (this.username == null || this.password == null) {
            return null;
        }
        return Base64.encode(this.username + ":" + this.password, 8);
    }

    public void setConnectTimeout(int timeout) {
        if (timeout > 0) {
            this.connectionTimeout = timeout;
        }
    }

    public void setReadTimeout(int timeout) {
        if (this.readTimeout > 0) {
            this.readTimeout = timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream payload) {
        if (this.conn == null) {
            this.conn = this.getConnection(true);
        }
        OutputStream output = null;
        try {
            output = this.conn.getOutputStream();
            byte[] buf = new byte[8192];
            int i = 0;
            while ((i = payload.read(buf)) != -1) {
                output.write(buf, 0, i);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception exception) {}
        }
        this.parseResponse(this.conn);
    }

    public void write(String payload) {
        this.write(payload.getBytes());
    }

    public void write(byte[] payload) {
        this.setHeader("Content-Length", payload.length + "");
        if (this.conn == null) {
            this.conn = this.getConnection(true);
        }
        try {
            this.conn.getOutputStream().write(payload);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parseResponse(this.conn);
    }

    public void write(Input[] inputs) {
        block14: {
            String boundary = "---------------------------";
            for (int i = 0; i < 14; ++i) {
                boundary = boundary + new Random().nextInt(10);
            }
            int boundarySize = boundary.length();
            try {
                long size = 0L;
                ArrayList<byte[]> metadata = new ArrayList<byte[]>();
                for (int i = 0; i < inputs.length; ++i) {
                    Input input = inputs[i];
                    String contentType = "";
                    String fileName = "";
                    long inputLength = 0L;
                    if (input.isFile()) {
                        File file = (File)input.getValue();
                        fileName = "; filename=\"" + file.getName() + "\"";
                        contentType = "Content-Type: " + file.getContentType() + "\r\n";
                        inputLength = file.getSize();
                    } else {
                        inputLength = input.getSize();
                    }
                    String contentDisposition = "Content-Disposition: form-data; name=\"" + input.getName() + "\"" + fileName;
                    byte[] md = (contentDisposition + "\r\n" + contentType + "\r\n").getBytes("UTF-8");
                    metadata.add(md);
                    size += (long)((i > 0 ? 2 : 0) + 2 + boundarySize + 2);
                    size += (long)md.length + inputLength;
                }
                this.setHeader("Content-Type", "multipart/form-data; boundary=" + boundary);
                this.setHeader("Content-Length", (size += (long)(boundarySize + 8)) + "");
                if (this.conn == null) {
                    this.conn = this.getConnection(true);
                }
                OutputStream outputStream = null;
                try {
                    outputStream = this.conn.getOutputStream();
                    for (int i = 0; i < inputs.length; ++i) {
                        byte[] bd = ((i > 0 ? "\r\n" : "") + "--" + boundary + "\r\n").getBytes("UTF-8");
                        byte[] md = (byte[])metadata.get(i);
                        outputStream.write(bd);
                        outputStream.write(md);
                        if (inputs[i].isFile()) {
                            File file = (File)inputs[i].getValue();
                            FileInputStream inputStream = file.getInputStream();
                            byte[] b = new byte[1024];
                            int x = 0;
                            while ((x = ((InputStream)inputStream).read(b)) != -1) {
                                outputStream.write(b, 0, x);
                            }
                            ((InputStream)inputStream).close();
                            continue;
                        }
                        outputStream.write(inputs[i].toByteArray());
                    }
                    byte[] bd = ("\r\n--" + boundary + "--\r\n").getBytes("UTF-8");
                    outputStream.write(bd);
                    outputStream.close();
                }
                catch (IOException e) {
                    if (outputStream == null) break block14;
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.parseResponse(this.conn);
    }

    public List<String> getHeader(String key) {
        for (String currKey : this.RequestProperties.keySet()) {
            if (!key.equalsIgnoreCase(currKey)) continue;
            return this.RequestProperties.get(currKey);
        }
        return null;
    }

    public void setHeader(String key, String value) {
        boolean foundProperty = false;
        for (String currKey : this.RequestProperties.keySet()) {
            if (!key.equalsIgnoreCase(currKey)) continue;
            foundProperty = true;
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.RequestProperties.put(currKey, values);
            break;
        }
        if (!foundProperty) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.RequestProperties.put(key, values);
        }
    }

    public void addHeader(String key, String value) {
        if (key.equalsIgnoreCase("If-None-Match") || key.equalsIgnoreCase("If-Modified-Since") && value != null) {
            this.useCache = true;
        }
        boolean foundProperty = false;
        for (String currKey : this.RequestProperties.keySet()) {
            if (!key.equalsIgnoreCase(currKey)) continue;
            foundProperty = true;
            List<String> values = this.RequestProperties.get(currKey);
            if (values == null) {
                values = new ArrayList<String>();
            }
            values.add(value);
            this.RequestProperties.put(currKey, values);
            break;
        }
        if (!foundProperty) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.RequestProperties.put(key, values);
        }
    }

    private URLConnection connect(boolean doOutput) {
        try {
            String credentials;
            HttpURLConnection con;
            boolean ssl = this.url.getProtocol().equalsIgnoreCase("https");
            if (ssl) {
                String sslProtocols;
                String[] arr = System.getProperty("java.version").split("\\.");
                StringBuilder stringBuilder = new StringBuilder();
                if (Double.valueOf(stringBuilder.append(arr[0]).append(".").append(arr[1]).toString()) < 1.7 && (sslProtocols = System.getProperty("https.protocols")) == null) {
                    System.setProperty("https.protocols", "TLSv1,SSLv3");
                }
            }
            if (ssl && !this.validateCertificates) {
                try {
                    SSLContext sc = SSLContext.getInstance("TLS");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                catch (Exception sc) {
                    // empty catch block
                }
            }
            this.url = new URL(this.url).toURL();
            URLConnection conn = this.HttpProxy == null || this.isLocalHost(this.url.getHost()) ? this.url.openConnection() : this.url.openConnection(this.HttpProxy);
            if (this.method != null) {
                con = (HttpsURLConnection)conn;
                con.setRequestMethod(this.method);
            }
            if (this.connectionTimeout > 0) {
                new Thread(new ConnectTimeout(conn)).start();
                conn.setConnectTimeout(this.connectionTimeout);
            }
            if (this.readTimeout > 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (ssl) {
                con = (HttpsURLConnection)conn;
                con.setInstanceFollowRedirects(false);
            } else {
                con = (HttpURLConnection)conn;
                con.setInstanceFollowRedirects(false);
            }
            if (ssl && !this.validateCertificates) {
                con = (HttpsURLConnection)conn;
                ((HttpsURLConnection)con).setHostnameVerifier(DO_NOT_VERIFY);
            }
            conn.setUseCaches(this.useCache);
            if (doOutput) {
                conn.setDoOutput(true);
            }
            if ((credentials = this.getCredentials()) != null) {
                conn.setRequestProperty("Authorization", "Basic " + credentials);
            }
            for (String key : this.RequestProperties.keySet()) {
                List<String> values = this.RequestProperties.get(key);
                if (values == null) continue;
                if (values.size() == 1) {
                    conn.setRequestProperty(key, values.iterator().next());
                    continue;
                }
                Iterator<String> value = values.iterator();
                while (value.hasNext()) {
                    conn.addRequestProperty(key, value.next());
                }
            }
            return conn;
        }
        catch (Exception e) {
            return null;
        }
    }

    private URLConnection getConnection(boolean doOutput) {
        if (doOutput && this.maxRedirects < 1) {
            URLConnection conn = this.connect(true);
            this.requestHeaders = conn.getRequestProperties();
            return conn;
        }
        this.conn = null;
        URLConnection conn = this.connect(false);
        if (conn != null) {
            this.requestHeaders = conn.getRequestProperties();
            this.parseResponse(conn);
            if (this.responseCode >= 300 && this.responseCode < 400 && this.maxRedirects > 0) {
                int numRedirects = 0;
                while (!(this.responseCode < 300 || this.responseCode >= 400 || this.useCache && this.responseCode == 304)) {
                    String location = this.getResponseHeader("Location");
                    URL newUrl = new URL(location);
                    if (newUrl.getProtocol() == null) {
                        URL url = new URL(this.url);
                        url.setPath(location);
                        this.url = url.toURL();
                    } else {
                        this.url = newUrl.toURL();
                    }
                    try {
                        conn = this.connect(false);
                        this.parseResponse(conn);
                        if (++numRedirects <= this.maxRedirects) continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }
        if (doOutput) {
            conn = this.connect(true);
            this.requestHeaders = conn.getRequestProperties();
        }
        return conn;
    }

    private void parseResponse(URLConnection conn) {
        List<String> status;
        this.protocol = "";
        this.version = "";
        this.responseCode = -1;
        this.message = "";
        this.headers = conn.getHeaderFields();
        if (!this.headers.isEmpty() && (status = this.headers.get(null)) != null) {
            StringTokenizer st = new StringTokenizer(status.get(0));
            if (st.hasMoreTokens()) {
                this.protocol = st.nextToken().trim().toUpperCase();
            }
            if (this.protocol.contains("/")) {
                String temp = this.protocol;
                this.protocol = temp.substring(0, temp.indexOf("/"));
                this.version = temp.substring(temp.indexOf("/") + 1);
            } else {
                this.protocol = "HTTP";
                this.version = "1.1";
            }
            if (st.hasMoreTokens()) {
                this.responseCode = Integer.valueOf(st.nextToken().trim());
            }
            if (st.hasMoreTokens()) {
                this.message = "";
                while (st.hasMoreTokens()) {
                    this.message = this.message + st.nextToken() + " ";
                }
                this.message = this.message.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getExpiration(URLConnection connection, long baseTime) {
        String expires;
        Object token;
        SimpleDateFormat PATTERN_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String cacheControl = connection.getHeaderField("Cache-Control");
        if (cacheControl != null) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                int eqIdx;
                token = tok.nextToken().trim().toLowerCase();
                if ("must-revalidate".equals(token)) {
                    return new Long(0L);
                }
                if (!((String)token).startsWith("max-age") || (eqIdx = ((String)token).indexOf(61)) == -1) continue;
                String value = ((String)token).substring(eqIdx + 1).trim();
                try {
                    int seconds = Integer.parseInt(value);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    System.err.println("getExpiration(): Bad Cache-Control max-age value: " + value);
                }
            }
        }
        if ((expires = connection.getHeaderField("Expires")) != null) {
            try {
                token = PATTERN_RFC1123;
                synchronized (token) {
                    Date expDate = PATTERN_RFC1123.parse(expires);
                    return new Long(expDate.getTime());
                }
            }
            catch (ParseException pe) {
                try {
                    int seconds = Integer.parseInt(expires);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    System.err.println("getExpiration(): Bad Expires header value: " + expires);
                }
            }
        }
        return null;
    }

    protected int getResponseCode() {
        return this.responseCode;
    }

    protected String getResponseMessage() {
        return this.message;
    }

    protected Map<String, List<String>> getResponseHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders != null) {
            return this.requestHeaders;
        }
        return this.RequestProperties;
    }

    protected String[] getResponseHeaders(String headerName) {
        if (this.headers == null) {
            return new String[0];
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String key : this.headers.keySet()) {
            if (key == null || !key.equalsIgnoreCase(headerName)) continue;
            List<String> list = this.headers.get(key);
            Iterator<String> val = list.iterator();
            while (val.hasNext()) {
                values.add(val.next());
            }
        }
        return values.toArray(new String[values.size()]);
    }

    protected String getResponseHeader(String headerName) {
        String[] arr = this.getResponseHeaders(headerName);
        if (arr.length > 0) {
            return this.getResponseHeaders(headerName)[0];
        }
        return null;
    }

    public String getProxy() {
        if (this.HttpProxy == null) {
            return null;
        }
        InetSocketAddress sa = (InetSocketAddress)this.HttpProxy.address();
        String proxy = sa.toString();
        if (proxy.startsWith("/") && proxy.length() > 1) {
            proxy = proxy.substring(1);
        }
        return proxy;
    }

    public Proxy setProxy(String proxyHost, int proxyPort) {
        InetSocketAddress proxyAddr = InetSocketAddress.createUnresolved(proxyHost, proxyPort);
        this.HttpProxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        return this.HttpProxy;
    }

    public Proxy setProxy(String httpProxy) {
        if (httpProxy != null && httpProxy.length() > 0) {
            String[] arr = httpProxy.split(":");
            String httpHost = arr[0];
            int httpPort = 80;
            if (arr.length > 0) {
                httpPort = Integer.valueOf(arr[1]);
            }
            return this.setProxy(httpHost, httpPort);
        }
        return null;
    }

    public void setProxy(Proxy httpProxy) {
        this.HttpProxy = httpProxy;
    }

    public boolean isProxyAvailable(String proxyHost, int proxyPort) {
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            System.out.println("Name: " + address.getHostName());
            System.out.println("Addr: " + address.getHostAddress());
            System.out.println("Reach: " + address.isReachable(3000));
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalHost(String host) {
        return (host = host.toLowerCase()).equals("localhost") || host.equals("127.0.0.1");
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append(this.url + "\r\n");
        Map<String, List<String>> requestHeaders = this.getRequestHeaders();
        if (requestHeaders != null) {
            for (String key : requestHeaders.keySet()) {
                if (key != null) {
                    List<String> list = requestHeaders.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        String value = list.get(i).toString();
                        out.append(key + ": " + value + "\r\n");
                    }
                    continue;
                }
                out.append(requestHeaders.get(key) + "\r\n");
            }
        }
        out.append("\r\n");
        return out.toString();
    }

    private class ConnectTimeout
    implements Runnable {
        HttpURLConnection con;

        public ConnectTimeout(URLConnection con) {
            this.con = (HttpURLConnection)con;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Request.this.connectionTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Request.this.responseCode == -1) {
                this.con.disconnect();
            }
        }
    }
}

