/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.io.Jar;
import javaxt.json.JSONArray;
import javaxt.json.JSONObject;
import javaxt.sql.Connection;
import javaxt.sql.ConnectionPool;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Function;
import javaxt.sql.Recordset;
import javaxt.sql.Value;

public abstract class Model {
    protected Long id;
    private String tableName;
    private final String modelName;
    private final HashMap<String, String> fieldMap;
    private String[] keywords;
    private static ConcurrentHashMap<String, PreparedStatement> sqlCache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, PreparedStatement> insertStatements = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, ConnectionPool> connPool = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String[]> reservedKeywords = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Field[]> fields = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String[]> tables = new ConcurrentHashMap();

    protected Model(String tableName) {
        this(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Model(String tableName, HashMap<String, String> fieldMap) {
        Class<?> c = this.getClass();
        String className = c.getName();
        this.modelName = c.getSimpleName();
        ConcurrentHashMap<String, String[]> concurrentHashMap = reservedKeywords;
        synchronized (concurrentHashMap) {
            this.keywords = reservedKeywords.get(className);
        }
        concurrentHashMap = tables;
        synchronized (concurrentHashMap) {
            String[] tableInfo = tables.get(className);
            if (tableInfo == null) {
                tableInfo = this.getTableInfo(tableName);
                tables.put(className, tableInfo);
            }
            this.tableName = tableInfo[0];
        }
        this.fieldMap = fieldMap;
    }

    public Long getID() {
        return this.id;
    }

    public void setID(Long id) {
        this.id = id;
    }

    protected final void init(long id) throws SQLException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (java.lang.reflect.Field f : this.getClass().getDeclaredFields()) {
            Class<?> c;
            String fieldName = f.getName();
            String columnName = this.fieldMap.get(fieldName);
            if (columnName == null || ArrayList.class.isAssignableFrom(c = f.getType())) continue;
            String className = c.getSimpleName();
            if (className.equals("Geometry")) {
                fieldNames.add("ST_AsText(" + columnName + ") as " + columnName);
                continue;
            }
            fieldNames.add(columnName);
        }
        this.init(id, fieldNames.toArray(new String[fieldNames.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void init(long id, String ... fieldNames) throws SQLException {
        StringBuilder sql = new StringBuilder("select ");
        boolean addID = true;
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName;
            if (i > 0) {
                sql.append(", ");
            }
            if ((fieldName = fieldNames[i]).equalsIgnoreCase("id")) {
                addID = false;
            }
            sql.append(this.escape(fieldName));
        }
        if (addID) {
            sql.append(", id");
        }
        sql.append(" from ");
        sql.append(this.tableName);
        sql.append(" where id=");
        try {
            ConcurrentHashMap<String, PreparedStatement> i = sqlCache;
            synchronized (i) {
                String query = sql.toString() + "?";
                PreparedStatement stmt = sqlCache.get(query);
                if (stmt == null) {
                    Connection conn = Model.getConnection(this.getClass());
                    stmt = conn.getConnection().prepareStatement(query);
                    sqlCache.put(query, stmt);
                    sqlCache.notify();
                }
                stmt.setLong(1, id);
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    rs.close();
                    throw new IllegalArgumentException();
                }
                this.update(rs);
                this.id = id;
                rs.close();
            }
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(this.modelName + " not found");
        }
        catch (Exception e) {
            Connection conn = null;
            try {
                conn = Model.getConnection(this.getClass());
                Recordset rs = new Recordset();
                String query = sql.toString() + id;
                rs.open(query, conn);
                if (rs.EOF) {
                    rs.close();
                    conn.close();
                    throw new SQLException(this.modelName + " not found");
                }
                this.update(rs);
                this.id = id;
                rs.close();
                conn.close();
            }
            catch (SQLException ex) {
                if (conn != null) {
                    conn.close();
                }
                throw ex;
            }
        }
    }

    protected abstract void update(Object var1) throws SQLException;

    protected abstract void update(JSONObject var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void save() throws SQLException {
        void var5_8;
        String className = this.getClass().getName();
        LinkedHashMap<java.lang.reflect.Field, Object> fields = this.getFields();
        ArrayList<java.lang.reflect.Field> arr = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : fields.keySet()) {
            String fieldName = field.getName();
            Class<?> clazz = field.getType();
            if (clazz.equals(ArrayList.class)) {
                arr.add(field);
            }
            if (!fieldName.equalsIgnoreCase("id")) continue;
            arr.add(field);
        }
        for (Object f : arr) {
            fields.remove(f);
        }
        boolean bl = false;
        for (Map.Entry entry : fields.entrySet()) {
            Object v = entry.getValue();
            if (v != null) {
                JSONObject json;
                if (v instanceof Model) {
                    Model model = (Model)v;
                    model.save();
                    entry.setValue(model.getID());
                } else if (v instanceof JSONObject && (json = (JSONObject)v).isEmpty()) {
                    entry.setValue(null);
                }
            }
            if (entry.getValue() != null) continue;
            ++var5_8;
        }
        if (var5_8 == fields.size()) {
            return;
        }
        if (this.id == null) {
            String columnName;
            Field[] dbFields;
            ConcurrentHashMap<String, Field[]> concurrentHashMap = Model.fields;
            synchronized (concurrentHashMap) {
                dbFields = Model.fields.get(className);
            }
            if (dbFields == null) {
                throw new SQLException("Failed to retrieve metadata for " + className + ". The model may not have been initialized. See Model.init()");
            }
            ArrayList<Field> arrayList = new ArrayList<Field>();
            for (java.lang.reflect.Field field : fields.keySet()) {
                Field[] obj;
                Class<?> fieldType = field.getType();
                String packageName = fieldType.getPackage() == null ? "" : fieldType.getPackage().getName();
                Object val = fields.get(field);
                if (packageName.startsWith("javaxt.geospatial.geometry") || packageName.startsWith("com.vividsolutions.jts.geom")) {
                    int srid = 4326;
                    try {
                        Method method = fieldType.getMethod("getSRID", new Class[0]);
                        if (method != null && (obj = method.invoke(val, null)) != null && (srid = ((Integer)obj).intValue()) == 0) {
                            srid = 4326;
                        }
                    }
                    catch (Exception method) {
                        // empty catch block
                    }
                    val = new Function(null, new Object[]{val == null ? null : val.toString(), srid});
                } else if (packageName.startsWith("javaxt.json") || packageName.startsWith("org.json")) {
                    val = new Function(null, new Object[]{val == null ? null : val.toString()});
                }
                boolean foundField = false;
                columnName = this.fieldMap.get(field.getName());
                obj = dbFields;
                int n = obj.length;
                for (int i = 0; i < n; ++i) {
                    Field field2 = obj[i];
                    if (!field2.getName().equalsIgnoreCase(columnName)) continue;
                    field2 = field2.clone();
                    field2.Value = new Value(val);
                    arrayList.add(field2);
                    foundField = true;
                    break;
                }
                if (foundField) continue;
                throw new SQLException("Model/Schema mismatch. Failed to find " + columnName + " in the database.");
            }
            ConcurrentHashMap<String, PreparedStatement> concurrentHashMap2 = insertStatements;
            synchronized (concurrentHashMap2) {
                PreparedStatement stmt = insertStatements.get(className);
                if (stmt == null) {
                    Connection conn = Model.getConnection(this.getClass());
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO " + this.tableName + " (");
                    Iterator<java.lang.reflect.Field> it = fields.keySet().iterator();
                    while (it.hasNext()) {
                        java.lang.reflect.Field f3 = it.next();
                        columnName = this.fieldMap.get(f3.getName());
                        sql.append(this.escape(columnName));
                        if (!it.hasNext()) continue;
                        sql.append(",");
                    }
                    sql.append(") VALUES (");
                    it = fields.keySet().iterator();
                    while (it.hasNext()) {
                        java.lang.reflect.Field f4 = it.next();
                        Class<?> fieldType = f4.getType();
                        String packageName = fieldType.getPackage() == null ? "" : fieldType.getPackage().getName();
                        String q = "?";
                        if (packageName.startsWith("javaxt.json") || packageName.startsWith("org.json")) {
                            Driver driver = conn.getDatabase().getDriver();
                            if (driver.equals("PostgreSQL")) {
                                q = "?::jsonb";
                            }
                        } else if (packageName.startsWith("javaxt.geospatial.geometry") || packageName.startsWith("com.vividsolutions.jts.geom")) {
                            String columnName2 = this.fieldMap.get(f4.getName());
                            String STGeomFromText = null;
                            for (Field field : dbFields) {
                                if (!field.getName().equals(columnName2)) continue;
                                STGeomFromText = Recordset.getSTGeomFromText(field, conn);
                                break;
                            }
                            q = STGeomFromText + "(?,?)";
                        }
                        sql.append(q);
                        if (!it.hasNext()) continue;
                        sql.append(",");
                    }
                    sql.append(")");
                    stmt = conn.getConnection().prepareStatement(sql.toString(), 1);
                    insertStatements.put(className, stmt);
                    insertStatements.notify();
                }
                try {
                    Recordset.update(stmt, arrayList);
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    throw this.Exception("Failed to save " + className + ". " + e.getMessage(), e);
                }
                ResultSet generatedKeys = stmt.getGeneratedKeys();
                if (generatedKeys.next()) {
                    this.id = new Value(generatedKeys.getString(1)).toLong();
                }
            }
        }
        Connection conn = null;
        try {
            conn = Model.getConnection(this.getClass());
            Driver driver = conn.getDatabase().getDriver();
            if (driver == null) {
                Driver driver2 = new Driver("", "", "");
            }
            Recordset recordset = new Recordset();
            recordset.open("select * from " + this.tableName + " where id=" + this.id, conn, false);
            if (recordset.EOF) {
                recordset.addNew();
                recordset.setValue("id", this.id);
            }
            for (java.lang.reflect.Field f : fields.keySet()) {
                String columnName = this.fieldMap.get(f.getName());
                Object val = fields.get(f);
                if (val instanceof JSONObject || val instanceof JSONArray) {
                    void var7_17;
                    if (var7_17.equals("PostgreSQL")) {
                        recordset.setValue(columnName, new Function("?::jsonb", new Object[]{val.toString()}));
                        continue;
                    }
                    recordset.setValue(columnName, val.toString());
                    continue;
                }
                recordset.setValue(columnName, val);
            }
            recordset.update();
            recordset.close();
            conn.close();
        }
        catch (SQLException sQLException) {
            if (conn != null) {
                conn.close();
            }
            throw this.Exception("Failed to update " + className + "#" + this.id + ". " + sQLException.getMessage(), sQLException);
        }
    }

    public void delete() throws SQLException {
        if (this.id == null) {
            return;
        }
        Connection conn = null;
        try {
            conn = Model.getConnection(this.getClass());
            conn.execute("delete from " + this.tableName + " where id=" + this.id);
            conn.close();
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.close();
            }
            String className = this.getClass().getName();
            throw this.Exception("Failed to delete " + className + "#" + this.id + ". " + e.getMessage(), e);
        }
    }

    private SQLException Exception(String err, SQLException e) {
        SQLException ex = new SQLException(err);
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        boolean addElement = false;
        StackTraceElement[] arr = ex.getStackTrace();
        for (int i = 2; i < arr.length; ++i) {
            StackTraceElement el = arr[i];
            if (!el.getClassName().contains("reflect")) {
                addElement = true;
            }
            if (!addElement) continue;
            stackTrace.add(el);
        }
        ex.setStackTrace(stackTrace.toArray(new StackTraceElement[stackTrace.size()]));
        ex.setNextException(e);
        return ex;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        if (this.id != null) {
            json.set("id", this.id);
        }
        LinkedHashMap<java.lang.reflect.Field, Object> fields = this.getFields();
        for (java.lang.reflect.Field f : fields.keySet()) {
            String fieldName = f.getName();
            Object val = fields.get(f);
            if (val == null) continue;
            if (val instanceof ArrayList) {
                Class<?> c;
                ArrayList list = (ArrayList)val;
                if (!list.isEmpty() && Model.class.isAssignableFrom(c = list.get(0).getClass())) {
                    JSONArray arr = new JSONArray();
                    for (Object obj : list) {
                        arr.add(((Model)obj).toJson());
                    }
                    val = arr;
                }
            } else if (val instanceof Model) {
                val = ((Model)val).toJson();
            }
            json.set(fieldName, val);
        }
        return json;
    }

    public boolean equals(Object obj) {
        if (this.id != null && this.getClass().isAssignableFrom(obj.getClass())) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? -1 : (int)(this.id ^ this.id >>> 32);
    }

    protected static Object _get(Class c, Object ... args) throws SQLException {
        if (args.length == 1) {
            if (args[0] instanceof Long || args[0] instanceof Integer) {
                try {
                    long id = args[0] instanceof Long ? ((Long)args[0]).longValue() : new Long(((Integer)args[0]).intValue()).longValue();
                    return c.getConstructor(Long.TYPE).newInstance(id);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }
        String sql = Model.getSQL(c, args);
        Long id = null;
        Connection conn = null;
        try {
            conn = Model.getConnection(c);
            Recordset rs = new Recordset();
            rs.open(sql, conn);
            if (!rs.EOF) {
                id = rs.getValue(0).toLong();
            }
            rs.close();
            conn.close();
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
        if (id != null) {
            try {
                return c.getConstructor(Long.TYPE).newInstance(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Object[] _find(Class c, Object ... args) throws SQLException {
        String sql = Model.getSQL(c, args);
        ArrayList<Long> ids = new ArrayList<Long>();
        Connection conn = null;
        try {
            conn = Model.getConnection(c);
            Recordset rs = new Recordset();
            rs.open(sql, conn);
            while (rs.hasNext()) {
                ids.add(rs.getValue(0).toLong());
                rs.moveNext();
            }
            rs.close();
            conn.close();
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.close();
            }
            throw e;
        }
        if (!ids.isEmpty()) {
            ArrayList arr = new ArrayList(ids.size());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                try {
                    arr.add(c.getConstructor(Long.TYPE).newInstance(id));
                }
                catch (Exception exception) {}
            }
            return arr.toArray();
        }
        return new Object[0];
    }

    private static String getSQL(Class c, Object ... args) {
        String tableName = null;
        try {
            tableName = ((Model)c.newInstance()).tableName;
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder str = new StringBuilder("select ");
        str.append(tableName);
        str.append(".id from ");
        str.append(tableName);
        if (args.length > 1) {
            str.append(" where ");
            for (int i = 0; i < args.length - 1; ++i) {
                str.append(args[i]);
                Object val = args[++i];
                if (val instanceof String) {
                    str.append("'");
                    str.append(val.toString().replace("'", "''"));
                    str.append("'");
                } else {
                    str.append(val);
                }
                if (i >= args.length - 2) continue;
                str.append(" and ");
            }
        }
        return str.toString();
    }

    protected Value getValue(Object rs, String key) throws SQLException {
        if (rs instanceof ResultSet) {
            return new Value(((ResultSet)rs).getObject(key));
        }
        return ((Recordset)rs).getValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Connection getConnection(Class c) throws SQLException {
        ConnectionPool connectionPool = null;
        ConcurrentHashMap<String, ConnectionPool> concurrentHashMap = connPool;
        synchronized (concurrentHashMap) {
            connectionPool = connPool.get(c.getName());
        }
        if (connectionPool != null) {
            return connectionPool.getConnection();
        }
        throw new SQLException("Failed to find connection for " + c.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Class c, ConnectionPool connectionPool) throws SQLException {
        String className = c.getName();
        ConcurrentHashMap<String, ConnectionPool> concurrentHashMap = connPool;
        synchronized (concurrentHashMap) {
            connPool.put(className, connectionPool);
            connPool.notifyAll();
        }
        Connection conn = null;
        try {
            conn = connectionPool.getConnection();
        }
        catch (Exception e) {
            SQLException ex = new SQLException("Failed to acquire database connection");
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        try {
            String[] keywords = Database.getReservedKeywords(conn);
            ConcurrentHashMap<String, String[]> ex = reservedKeywords;
            synchronized (ex) {
                reservedKeywords.put(className, keywords);
                reservedKeywords.notifyAll();
            }
            Model model = (Model)c.newInstance();
            Recordset rs = new Recordset();
            rs.open("select * from " + model.tableName + " where id is null", conn);
            ConcurrentHashMap<String, Field[]> concurrentHashMap2 = fields;
            synchronized (concurrentHashMap2) {
                fields.put(className, rs.getFields());
                fields.notifyAll();
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            SQLException ex = new SQLException("Failed to initialize Model: " + className);
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    public static void init(Jar jar, ConnectionPool connectionPool) throws SQLException {
        for (Class c : jar.getClasses()) {
            if (!Model.class.isAssignableFrom(c)) continue;
            Model.init(c, connectionPool);
        }
    }

    public static String getTableName(Model model) {
        return model.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSchemaName(String schemaName, Class c) {
        if (!Model.class.isAssignableFrom(c)) {
            return;
        }
        String className = c.getName();
        try {
            Model model = (Model)c.newInstance();
            ConcurrentHashMap<String, String[]> concurrentHashMap = tables;
            synchronized (concurrentHashMap) {
                String[] tableInfo = tables.get(className);
                String tableName = tableInfo[1];
                if (schemaName != null) {
                    tableName = schemaName + "." + tableName;
                }
                tableInfo = model.getTableInfo(tableName);
                tables.put(className, tableInfo);
            }
        }
        catch (Exception e) {
            Exception ex = new Exception("Failed to update schema for Model: " + className);
            ex.setStackTrace(e.getStackTrace());
            throw new RuntimeException(ex);
        }
    }

    private String[] getTableInfo(String tableName) {
        String escapedTableName;
        String schemaName;
        int idx = tableName.indexOf(".");
        if (idx > -1) {
            schemaName = tableName.substring(0, idx);
            tableName = tableName.substring(idx + 1);
            escapedTableName = this.escape(schemaName) + "." + tableName;
        } else {
            schemaName = null;
            escapedTableName = this.escape(tableName);
        }
        return new String[]{escapedTableName, tableName, schemaName};
    }

    protected String escape(String colName) {
        if (this.keywords == null) {
            return colName;
        }
        for (String keyWord : this.keywords) {
            if (!colName.equalsIgnoreCase(keyWord)) continue;
            colName = "\"" + colName + "\"";
            break;
        }
        return colName;
    }

    private LinkedHashMap<java.lang.reflect.Field, Object> getFields() {
        LinkedHashMap<java.lang.reflect.Field, Object> fields = new LinkedHashMap<java.lang.reflect.Field, Object>();
        for (java.lang.reflect.Field f : this.getClass().getDeclaredFields()) {
            String fieldName = f.getName();
            if (!this.fieldMap.containsKey(fieldName)) continue;
            Object val = null;
            try {
                f.setAccessible(true);
                val = f.get(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            fields.put(f, val);
        }
        return fields;
    }
}

