/*
 * Decompiled with CFR 0.152.
 */
package javaxt.html;

import javaxt.html.Parser;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

public class Element {
    private String tagName;
    private String tagHTML;
    protected String innerHTML;
    protected String outerHTML;
    private boolean isStartTag;
    private boolean isEndTag;
    private String tag;

    protected Element(String tagHTML) {
        this.tagHTML = tagHTML;
        this.tag = tagHTML;
        if (this.tag.startsWith("</")) {
            this.isStartTag = false;
            this.isEndTag = true;
        } else {
            this.isStartTag = true;
            this.isEndTag = this.tag.endsWith("/>");
        }
        this.tag = this.tag.replace("</", "");
        this.tag = this.tag.replace("<", "");
        this.tag = this.tag.replace("/>", "");
        this.tag = this.tag.replace(">", "");
        this.tag = this.tag.replaceAll("\\s+", " ").trim();
        String[] arr = this.tag.split(" ");
        this.tagName = arr[0];
    }

    protected String getTag() {
        return this.tagHTML;
    }

    protected boolean isStartTag() {
        return this.isStartTag;
    }

    protected boolean isEndTag() {
        return this.isEndTag;
    }

    public String getName() {
        return this.tagName;
    }

    public String getInnerHTML() {
        return this.innerHTML;
    }

    public String getOuterHTML() {
        return this.outerHTML;
    }

    public String getInnerText() {
        return Parser.stripHTMLTags(this.innerHTML);
    }

    public String getAttribute(String attributeName) {
        return this._getAttributeValue(attributeName);
    }

    public Element getElementByID(String id) {
        return this.getElementByAttributes(null, "id", id);
    }

    public Element[] getElementsByTagName(String tagName) {
        return new Parser(this.innerHTML).getElementsByTagName(tagName);
    }

    public Element getElementByTagName(String tagName) {
        return this.getElementByAttributes(tagName, null, null);
    }

    public Element[] getElements(String tagName, String attributeName, String attributeValue) {
        return new Parser(this.innerHTML).getElements(tagName, attributeName, attributeValue);
    }

    public Element getElementByAttributes(String tagName, String attributeName, String attributeValue) {
        return new Parser(this.innerHTML).getElementByAttributes(tagName, attributeName, attributeValue);
    }

    public String[] getImageLinks() {
        return new Parser(this.innerHTML).getImageLinks();
    }

    public String toString() {
        return this.outerHTML;
    }

    public String stripHTMLTags() {
        return this.getInnerText();
    }

    public String getAttributeValue(String attributeName) {
        return this.getAttribute(attributeName);
    }

    private String _getAttributeValue(String attributeName) {
        try {
            Document XMLDoc = DOM.createDocument("<" + this.tag + "/>");
            NamedNodeMap attr = XMLDoc.getFirstChild().getAttributes();
            return DOM.getAttributeValue(attr, attributeName);
        }
        catch (Exception e) {
            try {
                return this._getAttributeValue2(this.tag, attributeName);
            }
            catch (Exception ex) {
                return "";
            }
        }
    }

    private String _getAttributeValue2(String tag, String attributeName) {
        char ch;
        int i;
        if (!(tag = tag.trim()).contains(" ")) {
            return tag;
        }
        String orgTag = tag;
        tag = tag.substring(tag.indexOf(" "), tag.length()).trim();
        String tagName = orgTag + " ";
        tagName = tagName.substring(0, tagName.indexOf(" "));
        String newTag = "";
        tag = tag + " ";
        for (i = 0; i < tag.length() - 1; ++i) {
            ch = tag.charAt(i);
            if (ch == ' ' && tag.charAt(i + 1) == ' ') continue;
            newTag = newTag + ch;
        }
        newTag = newTag.replace("= ", "=");
        newTag = newTag.replace(" =", "=");
        newTag = " " + newTag + " ";
        for (i = 0; i < newTag.length(); ++i) {
            ch = newTag.charAt(i);
            if (ch != '=') continue;
            String tmp = newTag.substring(0, i);
            String AttrName = tmp.substring(tmp.lastIndexOf(" "), tmp.length()).trim();
            String AttrValue = "";
            if (!AttrName.equalsIgnoreCase(attributeName)) continue;
            tmp = newTag.substring(i + 1, newTag.length()).trim() + " ";
            if (newTag.charAt(i + 1) == '\"') {
                tmp = tmp.substring(1, tmp.length());
                AttrValue = tmp.substring(0, tmp.indexOf("\""));
            } else if (newTag.charAt(i + 1) == '\'') {
                tmp = tmp.substring(1, tmp.length());
                AttrValue = tmp.substring(0, tmp.indexOf("'"));
            } else {
                AttrValue = tmp.substring(0, tmp.indexOf(" "));
            }
            return AttrValue;
        }
        return "";
    }
}

