/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.io.FileSystemWatcherNative;

class FileSystemWatcher
implements Runnable {
    private Directory directory;
    private Timer timer;
    private boolean includeSubdirectories = true;
    private boolean terminationRequested = false;
    private Long osHandle = null;
    private List events = new LinkedList();
    private Directory.Event LastEvent = null;

    public FileSystemWatcher(Directory directory) throws IOException {
        if (!directory.exists()) {
            throw new IOException("Directory not found.");
        }
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (!File.loadDLL()) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new EventMonitor(), new Date(), 1000L);
        } else {
            try {
                long osWaitHandle = FileSystemWatcherNative.FindFirstChangeNotification(this.directory.getPath(), this.includeSubdirectories, -1);
                this.osHandle = new Long(osWaitHandle);
                FileSystemWatcherNative.FindNextChangeNotification(osWaitHandle);
                String event = null;
                while (!this.terminationRequested && (event = FileSystemWatcherNative.ReadDirectoryChangesW()) != null) {
                    for (String e : event.split("\n")) {
                        this.addEvent(e.trim());
                    }
                }
                if (FileSystemWatcherNative.WaitForSingleObject(osWaitHandle, -1) != 0) {
                    throw new Exception("Wait failed while waiting for OS to signal file system event.");
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.osHandle != null) {
                    System.out.println("Shutting down...");
                    try {
                        FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
                    }
                    catch (Exception exception) {}
                    this.osHandle = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(String str) {
        Directory.Event event = new Directory.Event(str);
        String action = event.getAction();
        String path = event.getFile();
        Date date = event.getDate();
        boolean exists = true;
        boolean isDirectory = false;
        try {
            isDirectory = new File.FileAttributes(path).isDirectory();
        }
        catch (Exception e) {
            exists = false;
        }
        boolean updateEvents = true;
        if (action.equalsIgnoreCase("modify")) {
            if (isDirectory || !exists) {
                updateEvents = false;
            } else if (this.LastEvent != null) {
                if (this.LastEvent.getFile().equals(path) && this.LastEvent.getDate().equals(date)) {
                    updateEvents = false;
                }
                this.LastEvent = null;
            } else {
                this.LastEvent = event;
            }
        }
        if (action.equalsIgnoreCase("rename")) {
            updateEvents = false;
            this.LastEvent = event;
        } else if (action.equalsIgnoreCase("renam2") && this.LastEvent != null) {
            event.setOrgFile(this.LastEvent.getFile());
            event.setAction("Rename");
            this.LastEvent = null;
        }
        if (updateEvents) {
            List list = this.events;
            synchronized (list) {
                this.events.add(event);
                this.events.notifyAll();
            }
        }
    }

    public List getEvents() {
        return this.events;
    }

    public void stop() {
        this.terminationRequested = true;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.osHandle != null) {
            FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
        }
    }

    private class EventMonitor
    extends TimerTask {
        private List index = this.createIndex();
        private long lastUpdate = 0L;
        private long interval = 0L;

        @Override
        public final void run() {
            long startTime = Calendar.getInstance().getTimeInMillis();
            if (this.interval == 0L) {
                this.interval = 100L;
            }
            if (startTime - this.lastUpdate > this.interval * 2L) {
                Item item;
                int i;
                List orgIndex = this.index;
                List newIndex = this.createIndex();
                for (i = 0; i < newIndex.size(); ++i) {
                    item = (Item)newIndex.get(i);
                    if (orgIndex.contains(item)) {
                        int x = orgIndex.indexOf(item);
                        Item orgItem = (Item)orgIndex.get(x);
                        orgIndex.remove(x);
                        if (item.isDirectory() || item.getSize() == orgItem.getSize() && item.getDate() == orgItem.getDate()) continue;
                        this.addEvent("Modify", item.getPath());
                        continue;
                    }
                    this.addEvent("Create", item.getPath());
                }
                if (orgIndex.size() > 0) {
                    for (i = 0; i < orgIndex.size(); ++i) {
                        item = (Item)orgIndex.get(i);
                        this.addEvent("Delete", item.getPath());
                    }
                    orgIndex.clear();
                }
                this.index = newIndex;
                long endTime = Calendar.getInstance().getTimeInMillis();
                this.interval = endTime - startTime;
                this.lastUpdate = endTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addEvent(String action, String file) {
            Directory.Event event = new Directory.Event(action, file);
            List list = FileSystemWatcher.this.events;
            synchronized (list) {
                FileSystemWatcher.this.events.add(event);
                FileSystemWatcher.this.events.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List createIndex() {
            LinkedList<Item> index = new LinkedList<Item>();
            List files = FileSystemWatcher.this.directory.getChildren(true, null, false);
            while (true) {
                Object obj;
                List list = files;
                synchronized (list) {
                    while (files.isEmpty()) {
                        try {
                            files.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    obj = files.remove(0);
                    files.notifyAll();
                }
                if (obj == null) break;
                index.add(new Item(obj));
            }
            return index;
        }

        private class Item {
            private String path;
            private long size;
            private long date;
            private boolean isDirectory;

            public Item(Object obj) {
                java.io.File file = null;
                if (obj instanceof File) {
                    file = ((File)obj).toFile();
                } else if (obj instanceof Directory) {
                    file = ((Directory)obj).toFile();
                } else if (obj instanceof java.io.File) {
                    file = (java.io.File)obj;
                }
                if (file != null) {
                    this.path = file.getPath();
                    this.size = file.length();
                    this.date = file.lastModified();
                    this.isDirectory = file.isDirectory();
                }
            }

            public String getPath() {
                return this.path;
            }

            public long getSize() {
                return this.size;
            }

            public long getDate() {
                return this.date;
            }

            public boolean isDirectory() {
                return this.isDirectory;
            }

            public String toString() {
                return this.path;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Item) {
                    Item item = (Item)obj;
                    return item.getPath().equals(this.getPath());
                }
                return false;
            }
        }
    }
}

