/*
 * Decompiled with CFR 0.152.
 */
package javaxt.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javaxt.json.JSONArray;
import javaxt.json.JSONException;
import javaxt.json.JSONTokener;
import javaxt.json.JSONValue;
import javaxt.sql.Model;
import javaxt.sql.Value;
import javaxt.utils.Date;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSONObject {
    private final LinkedHashMap<String, Object> map;

    public JSONObject() {
        this.map = new LinkedHashMap();
    }

    public JSONObject(String source) throws JSONException {
        this();
        if (source != null) {
            this.init(new JSONTokener(source));
        }
    }

    protected JSONObject(JSONTokener source) throws JSONException {
        this();
        if (source != null) {
            this.init(source);
        }
    }

    private void init(JSONTokener x) throws JSONException {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            if (key != null) {
                Object value;
                if (this.map.get(key) != null) {
                    // empty if block
                }
                if ((value = x.nextValue()) != null) {
                    this.put(key, value);
                }
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Document xml) throws JSONException {
        this(DOM.getOuterNode(xml));
    }

    public JSONObject(Node node) throws JSONException {
        JSONObject json = new JSONObject();
        if (DOM.hasChildren(node)) {
            this.traverse(node, json);
        } else {
            json.set(node.getNodeName(), node.getTextContent());
        }
        this.map = json.map;
    }

    private void traverse(Node node, JSONObject json) {
        if (node.getNodeType() == 1) {
            if (DOM.hasChildren(node)) {
                JSONObject _json = new JSONObject();
                NodeList xmlNodeList = node.getChildNodes();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    this.traverse(xmlNodeList.item(i), _json);
                }
                json.set(node.getNodeName(), _json);
            } else {
                json.set(node.getNodeName(), node.getTextContent());
            }
        }
    }

    public JSONValue get(String key) {
        if (key == null) {
            return new JSONValue(null);
        }
        return new JSONValue(this.map.get(key));
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }

    public boolean isNull(String key) {
        return this.map.get(key) == null;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Iterator<String> keys() {
        return this.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    private Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public int length() {
        return this.map.size();
    }

    public void set(String key, Object value) throws JSONException {
        if (value instanceof javaxt.utils.Value) {
            value = ((javaxt.utils.Value)value).toObject();
        }
        if (value instanceof String) {
            String str = (String)value;
            if ((str = str.trim()).length() == 0) {
                str = null;
            }
            this.put(key, str);
        } else {
            this.put(key, value);
        }
    }

    private void put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.map.put(key, value);
        } else {
            this.map.remove(key);
        }
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public boolean equals(Object obj) {
        JSONObject json;
        if (obj instanceof JSONObject && (json = (JSONObject)obj).length() == this.length()) {
            JSONObject j1 = new JSONObject(this.toString());
            JSONObject j2 = new JSONObject(json.toString());
            for (String key : j1.keySet()) {
                if (!j2.has(key)) {
                    return false;
                }
                Object val = j1.get(key).toObject();
                Object val2 = j2.get(key).toObject();
                if (!(val == null ? val2 != null : !val.equals(val2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) {
        try {
            StringWriter w = new StringWriter();
            StringBuffer stringBuffer = w.getBuffer();
            synchronized (stringBuffer) {
                return this.write(w, indentFactor, 0).toString();
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static final Writer writeValue(Writer writer, Object value, int indentFactor, int indent) throws JSONException, IOException {
        if (value == null || value.equals(null)) {
            writer.write("null");
        } else if (value instanceof Number) {
            String numberAsString = JSONObject.numberToString((Number)value);
            try {
                BigDecimal testNum = new BigDecimal(numberAsString);
                writer.write(numberAsString);
            }
            catch (NumberFormatException ex) {
                JSONObject.quote(numberAsString, writer);
            }
        } else if (value instanceof Boolean) {
            writer.write(value.toString());
        } else if (value instanceof Date) {
            writer.write(JSONObject.quote(((Date)value).toISOString()));
        } else if (value instanceof java.util.Date) {
            writer.write(JSONObject.quote(new Date((java.util.Date)value).toISOString()));
        } else if (value instanceof Calendar) {
            writer.write(JSONObject.quote(new Date((Calendar)value).toISOString()));
        } else if (value instanceof Clob) {
            writer.write(JSONObject.quote(new Value(value).toString()));
        } else if (value instanceof Enum) {
            writer.write(JSONObject.quote(((Enum)value).name()));
        } else if (value instanceof Model) {
            JSONObject json = ((Model)value).toJson();
            json.write(writer, indentFactor, indent);
        } else if (value instanceof JSONObject) {
            ((JSONObject)value).write(writer, indentFactor, indent);
        } else if (value instanceof JSONArray) {
            ((JSONArray)value).write(writer, indentFactor, indent);
        } else {
            JSONObject.quote(value.toString(), writer);
        }
        return writer;
    }

    private Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            writer.write(123);
            if (length == 1) {
                Map.Entry<String, Object> entry = this.entrySet().iterator().next();
                String key = entry.getKey();
                writer.write(JSONObject.quote(key));
                writer.write(58);
                if (indentFactor > 0) {
                    writer.write(32);
                }
                try {
                    JSONObject.writeValue(writer, entry.getValue(), indentFactor, indent);
                }
                catch (Exception e) {
                    throw new JSONException("Unable to write JSONObject value for key: " + key, e);
                }
            }
            if (length != 0) {
                int newindent = indent + indentFactor;
                for (Map.Entry<String, Object> entry : this.entrySet()) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    String key = entry.getKey();
                    writer.write(JSONObject.quote(key));
                    writer.write(58);
                    if (indentFactor > 0) {
                        writer.write(32);
                    }
                    try {
                        JSONObject.writeValue(writer, entry.getValue(), indentFactor, newindent);
                    }
                    catch (Exception e) {
                        throw new JSONException("Unable to write JSONObject value for key: " + key, e);
                    }
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(125);
            return writer;
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    protected static final void indent(Writer writer, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            writer.write(32);
        }
    }

    protected static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    private static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JSONObject.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    private static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block9;
                }
                case '\b': {
                    w.write("\\b");
                    continue block9;
                }
                case '\t': {
                    w.write("\\t");
                    continue block9;
                }
                case '\n': {
                    w.write("\\n");
                    continue block9;
                }
                case '\f': {
                    w.write("\\f");
                    continue block9;
                }
                case '\r': {
                    w.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block9;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }
}

