/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Generator<T>
implements Iterable<T> {
    static ThreadGroup THREAD_GROUP;
    Thread producer;
    private boolean hasFinished;
    private final Condition itemAvailableOrHasFinished = new Condition();
    private final Condition itemRequested = new Condition();
    private T nextItem;
    private boolean nextItemAvailable;
    private RuntimeException exceptionRaisedByProducer;

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return this.waitForNext();
            }

            @Override
            public T next() {
                if (!this.waitForNext()) {
                    throw new NoSuchElementException();
                }
                Generator.this.nextItemAvailable = false;
                return Generator.this.nextItem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean waitForNext() {
                if (Generator.this.nextItemAvailable) {
                    return true;
                }
                if (Generator.this.hasFinished) {
                    return false;
                }
                if (Generator.this.producer == null) {
                    Generator.this.startProducer();
                }
                Generator.this.itemRequested.set();
                try {
                    Generator.this.itemAvailableOrHasFinished.await();
                }
                catch (InterruptedException e) {
                    Generator.this.hasFinished = true;
                }
                if (Generator.this.exceptionRaisedByProducer != null) {
                    throw Generator.this.exceptionRaisedByProducer;
                }
                return !Generator.this.hasFinished;
            }
        };
    }

    protected abstract void run() throws InterruptedException;

    protected void yield(T element) throws InterruptedException {
        this.nextItem = element;
        this.nextItemAvailable = true;
        this.itemAvailableOrHasFinished.set();
        this.itemRequested.await();
    }

    private void startProducer() {
        assert (this.producer == null);
        if (THREAD_GROUP == null) {
            THREAD_GROUP = new ThreadGroup("generatorfunctions");
        }
        this.producer = new Thread(THREAD_GROUP, new Runnable(){

            @Override
            public void run() {
                try {
                    Generator.this.itemRequested.await();
                    Generator.this.run();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (RuntimeException e) {
                    Generator.this.exceptionRaisedByProducer = e;
                }
                Generator.this.hasFinished = true;
                Generator.this.itemAvailableOrHasFinished.set();
            }
        });
        this.producer.setDaemon(true);
        this.producer.start();
    }

    protected void finalize() throws Throwable {
        this.producer.interrupt();
        this.producer.join();
        super.finalize();
    }

    private class Condition {
        private boolean isSet;

        private Condition() {
        }

        public synchronized void set() {
            this.isSet = true;
            this.notify();
        }

        public synchronized void await() throws InterruptedException {
            try {
                if (this.isSet) {
                    return;
                }
                this.wait();
            }
            finally {
                this.isSet = false;
            }
        }
    }
}

