/*
 * Decompiled with CFR 0.152.
 */
package javaxt.html;

import java.net.URL;
import java.util.ArrayList;
import javaxt.html.Element;

public class Parser {
    private String html;

    public Parser(String html) {
        this.html = html;
    }

    public String getHTML() {
        return this.html;
    }

    public void setHTML(String html) {
        this.html = html;
    }

    public Element getElementByID(String id) {
        return this.getElementByAttributes(null, "id", id);
    }

    public Element[] getElementsByTagName(String tagName) {
        String orgHTML = this.html;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element e = this.getElementByTagName(tagName);
        while (e != null) {
            elements.add(e);
            int idx = this.html.indexOf(e.outerHTML);
            String a = this.html.substring(0, idx);
            String b = this.html.substring(idx + e.outerHTML.length());
            this.html = a + b;
            e = this.getElementByTagName(tagName);
        }
        this.html = orgHTML;
        return elements.toArray(new Element[elements.size()]);
    }

    public Element[] getElements(String tagName, String attributeName, String attributeValue) {
        String orgHTML = this.html;
        ArrayList<Element> elements = new ArrayList<Element>();
        Element e = this.getElementByAttributes(tagName, attributeName, attributeValue);
        while (e != null) {
            elements.add(e);
            int idx = this.html.indexOf(e.outerHTML);
            String a = this.html.substring(0, idx);
            String b = this.html.substring(idx + e.outerHTML.length());
            this.html = a + b;
            e = this.getElementByAttributes(tagName, attributeName, attributeValue);
        }
        this.html = orgHTML;
        return elements.toArray(new Element[elements.size()]);
    }

    public Element getElementByTagName(String tagName) {
        return this.getElementByAttributes(tagName, null, null);
    }

    public Element getElementByAttributes(String tagName, String attributeName, String attributeValue) {
        String s = this.html + " ";
        String c = "";
        boolean concat = false;
        int absStart = 0;
        int absEnd = 0;
        int numStartTags = 0;
        int numEndTags = 0;
        int outerStart = 0;
        int outerEnd = 0;
        StringBuffer tag = new StringBuffer();
        Element el = null;
        boolean insideQuote = false;
        boolean insideComment = false;
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("<") && !insideQuote && !insideComment) {
                concat = true;
                absEnd = i;
            }
            if (c.equals("\"")) {
                insideQuote = !insideQuote;
            }
            if (c.equals("/")) {
                insideComment = insideComment ? s.substring(i - 1, i + 1).equals("*/") : s.substring(i, i + 2).equals("/*");
            }
            if (concat) {
                tag.append(c);
            }
            if (!c.equals(">") || insideQuote || insideComment || !concat) continue;
            concat = false;
            Element Tag = new Element(tag.toString());
            if (el == null) {
                if (Tag.isStartTag() && (tagName == null || Tag.getName().equalsIgnoreCase(tagName)) && (attributeName == null || Tag.getAttribute(attributeName).equalsIgnoreCase(attributeValue))) {
                    absStart = i + 1;
                    el = Tag;
                    outerStart = absStart - tag.length();
                    if (tagName == null) {
                        tagName = Tag.getName();
                    }
                    if (Tag.isEndTag()) {
                        el.outerHTML = tag.toString();
                        return el;
                    }
                }
            } else if (Tag.getName().equalsIgnoreCase(tagName)) {
                if (Tag.isStartTag()) {
                    ++numStartTags;
                }
                if (Tag.isEndTag()) {
                    ++numEndTags;
                }
                boolean foundEnd = false;
                if (Tag.isStartTag() && Tag.isEndTag()) {
                    foundEnd = false;
                } else if (!Tag.isStartTag() && Tag.isEndTag()) {
                    foundEnd = numEndTags > numStartTags;
                } else {
                    boolean bl = foundEnd = numEndTags >= numStartTags;
                }
                if (foundEnd) {
                    el.innerHTML = this.html.substring(absStart, absEnd);
                    outerEnd = i + 1;
                    el.outerHTML = this.html.substring(outerStart, outerEnd);
                    return el;
                }
            }
            tag = new StringBuffer();
        }
        if (el != null) {
            if (el.getOuterHTML() == null) {
                el.outerHTML = el.getTag();
            }
            return el;
        }
        return null;
    }

    public String[] getImageLinks() {
        ArrayList<String> links = new ArrayList<String>();
        for (Element img : this.getElementsByTagName("img")) {
            String src = img.getAttribute("src");
            if (src.length() <= 0) continue;
            links.add(src);
        }
        return links.toArray(new String[links.size()]);
    }

    public static String stripHTMLTags(String html) {
        String s = html + " ";
        String c = "";
        boolean concat = false;
        String tag = "";
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("<")) {
                concat = true;
            }
            if (concat) {
                tag = tag + c;
            }
            if (!c.equals(">") || !concat) continue;
            concat = false;
            html = html.replace(tag, "");
            tag = "";
        }
        return html.replace("&nbsp;", " ").trim();
    }

    public static String MapPath(String relPath, URL url) {
        try {
            new URL(relPath);
            return relPath;
        }
        catch (Exception exception) {
            if (relPath.length() > 2 && relPath.substring(0, 2).equals("./")) {
                relPath = relPath.substring(2, relPath.length());
            }
            String[] arrRelPath = relPath.split("/");
            try {
                String newPath;
                String urlBase = url.getProtocol() + "://" + url.getHost();
                int port = url.getPort();
                if (port > 0 && port != 80) {
                    urlBase = urlBase + ":" + url.getPort();
                }
                String urlPath = "";
                if (relPath.substring(0, 1).equals("/")) {
                    newPath = relPath;
                } else {
                    urlPath = "/";
                    String[] arr = url.getPath().split("/");
                    for (int i = 0; i <= arr.length - arrRelPath.length; ++i) {
                        String dir = arr[i];
                        if (dir.length() <= 0) continue;
                        urlPath = urlPath + dir + "/";
                    }
                    newPath = relPath.substring(0, 1).equals("/") ? relPath.substring(1, relPath.length()) : (relPath.substring(0, 2).equals("./") ? relPath.substring(2, relPath.length()) : (relPath.substring(0, 3).equals("../") ? relPath.replace("../", "") : relPath));
                }
                return urlBase + urlPath + newPath;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static String getAbsolutePath(String relPath, String url) {
        try {
            return Parser.MapPath(relPath, new URL(url));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

