/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javaxt.sql.Database;
import javaxt.sql.Recordset;
import javaxt.utils.Generator;

public class Connection {
    private java.sql.Connection Conn = null;
    private long Speed;
    private Database database;

    public Connection() {
    }

    public Connection(java.sql.Connection conn) {
        this.open(conn);
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public boolean isClosed() {
        try {
            return this.Conn.isClosed();
        }
        catch (Exception e) {
            return true;
        }
    }

    public long getConnectionSpeed() {
        return this.Speed;
    }

    public java.sql.Connection getConnection() {
        return this.Conn;
    }

    public boolean open(String ConnectionString) throws SQLException {
        return this.open(new Database(ConnectionString));
    }

    public boolean open(Database database) throws SQLException {
        long startTime = System.currentTimeMillis();
        this.database = database;
        boolean isClosed = true;
        Driver Driver2 = database.getDriver().load();
        String url = database.getURL();
        String username = database.getUserName();
        String password = database.getPassword();
        Properties properties = database.getProperties();
        if (properties == null) {
            properties = new Properties();
        }
        if (username != null) {
            properties.put("user", username);
            properties.put("password", password);
        }
        this.Conn = Driver2.connect(url, properties);
        isClosed = this.Conn.isClosed();
        long endTime = System.currentTimeMillis();
        this.Speed = endTime - startTime;
        return isClosed;
    }

    public boolean open(java.sql.Connection conn) {
        boolean isClosed = true;
        try {
            this.database = new Database(conn);
            this.Conn = conn;
            isClosed = this.Conn.isClosed();
        }
        catch (Exception e) {
            isClosed = true;
        }
        this.Speed = 0L;
        return isClosed;
    }

    public void close() {
        try {
            this.Conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Generator<Recordset> getRecordset(String sql, boolean readOnly) throws SQLException {
        final Recordset rs = new Recordset();
        if (readOnly) {
            rs.setFetchSize(1000);
        }
        rs.open(sql, this, readOnly);
        return new Generator<Recordset>(){

            @Override
            public void run() {
                while (rs.hasNext()) {
                    try {
                        this.yield(rs);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    rs.moveNext();
                }
                rs.close();
            }
        };
    }

    public Generator<Recordset> getRecordset(String sql) throws SQLException {
        return this.getRecordset(sql, true);
    }

    public void execute(String sql) throws SQLException {
        PreparedStatement preparedStmt = this.Conn.prepareStatement(sql);
        preparedStmt.execute();
        preparedStmt.close();
        preparedStmt = null;
    }

    public void commit() throws SQLException {
        this.execute("COMMIT");
    }

    public Database getDatabase() {
        return this.database;
    }
}

