/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.HashMap;
import javaxt.io.Jar;

public class Console {
    private static final String indent = "                       ";
    private static final DecimalFormat df = new DecimalFormat("#.##");
    public static Console console = new Console();

    public void log(Object obj) {
        this.l(obj);
    }

    public void log(Object ... obj) {
        this.l(obj);
    }

    private void l(Object ... any) {
        String source = this.getSource();
        source = "[" + source + "]";
        source = source.length() < indent.length() ? source + indent.substring(0, indent.length() - source.length()) : source + " ";
        StringBuilder out = new StringBuilder(source);
        if (any != null) {
            int n = 0;
            for (Object obj : any) {
                String str = null;
                if (obj != null) {
                    if (obj.getClass().isArray()) {
                        StringBuilder sb = new StringBuilder("[");
                        for (int i = 0; i < Array.getLength(obj); ++i) {
                            Object o = Array.get(obj, i);
                            String s = this.format(o);
                            if (i > 0) {
                                sb.append(",");
                            }
                            sb.append(s);
                        }
                        sb.append("]");
                        str = sb.toString();
                    } else {
                        str = this.format(obj);
                    }
                }
                if (n > 0) {
                    out.append(" ");
                }
                out.append(str);
                ++n;
            }
        } else {
            out.append(any);
        }
        System.out.println(out);
    }

    private String format(Object obj) {
        String str = null;
        if (obj != null) {
            if (obj instanceof Double) {
                df.setMaximumFractionDigits(8);
                str = df.format((Double)obj);
            } else {
                str = obj.toString();
            }
        }
        return str;
    }

    private String getSource() {
        Exception e = new Exception();
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement target = null;
        boolean foundConsole = false;
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement el = stackTrace[i];
            try {
                Class<?> c = Class.forName(el.getClassName());
                if (c.isAssignableFrom(this.getClass())) {
                    foundConsole = true;
                    continue;
                }
                if (!foundConsole) continue;
                target = stackTrace[i];
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (target == null) {
            return "";
        }
        String className = target.getClassName();
        int idx = className.lastIndexOf(".");
        if (idx > 0) {
            className = className.substring(idx + 1);
        }
        if ((idx = className.indexOf("$")) > 0) {
            className = className.substring(0, idx);
        }
        return className + ":" + target.getLineNumber();
    }

    public static String getInput(String prompt) {
        String input = null;
        System.out.print(prompt);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            input = br.readLine();
        }
        catch (IOException e) {
            System.out.println("Failed to read input");
        }
        return input;
    }

    public static String getUserName(String prompt) {
        return Console.getInput(prompt);
    }

    public static String getPassword(String prompt) {
        String password = "";
        ConsoleEraser consoleEraser = new ConsoleEraser();
        System.out.print(prompt);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        consoleEraser.start();
        try {
            password = in.readLine();
        }
        catch (IOException e) {
            System.out.println("Error trying to read your password!");
        }
        consoleEraser.halt();
        System.out.print("\b");
        return password;
    }

    public static HashMap<String, String> parseArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (!key.startsWith("-")) continue;
            if (i < args.length - 1) {
                String nextArg = args[i + 1];
                if (nextArg.startsWith("-")) {
                    map.put(key, null);
                    continue;
                }
                ++i;
                map.put(key, nextArg);
                continue;
            }
            map.put(key, null);
        }
        return map;
    }

    public static void main(String[] args) {
        Jar jar = new Jar(Jar.class);
        System.out.println("JavaXT: " + jar.getVersion());
    }

    private static class ConsoleEraser
    extends Thread {
        private boolean running = true;

        private ConsoleEraser() {
        }

        @Override
        public void run() {
            while (this.running) {
                System.out.print("\b ");
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

