/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Timer {
    private Scheduler scheduler = new Scheduler();

    public void schedule(Runnable task, long delay) {
        this.scheduleAtFixedRate(task, delay, 0L);
    }

    public void schedule(Runnable task, Date time) {
        long delay = time.getTime() - System.currentTimeMillis();
        this.scheduleAtFixedRate(task, delay, 0L);
    }

    public void scheduleAtFixedRate(Runnable task, Date firstTime, long period) {
        long delay = firstTime.getTime() - System.currentTimeMillis();
        this.scheduleAtFixedRate(task, delay, period);
    }

    public void scheduleAtFixedRate(Runnable task, long delay, long period) {
        if (delay < 0L) {
            delay = 0L;
        }
        if (period <= 0L) {
            this.scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
        } else {
            this.scheduler.scheduleAtFixedRate(task, delay, period, TimeUnit.MILLISECONDS);
        }
    }

    public void cancel() {
        this.scheduler.shutdown();
    }

    public boolean initialized() {
        return this.scheduler.task != null;
    }

    private class Scheduler
    extends ScheduledThreadPoolExecutor {
        private String task;
        private Runnable command;
        private long initialDelay;
        private long period;
        private TimeUnit unit;

        public Scheduler() {
            super(1);
        }

        public ScheduledFuture schedule(Runnable command, long initialDelay, TimeUnit unit) {
            this.task = "schedule";
            this.command = command;
            this.initialDelay = initialDelay;
            this.unit = unit;
            return this.init();
        }

        public ScheduledFuture scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            this.task = "scheduleAtFixedRate";
            this.command = command;
            this.initialDelay = initialDelay;
            this.period = period;
            this.unit = unit;
            return this.init();
        }

        public ScheduledFuture scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            this.task = "scheduleWithFixedDelay";
            this.command = command;
            this.initialDelay = initialDelay;
            this.period = delay;
            this.unit = unit;
            return this.init();
        }

        private ScheduledFuture init() {
            if (this.task.equals("schedule")) {
                return super.schedule(this.wrapRunnable(this.command), this.initialDelay, this.unit);
            }
            if (this.task.equals("scheduleAtFixedRate")) {
                return super.scheduleAtFixedRate(this.wrapRunnable(this.command), this.initialDelay, this.period, this.unit);
            }
            if (this.task.equals("scheduleWithFixedDelay")) {
                return super.scheduleWithFixedDelay(this.wrapRunnable(this.command), this.initialDelay, this.period, this.unit);
            }
            return null;
        }

        private Runnable wrapRunnable(Runnable command) {
            return new LogOnExceptionRunnable(command);
        }

        private class LogOnExceptionRunnable
        implements Runnable {
            private Runnable theRunnable;

            public LogOnExceptionRunnable(Runnable theRunnable) {
                this.theRunnable = theRunnable;
            }

            @Override
            public void run() {
                try {
                    this.theRunnable.run();
                }
                catch (Throwable e) {
                    Scheduler.this.init();
                }
            }
        }
    }
}

