/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javaxt.io.Image;
import javaxt.utils.string;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

public class Response {
    private URLConnection conn = null;
    private Map headers = null;
    private String protocol;
    private String version;
    private int responseCode;
    private String message;

    protected Response(URLConnection conn) {
        this.conn = conn;
        this.headers = conn.getHeaderFields();
        if (!this.headers.isEmpty()) {
            StringTokenizer st = new StringTokenizer((String)((List)this.headers.get(null)).get(0));
            if (st.hasMoreTokens()) {
                this.protocol = st.nextToken().trim().toUpperCase();
            }
            if (this.protocol.contains("/")) {
                String temp = this.protocol;
                this.protocol = temp.substring(0, temp.indexOf("/"));
                this.version = temp.substring(temp.indexOf("/") + 1);
            } else {
                this.protocol = "HTTP";
                this.version = "1.1";
            }
            if (st.hasMoreTokens()) {
                this.responseCode = string.toInt(st.nextToken().trim());
            }
            if (st.hasMoreTokens()) {
                this.message = "";
                while (st.hasMoreTokens()) {
                    this.message = this.message + st.nextToken() + " ";
                }
                this.message = this.message.trim();
            }
        }
    }

    public Map getHeaders() {
        return this.headers;
    }

    public String[] getHeaders(String headerName) {
        List values = new LinkedList();
        for (String key : this.headers.keySet()) {
            if (key == null || !key.equalsIgnoreCase(headerName)) continue;
            values = (List)this.headers.get(key);
        }
        String[] arr = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arr[i] = (String)values.get(i);
        }
        return arr;
    }

    public String getHeader(String headerName) {
        return this.getHeaders(headerName)[0];
    }

    public int getStatus() {
        return this.responseCode;
    }

    public String getMessage() {
        return this.message;
    }

    public InputStream getInputStream() {
        try {
            return this.conn.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getText() {
        try {
            return this.getText("ISO-8859-1");
        }
        catch (Exception e) {
            try {
                return this.getBytes().toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes().toString(charsetName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document getXML() {
        return DOM.createDocument(this.getInputStream());
    }

    public Image getImage() {
        return new Image(this.getInputStream());
    }

    public ByteArrayOutputStream getBytes() {
        try {
            InputStream inputStream = this.conn.getInputStream();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int x = 0;
            while ((x = inputStream.read(b, 0, 1024)) > -1) {
                bas.write(b, 0, x);
            }
            bas.close();
            inputStream.close();
            return bas;
        }
        catch (Exception e) {
            e.toString();
            return null;
        }
    }

    public InputStream getErrorStream() {
        try {
            return ((HttpURLConnection)this.conn).getErrorStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer header = new StringBuffer();
        System.out.println("HeaderFields");
        System.out.println("------------------------------------------------");
        for (String key : this.headers.keySet()) {
            if (key != null) {
                List list = (List)this.headers.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    String value = list.get(i).toString();
                    System.out.println(key + ": " + value);
                }
                continue;
            }
            System.out.println(this.headers.get(key));
        }
        return header.toString();
    }
}

