/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices.wsdl;

import java.text.SimpleDateFormat;
import java.util.Date;
import javaxt.utils.Base64;
import javaxt.webservices.wsdl.Option;
import javaxt.webservices.wsdl.Parameter;
import javaxt.xml.DOM;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Parameters {
    private String vbCrLf = "\r\n";
    private Parameter[] Parameters = null;
    private StringBuffer xml = null;
    private StringBuffer html = null;

    public Parameters(Parameter[] Parameters2) {
        this.Parameters = Parameters2;
    }

    public Parameter[] getArray() {
        return this.Parameters;
    }

    public int getLength() {
        return this.Parameters.length;
    }

    public void setValue(String parameterName, String parameterValue) {
        if (this.Parameters == null) {
            return;
        }
        Parameter parameter = this.getParameter(parameterName);
        if (parameter != null) {
            if (parameter.getValue() == null) {
                parameter.setValue(parameterValue);
            } else if (parameter.getMaxOccurs() > 1) {
                // empty if block
            }
        }
    }

    public void setValue(String parameterName, byte[] bytes) {
        this.setValue(parameterName, Base64.encodeBytes(bytes));
    }

    public void setValue(String ParameterName, Date ParameterValue) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSSZ");
        String d = formatter.format(ParameterValue).replace(" ", "T");
        String d1 = d.substring(0, d.length() - 2);
        String d2 = d.substring(d.length() - 2);
        d = d1 + ":" + d2;
        this.setValue(ParameterName, d);
    }

    public String getValue(String ParameterName) {
        Parameter p = this.getParameter(ParameterName);
        if (p != null) {
            return p.getValue();
        }
        return null;
    }

    public Parameter getParameter(String ParameterName) {
        if (this.Parameters == null) {
            return null;
        }
        return this.getParameter(this.Parameters, ParameterName);
    }

    public Parameter getParameter(int i) {
        return this.Parameters[i];
    }

    private Parameter getParameter(Parameter[] Parameters2, String ParameterName) {
        String B = "";
        if (ParameterName.contains("/")) {
            String[] arr = ParameterName.split("/");
            String A = arr[0];
            B = ParameterName.substring(A.length() + 1);
            ParameterName = A;
        }
        for (int i = 0; i < Parameters2.length; ++i) {
            if (!Parameters2[i].getName().equalsIgnoreCase(ParameterName)) continue;
            if (B.length() == 0) {
                return Parameters2[i];
            }
            return this.getParameter(Parameters2[i].getChildren(), B);
        }
        return null;
    }

    public String toString() {
        if (this.Parameters != null) {
            this.xml = new StringBuffer();
            this.getParameters(this.Parameters);
            return this.xml.toString();
        }
        return "";
    }

    private void getParameters(Parameter[] Parameters2) {
        if (Parameters2 != null) {
            for (int i = 0; i < Parameters2.length; ++i) {
                Parameter Parameter2 = Parameters2[i];
                this.getParameter(Parameter2);
            }
        }
    }

    private void getParameter(Parameter parameter) {
        String ParameterName = parameter.getName();
        this.xml.append("<" + ParameterName + ">");
        if (parameter.isComplex()) {
            this.getParameters(parameter.getChildren());
        } else {
            String ParameterValue = parameter.getValue();
            if (ParameterValue == null) {
                ParameterValue = "";
            }
            if (ParameterValue.trim().length() > 0) {
                if (parameter.Type.equalsIgnoreCase("base64Binary")) {
                    this.xml.append(ParameterValue);
                } else {
                    this.xml.append("<![CDATA[" + ParameterValue + "]]>");
                }
            }
        }
        this.xml.append("</" + ParameterName + ">");
    }

    public String toHTML() {
        String buttons = "<div><br><input type=\"submit\" value=\"Invoke\" name=\"Invoke\" class=\"button\">&nbsp;&nbsp;<input type=\"reset\" value=\"Reset\" name=\"Reset\" class=\"button\"></div>" + this.vbCrLf;
        if (this.Parameters == null) {
            return buttons;
        }
        this.html = new StringBuffer();
        this.html.append(this.vbCrLf);
        this.html.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse:collapse;\">" + this.vbCrLf);
        this.addRows(this.Parameters);
        this.html.append("<tr><td colspan=\"2\"></td><td align=\"center\">" + buttons + "</td><td></td></tr>" + this.vbCrLf);
        this.html.append("</table>" + this.vbCrLf);
        return this.html.toString();
    }

    private void addRows(Parameter[] Parameters2) {
        if (Parameters2 != null) {
            for (int i = 0; i < Parameters2.length; ++i) {
                Parameter Parameter2 = Parameters2[i];
                this.addRow(Parameter2);
            }
        }
    }

    private void addRow(Parameter Parameter2) {
        String ParameterName = Parameter2.getName();
        String ParameterType = Parameter2.getType();
        String ParameterValue = Parameter2.getValue();
        boolean isRequired = Parameter2.isRequired();
        boolean isComplex = Parameter2.isComplex();
        Option[] Options = Parameter2.getOptions();
        String InputText = "";
        String InputName = "";
        String InputValue = "";
        String InputHTML = "";
        InputText = isRequired ? ParameterName + "<span style=\"color:#FF0000;\">*</span>" : ParameterName;
        InputName = this.getParentName(Parameter2.ParentNode) + ParameterName;
        if (ParameterType.equalsIgnoreCase("String")) {
            String type = "text";
            if (ParameterName.toLowerCase().contains("password")) {
                type = "password";
            }
            InputHTML = "<input style=\"width:275px;\" type=\"" + type + "\" size=\"40\" name=\"" + InputName + "\">";
        } else {
            InputHTML = ParameterType.equalsIgnoreCase("Boolean") ? "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-collapse:collapse;\"><tr><td><input type=\"radio\" value=\"TRUE\" checked name=\"" + InputName + "\"></td>" + "<td>TRUE</td>" + "<td>&nbsp;&nbsp; </td>" + "<td><input type=\"radio\" value=\"FALSE\" checked name=\"" + InputName + "\"></td>" + "<td>FALSE</td>" + "</tr>" + "</table>" : (ParameterType.equalsIgnoreCase("base64Binary") ? "<input style=\"width:275px;\" type=\"file\" size=\"40\" name=\"" + InputName + "\">" : "<input style=\"width:275px;\" type=\"text\" size=\"40\" name=\"" + InputName + "\">");
        }
        if (isComplex) {
            InputHTML = "";
        }
        if (Options != null) {
            InputHTML = "<select style=\"width:275px;\" name=\"" + InputName + "\">";
            for (int i = 0; i < Options.length; ++i) {
                Option Option2 = Options[i];
                InputHTML = InputHTML + "<option value=\"" + Option2.getValue() + "\">" + Option2.getName() + "</option>";
            }
            InputHTML = InputHTML + "</select>";
        }
        this.html.append("<tr>" + this.vbCrLf);
        this.html.append("<td></td>" + this.vbCrLf);
        this.html.append("<td valign=\"top\">" + InputText + "</td>" + this.vbCrLf);
        this.html.append("<td valign=\"top\" style=\"padding-left:5px;padding-right:5px;\">" + InputHTML + "</td>" + this.vbCrLf);
        this.html.append("<td valign=\"top\" class=\"smgrytxt\"><i>" + ParameterType + "</i></td>" + this.vbCrLf);
        this.html.append("</tr>" + this.vbCrLf);
        if (Parameter2.isComplex()) {
            this.addRows(Parameter2.getChildren());
        }
    }

    private String getParentName(Node ParameterNode) {
        String ret = "";
        while (ParameterNode != null) {
            if (ParameterNode.getNodeType() == 1 && ParameterNode.getNodeName().equals("parameter")) {
                NamedNodeMap attr = ParameterNode.getAttributes();
                String ParameterName = DOM.getAttributeValue(attr, "name");
                ret = ParameterName + "/" + ret;
            }
            ParameterNode = ParameterNode.getParentNode();
        }
        return ret;
    }
}

