/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices.wsdl;

import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.HashMap;
import javaxt.http.Request;
import javaxt.utils.string;
import javaxt.webservices.wsdl.Method;
import javaxt.webservices.wsdl.Option;
import javaxt.webservices.wsdl.Parameter;
import javaxt.webservices.wsdl.Service;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Parser {
    private Document XMLDoc;
    private String SSD;
    private String vbCrLf = "\r\n";
    private String ElementNameSpace = "";
    private String temp = "";
    private StringBuffer auxSchemas;
    private HashMap NameSpaces;

    public Parser(URL wsdl) {
        this(wsdl, null);
    }

    public Parser(URL wsdl, String HttpProxyServer) {
        this(new Request(wsdl).getResponse().getXML());
    }

    public Parser(File wsdl) {
        this(new javaxt.io.File(wsdl).getXML());
    }

    public Parser(Document wsdl) {
        this.XMLDoc = wsdl;
        this.ElementNameSpace = this.getElementNameSpace();
        this.SSD = "";
        this.generateSSD();
        this.SSD = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + this.vbCrLf + "<ssd>" + this.vbCrLf + this.SSD + this.vbCrLf + "</ssd>";
        this.XMLDoc = DOM.createDocument(this.SSD);
    }

    private void importSchemas() {
        this.auxSchemas = new StringBuffer();
        this.NameSpaces = new HashMap();
        NodeList Schema = this.getSchema();
        for (int i = 0; i < Schema.getLength(); ++i) {
            Node node = this.getNode(Schema.item(i), "import");
            if (node == null) continue;
            NamedNodeMap attr = node.getAttributes();
            String schemaLocation = this.getAttributeValue(attr, "schemaLocation");
            this.importSchemas(schemaLocation);
            Node iSchema = node.getParentNode();
            iSchema.removeChild(node);
        }
        this.auxSchemas.append(DOM.getText(Schema));
    }

    private void importSchemas(String schemaLocation) {
        Document doc = DOM.createDocument(schemaLocation);
        if (doc != null) {
            this.NameSpaces.putAll(DOM.getNameSpaces(doc));
            NodeList Schema = doc.getChildNodes();
            Schema = this.getChildNodes(Schema, "schema");
            for (int i = 0; i < Schema.getLength(); ++i) {
                Node node = this.getNode(Schema.item(i), "import");
                if (node == null) continue;
                NamedNodeMap attr = node.getAttributes();
                schemaLocation = this.getAttributeValue(attr, "schemaLocation");
                this.importSchemas(schemaLocation);
                Node iSchema = node.getParentNode();
                iSchema.removeChild(node);
            }
            this.auxSchemas.append(DOM.getText(Schema));
        }
    }

    public String getSSD() {
        return this.SSD;
    }

    public String toString() {
        return this.getSSD();
    }

    private NamedNodeMap getDefinitionAttributes() {
        NodeList Definitions = this.XMLDoc.getChildNodes();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            if (Definitions.item(i).getNodeType() != 1 || !this.contains(Definitions.item(i).getNodeName(), "definitions")) continue;
            return Definitions.item(i).getAttributes();
        }
        return null;
    }

    private String getTargetNameSpace() {
        NamedNodeMap attr = this.getDefinitionAttributes();
        return this.getAttributeValue(attr, "targetNamespace");
    }

    private String getElementNameSpace() {
        String elementNameSpace = "http://www.w3.org/2001/XMLSchema";
        NamedNodeMap attr = this.getDefinitionAttributes();
        if (attr != null) {
            for (int i = 0; i < attr.getLength(); ++i) {
                Node node = attr.item(i);
                String nodeName = node.getNodeName().toLowerCase();
                String nodeValue = node.getNodeValue();
                if (!nodeValue.toLowerCase().equals(elementNameSpace.toLowerCase())) continue;
                return this.stripNameSpace(nodeName);
            }
        }
        return "";
    }

    private boolean isElementComplex(String elementType) {
        String elementNameSpace = this.getNameSpace(elementType);
        return !elementNameSpace.toLowerCase().equals(this.ElementNameSpace.toLowerCase());
    }

    private boolean isElementNillable(String isnillable) {
        return isnillable.toLowerCase().equals("true");
    }

    private void generateSSD() {
        String ServiceName = "";
        String ServiceDescription = "";
        Port Port2 = null;
        Binding Binding2 = null;
        Binding[] arrBindings = null;
        Element Element2 = null;
        Element[] arrElements = null;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            int j;
            if (!this.contains(Definitions.item(i).getNodeName(), "service")) continue;
            NamedNodeMap attr = Definitions.item(i).getAttributes();
            ServiceName = this.getAttributeValue(attr, "name");
            NodeList ChildNodes = Definitions.item(i).getChildNodes();
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "documentation")) continue;
                ServiceDescription = ChildNodes.item(j).getTextContent();
            }
            Port2 = this.getPort(ChildNodes);
            if (Port2 == null) continue;
            this.SSD = this.SSD + " <service name=\"" + ServiceName + "\" url=\"" + Port2.Address + "\" namespace=\"" + this.getTargetNameSpace() + "\">" + this.vbCrLf;
            if (ServiceDescription != null) {
                this.SSD = this.SSD + "  <description>" + ServiceDescription + "</description>" + this.vbCrLf;
            }
            this.SSD = this.SSD + "  <methods>" + this.vbCrLf;
            arrBindings = this.getBindings(Port2.Binding);
            for (j = 0; j < arrBindings.length; ++j) {
                int k;
                Binding2 = arrBindings[j];
                String SoapAction = Binding2.SoapAction;
                if (SoapAction != null) {
                    SoapAction = " soapAction=\"" + SoapAction + "\"";
                }
                Message Message2 = this.getMessages(Binding2.Type, Binding2.Operation);
                String ResultsNode = "";
                try {
                    arrElements = this.getMessageType(Message2.Output);
                    for (k = 0; k < arrBindings.length; ++k) {
                        Element2 = arrElements[k];
                        ResultsNode = Element2.Name;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.SSD = this.SSD + "  <method name=\"" + Binding2.Operation + "\"" + SoapAction + " resultsNode=\"" + ResultsNode + "\">" + this.vbCrLf;
                if (Message2.Documentation != null) {
                    this.SSD = this.SSD + "  <description>" + Message2.Documentation + "</description>" + this.vbCrLf;
                }
                this.SSD = this.SSD + "  <parameters>" + this.vbCrLf;
                try {
                    arrElements = this.getMessageType(Message2.Input);
                    for (k = 0; k < arrElements.length; ++k) {
                        Element2 = arrElements[k];
                        this.SSD = this.SSD + "   <parameter name=\"" + Element2.Name + "\" " + "type=\"" + Element2.Type + "\" " + "minOccurs=\"" + Element2.minOccurs + "\" " + "maxOccurs=\"" + Element2.maxOccurs + "\" " + "iscomplex=\"" + Element2.IsComplex + "\" " + "isnillable=\"" + Element2.IsNillable + "\">" + this.vbCrLf;
                        try {
                            if (Element2.IsComplex) {
                                this.temp = "";
                                this.decomposeComplexType(Element2.Type, null);
                                this.SSD = this.SSD + this.temp;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.SSD = this.SSD + "   </parameter>" + this.vbCrLf;
                    }
                }
                catch (Exception e) {
                    StackTraceElement[] arr = e.getStackTrace();
                    for (int z = 0; z < arr.length; ++z) {
                    }
                }
                this.SSD = this.SSD + "  </parameters>" + this.vbCrLf;
                this.SSD = this.SSD + "  </method>" + this.vbCrLf;
            }
            this.SSD = this.SSD + "  </methods>" + this.vbCrLf;
            this.SSD = this.SSD + " </service>" + this.vbCrLf;
        }
    }

    private Port getPort(NodeList Ports) {
        Port Port2 = null;
        boolean foundSoapPort = false;
        for (int j = 0; j < Ports.getLength(); ++j) {
            if (!this.contains(Ports.item(j).getNodeName(), "port")) continue;
            NamedNodeMap attr = Ports.item(j).getAttributes();
            String PortName = this.getAttributeValue(attr, "name");
            String PortBinding = this.stripNameSpace(this.getAttributeValue(attr, "binding"));
            String PortAddress = "";
            NodeList Addresses2 = Ports.item(j).getChildNodes();
            for (int k = 0; k < Addresses2.getLength(); ++k) {
                String Address = Addresses2.item(k).getNodeName();
                if (!this.contains(Address, "address") || this.contains(Address, "http:")) continue;
                attr = Addresses2.item(k).getAttributes();
                PortAddress = this.getAttributeValue(attr, "location");
                foundSoapPort = true;
            }
            if (!foundSoapPort) continue;
            Port2 = new Port();
            Port2.Name = PortName;
            Port2.Binding = PortBinding;
            Port2.Address = PortAddress;
            return Port2;
        }
        return Port2;
    }

    private Binding[] getBindings(String PortBinding) {
        Binding Binding2 = null;
        Binding[] arrBindings = null;
        int BindingCount = -1;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            int j;
            if (!this.contains(Definitions.item(i).getNodeName(), "binding")) continue;
            NamedNodeMap attr = Definitions.item(i).getAttributes();
            String BindingName = this.getAttributeValue(attr, "name");
            String BindingType = this.getAttributeValue(attr, "type");
            if (!BindingName.equals(PortBinding)) continue;
            arrBindings = new Binding[]{};
            String BindingTransport = "";
            String BindingStyle = "";
            NodeList ChildNodes = Definitions.item(i).getChildNodes();
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "binding")) continue;
                attr = ChildNodes.item(j).getAttributes();
                BindingStyle = this.getAttributeValue(attr, "style");
                BindingTransport = this.getAttributeValue(attr, "transport");
            }
            for (j = 0; j < ChildNodes.getLength(); ++j) {
                if (!this.contains(ChildNodes.item(j).getNodeName(), "operation")) continue;
                Binding2 = new Binding();
                ++BindingCount;
                attr = ChildNodes.item(j).getAttributes();
                Binding2.Operation = this.getAttributeValue(attr, "name");
                NodeList Operations = ChildNodes.item(j).getChildNodes();
                for (int k = 0; k < Operations.getLength(); ++k) {
                    if (!this.contains(Operations.item(k).getNodeName(), "operation")) continue;
                    attr = Operations.item(k).getAttributes();
                    Binding2.SoapAction = this.getAttributeValue(attr, "soapaction");
                    Binding2.Style = BindingStyle;
                    Binding2.Name = BindingName;
                    Binding2.Type = this.stripNameSpace(BindingType);
                }
                arrBindings = (Binding[])Parser.resizeArray(arrBindings, BindingCount + 1);
                arrBindings[BindingCount] = Binding2;
            }
            return arrBindings;
        }
        return null;
    }

    private Message getMessages(String PortTypeName, String OperationName) {
        Message Message2 = null;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            NamedNodeMap attr;
            String portTypeName;
            if (!this.contains(Definitions.item(i).getNodeName(), "porttype") || !(portTypeName = this.getAttributeValue(attr = Definitions.item(i).getAttributes(), "name")).equals(PortTypeName)) continue;
            String Documentation = "";
            NodeList PortTypes = Definitions.item(i).getChildNodes();
            for (int j = 0; j < PortTypes.getLength(); ++j) {
                String operationName;
                String NodeName = PortTypes.item(j).getNodeName();
                if (NodeName.endsWith("documentation")) {
                    Documentation = DOM.getNodeValue(PortTypes.item(j));
                }
                if (!NodeName.endsWith("operation") || !(operationName = this.getAttributeValue(attr = PortTypes.item(j).getAttributes(), "name")).equals(OperationName)) continue;
                Message2 = new Message();
                Message2.Documentation = Documentation;
                NodeList Messages = PortTypes.item(j).getChildNodes();
                for (int k = 0; k < Messages.getLength(); ++k) {
                    if (Messages.item(k).getNodeType() != 1) continue;
                    attr = Messages.item(k).getAttributes();
                    String messageName = this.stripNameSpace(this.getAttributeValue(attr, "message"));
                    if (this.contains(Messages.item(k).getNodeName(), "input")) {
                        Message2.Input = messageName;
                    }
                    if (this.contains(Messages.item(k).getNodeName(), "output")) {
                        Message2.Output = messageName;
                    }
                    if (!this.contains(Messages.item(k).getNodeName(), "documentation") || (Documentation = DOM.getNodeValue(Messages.item(k))).length() <= 0) continue;
                    Message2.Documentation = Documentation;
                }
                return Message2;
            }
        }
        return Message2;
    }

    private Element[] getMessageType(String MessageName) {
        Element Element2 = null;
        Element[] arrElements = new Element[]{};
        int ElementCount = -1;
        NodeList Definitions = this.getDefinitions();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            NamedNodeMap attr;
            String messageName;
            if (!this.contains(Definitions.item(i).getNodeName(), "message") || !(messageName = this.getAttributeValue(attr = Definitions.item(i).getAttributes(), "name")).equals(MessageName)) continue;
            NodeList Messages = Definitions.item(i).getChildNodes();
            for (int j = 0; j < Messages.getLength(); ++j) {
                if (!this.contains(Messages.item(j).getNodeName(), "part")) continue;
                attr = Messages.item(j).getAttributes();
                String type = this.getAttributeValue(attr, "type");
                if (type != "") {
                    Element2 = new Element(Messages.item(j));
                    arrElements = (Element[])Parser.resizeArray(arrElements, ++ElementCount + 1);
                    arrElements[ElementCount] = Element2;
                    continue;
                }
                String element = this.stripNameSpace(this.getAttributeValue(attr, "element"));
                arrElements = this.getElementType(element);
            }
            return arrElements;
        }
        return null;
    }

    private Element[] getElementType(String ElementName) {
        Element[] arrElements = new Element[]{};
        int ElementCount = -1;
        NodeList Schemas = this.getSchema();
        for (int k = 0; k < Schemas.getLength(); ++k) {
            if (!this.contains(Schemas.item(k).getNodeName(), "element")) continue;
            NamedNodeMap attrElement = Schemas.item(k).getAttributes();
            String elementName = this.getAttributeValue(attrElement, "name");
            String elementType = this.getAttributeValue(attrElement, "type");
            if (!elementName.equals(ElementName)) continue;
            if (!DOM.hasChildren(Schemas.item(k))) {
                String s = this.decomposeComplexType(this.stripNameSpace(elementType), null);
                Document doc = DOM.createDocument("<parameters>" + s + "</parameters>");
                NodeList Elements = doc.getElementsByTagName("parameter");
                for (int x = 0; x < Elements.getLength(); ++x) {
                    if (Elements.item(x).getNodeType() != 1) continue;
                    Element Element2 = new Element(Elements.item(x));
                    arrElements = (Element[])Parser.resizeArray(arrElements, ++ElementCount + 1);
                    arrElements[ElementCount] = Element2;
                }
            } else {
                try {
                    NodeList Elements = Schemas.item(k).getChildNodes();
                    for (int x = 0; x < Elements.getLength(); ++x) {
                        if (!this.contains(Elements.item(x).getNodeName(), "complextype")) continue;
                        NodeList ComplexType = Elements.item(x).getChildNodes();
                        for (int y = 0; y < ComplexType.getLength(); ++y) {
                            if (!this.contains(ComplexType.item(y).getNodeName(), "sequence")) continue;
                            NodeList Sequence = ComplexType.item(y).getChildNodes();
                            for (int z = 0; z < Sequence.getLength(); ++z) {
                                if (!this.contains(Sequence.item(z).getNodeName(), "element")) continue;
                                Element Element3 = new Element(Sequence.item(z));
                                arrElements = (Element[])Parser.resizeArray(arrElements, ++ElementCount + 1);
                                arrElements[ElementCount] = Element3;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return arrElements;
        }
        return null;
    }

    private NodeList getChildNodes(NodeList ParentNodes, String NodeName) {
        for (int i = 0; i < ParentNodes.getLength(); ++i) {
            Node node = ParentNodes.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().endsWith(NodeName)) continue;
            return node.getChildNodes();
        }
        return null;
    }

    private Node getNode(Node node, String NodeName) {
        if (node.getNodeType() == 1 && node.getNodeName().endsWith(NodeName)) {
            return node;
        }
        return null;
    }

    private NodeList getDefinitions() {
        NodeList Definitions = this.XMLDoc.getChildNodes();
        if (Definitions != null) {
            for (int i = 0; i < Definitions.getLength(); ++i) {
                Node node = Definitions.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().endsWith("definitions")) continue;
                return Definitions.item(i).getChildNodes();
            }
        }
        return null;
    }

    private NodeList getTypes() {
        NodeList Definitions = this.getDefinitions();
        if (Definitions != null) {
            for (int i = 0; i < Definitions.getLength(); ++i) {
                Node node = Definitions.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().endsWith("types")) continue;
                return node.getChildNodes();
            }
        }
        return null;
    }

    private NodeList getSchema() {
        NodeList Types = this.getTypes();
        if (Types != null) {
            for (int i = 0; i < Types.getLength(); ++i) {
                Node node = Types.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().endsWith("schema")) continue;
                return node.getChildNodes();
            }
        }
        return null;
    }

    private String decomposeComplexType(String ElementName, NodeList Types) {
        if (Types == null) {
            Types = this.getTypes();
        }
        NodeList Schemas = this.getSchema();
        for (int x = 0; x < Schemas.getLength(); ++x) {
            NamedNodeMap attr;
            String typeName;
            String nodeName = Schemas.item(x).getNodeName().toLowerCase();
            boolean isComplexType = false;
            boolean isSimpleType = false;
            if (nodeName.equals("complextype") || nodeName.contains(":complextype")) {
                isComplexType = true;
            }
            if (nodeName.equals("simpletype") || nodeName.contains(":simpletype")) {
                isSimpleType = true;
            }
            if (!isComplexType && !isSimpleType || !(typeName = this.getAttributeValue(attr = Schemas.item(x).getAttributes(), "name")).equals(ElementName)) continue;
            if (isComplexType) {
                NodeList ComplexType = Schemas.item(x).getChildNodes();
                for (int y = 0; y < ComplexType.getLength(); ++y) {
                    if (!ComplexType.item(y).getNodeName().endsWith("sequence")) continue;
                    NodeList Sequence = ComplexType.item(y).getChildNodes();
                    for (int z = 0; z < Sequence.getLength(); ++z) {
                        if (!Sequence.item(z).getNodeName().endsWith("element")) continue;
                        Element Element2 = new Element(Sequence.item(z));
                        String elementType = this.stripNameSpace(Element2.Type);
                        this.temp = this.temp + "   <parameter name=\"" + Element2.Name + "\" " + "type=\"" + elementType + "\" " + "iscomplex=\"" + Element2.IsComplex + "\" " + "isnillable=\"" + Element2.IsNillable + "\">" + this.vbCrLf;
                        if (Element2.IsComplex) {
                            this.decomposeComplexType(elementType, Types);
                        }
                        this.temp = this.temp + "   </parameter>" + this.vbCrLf;
                    }
                }
            }
            if (!isSimpleType) continue;
            String Options = "";
            NodeList SimpleType = Schemas.item(x).getChildNodes();
            for (int y = 0; y < SimpleType.getLength(); ++y) {
                nodeName = SimpleType.item(y).getNodeName();
                if (!nodeName.equals("restriction") && !nodeName.contains(":restriction")) continue;
                NodeList Restriction = SimpleType.item(y).getChildNodes();
                for (int z = 0; z < Restriction.getLength(); ++z) {
                    String OptionValue;
                    nodeName = Restriction.item(z).getNodeName();
                    if (!nodeName.equals("enumeration") && !nodeName.contains(":enumeration") || (OptionValue = this.getAttributeValue(attr = Restriction.item(z).getAttributes(), "value")).length() <= 0) continue;
                    Options = Options + "    <option value=\"" + OptionValue + "\">" + OptionValue + "</option>" + this.vbCrLf;
                }
            }
            if (Options.length() <= 0) continue;
            this.temp = this.temp + "   <options>" + this.vbCrLf;
            this.temp = this.temp + Options;
            this.temp = this.temp + "   </options>" + this.vbCrLf;
        }
        return this.temp;
    }

    public Service getService(String ServiceName) {
        if (ServiceName == null) {
            ServiceName = "";
        }
        if ((ServiceName = ServiceName.trim()).equals("")) {
            return this.getService(0);
        }
        Service[] arrServices = this.getServices();
        if (arrServices != null) {
            for (int i = 0; i < arrServices.length; ++i) {
                if (!arrServices[i].equals(ServiceName)) continue;
                return arrServices[i];
            }
        }
        return null;
    }

    public Service getService(int i) {
        Service[] arrServices = this.getServices();
        if (arrServices != null && i < arrServices.length) {
            return arrServices[i];
        }
        return null;
    }

    public Method getMethod(String ServiceName, String MethodName) {
        Service Service2 = this.getService(ServiceName);
        if (Service2 != null) {
            return Service2.getMethod(MethodName);
        }
        return null;
    }

    public Method getMethod(String MethodName) {
        Service Service2 = this.getService(0);
        if (Service2 != null) {
            return Service2.getMethod(MethodName);
        }
        return null;
    }

    public Service[] getServices() {
        Service[] arrServices = new Service[]{};
        NodeList Services = this.XMLDoc.getElementsByTagName("service");
        for (int i = 0; i < Services.getLength(); ++i) {
            Service Service2;
            if (Services.item(i).getNodeType() != 1 || (Service2 = this.getService(Services.item(i))) == null) continue;
            int x = arrServices.length;
            arrServices = (Service[])Parser.resizeArray(arrServices, x + 1);
            arrServices[x] = Service2;
        }
        if (arrServices.length == 0) {
            return null;
        }
        return arrServices;
    }

    private Service getService(Node ServiceNode) {
        Service Service2 = null;
        if (ServiceNode.getNodeType() == 1) {
            NamedNodeMap attr = ServiceNode.getAttributes();
            Service2 = new Service();
            Service2.Name = this.getAttributeValue(attr, "name");
            Service2.NameSpace = this.getAttributeValue(attr, "namespace");
            Service2.URL = this.getAttributeValue(attr, "url");
            NodeList ChildNodes = ServiceNode.getChildNodes();
            for (int j = 0; j < ChildNodes.getLength(); ++j) {
                if (ChildNodes.item(j).getNodeType() != 1) continue;
                String NodeName = ChildNodes.item(j).getNodeName();
                String NodeValue = ChildNodes.item(j).getTextContent();
                if (NodeName.toLowerCase().equals("description")) {
                    Service2.Description = NodeValue;
                }
                if (!NodeName.toLowerCase().equals("methods")) continue;
                Service2.Methods = this.getMethods(ChildNodes.item(j).getChildNodes());
            }
        }
        return Service2;
    }

    private Method[] getMethods(NodeList Methods) {
        Method[] arrMethods = new Method[]{};
        for (int i = 0; i < Methods.getLength(); ++i) {
            Method method;
            if (Methods.item(i).getNodeType() != 1 || (method = this.getMethod(Methods.item(i))) == null) continue;
            int x = arrMethods.length;
            arrMethods = (Method[])Parser.resizeArray(arrMethods, x + 1);
            arrMethods[x] = method;
        }
        if (arrMethods.length == 0) {
            return null;
        }
        return arrMethods;
    }

    private Method getMethod(Node MethodNode) {
        Method Method2 = null;
        if (MethodNode.getNodeType() == 1) {
            NamedNodeMap attr = MethodNode.getAttributes();
            Method2 = new Method();
            Method2.Name = this.getAttributeValue(attr, "name");
            Method2.SoapAction = this.getAttributeValue(attr, "soapAction");
            Method2.ResultsNode = this.getAttributeValue(attr, "resultsNode");
            NodeList ChildNodes = MethodNode.getChildNodes();
            for (int j = 0; j < ChildNodes.getLength(); ++j) {
                if (ChildNodes.item(j).getNodeType() != 1) continue;
                String NodeName = ChildNodes.item(j).getNodeName();
                String NodeValue = ChildNodes.item(j).getTextContent();
                if (NodeName.toLowerCase().equals("description")) {
                    Method2.Description = NodeValue;
                }
                if (!NodeName.toLowerCase().equals("parameters")) continue;
                Method2.ParameterXML = ChildNodes.item(j).getChildNodes();
                Method2.Parameters = this.getParameters(ChildNodes.item(j).getChildNodes());
            }
        }
        return Method2;
    }

    private Parameter[] getParameters(NodeList Parameters2) {
        Parameter[] arrParameters = new Parameter[]{};
        for (int i = 0; i < Parameters2.getLength(); ++i) {
            if (Parameters2.item(i).getNodeType() != 1) continue;
            Parameter Parameter2 = this.getParameter(Parameters2.item(i));
            int numParams = arrParameters.length;
            arrParameters = (Parameter[])Parser.resizeArray(arrParameters, numParams + 1);
            arrParameters[numParams] = Parameter2;
            if (!Parameter2.isComplex()) continue;
            Parameter2.Children = this.getParameters(Parameter2.ChildNodes);
        }
        if (arrParameters.length == 0) {
            return null;
        }
        return arrParameters;
    }

    private Parameter getParameter(Node ParameterNode) {
        Parameter Parameter2 = new Parameter();
        NamedNodeMap attr = ParameterNode.getAttributes();
        Parameter2.Name = this.getAttributeValue(attr, "name");
        Parameter2.Type = this.getAttributeValue(attr, "type");
        Parameter2.IsNillable = this.bool(this.getAttributeValue(attr, "isnillable"));
        Parameter2.minOccurs = this.getAttributeValue(attr, "minOccurs");
        Parameter2.ChildNodes = ParameterNode.getChildNodes();
        Parameter2.ParentNode = ParameterNode.getParentNode();
        Parameter2.Options = this.getOptions(ParameterNode.getChildNodes());
        return Parameter2;
    }

    private Option[] getOptions(NodeList Options) {
        Option[] arrOptions = new Option[]{};
        for (int i = 0; i < Options.getLength(); ++i) {
            String NodeName;
            if (Options.item(i).getNodeType() != 1 || !(NodeName = Options.item(i).getNodeName()).equalsIgnoreCase("options")) continue;
            NodeList ChildNodes = Options.item(i).getChildNodes();
            for (int j = 0; j < ChildNodes.getLength(); ++j) {
                if (ChildNodes.item(j).getNodeType() != 1) continue;
                Option Option2 = this.getOption(ChildNodes.item(j));
                int numOptions = arrOptions.length;
                arrOptions = (Option[])Parser.resizeArray(arrOptions, numOptions + 1);
                arrOptions[numOptions] = Option2;
            }
        }
        if (arrOptions.length == 0) {
            return null;
        }
        return arrOptions;
    }

    private Option getOption(Node node) {
        String value;
        NamedNodeMap attr = node.getAttributes();
        String name = value = this.getAttributeValue(attr, "value");
        return new Option(name, value);
    }

    public String[] getListOfServices() {
        String[] arrServices = null;
        Service[] Services = this.getServices();
        if (Services != null) {
            arrServices = new String[Services.length];
            for (int i = 0; i < Services.length; ++i) {
                arrServices[i] = Services[i].getName();
            }
        }
        return arrServices;
    }

    public String[] getListOfMethods(String ServiceName) {
        String[] arrMethods = null;
        Service Service2 = this.getService(ServiceName);
        Method[] Methods = Service2.Methods;
        if (Methods != null) {
            arrMethods = new String[Methods.length];
            for (int i = 0; i < Methods.length; ++i) {
                arrMethods[i] = Methods[i].getName();
            }
        }
        return arrMethods;
    }

    private String getAttributeValue(NamedNodeMap attrCollection, String attrName) {
        return DOM.getAttributeValue(attrCollection, attrName);
    }

    private boolean bool(String str) {
        return str.equalsIgnoreCase("true");
    }

    private String getNameSpace(String str) {
        return this.left(str, this.instr(str, ":") - 1);
    }

    private String stripNameSpace(String str) {
        return this.right(str, this.len(str) - this.instr(str, ":"));
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    private int instr(String str, String ch) {
        return string.instr(str, ch);
    }

    private boolean contains(String str, String ch) {
        return string.contains(str, ch, true);
    }

    private int len(String str) {
        return string.len(str);
    }

    private String left(String str, int n) {
        return string.left(str, n);
    }

    private String right(String str, int n) {
        return string.right(str, n);
    }

    private class Element {
        public String Name;
        public String Type;
        public boolean IsNillable = false;
        public boolean IsComplex = false;
        public String minOccurs = "0";
        public String maxOccurs = "1";

        public Element(Node node) {
            NamedNodeMap attr = node.getAttributes();
            this.Name = Parser.this.getAttributeValue(attr, "name");
            this.Type = Parser.this.getAttributeValue(attr, "type");
            this.IsNillable = Parser.this.isElementNillable(Parser.this.getAttributeValue(attr, "nillable"));
            this.IsComplex = Parser.this.isElementComplex(this.Type);
            this.minOccurs = Parser.this.getAttributeValue(attr, "minOccurs");
            this.maxOccurs = Parser.this.getAttributeValue(attr, "maxOccurs");
            if (this.minOccurs.length() == 0) {
                this.minOccurs = "0";
            }
            if (this.maxOccurs.length() == 0) {
                this.maxOccurs = "1";
            }
            this.Type = Parser.this.stripNameSpace(this.Type);
            String elementRef = Parser.this.getAttributeValue(attr, "ref");
            if (elementRef.length() > 0) {
                this.Name = elementRef;
            }
        }
    }

    private class Message {
        public String Input;
        public String Output;
        public String Documentation = null;

        private Message() {
        }
    }

    private class Binding {
        public String Operation;
        public String SoapAction;
        public String Style;
        public String Name;
        public String Type;

        private Binding() {
        }
    }

    private class Port {
        public String Name;
        public String Binding;
        public String Address;

        private Port() {
        }
    }
}

