/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javaxt.http.Response;
import javaxt.utils.string;

public class Request {
    protected URLConnection conn = null;
    private Proxy HttpProxy;
    private URL url;
    private boolean useCache = false;
    private int maxRedirects = 5;
    private Map headers = null;
    private String protocol;
    private String version;
    private int responseCode;
    private String message;
    private List RequestProperties = new LinkedList();

    public Request(String url) {
        this(url, null);
    }

    public Request(String url, String httpProxy) {
        try {
            this.url = new URL(url);
            this.setProxy(httpProxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request(URL url) {
        this(url, null);
    }

    public Request(URL url, String httpProxy) {
        this.url = url;
        this.setProxy(httpProxy);
    }

    public URL getURL() {
        return this.url;
    }

    public Response getResponse() {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        return new Response(this);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setNumRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void addHeader(String key, String value) {
        new RequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStream output = null;
        try {
            output = this.conn.getOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = payload.read(buf)) != -1) {
                output.write(buf, 0, i);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStreamWriter output = null;
        try {
            output = new OutputStreamWriter(this.conn.getOutputStream());
            output.write(payload);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private URLConnection getConnection() {
        this.conn = null;
        URLConnection conn = this.connect();
        if (conn != null) {
            this.parseResponse(conn);
            if (this.responseCode >= 300 && this.responseCode < 400 && this.maxRedirects > 0) {
                int numRedirects = 0;
                while (this.responseCode >= 300 && this.responseCode < 400) {
                    try {
                        this.url = new URL(this.getResponseHeader("Location"));
                        conn = this.connect();
                        this.parseResponse(conn);
                        if (++numRedirects <= this.maxRedirects) continue;
                    }
                    catch (Exception e) {}
                    break;
                }
            }
        }
        return conn;
    }

    private URLConnection connect() {
        try {
            URLConnection conn = this.HttpProxy == null || this.isLocalHost(this.url.getHost()) ? this.url.openConnection() : this.url.openConnection(this.HttpProxy);
            conn.setUseCaches(this.useCache);
            for (int i = 0; i < this.RequestProperties.size(); ++i) {
                RequestProperty property = (RequestProperty)this.RequestProperties.get(i);
                conn.setRequestProperty(property.key, property.value);
            }
            return conn;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void parseResponse(URLConnection conn) {
        this.protocol = "";
        this.version = "";
        this.responseCode = -1;
        this.message = "";
        this.headers = conn.getHeaderFields();
        if (!this.headers.isEmpty()) {
            StringTokenizer st = new StringTokenizer((String)((List)this.headers.get(null)).get(0));
            if (st.hasMoreTokens()) {
                this.protocol = st.nextToken().trim().toUpperCase();
            }
            if (this.protocol.contains("/")) {
                String temp = this.protocol;
                this.protocol = temp.substring(0, temp.indexOf("/"));
                this.version = temp.substring(temp.indexOf("/") + 1);
            } else {
                this.protocol = "HTTP";
                this.version = "1.1";
            }
            if (st.hasMoreTokens()) {
                this.responseCode = string.toInt(st.nextToken().trim());
            }
            if (st.hasMoreTokens()) {
                this.message = "";
                while (st.hasMoreTokens()) {
                    this.message = this.message + st.nextToken() + " ";
                }
                this.message = this.message.trim();
            }
        }
    }

    protected int getResponseCode() {
        return this.responseCode;
    }

    protected String getResponseMessage() {
        return this.message;
    }

    protected Map getResponseHeaders() {
        return this.headers;
    }

    protected String[] getResponseHeaders(String headerName) {
        List values = new LinkedList();
        for (String key : this.headers.keySet()) {
            if (key == null || !key.equalsIgnoreCase(headerName)) continue;
            values = (List)this.headers.get(key);
        }
        String[] arr = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arr[i] = (String)values.get(i);
        }
        return arr;
    }

    protected String getResponseHeader(String headerName) {
        return this.getResponseHeaders(headerName)[0];
    }

    public Proxy setProxy(String proxyHost, int proxyPort) {
        InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
        this.HttpProxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        return this.HttpProxy;
    }

    public Proxy setProxy(String httpProxy) {
        if (httpProxy != null && httpProxy.length() > 0) {
            String[] arr = httpProxy.split(":");
            String httpHost = arr[0];
            int httpPort = 80;
            if (arr.length > 0) {
                httpPort = Integer.valueOf(arr[1]);
            }
            return this.setProxy(httpHost, httpPort);
        }
        return null;
    }

    public void setProxy(Proxy httpProxy) {
        this.HttpProxy = httpProxy;
    }

    public boolean isProxyAvailable(String proxyHost, int proxyPort) {
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            System.out.println("Name: " + address.getHostName());
            System.out.println("Addr: " + address.getHostAddress());
            System.out.println("Reach: " + address.isReachable(3000));
            return true;
        }
        catch (UnknownHostException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalHost(String host) {
        return (host = host.toLowerCase()).equals("localhost") || host.equals("127.0.0.1");
    }

    private class RequestProperty {
        private String key;
        private String value;

        public RequestProperty(String key, String value) {
            this.key = key;
            this.value = value;
            Request.this.RequestProperties.add(this);
        }
    }
}

