/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javaxt.http.Request;
import javaxt.io.Image;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

public class Response {
    private URLConnection conn;
    private Request request;

    protected Response(Request request) {
        this.request = request;
        this.conn = request.conn;
    }

    public URL getURL() {
        return this.request.getURL();
    }

    public Map getHeaders() {
        return this.request.getResponseHeaders();
    }

    public String[] getHeaders(String headerName) {
        return this.request.getResponseHeaders(headerName);
    }

    public String getHeader(String headerName) {
        return this.request.getResponseHeader(headerName);
    }

    public int getStatus() {
        return this.request.getResponseCode();
    }

    public String getMessage() {
        return this.request.getResponseMessage();
    }

    public InputStream getInputStream() {
        try {
            return this.conn.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getText() {
        try {
            return this.getText("ISO-8859-1");
        }
        catch (Exception e) {
            try {
                return this.getBytes().toString();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes().toString(charsetName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document getXML() {
        return DOM.createDocument(this.getInputStream());
    }

    public Image getImage() {
        return new Image(this.getInputStream());
    }

    public ByteArrayOutputStream getBytes() {
        try {
            InputStream inputStream = this.conn.getInputStream();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int x = 0;
            while ((x = inputStream.read(b, 0, 1024)) > -1) {
                bas.write(b, 0, x);
            }
            bas.close();
            inputStream.close();
            return bas;
        }
        catch (Exception e) {
            e.toString();
            return null;
        }
    }

    public InputStream getErrorStream() {
        try {
            return ((HttpURLConnection)this.conn).getErrorStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        Map headers = this.request.getResponseHeaders();
        StringBuffer header = new StringBuffer();
        System.out.println("HeaderFields");
        System.out.println("------------------------------------------------");
        for (String key : headers.keySet()) {
            if (key != null) {
                List list = (List)headers.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    String value = list.get(i).toString();
                    System.out.println(key + ": " + value);
                }
                continue;
            }
            System.out.println(headers.get(key));
        }
        return header.toString();
    }
}

