/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javaxt.io.File;

public class Shell {
    private java.io.File executable;
    private String[] inputs;
    private List<String> output = new LinkedList<String>();
    private List<String> errors = new LinkedList<String>();
    private long ellapsedTime;

    public Shell(java.io.File executable, String[] parameters) {
        this.executable = executable;
        this.ellapsedTime = -1L;
        if (parameters == null) {
            parameters = new String[]{};
        }
        this.inputs = new String[parameters.length + 1];
        this.inputs[0] = executable.toString();
        for (int i = 0; i < parameters.length; ++i) {
            this.inputs[i + 1] = parameters[i];
        }
    }

    public Shell(File executable, String[] parameters) {
        this(executable.toFile(), parameters);
    }

    public List getOutput() {
        return this.output;
    }

    public List getErrors() {
        return this.errors;
    }

    public void run() {
        this.ellapsedTime = -1L;
        long startTime = new Date().getTime();
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(this.inputs, null, this.executable.getParentFile());
            StreamReader s1 = new StreamReader(this.output, process.getInputStream());
            StreamReader s2 = new StreamReader(this.errors, process.getErrorStream());
            s1.start();
            s2.start();
            process.waitFor();
            s1.join();
            s2.join();
            try {
                process.getInputStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                process.getErrorStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                process.getOutputStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                process.destroy();
            }
            catch (Exception ex) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ellapsedTime = new Date().getTime() - startTime;
    }

    public long getEllapsedTime() {
        return this.ellapsedTime;
    }

    private class StreamReader
    implements Runnable {
        List list;
        InputStream is;
        Thread thread;

        public StreamReader(List list, InputStream is) {
            this.list = list;
            this.is = is;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            try {
                String s;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((s = br.readLine()) != null) {
                    if (this.list == null) continue;
                    this.list.add(s);
                }
                this.list.add(null);
                this.is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

