/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javaxt.io.DirectorySearch;
import javaxt.io.File;
import javaxt.io.FileSystemWatcher;
import javaxt.io.Jar;
import javaxt.utils.Date;

public class Directory {
    private java.io.File Directory;
    private boolean useCache = false;
    private static List events = new LinkedList();
    private FileSystemWatcher FileSystemWatcher;
    public final String PathSeparator = System.getProperty("file.separator");
    private Event LastEvent = null;

    public Directory(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.Directory = new java.io.File(Path2);
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public Directory(java.io.File File2) {
        this.Directory = File2;
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public boolean exists() {
        return this.Directory.exists();
    }

    public boolean create() {
        return this.Directory.mkdirs();
    }

    public boolean delete() {
        return this.Directory.delete();
    }

    public String[] copyTo(Directory Destination, boolean Overwrite) {
        int source = this.toString().length();
        String destination = Destination.toString();
        Vector<String> vec = new Vector<String>();
        Directory[] Directories = this.getSubDirectories(true);
        for (int i = 0; i < Directories.length; ++i) {
            new Directory(destination + Directories[i].toString().substring(source)).create();
        }
        File[] Files = this.getFiles(true);
        for (int i = 0; i < Files.length; ++i) {
            String FilePath = Files[i].toString();
            File out = new File(destination + FilePath.substring(source));
            boolean CopiedFile = Files[i].copyTo(out, Overwrite);
            if (CopiedFile) continue;
            vec.add(FilePath);
            System.out.println(FilePath);
        }
        Object[] arr = vec.toArray();
        String[] ret = new String[arr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)arr[i];
        }
        return ret;
    }

    public void moveTo(Directory Destination, boolean Overwrite) {
        if (Overwrite) {
            this.Directory.renameTo(Destination.getFile());
        } else if (!Destination.exists()) {
            this.Directory.renameTo(Destination.getFile());
        }
    }

    public void rename(String Name) {
        String path = this.getParentDirectory().getPath() + Name;
        this.Directory.renameTo(new java.io.File(path));
    }

    public String getName() {
        return this.Directory.getName();
    }

    public String getPath() {
        String path = "";
        try {
            path = this.Directory.getCanonicalPath().toString();
        }
        catch (Exception e) {
            path = this.Directory.toString();
        }
        if (path.endsWith(java.io.File.separator)) {
            return path;
        }
        return path + java.io.File.separator;
    }

    public java.util.Date getDate() {
        return new Date(this.Directory.lastModified()).getDate();
    }

    public long getSize() {
        return this.Directory.length();
    }

    public boolean isHidden() {
        return this.Directory.isHidden();
    }

    @Deprecated
    public Directory getDirectory() {
        return this.getParentDirectory();
    }

    public Directory getParentDirectory() {
        return new Directory(this.Directory.getParentFile());
    }

    public java.io.File getFile() {
        return this.Directory;
    }

    public File[] getFiles(Object filter) {
        if (this.Directory.exists()) {
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                public boolean accept(java.io.File file) {
                    return file.isFile();
                }
            };
            java.io.File[] Files = this.Directory.listFiles(fileFilter);
            if (Files == null) {
                return new File[0];
            }
            fileFilter = new FileFilter(filter).getFileFilter();
            Vector<File> vec = new Vector<File>();
            for (int i = 0; i < Files.length; ++i) {
                if (!fileFilter.accept(Files[i])) continue;
                vec.addElement(new File(Files[i]));
            }
            Collections.sort(vec, new FileComparer());
            File[] files = new File[vec.size()];
            for (int i = 0; i < files.length; ++i) {
                files[i] = (File)vec.get(i);
            }
            return files;
        }
        return new File[0];
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    public File[] getFiles(Object filter, boolean RecursiveSearch) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, filter, true);
                LinkedList files = new LinkedList();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof File)) continue;
                    files.add(item);
                }
                Collections.sort(files, new FileComparer());
                File[] array = new File[files.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (File)files.get(i);
                }
                return array;
            }
            return this.getFiles(filter);
        }
        return new File[0];
    }

    public File[] getFiles(boolean RecursiveSearch) {
        return this.getFiles(null, RecursiveSearch);
    }

    public Directory[] getSubDirectories() {
        if (this.Directory.exists()) {
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                public boolean accept(java.io.File file) {
                    return file.isDirectory();
                }
            };
            java.io.File[] Files = this.Directory.listFiles(fileFilter);
            if (Files == null) {
                return new Directory[0];
            }
            Directory[] dirs = new Directory[Files.length];
            for (int i = 0; i < Files.length; ++i) {
                dirs[i] = new Directory(Files[i]);
            }
            return dirs;
        }
        return new Directory[0];
    }

    public Directory[] getSubDirectories(boolean RecursiveSearch) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true);
                LinkedList directories = new LinkedList();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof Directory)) continue;
                    directories.add(item);
                }
                Collections.sort(directories, new FileComparer());
                Directory[] array = new Directory[directories.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Directory)directories.get(i);
                }
                return array;
            }
            return this.getSubDirectories();
        }
        return new Directory[0];
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean RecursiveSearch) {
        return this.getChildren(RecursiveSearch, null, true);
    }

    public List getChildren(boolean RecursiveSearch, Object filter) {
        return this.getChildren(RecursiveSearch, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren(boolean RecursiveSearch, Object filter, boolean wait) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                LinkedList items = new LinkedList();
                if (!this.useCache) {
                    DirectorySearch.deleteCache();
                    java.io.FileFilter fileFilter = new FileFilter(filter).getFileFilter();
                    long directoryID = Long.valueOf(Calendar.getInstance().getTimeInMillis() + "" + new Random().nextInt(100000));
                    int numThreads = 20;
                    DirectorySearch search = new DirectorySearch(fileFilter, items, directoryID, numThreads);
                    for (int i = 0; i < numThreads; ++i) {
                        Thread t = new Thread(search);
                        t.setName("DirectorySearch_" + directoryID + "-" + i);
                        t.start();
                    }
                    DirectorySearch.updatePool(this);
                    if (wait) {
                        List status;
                        List list = status = DirectorySearch.getStatus();
                        synchronized (list) {
                            while (status.isEmpty()) {
                                try {
                                    status.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        while (items.contains(null)) {
                            items.remove(null);
                        }
                    }
                }
                return items;
            }
            LinkedList<Object> results = new LinkedList<Object>();
            java.io.File[] files = this.Directory.listFiles(new FileFilter(filter).getFileFilter());
            if (files == null) {
                return results;
            }
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    results.add(new Directory(files[i]));
                    continue;
                }
                results.add(new File(files[i]));
            }
            Collections.sort(results, new FileComparer());
            return results;
        }
        return new LinkedList();
    }

    public void useCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Directory) {
            return this.Directory.equals(((Directory)obj).getFile());
        }
        if (obj instanceof java.io.File) {
            if (((java.io.File)obj).isDirectory()) {
                return this.Directory.equals(obj);
            }
            return false;
        }
        return false;
    }

    private List getEvents(String dll) throws Exception {
        if (this.FileSystemWatcher == null) {
            new Thread(new FileSystemWatcher(this, dll)).start();
            this.FileSystemWatcher = this.FileSystemWatcher;
        }
        return events;
    }

    public List getEvents() throws Exception {
        String os = System.getProperties().getProperty("os.name").trim();
        if (os.toLowerCase().startsWith("windows")) {
            Jar jar = new Jar(this);
            Jar.Entry entry = jar.getEntry("javaxt.ntfs", "FileSystemWatcher.dll");
            java.io.File dll = entry.getFile();
            if (dll == null && !(dll = new java.io.File(jar.getFile().getParentFile(), "FileSystemWatcher.dll")).exists()) {
                entry.extractFile(dll);
            }
            return this.getEvents(dll.toString());
        }
        return this.getEvents(null);
    }

    public void stop() {
        if (this.FileSystemWatcher != null) {
            this.FileSystemWatcher.stop();
        }
        DirectorySearch.stop();
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    protected void addEvent(String event) {
        new Event(event);
    }

    protected void addEvent(String action, java.io.File file) {
        new Event(action, file);
    }

    private class FileFilter {
        private java.io.FileFilter filter;
        private String[] filters;

        public java.io.FileFilter getFileFilter() {
            return this.filter;
        }

        public FileFilter(Object filter) {
            if (filter == null) {
                filter = "*";
            }
            if (filter instanceof java.io.FileFilter) {
                this.filter = (java.io.FileFilter)filter;
            }
            if (filter instanceof String) {
                filter = new String[]{(String)filter};
            }
            if (filter instanceof String[]) {
                this.filters = filter;
                this.filter = new java.io.FileFilter(){

                    public boolean accept(java.io.File file) {
                        for (int i = 0; i < FileFilter.this.filters.length; ++i) {
                            String regex = this.getRegEx(FileFilter.this.filters[i]);
                            Pattern pattern = Pattern.compile(regex, 2);
                            Matcher matcher = pattern.matcher(file.getName());
                            if (!matcher.find()) continue;
                            return true;
                        }
                        return false;
                    }

                    private String getRegEx(String wildcardSearch) {
                        String regex = wildcardSearch.trim();
                        if (!regex.endsWith("*")) {
                            regex = regex + "$";
                        }
                        if (regex.endsWith("*")) {
                            regex = (regex = regex.substring(0, regex.length() - 1) + ")").contains("*") ? regex.substring(0, regex.lastIndexOf("*") + 1) + "(" + regex.substring(regex.lastIndexOf("*") + 1) : "(" + regex;
                        }
                        regex = regex.replace(".", "\\.");
                        regex = regex.replace("*", ".*");
                        return regex;
                    }
                };
            }
        }
    }

    private class FileComparer
    implements Comparator {
        private FileComparer() {
        }

        public final int compare(Object a, Object b) {
            String x = a.toString().toUpperCase();
            String y = b.toString().toUpperCase();
            return x.compareTo(y);
        }
    }

    public class Event {
        private java.io.File file;
        private java.io.File orgFile;
        private java.util.Date date;
        private String action;
        public static final int DELETE = 0;
        public static final int CREATE = 1;
        public static final int RENAME = 2;
        public static final int MODIFY = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String event) {
            block15: {
                if (event != null) {
                    event = event.trim();
                    try {
                        String date = event.substring(1, event.indexOf("]")).trim();
                        String text = event.substring(event.indexOf("]") + 1).trim();
                        String path = text.substring(text.indexOf(" ")).trim();
                        String action = text.substring(0, text.indexOf(" ")).trim();
                        this.date = this.parseDate(date);
                        this.file = new java.io.File(path);
                        this.action = action;
                        boolean updateEvents = true;
                        if (action.equalsIgnoreCase("modify")) {
                            if (this.file.isDirectory() || !this.file.exists()) {
                                updateEvents = false;
                            } else if (Directory.this.LastEvent != null) {
                                if (Directory.this.LastEvent.getFile().equals(this.file) && Directory.this.LastEvent.getDate().equals(this.date)) {
                                    updateEvents = false;
                                }
                                Directory.this.LastEvent = null;
                            } else {
                                Directory.this.LastEvent = this;
                            }
                        }
                        if (action.equalsIgnoreCase("rename")) {
                            updateEvents = false;
                            Directory.this.LastEvent = this;
                        } else if (action.equalsIgnoreCase("renam2") && Directory.this.LastEvent != null) {
                            this.orgFile = Directory.this.LastEvent.getFile();
                            this.action = "Rename";
                            Directory.this.LastEvent = null;
                        }
                        if (!updateEvents) break block15;
                        List list = events;
                        synchronized (list) {
                            events.add(this);
                            events.notifyAll();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String action, java.io.File file) {
            this.date = new java.util.Date();
            this.action = action;
            this.file = file;
            List list = events;
            synchronized (list) {
                events.add(this);
                events.notifyAll();
            }
        }

        private java.util.Date parseDate(String date) {
            try {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getAction() {
            return this.action;
        }

        public java.io.File getFile() {
            return this.file;
        }

        public java.io.File getOriginalFile() {
            return this.orgFile;
        }

        public final int getEventID() {
            if (this.action.equalsIgnoreCase("create")) {
                return 1;
            }
            if (this.action.equalsIgnoreCase("delete")) {
                return 0;
            }
            if (this.action.equalsIgnoreCase("modify")) {
                return 3;
            }
            if (this.action.equalsIgnoreCase("rename")) {
                return 2;
            }
            return -1;
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public String toString() {
            if (this.action.equalsIgnoreCase("rename")) {
                return "[" + this.date.toString() + "] " + this.action + " " + this.orgFile.getPath() + " To " + this.file.getPath();
            }
            return "[" + this.date.toString() + "] " + this.action + " " + this.file.getPath();
        }

        public boolean equals(Object obj) {
            Event event;
            return obj instanceof Event && (event = (Event)obj).getFile().equals(this.file) && event.getDate().equals(this.date) && event.getAction().equals(this.action);
        }
    }
}

