/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.FileFilter;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javaxt.io.Directory;
import javaxt.io.File;

class DirectorySearch
implements Runnable {
    private static ConcurrentHashMap map;
    private static ConcurrentHashMap lut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectorySearch(FileFilter filter, List items, long directoryID, int numThreads) {
        String parentThread = Thread.currentThread().getName();
        if (map == null) {
            map = new ConcurrentHashMap();
        }
        if (DirectorySearch.getVars() == null) {
            DirectorySearch.createVars(filter, items, directoryID, numThreads);
        }
        if (lut == null) {
            lut = new ConcurrentHashMap();
        }
        ConcurrentHashMap concurrentHashMap = lut;
        synchronized (concurrentHashMap) {
            if (lut.get(parentThread) == null) {
                lut.put(parentThread, directoryID);
            } else {
                while (!lut.isEmpty()) {
                    try {
                        lut.wait();
                    }
                    catch (InterruptedException e) {}
                }
                DirectorySearch.createVars(filter, items, directoryID, numThreads);
                lut.put(parentThread, directoryID);
                lut.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createVars(FileFilter filter, List items, long directoryID, int numThreads) {
        ConcurrentHashMap concurrentHashMap = map;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<String, Object> vars = new ConcurrentHashMap<String, Object>();
            vars.put("items", items);
            vars.put("filter", filter);
            vars.put("pool", new LinkedList());
            vars.put("path", new LinkedList());
            vars.put("status", new LinkedList());
            vars.put("fileCount", new LinkedList());
            vars.put("threads", new LinkedList());
            vars.put("activatedThreads", new ConcurrentHashMap());
            vars.put("numThreads", numThreads);
            map.put(directoryID, vars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentHashMap getVars() {
        String currentThread = Thread.currentThread().getName();
        if (currentThread.startsWith("DirectorySearch_")) {
            Long directoryID = DirectorySearch.getDirectoryID();
            return (ConcurrentHashMap)map.get(directoryID);
        }
        if (lut == null) {
            return null;
        }
        Long directoryID = null;
        ConcurrentHashMap concurrentHashMap = lut;
        synchronized (concurrentHashMap) {
            directoryID = (Long)lut.get(currentThread);
        }
        if (directoryID == null) {
            return null;
        }
        return (ConcurrentHashMap)map.get(directoryID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCache() {
        ConcurrentHashMap vars;
        if (map != null && (vars = DirectorySearch.getVars()) != null) {
            ConcurrentHashMap concurrentHashMap = vars;
            synchronized (concurrentHashMap) {
                List path = (List)vars.get("path");
                List items = (List)vars.get("items");
                List status = (List)vars.get("status");
                List list = path;
                synchronized (list) {
                    path.clear();
                }
                list = items;
                synchronized (list) {
                    items.clear();
                }
                list = status;
                synchronized (list) {
                    status.clear();
                }
                vars.remove("startTime");
                vars.remove("root");
            }
        }
    }

    private static Long getDirectoryID() {
        try {
            String id = Thread.currentThread().getName();
            id = id.substring(id.indexOf("_") + 1);
            id = id.substring(0, id.indexOf("-"));
            return (long)Long.valueOf(id);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateFileCount() {
        List fileCount;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List list = fileCount = (List)vars.get("fileCount");
        synchronized (list) {
            if (fileCount.isEmpty()) {
                fileCount.add(1L);
            } else {
                fileCount.set(0, (Long)fileCount.get(0) + 1L);
            }
            fileCount.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getFileCount() {
        List fileCount;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List list = fileCount = (List)vars.get("fileCount");
        synchronized (list) {
            if (fileCount.isEmpty()) {
                return 0L;
            }
            return (Long)fileCount.get(0);
        }
    }

    public static void stop() {
        DirectorySearch.updatePool(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePool(Directory directory) {
        ConcurrentHashMap vars = DirectorySearch.getVars();
        Long startTime = null;
        if (vars.get("startTime") != null) {
            startTime = (Long)vars.get("startTime");
        }
        if (startTime == null) {
            ConcurrentHashMap concurrentHashMap = vars;
            synchronized (concurrentHashMap) {
                vars.put("startTime", DirectorySearch.getStartTime());
                vars.put("root", directory);
            }
        }
        boolean updatePool = true;
        if (directory == null && Thread.currentThread().getName().equalsIgnoreCase("Finalizer")) {
            updatePool = false;
        }
        if (updatePool) {
            List pool;
            List list = pool = (List)vars.get("pool");
            synchronized (list) {
                pool.add(directory);
                pool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(File file) {
        List items;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List list = items = (List)vars.get("items");
        synchronized (list) {
            items.add(file);
            DirectorySearch.updateFileCount();
            items.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDirectory(Directory directory) {
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List items = (List)vars.get("items");
        Directory root = (Directory)vars.get("root");
        List list = items;
        synchronized (list) {
            if (!directory.equals(root)) {
                items.add(directory);
                DirectorySearch.updateFileCount();
                items.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPath(Directory directory) {
        List path;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List list = path = (List)vars.get("path");
        synchronized (list) {
            path.add(directory.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePath(Directory directory) {
        List path;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List list = path = (List)vars.get("path");
        synchronized (list) {
            path.remove(directory.toString());
        }
    }

    public static List getStatus() {
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List status = (List)vars.get("status");
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStatus() {
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List status = (List)vars.get("status");
        List items = (List)vars.get("items");
        Long startTime = (Long)vars.get("startTime");
        Object object = status;
        synchronized (object) {
            status.add("ellapsedTime = " + DirectorySearch.getEllapsedTime(startTime) + " ms");
            status.notifyAll();
        }
        object = items;
        synchronized (object) {
            items.add(null);
            items.notifyAll();
        }
        ((List)vars.get("pool")).clear();
        ((List)vars.get("path")).clear();
        ((List)vars.get("threads")).clear();
        ((ConcurrentHashMap)vars.get("activatedThreads")).clear();
        object = lut;
        synchronized (object) {
            long directoryID = DirectorySearch.getDirectoryID();
            for (String parentThread : lut.keySet()) {
                if ((Long)lut.get(parentThread) != directoryID) continue;
                lut.remove(parentThread);
                lut.notifyAll();
                break;
            }
        }
    }

    public static List getItems() {
        ConcurrentHashMap vars = DirectorySearch.getVars();
        List items = (List)vars.get("items");
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        ConcurrentHashMap vars = DirectorySearch.getVars();
        if (vars == null) {
            System.out.println(Thread.currentThread().getName() + " found null vars!");
            ConcurrentHashMap concurrentHashMap = lut;
            synchronized (concurrentHashMap) {
                long directoryID = DirectorySearch.getDirectoryID();
                for (String parentThread : lut.keySet()) {
                    Long id = (Long)lut.get(parentThread);
                    System.out.println(parentThread + ": " + id + " (" + (map.get(id) == null) + ")");
                    if ((Long)lut.get(parentThread) != directoryID) continue;
                }
            }
            return;
        }
        List threads = (List)vars.get("threads");
        ConcurrentHashMap activatedThreads = (ConcurrentHashMap)vars.get("activatedThreads");
        List path = (List)vars.get("path");
        List pool = (List)vars.get("pool");
        FileFilter filter = (FileFilter)vars.get("filter");
        int numThreads = (Integer)vars.get("numThreads");
        while (true) {
            Directory dir;
            object = pool;
            synchronized (object) {
                while (pool.isEmpty()) {
                    try {
                        pool.wait();
                    }
                    catch (InterruptedException e) {}
                }
                dir = (Directory)pool.remove(0);
                Object e = threads;
                synchronized (e) {
                    threads.add(Thread.currentThread().getName());
                }
                e = activatedThreads;
                synchronized (e) {
                    if (activatedThreads.get(Thread.currentThread().getName()) == null) {
                        activatedThreads.put(Thread.currentThread().getName(), true);
                    }
                }
            }
            if (dir == null) break;
            DirectorySearch.addPath(dir);
            java.io.File[] items = dir.getFile().listFiles();
            if (items != null) {
                boolean addedDirectory = false;
                for (int i = 0; i < items.length; ++i) {
                    java.io.File item = items[i];
                    if (item.isDirectory()) {
                        DirectorySearch.updatePool(new Directory(item));
                        continue;
                    }
                    File file = new File(item);
                    if (!filter.accept(file.getFile())) continue;
                    if (!addedDirectory) {
                        DirectorySearch.addDirectory(dir);
                        addedDirectory = true;
                    }
                    DirectorySearch.addFile(file);
                }
            }
            DirectorySearch.removePath(dir);
            List addedDirectory = threads;
            synchronized (addedDirectory) {
                threads.remove(Thread.currentThread().getName());
            }
            addedDirectory = path;
            synchronized (addedDirectory) {
                if (path.isEmpty()) {
                    List list = pool;
                    synchronized (list) {
                        if (pool.isEmpty()) {
                            String threadID = Thread.currentThread().getName();
                            List list2 = threads;
                            synchronized (list2) {
                                if (threads.isEmpty()) {
                                    if (numThreads > 1) {
                                        DirectorySearch.updatePool(null);
                                    } else {
                                        DirectorySearch.updateStatus();
                                    }
                                    ConcurrentHashMap concurrentHashMap = activatedThreads;
                                    synchronized (concurrentHashMap) {
                                        activatedThreads.replace(threadID, false);
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        object = threads;
        synchronized (object) {
            String threadID = Thread.currentThread().getName();
            threads.remove(threadID);
        }
        object = activatedThreads;
        synchronized (object) {
            activatedThreads.replace(Thread.currentThread().getName(), false);
            if (activatedThreads.containsValue(true)) {
                DirectorySearch.updatePool(null);
            } else if (activatedThreads.size() < numThreads) {
                DirectorySearch.updatePool(null);
            } else {
                DirectorySearch.updateStatus();
            }
        }
    }

    private static long getStartTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    private static long getEllapsedTime(long StartTime) {
        try {
            long endTime = Calendar.getInstance().getTimeInMillis();
            return endTime - StartTime;
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

