/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javaxt.io.Directory;
import javaxt.io.Image;
import javaxt.utils.Date;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

public class File {
    private java.io.File File;
    public final String PathSeparator = System.getProperty("file.separator");
    public final String LineSeperator = System.getProperty("line.separator");

    public File(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.File = new java.io.File(Path2);
    }

    public File(java.io.File File2) {
        this.File = File2;
    }

    public File(java.io.File Parent, String Child) {
        this.File = new java.io.File(Parent, Child);
    }

    public File(Directory Parent, String Child) {
        this.File = new java.io.File(Parent.getFile(), Child);
    }

    public File(String Parent, String Child) {
        this.File = new java.io.File(new Directory(Parent).getFile(), Child);
    }

    public String getName() {
        if (this.File != null) {
            return this.File.getName();
        }
        return "";
    }

    public String getName(boolean IncludeFileExtension) {
        String FileExt;
        String FileName = this.getName();
        if (!IncludeFileExtension && (FileExt = this.getExtension()).length() > 0) {
            FileName = FileName.substring(0, FileName.length() - (FileExt.length() + 1));
        }
        return FileName;
    }

    public String getPath() {
        if (this.File != null) {
            String path = "";
            try {
                path = this.File.getParentFile().getCanonicalPath().toString();
            }
            catch (Exception e) {
                path = this.File.getParentFile().toString();
            }
            if (!path.endsWith(this.PathSeparator)) {
                path = path + this.PathSeparator;
            }
            return path;
        }
        return "";
    }

    public Directory getDirectory() {
        if (this.File != null) {
            return new Directory(this.getPath());
        }
        return null;
    }

    public java.io.File getFile() {
        return this.File;
    }

    public String getExtension() {
        String FileName = this.getName();
        if (FileName.contains(".")) {
            return FileName.substring(FileName.lastIndexOf(".") + 1, FileName.length());
        }
        return "";
    }

    public long getSize() {
        if (this.File != null) {
            return this.File.length();
        }
        return 0L;
    }

    public java.util.Date getDate() {
        if (this.File != null) {
            return new Date(this.File.lastModified()).getDate();
        }
        return null;
    }

    public boolean exists() {
        if (this.File != null) {
            return this.File.exists();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.File != null) {
            return this.File.isHidden();
        }
        return false;
    }

    public boolean isReadOnly() {
        if (this.File != null) {
            return !this.File.canWrite();
        }
        return true;
    }

    public boolean isExecutable() {
        if (this.File != null) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.File.getClass().getMethod("canExecute", new Class[0]).invoke((Object)this.File, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean delete() {
        if (this.File != null) {
            return this.File.delete();
        }
        return false;
    }

    public File moveTo(Directory Destination) {
        java.io.File Dir = Destination.getFile();
        Dir.mkdirs();
        File newFile = new File(Dir, this.File.getName());
        this.File.renameTo(newFile.getFile());
        this.File = newFile.getFile();
        return newFile;
    }

    public boolean copyTo(Directory Destination, boolean Overwrite) {
        File Output = new File(Destination, this.File.getName());
        return this.copyTo(Output, Overwrite);
    }

    public boolean copyTo(File Destination, boolean Overwrite) {
        System.out.println(Destination);
        if (!this.File.exists()) {
            return false;
        }
        if (Destination.exists() && !Overwrite) {
            return false;
        }
        if (this.File.equals(Destination.getFile())) {
            return false;
        }
        Destination.getDirectory().create();
        try {
            this.copyFile(this.File, Destination.getFile());
            Destination.getFile().setLastModified(this.File.lastModified());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void copyFile(java.io.File in, java.io.File out) throws Exception {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public File rename(String FileName) {
        if (FileName != null && (FileName = FileName.trim()).length() > 0 && this.File != null) {
            File newFile = new File(this.getPath() + FileName);
            this.File.renameTo(newFile.getFile());
            this.File = newFile.getFile();
            return newFile;
        }
        return this;
    }

    public BufferedReader getBufferedReader() {
        if (this.File.exists()) {
            try {
                return new BufferedReader(new FileReader(this.File));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedReader getBufferedReader(String charsetName) {
        if (this.File.exists()) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), charsetName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        if (this.File.exists()) {
            try {
                return ImageIO.read(this.File);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Image getImage() {
        if (this.File.exists()) {
            return new Image(this.File);
        }
        return null;
    }

    public String getText() {
        try {
            return this.getText("ISO-8859-1");
        }
        catch (Exception e) {
            try {
                return this.getBytes().toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes().toString(charsetName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Document getXML() {
        try {
            return DOM.createDocument(this.getInputStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteArrayOutputStream getBytes() {
        if (this.File.exists()) {
            try {
                FileInputStream InputStream2 = new FileInputStream(this.File);
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int x = 0;
                while ((x = InputStream2.read(b, 0, 1024)) > -1) {
                    bas.write(b, 0, x);
                }
                bas.close();
                InputStream2.close();
                return bas;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void write(ByteArrayOutputStream bas) {
        this.write(bas.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        if (this.File != null) {
            FileOutputStream output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new FileOutputStream(this.File);
                output.write(bytes);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream input) {
        if (this.File != null) {
            FileOutputStream output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new FileOutputStream(this.File);
                byte[] buf = new byte[1024];
                int i = 0;
                while ((i = input.read(buf)) != -1) {
                    output.write(buf, 0, i);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(String Text2) {
        this.write(Text2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String Text2, String charsetName) {
        if (this.File != null) {
            Writer output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = charsetName == null ? new BufferedWriter(new FileWriter(this.File)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.File), charsetName));
                output.write(Text2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] Content) {
        if (this.File != null) {
            Writer output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new BufferedWriter(new FileWriter(this.File));
                for (int i = 0; i < Content.length - 1; ++i) {
                    output.write(Content[i] + this.LineSeperator);
                }
                output.write(Content[Content.length - 1]);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(BufferedImage Image2) {
        if (this.File != null) {
            try {
                this.File.getParentFile().mkdirs();
                BufferedImage rendImage = Image2;
                ImageIO.write((RenderedImage)rendImage, this.getExtension(), this.File);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String MapPath(String RelPath) {
        String currDir = this.getPath();
        if (!(currDir = currDir.replace("\\", "/")).endsWith("/")) {
            currDir = currDir + "/";
        }
        RelPath = RelPath.replace("\\", "/");
        String[] arrRelPath = RelPath.split("/");
        String[] arrAbsPath = currDir.split("/");
        int x = -1;
        RelPath = "";
        String Dir = "";
        for (int i = 0; i < arrRelPath.length; ++i) {
            Dir = arrRelPath[i];
            if (Dir.equals("..")) {
                ++x;
                continue;
            }
            if (Dir.equals(".")) continue;
            RelPath = RelPath + "\\" + arrRelPath[i];
        }
        Dir = "";
        boolean ubound = false;
        for (int i = 0; i < arrAbsPath.length - (x + 1); ++i) {
            Dir = Dir + arrAbsPath[i] + "\\";
        }
        Dir = Dir.substring(0, Dir.length() - 1);
        Dir = Dir + RelPath.replace("/", "\\");
        Dir = Dir.replace("\\", this.PathSeparator);
        return Dir;
    }

    public FileInputStream getInputStream() throws IOException {
        return new FileInputStream(this.File);
    }

    public FileOutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.File);
    }

    public String toString() {
        return this.File.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof File) {
            return this.File.equals(((File)obj).getFile());
        }
        if (obj instanceof java.io.File && ((java.io.File)obj).isFile()) {
            return this.File.equals(obj);
        }
        return false;
    }

    private boolean isValidPath(String PathToFile) {
        if (PathToFile == null) {
            return false;
        }
        if (PathToFile.length() < 1) {
            return false;
        }
        if (this.File.isDirectory()) {
            return false;
        }
        String FileName = this.File.getName();
        if (FileName.length() < 1) {
            return false;
        }
        if (FileName.length() > 260) {
            return false;
        }
        PathToFile = this.File.toString();
        PathToFile = PathToFile.replace("\\", "/");
        String[] Path2 = PathToFile.split("/");
        String[] arr = new String[]{"/", "?", "<", ">", "\\", ":", "*", "|", "\""};
        for (int i = 0; i < Path2.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j].equals(":") && i == 0 & Path2[i].length() == 2 || !Path2[i].contains(arr[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String getContentType() {
        if (this.extensionEquals("css")) {
            return "text/css";
        }
        if (this.extensionEquals("dtd")) {
            return "text/plain";
        }
        if (this.extensionEquals("htm,html")) {
            return "text/html";
        }
        if (this.extensionEquals("java")) {
            return "text/plain";
        }
        if (this.extensionEquals("js")) {
            return "text/javascript";
        }
        if (this.extensionEquals("txt")) {
            return "text/plain";
        }
        if (this.extensionEquals("bmp")) {
            return "image/bmp";
        }
        if (this.extensionEquals("gif")) {
            return "image/gif";
        }
        if (this.extensionEquals("jp2,j2c,j2k,jpx")) {
            return "image/jp2";
        }
        if (this.extensionEquals("jpg,jpe,jpeg,jfif,pjpeg,pjp")) {
            return "image/jpeg";
        }
        if (this.extensionEquals("png")) {
            return "image/png";
        }
        if (this.extensionEquals("psd")) {
            return "image/x-photoshop";
        }
        if (this.extensionEquals("rgb")) {
            return "image/x-rgb";
        }
        if (this.extensionEquals("tif,tiff")) {
            return "image/tiff";
        }
        if (this.extensionEquals("xbm")) {
            return "image/x-xbitmap";
        }
        if (this.extensionEquals("xpm")) {
            return "image/x-xpixmap";
        }
        if (this.extensionEquals("doc,dot")) {
            return "application/msword";
        }
        if (this.extensionEquals("xls,xlw,xla,xlc,xlm,xlt,xll")) {
            return "application/vnd.ms-excel";
        }
        if (this.extensionEquals("ppt,pps,pot")) {
            return "application/vnd.ms-powerpoint";
        }
        if (this.extensionEquals("mdb")) {
            return "application/x-msaccess";
        }
        if (this.extensionEquals("mpp")) {
            return "application/vnd.ms-project";
        }
        if (this.extensionEquals("pub")) {
            return "application/x-mspublisher";
        }
        if (this.extensionEquals("wmz")) {
            return "application/x-ms-wmz";
        }
        if (this.extensionEquals("wmd")) {
            return "application/x-ms-wmd";
        }
        if (this.extensionEquals("ai,eps,ps")) {
            return "application/postscript";
        }
        if (this.extensionEquals("gz")) {
            return "application/x-gzip";
        }
        if (this.extensionEquals("pdf")) {
            return "application/pdf";
        }
        if (this.extensionEquals("xml")) {
            return "application/xml";
        }
        if (this.extensionEquals("z")) {
            return "application/x-compress";
        }
        if (this.extensionEquals("zip")) {
            return "application/zip";
        }
        if (this.extensionEquals("mid,midi")) {
            return "audio/x-midi";
        }
        if (this.extensionEquals("mp1,mp2,mp3,mpa,mpega")) {
            return "audio/x-mpeg";
        }
        if (this.extensionEquals("ra,ram")) {
            return "audio/x-pn-realaudio";
        }
        if (this.extensionEquals("wav")) {
            return "audio/x-wav";
        }
        if (this.extensionEquals("wma")) {
            return "audio/x-ms-wma";
        }
        if (this.extensionEquals("wax")) {
            return "audio/x-ms-wax";
        }
        if (this.extensionEquals("wmv")) {
            return "audio/x-ms-wmv";
        }
        if (this.extensionEquals("asf,asx")) {
            return "video/x-ms-asf";
        }
        if (this.extensionEquals("avi")) {
            return "video/msvideo";
        }
        if (this.extensionEquals("mov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("mpe,mpeg,mpg")) {
            return "video/mpeg";
        }
        if (this.extensionEquals("mpv2")) {
            return "video/mpeg2";
        }
        if (this.extensionEquals("qt,mov,moov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("wvx")) {
            return "video/x-ms-wvx";
        }
        if (this.extensionEquals("wm")) {
            return "video/x-ms-wm";
        }
        if (this.extensionEquals("wmx")) {
            return "video/x-ms-wmx";
        }
        return "application/octet-stream";
    }

    private boolean extensionEquals(String FileExtension) {
        String ext = this.getExtension();
        String[] arr = FileExtension.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i].trim();
            if (!str.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }
}

