/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javaxt.io.Directory;
import javaxt.io.File;
import javaxt.io.FileSystemWatcherNative;

class FileSystemWatcher
implements Runnable {
    private Directory directory;
    private Timer timer;
    private File dll;
    private boolean includeSubdirectories = true;
    private boolean terminationRequested = false;
    private Long osHandle = null;

    public FileSystemWatcher(Directory directory, String dll) throws Exception {
        this.directory = directory;
        if (dll != null && (dll = dll.trim()).length() > 0) {
            this.setLibraryPath(new File(dll.trim()));
        }
    }

    private void setLibraryPath(File dll) {
        if (dll != null && dll.exists() && dll.getExtension().equalsIgnoreCase("dll")) {
            this.dll = dll;
        }
    }

    private boolean loadLibrary() {
        boolean useDLL = false;
        if (System.getProperty("os.name").toLowerCase().contains("windows") && this.dll != null) {
            try {
                System.load(this.dll.toString());
                useDLL = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return useDLL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        if (!this.loadLibrary()) {
            System.out.println("Failed to load FileSystemWatcher.dll...");
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new EventMonitor(), new Date(), 1000L);
        } else {
            try {
                long osWaitHandle = FileSystemWatcherNative.FindFirstChangeNotification(this.directory.getPath(), this.includeSubdirectories, -1);
                this.osHandle = new Long(osWaitHandle);
                do {
                    FileSystemWatcherNative.FindNextChangeNotification(osWaitHandle);
                    String event = null;
                    while ((event = FileSystemWatcherNative.ReadDirectoryChangesW()) != null) {
                        this.directory.addEvent(event);
                    }
                    Thread.sleep(25L);
                    while ((event = FileSystemWatcherNative.ReadDirectoryChangesW()) != null) {
                        this.directory.addEvent(event);
                    }
                    if (FileSystemWatcherNative.WaitForSingleObject(osWaitHandle, -1) == 0) continue;
                    throw new Exception("Wait failed while waiting for OS to signal file system event.");
                } while (!this.terminationRequested);
            }
            catch (Exception ex) {
                Logger.getLogger("FileSystemWatcher").log(Level.WARNING, "Exception encountered.", ex);
            }
            finally {
                if (this.osHandle != null) {
                    try {
                        FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
                    }
                    catch (Exception ex2) {
                        Logger.getLogger("FileSystemWatcher").log(Level.WARNING, "Unable to close file system watch handle.", ex2);
                    }
                    this.osHandle = null;
                }
            }
        }
    }

    public void stop() {
        this.terminationRequested = true;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.osHandle != null) {
            FileSystemWatcherNative.FindCloseChangeNotification(this.osHandle);
        }
    }

    private class EventMonitor
    extends TimerTask {
        private List index = this.createIndex();
        private long lastEvent = 0L;
        private long lastUpdate = 0L;
        private long interval = 0L;

        public final void run() {
            long startTime = Calendar.getInstance().getTimeInMillis();
            if (this.interval == 0L) {
                this.interval = 100L;
            }
            if (startTime - this.lastUpdate > this.interval * 2L) {
                List orgIndex = this.index;
                List newIndex = this.createIndex();
                for (int i = 0; i < newIndex.size(); ++i) {
                    Item item = (Item)newIndex.get(i);
                    if (orgIndex.contains(item)) {
                        int x = orgIndex.indexOf(item);
                        Item orgItem = (Item)orgIndex.get(x);
                        orgIndex.remove(x);
                        if (item.isDirectory() || item.getSize() == orgItem.getSize() && item.getDate() == orgItem.getDate()) continue;
                        FileSystemWatcher.this.directory.addEvent("Modify", item.getFile());
                        continue;
                    }
                    FileSystemWatcher.this.directory.addEvent("Create", item.getFile());
                }
                if (orgIndex.size() > 0) {
                    int len = orgIndex.size();
                    for (int i = 0; i < orgIndex.size(); ++i) {
                        Item item = (Item)orgIndex.get(i);
                        FileSystemWatcher.this.directory.addEvent("Delete", item.getFile());
                    }
                    orgIndex.clear();
                }
                this.index = newIndex;
                long endTime = Calendar.getInstance().getTimeInMillis();
                this.interval = startTime - endTime;
                this.lastUpdate = endTime;
            }
        }

        private List createIndex() {
            LinkedList<Item> index = new LinkedList<Item>();
            List array = FileSystemWatcher.this.directory.getChildren(true);
            for (int i = 0; i < array.size(); ++i) {
                index.add(new Item(array.get(i)));
            }
            return index;
        }

        private class Item {
            private java.io.File file;
            private String name;
            private String path;
            private long size;
            private long date;
            private boolean isDirectory;

            public Item(Object obj) {
                java.io.File file = null;
                if (obj instanceof File) {
                    file = ((File)obj).getFile();
                } else if (obj instanceof Directory) {
                    file = ((Directory)obj).getFile();
                } else if (obj instanceof java.io.File) {
                    file = (java.io.File)obj;
                }
                if (file != null) {
                    this.file = file;
                    this.name = file.getName();
                    this.path = file.getPath();
                    this.size = file.length();
                    this.date = file.lastModified();
                    this.isDirectory = file.isDirectory();
                }
            }

            public java.io.File getFile() {
                return this.file;
            }

            public String getName() {
                return this.name;
            }

            public String getPath() {
                return this.path;
            }

            public long getSize() {
                return this.size;
            }

            public long getDate() {
                return this.date;
            }

            public boolean isDirectory() {
                return this.isDirectory;
            }

            public String toString() {
                return this.path;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Item) {
                    Item item = (Item)obj;
                    return item.getPath().equals(this.getPath());
                }
                return false;
            }
        }
    }
}

