/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.imageio.ImageIO;
import javaxt.io.File;

public class Image {
    private BufferedImage bufferedImage = null;
    private int width = 0;
    private int height = 0;
    private Vector corners = null;
    private float outputQuality = 1.0f;
    private Graphics2D g2d = null;
    public static String[] InputFormats = Image.getFormats(ImageIO.getReaderFormatNames());
    public static String[] OutputFormats = Image.getFormats(ImageIO.getWriterFormatNames());

    public Image(String PathToImageFile) {
        this(new java.io.File(PathToImageFile));
    }

    public Image(java.io.File File2) {
        this.createBufferedImage(File2);
    }

    public Image(File File2) {
        this(File2.getFile());
    }

    public Image(InputStream InputStream2) {
        this.createBufferedImage(InputStream2);
    }

    public Image(byte[] byteArray) {
        this(new ByteArrayInputStream(byteArray));
    }

    public Image(int Width, int Height) {
        this.width = Width;
        this.height = Height;
        this.bufferedImage = new BufferedImage(this.width, this.height, 2);
        this.g2d = this.getGraphics();
    }

    public Image(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
    }

    public void setBackgroundColor(int r, int g, int b) {
        Color org = this.g2d.getColor();
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.fillRect(1, 1, this.width - 2, this.height - 2);
        this.g2d.setColor(org);
    }

    public String[] getInputFormats() {
        return Image.getFormats(ImageIO.getReaderFormatNames());
    }

    public String[] getOutputFormats() {
        return Image.getFormats(ImageIO.getWriterFormatNames());
    }

    private static String[] getFormats(String[] inputFormats) {
        HashMap formats = new HashMap();
        for (int i = 0; i < inputFormats.length; ++i) {
            String format = inputFormats[i].toUpperCase();
            if (format.contains("JPEG") && format.contains("2000")) {
                formats.put("JP2", null);
                formats.put("J2C", null);
                formats.put("J2K", null);
                formats.put("JPX", null);
                continue;
            }
            formats.put(format, null);
        }
        inputFormats = new String[formats.size()];
        int x = 0;
        for (Map.Entry entry : formats.entrySet()) {
            inputFormats[x] = (String)entry.getKey();
            ++x;
        }
        Collections.sort(Arrays.asList(inputFormats));
        return inputFormats;
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    private Graphics2D getGraphics() {
        if (this.g2d == null) {
            this.g2d = this.bufferedImage.createGraphics();
            RenderingHints rhints = this.g2d.getRenderingHints();
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return this.g2d;
    }

    public void addText(String text, int x, int y) {
        this.g2d = this.getGraphics();
        this.g2d.setColor(Color.BLACK);
        this.g2d.setFont(new Font("SansSerif", 0, 12));
        this.g2d.drawString(text, x, y);
    }

    public void addPoint(int x, int y, int r, int g, int b) {
        this.g2d = this.getGraphics();
        Color org = this.g2d.getColor();
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.fillRect(x, y, 1, 1);
        this.g2d.setColor(org);
    }

    public Color getColor(int x, int y) {
        return new Color(this.bufferedImage.getRGB(x, y));
    }

    public void addImage(BufferedImage in, int x, int y, boolean expand) {
        int x2 = 0;
        int y2 = 0;
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        if (expand) {
            if (x < 0) {
                if (in.getWidth() > (w += -x)) {
                    w += in.getWidth() - w;
                }
                x2 = -x;
                x = 0;
            } else if (x > w) {
                w = w + (x - w) + in.getWidth();
            } else if (x + in.getWidth() > w) {
                w += x + in.getWidth() - w;
            }
            if (y < 0) {
                if (in.getHeight() > (h += -y)) {
                    h += in.getHeight() - h;
                }
                y2 = -y;
                y = 0;
            } else if (y > h) {
                h = h + (y - h) + in.getHeight();
            } else if (y + in.getHeight() > h) {
                h += y + in.getHeight() - h;
            }
        }
        if (w > this.bufferedImage.getWidth() || h > this.bufferedImage.getHeight()) {
            BufferedImage bi = new BufferedImage(w, h, 2);
            Graphics2D g2d = bi.createGraphics();
            BufferedImage img = this.bufferedImage;
            g2d.drawImage((java.awt.Image)img, x2, y2, null);
            img = in;
            g2d.drawImage((java.awt.Image)img, x, y, null);
            this.bufferedImage = bi;
            this.width = this.bufferedImage.getWidth();
            this.height = this.bufferedImage.getHeight();
        } else {
            Graphics2D g2d = this.bufferedImage.createGraphics();
            BufferedImage img = in;
            g2d.drawImage((java.awt.Image)img, x, y, null);
            g2d.dispose();
        }
    }

    public void addImage(Image in, int x, int y, boolean expand) {
        this.addImage(in.getBufferedImage(), x, y, expand);
    }

    private void createBufferedImage(java.io.File File2) {
        try {
            this.bufferedImage = ImageIO.read(File2);
            this.width = this.bufferedImage.getWidth();
            this.height = this.bufferedImage.getHeight();
            if (this.bufferedImage.getType() == 13) {
                BufferedImage bi = new BufferedImage(this.width, this.height, 2);
                Graphics2D g2d = bi.createGraphics();
                BufferedImage img = this.bufferedImage;
                g2d.drawImage((java.awt.Image)img, 0, 0, null);
                this.bufferedImage = bi;
            }
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    private void createBufferedImage(InputStream input) {
        try {
            long startTime = this.getStartTime();
            this.bufferedImage = ImageIO.read(input);
            this.width = this.bufferedImage.getWidth();
            this.height = this.bufferedImage.getHeight();
            input.close();
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    public void rotate(double Degrees) {
        int maxY;
        int maxX;
        int cx = this.width / 2;
        int cy = this.height / 2;
        int[] corners = new int[]{0, 0, this.width, 0, this.width, this.height, 0, this.height};
        int minX = maxX = cx;
        int minY = maxY = cy;
        double theta = Math.toRadians(Degrees);
        for (int i = 0; i < corners.length; i += 2) {
            int x = this.getInt(Math.cos(theta) * (double)(corners[i] - cx) - Math.sin(theta) * (double)(corners[i + 1] - cy) + (double)cx);
            int y = this.getInt(Math.sin(theta) * (double)(corners[i] - cx) + Math.cos(theta) * (double)(corners[i + 1] - cy) + (double)cy);
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y >= minY) continue;
            minY = y;
        }
        cx -= minX;
        cy -= minY;
        BufferedImage result = new BufferedImage(maxX - minX, maxY - minY, 2);
        Graphics2D g2d = result.createGraphics();
        RenderingHints rhints = g2d.getRenderingHints();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform xform = new AffineTransform();
        xform.rotate(theta, cx, cy);
        g2d.setTransform(xform);
        g2d.drawImage((java.awt.Image)this.bufferedImage, -minX, -minY, null);
        g2d.dispose();
        this.bufferedImage = result;
        this.width = this.bufferedImage.getWidth();
        this.height = this.bufferedImage.getHeight();
        result = null;
        xform = null;
    }

    private int getInt(double value) {
        return (int)Math.round(value);
    }

    public void rotateClockwise() {
        this.rotate(90.0);
    }

    public void rotateCounterClockwise() {
        this.rotate(-90.0);
    }

    public void setWidth(int Width) {
        double ratio = (double)Width / (double)this.width;
        double dw = (double)this.width * ratio;
        double dh = (double)this.height * ratio;
        int outputWidth = (int)Math.round(dw);
        int outputHeight = (int)Math.round(dh);
        this.resize(outputWidth, outputHeight);
    }

    public void setHeight(int Height) {
        double ratio = (double)Height / (double)this.height;
        double dw = (double)this.width * ratio;
        double dh = (double)this.height * ratio;
        int outputWidth = (int)Math.round(dw);
        int outputHeight = (int)Math.round(dh);
        this.resize(outputWidth, outputHeight);
    }

    public void resize(int Width, int Height) {
        this.resize(Width, Height, false);
    }

    public void resize(int Width, int Height, boolean maintainRatio) {
        long startTime = this.getStartTime();
        int outputWidth = Width;
        int outputHeight = Height;
        if (maintainRatio) {
            double ratio = 0.0;
            ratio = this.width > this.height ? (double)Width / (double)this.width : (double)Height / (double)this.height;
            double dw = (double)this.width * ratio;
            double dh = (double)this.height * ratio;
            outputWidth = (int)Math.round(dw);
            outputHeight = (int)Math.round(dh);
            if (outputWidth > this.width || outputHeight > this.height) {
                outputWidth = this.width;
                outputHeight = this.height;
            }
        }
        java.awt.Image outputImage = this.bufferedImage.getScaledInstance(outputWidth, outputHeight, 16);
        BufferedImage bi = new BufferedImage(outputWidth, outputHeight, this.getImageType());
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(outputImage, 0, 0, null);
        g2d.dispose();
        this.bufferedImage = bi;
        this.width = outputWidth;
        this.height = outputHeight;
        outputImage = null;
        bi = null;
        g2d = null;
    }

    public void setCorners(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        Skew skew = new Skew(this.bufferedImage);
        this.bufferedImage = skew.setCorners(x0, y0, x1, y1, x2, y2, x3, y3);
        if (this.corners == null) {
            this.corners = new Vector();
        } else {
            this.corners.clear();
        }
        this.corners.add(Float.valueOf(x0));
        this.corners.add(Float.valueOf(y0));
        this.corners.add(Float.valueOf(x1));
        this.corners.add(Float.valueOf(y1));
        this.corners.add(Float.valueOf(x2));
        this.corners.add(Float.valueOf(y2));
        this.corners.add(Float.valueOf(x3));
        this.corners.add(Float.valueOf(y3));
    }

    public float[] getCorners() {
        if (this.corners == null) {
            float w = this.getWidth();
            float h = this.getHeight();
            this.corners = new Vector();
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(w));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(w));
            this.corners.add(Float.valueOf(h));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(h));
        }
        Object[] arr = this.corners.toArray();
        float[] ret = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Float f = (Float)arr[i];
            ret[i] = f.floatValue();
        }
        return ret;
    }

    public void sharpen() {
        Kernel kernel = new Kernel(3, 3, new float[]{0.0f, -0.2f, 0.0f, -0.2f, 1.8f, -0.2f, 0.0f, -0.2f, 0.0f});
        BufferedImage out = new BufferedImage(this.width, this.height, this.getImageType());
        ConvolveOp op = new ConvolveOp(kernel);
        out = op.filter(this.bufferedImage, out);
        BufferedImage overlay = out.getSubimage(2, 2, this.width - 4, this.height - 4);
        Graphics2D g2d = this.bufferedImage.createGraphics();
        g2d.drawImage((java.awt.Image)overlay, 2, 2, null);
        g2d.dispose();
    }

    public void desaturate() {
        this.bufferedImage = this.desaturate(this.bufferedImage);
    }

    public void desaturate(double percent) {
        float alpha = (float)percent;
        BufferedImage overlay = this.desaturate(this.bufferedImage);
        Graphics2D g2d = this.bufferedImage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((java.awt.Image)overlay, 0, 0, null);
        g2d.dispose();
    }

    private BufferedImage desaturate(BufferedImage in) {
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), this.getImageType(in));
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return op.filter(in, out);
    }

    public void setOpacity(double percent) {
        if (percent > 1.0) {
            percent /= 100.0;
        }
        float alpha = (float)percent;
        BufferedImage out = new BufferedImage(this.width, this.height, 2);
        Graphics2D g2d = out.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
        g2d.dispose();
        this.bufferedImage = out;
    }

    public void flip() {
        BufferedImage out = new BufferedImage(this.width, this.height, this.getImageType());
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-this.bufferedImage.getWidth(), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 3);
        this.bufferedImage = op.filter(this.bufferedImage, out);
    }

    public void crop(int x, int y, int width, int height) {
        this.bufferedImage = this.bufferedImage.getSubimage(x, y, width, height);
        this.width = this.bufferedImage.getWidth();
        this.height = this.bufferedImage.getHeight();
    }

    public BufferedImage getBufferedImage() {
        try {
            return this.bufferedImage;
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    public java.awt.Image getImage() {
        return this.getBufferedImage();
    }

    public RenderedImage getRenderedImage() {
        return this.getBufferedImage();
    }

    public BufferedImage getBufferedImage(int width, int height, boolean maintainRatio) {
        Image image = new Image(this.getBufferedImage());
        image.resize(width, height, maintainRatio);
        return image.getBufferedImage();
    }

    public byte[] getByteArray() {
        byte[] rgb = null;
        try {
            rgb = this.outputQuality >= 0.0f && this.outputQuality <= 1.0f ? this.getJPEGByteArray(this.outputQuality) : this.getJPEGByteArray(0.7f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rgb;
    }

    public byte[] getByteArray(String format) {
        byte[] rgb = null;
        if ((format = format.toLowerCase()).startsWith("image/")) {
            format = format.substring(format.indexOf("/") + 1);
        }
        try {
            if (this.isJPEG(format)) {
                rgb = this.getJPEGByteArray(this.outputQuality);
            } else {
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.bufferedImage, format.toLowerCase(), bas);
                rgb = bas.toByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rgb;
    }

    public void saveAs(File OutputFile) {
        this.saveAs(OutputFile.getFile());
    }

    public void saveAs(String PathToImageFile) {
        this.saveAs(new java.io.File(PathToImageFile));
    }

    public void saveAs(java.io.File OutputFile) {
        try {
            OutputFile.getParentFile().mkdirs();
            String FileExtension = this.getExtension(OutputFile.getName()).toLowerCase();
            if (this.isJPEG(FileExtension)) {
                FileOutputStream output = new FileOutputStream(OutputFile);
                output.write(this.getJPEGByteArray(this.outputQuality));
                output.close();
            } else {
                BufferedImage rendImage = this.bufferedImage;
                if (this.isJPEG2000(FileExtension)) {
                    ImageIO.write((RenderedImage)rendImage, "JPEG 2000", OutputFile);
                } else {
                    ImageIO.write((RenderedImage)rendImage, FileExtension, OutputFile);
                }
                Object var3_5 = null;
            }
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    public void setOutputQuality(double percentage) {
        float q;
        if (percentage > 1.0 && percentage <= 100.0) {
            percentage /= 100.0;
        }
        if ((q = (float)percentage) == 1.0f) {
            q = 1.2f;
        }
        if (q >= 0.0f && q <= 1.2f) {
            this.outputQuality = q;
        }
    }

    private boolean isJPEG(String FileExtension) {
        return (FileExtension = FileExtension.trim().toLowerCase()).equals("jpg") || FileExtension.equals("jpeg") || FileExtension.equals("jpe");
    }

    private boolean isJPEG2000(String FileExtension) {
        return (FileExtension = FileExtension.trim().toLowerCase()).equals("jp2") || FileExtension.equals("jpc") || FileExtension.equals("j2k") || FileExtension.equals("jpx");
    }

    private byte[] getJPEGByteArray(float outputQuality) throws IOException {
        if (outputQuality >= 0.0f && outputQuality <= 1.2f) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            BufferedImage bi = this.bufferedImage;
            int t = this.bufferedImage.getTransparency();
            if (t == 3) {
                bi = new BufferedImage(this.width, this.height, 1);
                Graphics2D biContext = bi.createGraphics();
                biContext.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
            }
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bas);
            JPEGEncodeParam params = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bi);
            params.setQuality(outputQuality, true);
            params.setHorizontalSubsampling(0, 2);
            params.setVerticalSubsampling(0, 2);
            encoder.encode(bi, params);
            bas.flush();
            return bas.toByteArray();
        }
        return this.getByteArray();
    }

    private int getImageType() {
        return this.getImageType(this.bufferedImage);
    }

    private int getImageType(BufferedImage bufferedImage) {
        int i = bufferedImage.getType();
        if (i <= 0) {
            i = 2;
        }
        return i;
    }

    private String getExtension(String FileName) {
        if (FileName.contains(".")) {
            return FileName.substring(FileName.lastIndexOf(".") + 1, FileName.length());
        }
        return "";
    }

    public boolean equals(Object obj) {
        Image image;
        if (obj != null && obj instanceof Image && (image = (Image)obj).getWidth() == this.getWidth() && image.getHeight() == this.getHeight()) {
            for (int i = 0; i < image.getWidth(); ++i) {
                for (int j = 0; j < image.getHeight(); ++j) {
                    if (image.getColor(i, j).equals(this.getColor(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void printError(Exception e) {
        System.out.println(e.toString());
        StackTraceElement[] arr = e.getStackTrace();
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i].toString());
        }
    }

    private long getStartTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    private long getEllapsedTime(long StartTime) {
        long endTime = Calendar.getInstance().getTimeInMillis();
        return endTime - StartTime;
    }

    private class Skew {
        public static final int ZERO = 0;
        public static final int CLAMP = 1;
        public static final int WRAP = 2;
        public static final int NEAREST_NEIGHBOUR = 0;
        public static final int BILINEAR = 1;
        protected int edgeAction = 0;
        protected int interpolation = 1;
        protected Rectangle transformedSpace;
        protected Rectangle originalSpace;
        private float x0;
        private float y0;
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float x3;
        private float y3;
        private float dx1;
        private float dy1;
        private float dx2;
        private float dy2;
        private float dx3;
        private float dy3;
        private float A;
        private float B;
        private float C;
        private float D;
        private float E;
        private float F;
        private float G;
        private float H;
        private float I;
        private BufferedImage src;
        private BufferedImage dst;

        public Skew(BufferedImage src) {
            this.src = src;
            this.dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }

        public Skew(Image src) {
            this(src.getBufferedImage());
        }

        public BufferedImage setCorners(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
            float a13;
            float a23;
            float a32;
            float a22;
            float a12;
            float a31;
            float a21;
            float a11;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
            this.dx1 = x1 - x2;
            this.dy1 = y1 - y2;
            this.dx2 = x3 - x2;
            this.dy2 = y3 - y2;
            this.dx3 = x0 - x1 + x2 - x3;
            this.dy3 = y0 - y1 + y2 - y3;
            if (this.dx3 == 0.0f && this.dy3 == 0.0f) {
                a11 = x1 - x0;
                a21 = x2 - x1;
                a31 = x0;
                a12 = y1 - y0;
                a22 = y2 - y1;
                a32 = y0;
                a23 = 0.0f;
                a13 = 0.0f;
            } else {
                a13 = (this.dx3 * this.dy2 - this.dx2 * this.dy3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
                a23 = (this.dx1 * this.dy3 - this.dy1 * this.dx3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
                a11 = x1 - x0 + a13 * x1;
                a21 = x3 - x0 + a23 * x3;
                a31 = x0;
                a12 = y1 - y0 + a13 * y1;
                a22 = y3 - y0 + a23 * y3;
                a32 = y0;
            }
            this.A = a22 - a32 * a23;
            this.B = a31 * a23 - a21;
            this.C = a21 * a32 - a31 * a22;
            this.D = a32 * a13 - a12;
            this.E = a11 - a31 * a13;
            this.F = a31 * a12 - a11 * a32;
            this.G = a12 * a23 - a22 * a13;
            this.H = a21 * a13 - a11 * a23;
            this.I = a11 * a22 - a21 * a12;
            return this.filter(this.src, this.dst);
        }

        protected void transformSpace(Rectangle rect) {
            rect.x = (int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3));
            rect.y = (int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3));
            rect.width = (int)Math.max(Math.max(this.x0, this.x1), Math.max(this.x2, this.x3)) - rect.x;
            rect.height = (int)Math.max(Math.max(this.y0, this.y1), Math.max(this.y2, this.y3)) - rect.y;
        }

        public float getOriginX() {
            return this.x0 - (float)((int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3)));
        }

        public float getOriginY() {
            return this.y0 - (float)((int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3)));
        }

        private BufferedImage filter(BufferedImage src, BufferedImage dst) {
            int width = src.getWidth();
            int height = src.getHeight();
            int type = src.getType();
            WritableRaster srcRaster = src.getRaster();
            this.originalSpace = new Rectangle(0, 0, width, height);
            this.transformedSpace = new Rectangle(0, 0, width, height);
            this.transformSpace(this.transformedSpace);
            if (dst == null) {
                ColorModel dstCM = src.getColorModel();
                dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
            }
            WritableRaster dstRaster = dst.getRaster();
            int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
            if (this.interpolation == 0) {
                return this.filterPixelsNN(dst, width, height, inPixels, this.transformedSpace);
            }
            int srcWidth = width;
            int srcHeight = height;
            int srcWidth1 = width - 1;
            int srcHeight1 = height - 1;
            int outWidth = this.transformedSpace.width;
            int outHeight = this.transformedSpace.height;
            boolean index = false;
            int[] outPixels = new int[outWidth];
            int outX = this.transformedSpace.x;
            int outY = this.transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    int se;
                    int sw;
                    int ne;
                    int nw;
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)Math.floor(out[0]);
                    int srcY = (int)Math.floor(out[1]);
                    float xWeight = out[0] - (float)srcX;
                    float yWeight = out[1] - (float)srcY;
                    if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                        int i = srcWidth * srcY + srcX;
                        nw = inPixels[i];
                        ne = inPixels[i + 1];
                        sw = inPixels[i + srcWidth];
                        se = inPixels[i + srcWidth + 1];
                    } else {
                        nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                        ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                        sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                        se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                    }
                    outPixels[x] = this.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                }
                this.setRGB(dst, 0, y, this.transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        private final int getPixel(int[] pixels, int x, int y, int width, int height) {
            if (x < 0 || x >= width || y < 0 || y >= height) {
                switch (this.edgeAction) {
                    default: {
                        return 0;
                    }
                    case 2: {
                        return pixels[this.mod(y, height) * width + this.mod(x, width)];
                    }
                    case 1: 
                }
                return pixels[this.clamp(y, 0, height - 1) * width + this.clamp(x, 0, width - 1)];
            }
            return pixels[y * width + x];
        }

        protected BufferedImage filterPixelsNN(BufferedImage dst, int width, int height, int[] inPixels, Rectangle transformedSpace) {
            int srcWidth = width;
            int srcHeight = height;
            int outWidth = transformedSpace.width;
            int outHeight = transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = transformedSpace.x;
            int outY = transformedSpace.y;
            int[] rgb = new int[4];
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)out[0];
                    int srcY = (int)out[1];
                    if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                        int p;
                        switch (this.edgeAction) {
                            default: {
                                p = 0;
                                break;
                            }
                            case 2: {
                                p = inPixels[this.mod(srcY, srcHeight) * srcWidth + this.mod(srcX, srcWidth)];
                                break;
                            }
                            case 1: {
                                p = inPixels[this.clamp(srcY, 0, srcHeight - 1) * srcWidth + this.clamp(srcX, 0, srcWidth - 1)];
                            }
                        }
                        outPixels[x] = p;
                        continue;
                    }
                    int i = srcWidth * srcY + srcX;
                    rgb[0] = inPixels[i];
                    outPixels[x] = inPixels[i];
                }
                this.setRGB(dst, 0, y, transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        protected void transformInverse(int x, int y, float[] out) {
            out[0] = (float)this.originalSpace.width * (this.A * (float)x + this.B * (float)y + this.C) / (this.G * (float)x + this.H * (float)y + this.I);
            out[1] = (float)this.originalSpace.height * (this.D * (float)x + this.E * (float)y + this.F) / (this.G * (float)x + this.H * (float)y + this.I);
        }

        public int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
            }
            return image.getRGB(x, y, width, height, pixels, 0, width);
        }

        public void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                image.getRaster().setDataElements(x, y, width, height, pixels);
            } else {
                image.setRGB(x, y, width, height, pixels, 0, width);
            }
        }

        private float clamp(float x, float a, float b) {
            return x < a ? a : (x > b ? b : x);
        }

        private int clamp(int x, int a, int b) {
            return x < a ? a : (x > b ? b : x);
        }

        private double mod(double a, double b) {
            int n;
            if ((a -= (double)(n = (int)(a / b)) * b) < 0.0) {
                return a + b;
            }
            return a;
        }

        private float mod(float a, float b) {
            int n;
            if ((a -= (float)(n = (int)(a / b)) * b) < 0.0f) {
                return a + b;
            }
            return a;
        }

        private int mod(int a, int b) {
            int n;
            if ((a -= (n = a / b) * b) < 0) {
                return a + b;
            }
            return a;
        }

        private int bilinearInterpolate(float x, float y, int nw, int ne, int sw, int se) {
            int a0 = nw >> 24 & 0xFF;
            int r0 = nw >> 16 & 0xFF;
            int g0 = nw >> 8 & 0xFF;
            int b0 = nw & 0xFF;
            int a1 = ne >> 24 & 0xFF;
            int r1 = ne >> 16 & 0xFF;
            int g1 = ne >> 8 & 0xFF;
            int b1 = ne & 0xFF;
            int a2 = sw >> 24 & 0xFF;
            int r2 = sw >> 16 & 0xFF;
            int g2 = sw >> 8 & 0xFF;
            int b2 = sw & 0xFF;
            int a3 = se >> 24 & 0xFF;
            int r3 = se >> 16 & 0xFF;
            int g3 = se >> 8 & 0xFF;
            int b3 = se & 0xFF;
            float cx = 1.0f - x;
            float cy = 1.0f - y;
            float m0 = cx * (float)a0 + x * (float)a1;
            float m1 = cx * (float)a2 + x * (float)a3;
            int a = (int)(cy * m0 + y * m1);
            m0 = cx * (float)r0 + x * (float)r1;
            m1 = cx * (float)r2 + x * (float)r3;
            int r = (int)(cy * m0 + y * m1);
            m0 = cx * (float)g0 + x * (float)g1;
            m1 = cx * (float)g2 + x * (float)g3;
            int g = (int)(cy * m0 + y * m1);
            m0 = cx * (float)b0 + x * (float)b1;
            m1 = cx * (float)b2 + x * (float)b3;
            int b = (int)(cy * m0 + y * m1);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }
}

