/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Vector;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Field;
import javaxt.sql.Parser;
import javaxt.sql.Table;
import javaxt.sql.Value;
import javaxt.utils.string;

public class Recordset {
    private ResultSet rs = null;
    private java.sql.Connection Conn = null;
    private Statement stmt = null;
    private int x;
    private String sqlString = null;
    private Parser sqlParser = null;
    private Connection Connection = null;
    public int State = 0;
    public boolean EOF = false;
    private Field[] Fields = null;
    public int MaxRecords = 1000000000;
    public int RecordCount;
    public long QueryResponseTime;
    public long EllapsedTime;
    public long MetadataQueryTime;
    private long startTime;
    private long endTime;
    private boolean isReadOnly = true;
    private boolean InsertOnUpdate = false;
    private int numRetries = 0;

    public Connection getConnection() {
        return this.Connection;
    }

    public boolean isOpen() {
        if (this.State != 0) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.rs.getClass().getMethod("isClosed", new Class[0]).invoke((Object)this.rs, null) == false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ResultSet open(String sql, Connection conn) {
        return this.open(sql, conn, true);
    }

    public ResultSet open(String sqlString, Connection Connection2, boolean ReadOnly) {
        this.rs = null;
        this.stmt = null;
        this.State = 0;
        this.EOF = true;
        this.sqlString = sqlString;
        this.Connection = Connection2;
        this.isReadOnly = ReadOnly;
        try {
            int i;
            block34: {
                this.startTime = Calendar.getInstance().getTimeInMillis();
                this.Conn = Connection2.getConnection();
                if (Connection2.getDatabase().getDriver().equals("PostgreSQL")) {
                    try {
                        this.sqlParser = new Parser(sqlString);
                        boolean wrapElements = false;
                        String[] exposedElements = this.sqlParser.getExposedDataElements();
                        for (i = 0; i < exposedElements.length; ++i) {
                            String element = exposedElements[i];
                            if (!string.hasUpperCase(element)) continue;
                            wrapElements = true;
                            break;
                        }
                        if (wrapElements = false) {
                            sqlString = this.sqlParser.addQuotes();
                            System.out.println(sqlString);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("WARNING: Failed to parse SQL");
                        e.printStackTrace();
                    }
                }
                if (ReadOnly) {
                    try {
                        this.stmt = Connection2.getDatabase().getDriver().equals("DB2") ? this.Conn.createStatement(1003, 1007) : this.Conn.createStatement(1004, 1007);
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        System.out.println("ERROR Open RecordSet: " + e.toString());
                    }
                    if (this.State != 1) {
                        try {
                            this.stmt = this.Conn.createStatement();
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                        }
                        catch (Exception e) {
                            System.out.println("ERROR Open RecordSet: " + e.toString());
                        }
                    }
                } else {
                    try {
                        if (Connection2.getDatabase().getDriver().equals("SYBASE")) {
                            this.stmt = this.Conn.createStatement(1003, 1008);
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                            break block34;
                        }
                        if (Connection2.getDatabase().getDriver().equals("DB2")) {
                            try {
                                this.stmt = this.Conn.createStatement(1005, 1008);
                                this.rs = this.stmt.executeQuery(sqlString);
                                this.State = 1;
                            }
                            catch (Exception e) {
                                this.rs = null;
                            }
                            if (this.rs == null) {
                                try {
                                    this.stmt = this.Conn.createStatement(1003, 1008);
                                    this.rs = this.stmt.executeQuery(sqlString);
                                    this.State = 1;
                                }
                                catch (Exception e) {}
                            }
                            break block34;
                        }
                        this.stmt = this.Conn.createStatement(1005, 1008);
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        System.out.println("ERROR Open RecordSet (RW): " + e.toString());
                    }
                }
            }
            this.endTime = Calendar.getInstance().getTimeInMillis();
            this.QueryResponseTime = this.endTime - this.startTime;
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            this.Fields = new Field[cols];
            for (i = 1; i <= cols; ++i) {
                Field Field2 = new Field();
                Field2.Name = rsmd.getColumnName(i);
                try {
                    Field2.Table = rsmd.getTableName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Schema = rsmd.getSchemaName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Type = rsmd.getColumnTypeName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Class = rsmd.getColumnClassName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.Fields[i - 1] = Field2;
            }
            this.x = -1;
            if (this.rs != null && this.rs.next()) {
                this.EOF = false;
                for (i = 1; i <= cols; ++i) {
                    this.Fields[i - 1].Value = new Value(this.rs.getString(i));
                }
                ++this.x;
                long mStart = Calendar.getInstance().getTimeInMillis();
                this.updateFields();
                long mEnd = Calendar.getInstance().getTimeInMillis();
                this.MetadataQueryTime = mEnd - mStart;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR Open RecordSet:");
            e.printStackTrace();
        }
        return this.rs;
    }

    public void close() {
        if (this.State == 1) {
            try {
                this.rs.close();
                this.stmt.close();
            }
            catch (Exception e) {
                System.out.println("ERROR Close Recordset: " + e.toString());
            }
        }
        this.endTime = Calendar.getInstance().getTimeInMillis();
        this.EllapsedTime = this.endTime - this.startTime;
    }

    public void commit() {
        try {
            this.Conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNew() {
        if (this.State == 1) {
            try {
                if (this.Connection.getDatabase().getDriver().equals("DB2")) {
                    for (int i = 0; i < this.Fields.length; ++i) {
                        this.Fields[i].Value = null;
                    }
                } else {
                    this.rs.moveToInsertRow();
                }
                this.InsertOnUpdate = true;
            }
            catch (Exception e) {
                System.out.println("AddNew ERROR: " + e.toString());
            }
        }
    }

    public void update() {
        if (this.State == 1) {
            try {
                int i;
                boolean usePreparedStatement = false;
                if (this.Connection.getDatabase().getDriver().equals("DB2")) {
                    usePreparedStatement = true;
                } else if (this.Connection.getDatabase().getDriver().equals("PostgreSQL")) {
                    for (i = 0; i < this.Fields.length; ++i) {
                        String name = this.Fields[i].Name;
                        String type = this.Fields[i].Class;
                        Object value = this.Fields[i].Value.toObject();
                        if (value == null || !value.getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        usePreparedStatement = true;
                        this.Fields[i].Value = new Value(this.getGeometry(name, value));
                        break;
                    }
                }
                if (!usePreparedStatement) {
                    for (i = 0; i < this.Fields.length; ++i) {
                        String FieldName = this.Fields[i].Name;
                        String FieldType = this.Fields[i].Class;
                        Value FieldValue = this.Fields[i].Value;
                        if (!this.Fields[i].RequiresUpdate) continue;
                        if (FieldType.indexOf("String") >= 0) {
                            this.rs.updateString(FieldName, FieldValue.toString());
                        }
                        if (FieldType.indexOf("Integer") >= 0) {
                            this.rs.updateInt(FieldName, (int)FieldValue.toInteger());
                        }
                        if (FieldType.indexOf("Short") >= 0) {
                            this.rs.updateShort(FieldName, (short)FieldValue.toShort());
                        }
                        if (FieldType.indexOf("Long") >= 0) {
                            this.rs.updateLong(FieldName, (long)FieldValue.toLong());
                        }
                        if (FieldType.indexOf("Double") >= 0) {
                            this.rs.updateDouble(FieldName, (double)FieldValue.toDouble());
                        }
                        if (FieldType.indexOf("Timestamp") >= 0) {
                            this.rs.updateTimestamp(FieldName, FieldValue.toTimeStamp());
                        }
                        if (FieldValue == null || !FieldValue.toObject().getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        this.rs.updateObject(FieldName, (Object)this.getGeometry(FieldName, FieldValue));
                    }
                }
                if (this.InsertOnUpdate) {
                    if (usePreparedStatement) {
                        this.insertRecord();
                    } else {
                        this.rs.insertRow();
                    }
                    this.InsertOnUpdate = false;
                } else {
                    this.rs.updateRow();
                }
            }
            catch (Exception e) {
                System.out.println("Update ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public Field getField(String FieldName) {
        if (this.Fields != null) {
            String[] arr = FieldName.split("\\.");
            FieldName = arr[arr.length - 1];
            for (int i = 0; i < this.Fields.length; ++i) {
                if (!(arr.length == 3 ? this.Fields[i].Name.equalsIgnoreCase(FieldName) && this.Fields[i].Table.equalsIgnoreCase(arr[1]) && this.Fields[i].Schema.equalsIgnoreCase(arr[0]) : (arr.length == 2 ? this.Fields[i].Name.equalsIgnoreCase(FieldName) && this.Fields[i].Table.equalsIgnoreCase(arr[0]) : this.Fields[i].Name.equalsIgnoreCase(FieldName)))) continue;
                return this.Fields[i];
            }
        }
        return null;
    }

    public Field getField(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i];
        }
        return null;
    }

    public Value getValue(String FieldName) {
        return this.getField((String)FieldName).Value;
    }

    public Value getValue(int i) {
        return this.Fields[i].Value;
    }

    public void setValue(String FieldName, Object FieldValue) {
        if (this.State == 1) {
            for (int i = 0; i < this.Fields.length; ++i) {
                String name = this.Fields[i].Name;
                if (!name.equalsIgnoreCase(FieldName)) continue;
                this.Fields[i].Value = new Value(FieldValue);
                this.Fields[i].RequiresUpdate = true;
                break;
            }
        }
    }

    public void setValue(String FieldName, boolean FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, long FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, int FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, double FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRecord() {
        Field Col;
        int i;
        String tableName = this.Fields[0].Table;
        if (tableName == null || tableName.length() <= 0) {
            if (this.sqlParser == null) {
                this.sqlParser = new Parser(this.sqlString);
            }
            tableName = this.sqlParser.getTables()[0];
        }
        if (this.Connection.getDatabase().getDriver().equals("PostgreSQL") && string.hasUpperCase(tableName)) {
            tableName = "\"" + tableName + "\"";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into " + tableName + " (");
        for (i = 0; i < this.Fields.length; ++i) {
            Col = this.Fields[i];
            if (Col.Value == null) continue;
            if (this.Connection.getDatabase().getDriver().equals("PostgreSQL") && string.hasUpperCase(tableName)) {
                sql.append("\"" + Col.Name + "\"");
            } else {
                sql.append(Col.Name);
            }
            if (i >= this.Fields.length - 1) continue;
            sql.append(",");
        }
        sql.append(") Values (");
        for (i = 0; i < this.Fields.length; ++i) {
            Col = this.Fields[i];
            if (Col.Value == null) continue;
            if (this.isNumericType(Col.Type)) {
                sql.append(Col.Value);
            } else if (this.isBooleanType(Col.Type)) {
                sql.append(Col.Value);
            } else if (this.containsFunction(Col.Value.toString())) {
                sql.append(Col.Value);
            } else {
                sql.append("'" + Col.Value.toString().replace("'", "''") + "'");
            }
            if (i >= this.Fields.length - 1) continue;
            sql.append(",");
        }
        sql.append(")");
        PreparedStatement preparedStmt = null;
        try {
            preparedStmt = this.Conn.prepareStatement(sql.toString());
            preparedStmt.execute();
            this.delPrepStmt(preparedStmt);
        }
        catch (Exception e) {
            try {
                System.out.println("Insert Error:");
                System.out.println(e.toString());
                System.out.println("SQL=" + sql.toString());
                this.delPrepStmt(preparedStmt);
            }
            catch (Throwable throwable) {
                this.delPrepStmt(preparedStmt);
                throw throwable;
            }
        }
    }

    private void delPrepStmt(PreparedStatement preparedStmt) {
        if (preparedStmt != null) {
            try {
                preparedStmt.close();
                preparedStmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isNumericType(String FieldType) {
        if (FieldType.equalsIgnoreCase("Integer")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("Short")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("Long")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("Double")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("Float")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("SMALLINT")) {
            return true;
        }
        if (FieldType.equalsIgnoreCase("TINYINT")) {
            return true;
        }
        return FieldType.equalsIgnoreCase("BIGINT");
    }

    private boolean isBooleanType(String FieldType) {
        if (FieldType.equalsIgnoreCase("Boolean")) {
            return true;
        }
        return FieldType.equalsIgnoreCase("Bool");
    }

    private boolean containsFunction(String ColValue) {
        return (ColValue = ColValue.trim()).contains("(") && ColValue.endsWith(")");
    }

    public boolean moveNext() {
        if (this.EOF) {
            return false;
        }
        if (this.x >= this.MaxRecords - 1) {
            this.EOF = true;
            return false;
        }
        try {
            if (this.rs.next()) {
                for (int i = 1; i <= this.Fields.length; ++i) {
                    Field Field2 = this.Fields[i - 1];
                    Field2.Value = new Value(this.rs.getString(i));
                }
                ++this.x;
                return true;
            }
            this.EOF = true;
            return false;
        }
        catch (Exception e) {
            System.out.println("ERROR MoveNext: " + e.toString());
            return false;
        }
    }

    public void move(int numRecords) {
        boolean tryAgain = false;
        try {
            this.rs.absolute(numRecords);
        }
        catch (Exception e) {
            tryAgain = true;
            System.out.println("ERROR Move: " + e.toString());
        }
        try {
            if (tryAgain) {
                int rowPosition = this.rs.getRow();
                while (this.rs.getRow() < numRecords + rowPosition) {
                    this.rs.next();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            for (int i = 1; i <= this.Fields.length; ++i) {
                Field Field2 = this.Fields[i - 1];
                Field2.Value = new Value(this.rs.getString(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Column getColumn(Field field, Table[] tables) {
        int i;
        Vector<Column> matches = new Vector<Column>();
        for (i = 0; i < tables.length; ++i) {
            Column[] columns = tables[i].getColumns();
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                if (!column.getName().equalsIgnoreCase(field.Name)) continue;
                matches.add(column);
            }
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Column)matches.get(0);
            }
            case 2: {
                for (i = 0; i < matches.size(); ++i) {
                    Column column = (Column)matches.get(i);
                    if (!column.getType().equalsIgnoreCase(field.Type)) continue;
                    return column;
                }
                return (Column)matches.get(0);
            }
        }
        return null;
    }

    private Table getTable(String tableName, Table[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            if (!tables[i].getName().equalsIgnoreCase(tableName)) continue;
            return tables[i];
        }
        return null;
    }

    private void updateFields() {
        if (this.Fields == null) {
            return;
        }
        Table[] tables = null;
        for (int i = 0; i < this.Fields.length; ++i) {
            if (this.Fields[i].Table != null && this.Fields[i].Schema != null) continue;
            if (tables == null) {
                tables = this.Connection.getDatabase().getTables();
            }
            if (this.Fields[i].Table == null) {
                Column column = this.getColumn(this.Fields[i], tables);
                this.Fields[i].Table = column.getTable().getName();
                this.Fields[i].Schema = column.getTable().getSchema();
                continue;
            }
            Table table = this.getTable(this.Fields[i].Table, tables);
            this.Fields[i].Schema = table.getSchema();
        }
    }

    public int getRecordCount() {
        try {
            int oldRow = this.rs.getRow();
            this.rs.last();
            int size = this.rs.getRow();
            this.rs.absolute(oldRow);
            return size;
        }
        catch (Exception e) {
            System.out.println("RowCount ERROR: " + e.toString());
            return -1;
        }
    }

    public boolean hasNext() {
        return !this.EOF;
    }

    public Field[] getFields() {
        return this.Fields;
    }

    private String getGeometry(String FieldName, Object FieldValue) {
        String geometryType = FieldValue.getClass().getCanonicalName().toString();
        geometryType = geometryType.substring(geometryType.lastIndexOf(".") + 1).trim().toUpperCase();
        if (this.Connection.getDatabase().getDriver().equals("PostgreSQL")) {
            return "ST_GeomFromText('" + FieldValue.toString() + "', 4326)";
        }
        if (this.Connection.getDatabase().getDriver().equals("DB2")) {
            if (geometryType.equals("LINE")) {
                String line = FieldValue.toString().toUpperCase().replace("LINESTRING", "LINE");
                return "db2GSE.ST_LINE('" + line + "', 2000000000)";
            }
            return "db2GSE.ST_" + geometryType + "('" + FieldValue.toString() + "', 2000000000)";
        }
        return null;
    }
}

