/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class Date {
    private Locale currentLocale = Locale.US;
    private java.util.Date currDate = new java.util.Date();
    public static final String INTERVAL_MILLISECONDS = "S";
    public static final String INTERVAL_SECONDS = "s";
    public static final String INTERVAL_MINUTES = "m";
    public static final String INTERVAL_HOURS = "h";
    public static final String INTERVAL_DAYS = "d";
    public static final String INTERVAL_WEEKS = "w";
    public static final String INTERVAL_MONTHS = "m";
    public static final String INTERVAL_YEARS = "y";
    private boolean parserFailed = false;

    public Date() {
        this.currDate = new java.util.Date();
    }

    public Date(java.util.Date date) {
        this.currDate = date;
    }

    public Date(Calendar calendar) {
        this.currDate = calendar.getTime();
    }

    public Date(long milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliseconds);
        this.currDate = cal.getTime();
    }

    public Date(String date) {
        String[] Format2 = new String[]{"EEE, d MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM d HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE MMM d HH:mm:ss yyyy", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy:MM:dd HH:mm:ss", "yyyy-MM-dd-HH:mm:ss.SSS", "yyyy-MM-dd-HH:mm:ss", "dd-MMM-yyyy h:mm:ss a", "dd-MMM-yy h:mm:ss a", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm", "dd-MMM-yy", "dd-MMM-yyyy", "MMMMMM d, yyyy", "M/d/yyyy h:mm:ss a", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy HH:mm", "M/d/yy", "MM/dd/yyyy", "M/d/yyyy", "yyyyMMddHHmmssSSS", "yyyyMMddHHmmss"};
        java.util.Date d = null;
        for (int i = 0; i < Format2.length; ++i) {
            d = this.ParseDate(date, Format2[i]);
            if (d == null) continue;
            this.currDate = d;
            break;
        }
        if (d == null) {
            String newDate = date.replace("T", " ");
            for (int i = 0; i < Format2.length; ++i) {
                d = this.ParseDate(newDate, Format2[i]);
                if (d == null) continue;
                this.currDate = d;
                break;
            }
        }
        if (d == null) {
            this.currDate = new java.util.Date();
        }
    }

    public boolean failedToParse() {
        return this.parserFailed;
    }

    public Date(String date, String Format2) {
        this.setDate(date, Format2);
    }

    public void setDate(String date, String format) {
        java.util.Date d = this.ParseDate(date, format);
        if (d != null) {
            this.currDate = d;
        }
    }

    public void setDate(java.util.Date date) {
        this.currDate = date;
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    private java.util.Date ParseDate(String date, String format) {
        try {
            this.parserFailed = false;
            SimpleDateFormat formatter = new SimpleDateFormat(format, this.currentLocale);
            return formatter.parse(date);
        }
        catch (Exception e) {
            this.parserFailed = true;
            return null;
        }
    }

    public String toString() {
        SimpleDateFormat currFormatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", this.currentLocale);
        return currFormatter.format(this.currDate);
    }

    public String toString(String Format2) {
        SimpleDateFormat currFormatter = new SimpleDateFormat(Format2, this.currentLocale);
        return currFormatter.format(this.currDate);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).getDate().equals(this.currDate);
        }
        if (obj instanceof java.util.Date) {
            return ((java.util.Date)obj).equals(this.currDate);
        }
        return false;
    }

    private String FormatDate(java.util.Date date, String OutputFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(OutputFormat, this.currentLocale);
        return formatter.format(date);
    }

    public long compareTo(Date date, String interval) {
        return this.DateDiff(this.currDate, date.getDate(), interval);
    }

    public long compareTo(java.util.Date date, String interval) {
        return this.DateDiff(this.currDate, date, interval);
    }

    private long DateDiff(java.util.Date date1, java.util.Date date2, String interval) {
        double div = 1.0;
        if (interval.equals(INTERVAL_MILLISECONDS) || interval.toLowerCase().startsWith("sec")) {
            div = 1000.0;
        }
        if (interval.equals("m") || interval.toLowerCase().startsWith("min")) {
            div = 60000.0;
        }
        if (interval.equals("H") || interval.toLowerCase().startsWith(INTERVAL_HOURS)) {
            div = 3600000.0;
        }
        if (interval.equals(INTERVAL_DAYS) || interval.toLowerCase().startsWith(INTERVAL_DAYS)) {
            div = 8.64E7;
        }
        if (interval.equals(INTERVAL_WEEKS) || interval.toLowerCase().startsWith(INTERVAL_WEEKS)) {
            div = 6.048E8;
        }
        if (interval.equals("M") || interval.toLowerCase().startsWith("mon")) {
            div = 2.592E9;
        }
        if (interval.equals(INTERVAL_YEARS) || interval.toLowerCase().startsWith(INTERVAL_YEARS)) {
            div = 3.1536E10;
        }
        long d1 = date1.getTime();
        long d2 = date2.getTime();
        int i2 = (int)Math.abs((double)(d1 - d2) / div);
        if (date2.after(date1)) {
            i2 = -i2;
        }
        return i2;
    }

    public boolean isBefore(Date Date2) {
        return this.currDate.before(Date2.getDate());
    }

    public boolean isAfter(Date Date2) {
        return this.currDate.after(Date2.getDate());
    }

    public java.util.Date add(int amount, String interval) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currDate);
        int div = 0;
        if (interval.equals(INTERVAL_MILLISECONDS) || interval.toLowerCase().startsWith("sec")) {
            div = 14;
        }
        if (interval.equals("m") || interval.toLowerCase().startsWith("min")) {
            div = 12;
        }
        if (interval.equals("H") || interval.toLowerCase().startsWith(INTERVAL_HOURS)) {
            div = 11;
        }
        if (interval.equals(INTERVAL_DAYS) || interval.toLowerCase().startsWith(INTERVAL_DAYS)) {
            div = 6;
        }
        if (interval.equals(INTERVAL_WEEKS) || interval.toLowerCase().startsWith(INTERVAL_WEEKS)) {
            div = 3;
        }
        if (interval.equals("M") || interval.toLowerCase().startsWith("mon")) {
            div = 2;
        }
        if (interval.equals(INTERVAL_YEARS) || interval.toLowerCase().startsWith(INTERVAL_YEARS)) {
            div = 1;
        }
        cal.add(div, amount);
        this.currDate = cal.getTime();
        return this.currDate;
    }

    public java.util.Date getDate() {
        return this.currDate;
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currDate);
        return cal;
    }

    public String getWeekdayName() {
        return this.FormatDate(this.currDate, "EEEEEE");
    }

    public String getMonthName() {
        return this.FormatDate(this.currDate, "MMMMMM");
    }

    public int getDayOfWeek() {
        return Integer.valueOf(this.FormatDate(this.currDate, "F"));
    }

    public int getWeekInMonth() {
        return Integer.valueOf(this.FormatDate(this.currDate, "W"));
    }

    public int getDayInYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, "D"));
    }

    public int getWeekInYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_WEEKS));
    }

    public int getYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, "yyyy"));
    }

    public int getMonth() {
        return Integer.valueOf(this.FormatDate(this.currDate, "MM"));
    }

    public int getDay() {
        return Integer.valueOf(this.FormatDate(this.currDate, "dd"));
    }

    public int getHour() {
        return Integer.valueOf(this.FormatDate(this.currDate, "HH"));
    }

    public int getMinute() {
        return Integer.valueOf(this.FormatDate(this.currDate, "m"));
    }

    public int getSecond() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_SECONDS));
    }

    public int getMilliSecond() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_MILLISECONDS));
    }
}

