/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javaxt.http.Response;
import javaxt.utils.string;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request {
    protected URLConnection conn = null;
    private Proxy HttpProxy;
    private URL url;
    private boolean useCache = false;
    private int maxRedirects = 5;
    private Map<String, List<String>> requestHeaders = null;
    private Map headers = null;
    private String protocol;
    private String version;
    private int responseCode;
    private String message;
    private List<RequestProperty> RequestProperties = new LinkedList<RequestProperty>();

    public Request(String url) {
        this(url, null);
    }

    public Request(String url, String httpProxy) {
        try {
            this.url = new URL(url);
            this.setProxy(httpProxy);
            this.initHeaders();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request(URL url) {
        this(url, null);
    }

    public Request(URL url, String httpProxy) {
        this.url = url;
        this.setProxy(httpProxy);
        this.initHeaders();
    }

    private void initHeaders() {
        this.setUseCache(false);
        this.setHeader("Accept-Encoding", "gzip,deflate");
        this.setHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
        this.setHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.10)");
    }

    public URL getURL() {
        return this.url;
    }

    public Response getResponse() {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        return new Response(this);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setNumRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public void addHeader(String key, String value) {
        if (key.equalsIgnoreCase("If-None-Match") || key.equalsIgnoreCase("If-Modified-Since") && value != null) {
            this.useCache = true;
        }
        new RequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStream output = null;
        try {
            output = this.conn.getOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = payload.read(buf)) != -1) {
                output.write(buf, 0, i);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStreamWriter output = null;
        try {
            output = new OutputStreamWriter(this.conn.getOutputStream());
            output.write(payload);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public void setHeader(String key, String value) {
        boolean foundProperty = false;
        for (RequestProperty property : this.RequestProperties) {
            if (!property.key.equalsIgnoreCase(key)) continue;
            property.value = value;
            foundProperty = true;
        }
        if (!foundProperty) {
            this.addHeader(key, value);
        }
    }

    private URLConnection getConnection() {
        this.conn = null;
        URLConnection conn = this.connect();
        if (conn != null) {
            this.parseResponse(conn);
            if (this.responseCode >= 300 && this.responseCode < 400 && this.maxRedirects > 0) {
                int numRedirects = 0;
                while (!(this.responseCode < 300 || this.responseCode >= 400 || this.useCache && this.responseCode == 304)) {
                    try {
                        this.url = new URL(this.getResponseHeader("Location"));
                        conn = this.connect();
                        this.parseResponse(conn);
                        if (++numRedirects <= this.maxRedirects) continue;
                    }
                    catch (Exception e) {}
                    break;
                }
            }
        }
        return conn;
    }

    private URLConnection connect() {
        try {
            URLConnection conn = this.HttpProxy == null || this.isLocalHost(this.url.getHost()) ? this.url.openConnection() : this.url.openConnection(this.HttpProxy);
            conn.setUseCaches(this.useCache);
            for (int i = 0; i < this.RequestProperties.size(); ++i) {
                RequestProperty property = this.RequestProperties.get(i);
                conn.setRequestProperty(property.key, property.value);
            }
            return conn;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getExpiration(URLConnection connection, long baseTime) {
        String expires;
        Object token;
        SimpleDateFormat PATTERN_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        String cacheControl = connection.getHeaderField("Cache-Control");
        if (cacheControl != null) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                int eqIdx;
                token = tok.nextToken().trim().toLowerCase();
                if ("must-revalidate".equals(token)) {
                    return new Long(0L);
                }
                if (!((String)token).startsWith("max-age") || (eqIdx = ((String)token).indexOf(61)) == -1) continue;
                String value = ((String)token).substring(eqIdx + 1).trim();
                try {
                    int seconds = Integer.parseInt(value);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    System.err.println("getExpiration(): Bad Cache-Control max-age value: " + value);
                }
            }
        }
        if ((expires = connection.getHeaderField("Expires")) != null) {
            try {
                token = PATTERN_RFC1123;
                synchronized (token) {
                    Date expDate = PATTERN_RFC1123.parse(expires);
                    return new Long(expDate.getTime());
                }
            }
            catch (ParseException pe) {
                try {
                    int seconds = Integer.parseInt(expires);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    System.err.println("getExpiration(): Bad Expires header value: " + expires);
                }
            }
        }
        return null;
    }

    private void parseResponse(URLConnection conn) {
        this.protocol = "";
        this.version = "";
        this.responseCode = -1;
        this.message = "";
        this.requestHeaders = conn.getRequestProperties();
        this.headers = conn.getHeaderFields();
        if (!this.headers.isEmpty()) {
            StringTokenizer st = new StringTokenizer((String)((List)this.headers.get(null)).get(0));
            if (st.hasMoreTokens()) {
                this.protocol = st.nextToken().trim().toUpperCase();
            }
            if (this.protocol.contains("/")) {
                String temp = this.protocol;
                this.protocol = temp.substring(0, temp.indexOf("/"));
                this.version = temp.substring(temp.indexOf("/") + 1);
            } else {
                this.protocol = "HTTP";
                this.version = "1.1";
            }
            if (st.hasMoreTokens()) {
                this.responseCode = string.toInt(st.nextToken().trim());
            }
            if (st.hasMoreTokens()) {
                this.message = "";
                while (st.hasMoreTokens()) {
                    this.message = this.message + st.nextToken() + " ";
                }
                this.message = this.message.trim();
            }
        }
    }

    protected int getResponseCode() {
        return this.responseCode;
    }

    protected String getResponseMessage() {
        return this.message;
    }

    protected Map getResponseHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getRequestHeaders() {
        if (this.requestHeaders != null) {
            return this.requestHeaders;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RequestProperty prop : this.RequestProperties) {
            String key = prop.key;
            String val = prop.value;
            Vector<String> vals = (Vector<String>)map.get(key);
            if (vals == null) {
                vals = new Vector<String>();
            }
            vals.add(val);
            map.put(key, vals);
        }
        return map;
    }

    protected String[] getResponseHeaders(String headerName) {
        List values = new LinkedList();
        for (String key : this.headers.keySet()) {
            if (key == null || !key.equalsIgnoreCase(headerName)) continue;
            values = (List)this.headers.get(key);
        }
        String[] arr = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arr[i] = (String)values.get(i);
        }
        return arr;
    }

    protected String getResponseHeader(String headerName) {
        String[] arr = this.getResponseHeaders(headerName);
        if (arr.length > 0) {
            return this.getResponseHeaders(headerName)[0];
        }
        return null;
    }

    public Proxy setProxy(String proxyHost, int proxyPort) {
        InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
        this.HttpProxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        return this.HttpProxy;
    }

    public Proxy setProxy(String httpProxy) {
        if (httpProxy != null && httpProxy.length() > 0) {
            String[] arr = httpProxy.split(":");
            String httpHost = arr[0];
            int httpPort = 80;
            if (arr.length > 0) {
                httpPort = Integer.valueOf(arr[1]);
            }
            return this.setProxy(httpHost, httpPort);
        }
        return null;
    }

    public void setProxy(Proxy httpProxy) {
        this.HttpProxy = httpProxy;
    }

    public boolean isProxyAvailable(String proxyHost, int proxyPort) {
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            System.out.println("Name: " + address.getHostName());
            System.out.println("Addr: " + address.getHostAddress());
            System.out.println("Reach: " + address.isReachable(3000));
            return true;
        }
        catch (UnknownHostException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalHost(String host) {
        return (host = host.toLowerCase()).equals("localhost") || host.equals("127.0.0.1");
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        Map<String, List<String>> requestHeaders = this.getRequestHeaders();
        if (requestHeaders != null) {
            for (String key : requestHeaders.keySet()) {
                if (key != null) {
                    List<String> list = requestHeaders.get(key);
                    for (int i = 0; i < list.size(); ++i) {
                        String value = list.get(i).toString();
                        out.append(key + ": " + value + "\r\n");
                    }
                    continue;
                }
                out.append(requestHeaders.get(key) + "\r\n");
            }
        }
        out.append("\r\n");
        return out.toString();
    }

    private class RequestProperty {
        private String key;
        private String value;

        public RequestProperty(String key, String value) {
            this.key = key;
            this.value = value;
            Request.this.RequestProperties.add(this);
        }
    }
}

