/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javaxt.io.DirectorySearch;
import javaxt.io.File;
import javaxt.io.FileFilter;
import javaxt.io.FileSystemWatcher;
import javaxt.io.Jar;
import javaxt.io.Shell;
import javaxt.utils.Date;

public class Directory {
    private java.io.File Directory;
    private boolean useCache = false;
    private static List events = new LinkedList();
    private FileSystemWatcher FileSystemWatcher;
    public static final String PathSeparator = System.getProperty("file.separator");
    protected static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Event LastEvent = null;

    public Directory(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.Directory = new java.io.File(Path2);
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public Directory(java.io.File File2) {
        this.Directory = File2;
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public static Directory[] getRootDirectories() {
        java.io.File[] files = java.io.File.listRoots();
        if (files == null) {
            return new Directory[0];
        }
        Directory[] directories = new Directory[files.length];
        for (int i = 0; i < files.length; ++i) {
            directories[i] = new Directory(files[i]);
        }
        return directories;
    }

    public boolean exists() {
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                Shell cmd = new Shell("net view " + path);
                cmd.run();
                List errors = cmd.getErrors();
                errors.remove(null);
                return errors.isEmpty();
            }
        }
        return this.Directory.exists();
    }

    public boolean create() {
        return this.Directory.mkdirs();
    }

    public boolean delete() {
        return this.Directory.delete();
    }

    public String[] copyTo(Directory Destination, boolean Overwrite) {
        int source = this.toString().length();
        String destination = Destination.toString();
        Vector<String> vec = new Vector<String>();
        Directory[] Directories = this.getSubDirectories(true);
        for (int i = 0; i < Directories.length; ++i) {
            new Directory(destination + Directories[i].toString().substring(source)).create();
        }
        File[] Files = this.getFiles(true);
        for (int i = 0; i < Files.length; ++i) {
            String FilePath = Files[i].toString();
            File out = new File(destination + FilePath.substring(source));
            boolean CopiedFile = Files[i].copyTo(out, Overwrite);
            if (CopiedFile) continue;
            vec.add(FilePath);
        }
        Object[] arr = vec.toArray();
        String[] ret = new String[arr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)arr[i];
        }
        return ret;
    }

    public void moveTo(Directory Destination, boolean Overwrite) {
        if (Overwrite) {
            this.Directory.renameTo(Destination.getFile());
        } else if (!Destination.exists()) {
            this.Directory.renameTo(Destination.getFile());
        }
    }

    public void rename(String Name) {
        String path = this.getParentDirectory().getPath() + Name;
        this.Directory.renameTo(new java.io.File(path));
    }

    public String getName() {
        return this.Directory.getName();
    }

    public String getPath() {
        String path = "";
        try {
            path = this.Directory.getCanonicalPath().toString();
        }
        catch (Exception e) {
            path = this.Directory.toString();
        }
        if (path.endsWith(java.io.File.separator)) {
            return path;
        }
        return path + java.io.File.separator;
    }

    public java.util.Date getDate() {
        return new Date(this.Directory.lastModified()).getDate();
    }

    public long getSize() {
        return this.Directory.length();
    }

    public boolean isHidden() {
        return this.Directory.isHidden();
    }

    @Deprecated
    public Directory getDirectory() {
        return this.getParentDirectory();
    }

    public Directory getParentDirectory() {
        if (this.Directory.getParentFile() != null) {
            return new Directory(this.Directory.getParentFile());
        }
        return null;
    }

    @Deprecated
    public java.io.File getFile() {
        return this.Directory;
    }

    public java.io.File toFile() {
        return this.Directory;
    }

    public File[] getFiles(Object filter) {
        if (this.Directory.exists()) {
            FileFilter fileFilter = new FileFilter(filter);
            Object[] files = this.listFiles(fileFilter);
            if (files == null) {
                return new File[0];
            }
            Vector<File> vec = new Vector<File>();
            for (int i = 0; i < files.length; ++i) {
                java.io.File file = null;
                file = files[i] instanceof java.io.File ? (java.io.File)files[i] : new java.io.File(files[i].toString());
                if (!file.exists() || !file.isFile()) continue;
                vec.add(new File(file));
            }
            Collections.sort(vec, new FileComparer());
            File[] arr = new File[vec.size()];
            for (int i = 0; i < files.length; ++i) {
                arr[i] = (File)vec.get(i);
            }
            return arr;
        }
        return new File[0];
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    public File[] getFiles(Object filter, boolean RecursiveSearch) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, filter, true);
                LinkedList files = new LinkedList();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof File)) continue;
                    files.add(item);
                }
                Collections.sort(files, new FileComparer());
                File[] array = new File[files.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (File)files.get(i);
                }
                return array;
            }
            return this.getFiles(filter);
        }
        return new File[0];
    }

    public File[] getFiles(boolean RecursiveSearch) {
        return this.getFiles(null, RecursiveSearch);
    }

    public Directory[] getSubDirectories() {
        if (this.exists()) {
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                public boolean accept(java.io.File file) {
                    return file.isDirectory();
                }
            };
            Object[] files = this.listFiles(new FileFilter(fileFilter));
            if (files == null) {
                return new Directory[0];
            }
            Directory[] dirs = new Directory[files.length];
            for (int i = 0; i < files.length; ++i) {
                dirs[i] = new Directory((java.io.File)files[i]);
            }
            return dirs;
        }
        return new Directory[0];
    }

    public Directory[] getSubDirectories(boolean RecursiveSearch) {
        if (this.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true);
                LinkedList directories = new LinkedList();
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof Directory)) continue;
                    directories.add(item);
                }
                Collections.sort(directories, new FileComparer());
                Directory[] array = new Directory[directories.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = (Directory)directories.get(i);
                }
                return array;
            }
            return this.getSubDirectories();
        }
        return new Directory[0];
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean RecursiveSearch) {
        return this.getChildren(RecursiveSearch, null, true);
    }

    public List getChildren(boolean RecursiveSearch, Object filter) {
        return this.getChildren(RecursiveSearch, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren(boolean RecursiveSearch, Object filter, boolean wait) {
        if (this.exists()) {
            if (RecursiveSearch) {
                LinkedList items = new LinkedList();
                if (!this.useCache) {
                    DirectorySearch.deleteCache();
                    FileFilter fileFilter = new FileFilter(filter);
                    long directoryID = Long.valueOf(Calendar.getInstance().getTimeInMillis() + "" + new Random().nextInt(100000));
                    int numThreads = 20;
                    DirectorySearch search = new DirectorySearch(fileFilter, items, directoryID, numThreads);
                    for (int i = 0; i < numThreads; ++i) {
                        Thread t = new Thread(search);
                        t.setName("DirectorySearch_" + directoryID + "-" + i);
                        t.start();
                    }
                    DirectorySearch.updatePool(this);
                    if (wait) {
                        List status;
                        List list = status = DirectorySearch.getStatus();
                        synchronized (list) {
                            while (status.isEmpty()) {
                                try {
                                    status.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                        }
                        while (items.contains(null)) {
                            items.remove(null);
                        }
                    }
                }
                return items;
            }
            LinkedList<Object> results = new LinkedList<Object>();
            Object[] files = this.listFiles(new FileFilter(filter));
            if (files == null) {
                return results;
            }
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory = false;
                java.io.File file = null;
                if (files[i] instanceof java.io.File) {
                    file = (java.io.File)files[i];
                    isDirectory = file.isDirectory();
                } else {
                    file = new java.io.File(files[i].toString());
                    isDirectory = files[i].toString().replace("\\", "/").endsWith("/");
                }
                if (isDirectory) {
                    results.add(new Directory(file));
                    continue;
                }
                results.add(new File(file));
            }
            Collections.sort(results, new FileComparer());
            return results;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (!wait) {
            list.add(null);
        }
        return list;
    }

    protected Object[] listFiles() {
        return this.listFiles(null);
    }

    protected Object[] listFiles(FileFilter fileFilter) {
        int i;
        java.io.File file;
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                Shell cmd = new Shell("net view " + path);
                cmd.run();
                List errors = cmd.getErrors();
                errors.remove(null);
                if (errors.isEmpty()) {
                    path = path + PathSeparator;
                    Vector<String> output = cmd.getOutput();
                    Vector<String> tmp = new Vector<String>();
                    for (String row : output) {
                        if (row == null || row.trim().length() == 0) continue;
                        tmp.add(row);
                    }
                    output = tmp;
                    tmp = null;
                    Vector<java.io.File> files = new Vector<java.io.File>();
                    int x = 0;
                    int len = -1;
                    for (String row : output) {
                        java.io.File file2;
                        String colHeader;
                        if (row.startsWith("---") && (colHeader = (String)output.get(x - 1)).startsWith("Share name") && colHeader.contains("Type")) {
                            len = colHeader.indexOf("Type");
                        }
                        if (len > 0 && row.length() > len && (file2 = new java.io.File(row = path + row.substring(0, len).trim())).exists()) {
                            if (fileFilter == null) {
                                files.add(new java.io.File(row));
                            } else if (fileFilter.accept(file2)) {
                                files.add(new java.io.File(row));
                            }
                        }
                        if (row.startsWith("The command completed successfully.")) break;
                        ++x;
                    }
                    Object[] arr = new java.io.File[files.size()];
                    for (int i2 = 0; i2 < arr.length; ++i2) {
                        arr[i2] = (java.io.File)files.get(i2);
                    }
                    return arr;
                }
            }
        }
        ArrayList<Object> files = new ArrayList<Object>();
        path = this.getPath();
        String[] list = null;
        if (isWindows) {
            list = this.dir();
            if (list == null) {
                return null;
            }
            for (int i3 = 0; i3 < list.length; ++i3) {
                boolean isDirectory = list[i3].endsWith("\\");
                if (fileFilter == null || isDirectory) {
                    files.add(path + list[i3]);
                    continue;
                }
                if (fileFilter.usesIOFilter()) {
                    file = new java.io.File(path + list[i3]);
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                    continue;
                }
                if (!fileFilter.accept(list[i3])) continue;
                files.add(path + list[i3]);
            }
        } else {
            java.io.File[] fs = this.Directory.listFiles();
            if (fs != null) {
                for (i = 0; i < fs.length; ++i) {
                    file = fs[i];
                    if (fileFilter == null) {
                        files.add(file);
                        continue;
                    }
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                }
            }
        }
        if (files.size() < 1) {
            return null;
        }
        Collections.sort(files, new FileComparer());
        Object[] arr = new Object[files.size()];
        for (i = 0; i < arr.length; ++i) {
            arr[i] = files.get(i);
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ls() {
        String path = this.getPath();
        ArrayList<String> files = new ArrayList<String>();
        String[] params = new String[]{"ls", "-ap", path};
        Shell cmd = new Shell(params);
        List output = cmd.getOutput();
        cmd.run();
        while (true) {
            String line;
            List list = output;
            synchronized (list) {
                while (output.isEmpty()) {
                    try {
                        output.wait();
                    }
                    catch (InterruptedException e) {}
                }
                line = (String)output.remove(0);
            }
            if (line == null) break;
            if ((line = line.trim()).length() <= 0 || line.equals("./") || line.equals("../")) continue;
            files.add(line);
        }
        String[] arr = new String[files.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (String)files.get(i);
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] dir() {
        String path = this.getPath();
        if (path.contains(" ")) {
            path = "\"" + path + "\"";
        }
        ArrayList<String> files = new ArrayList<String>();
        Shell cmd = new Shell("cmd.exe /c dir /OG " + path);
        List output = cmd.getOutput();
        cmd.run();
        boolean parseFiles = false;
        int colWidth = -1;
        while (true) {
            boolean isSymLink;
            boolean isDirectory;
            String type;
            String line;
            List list = output;
            synchronized (list) {
                while (output.isEmpty()) {
                    try {
                        output.wait();
                    }
                    catch (InterruptedException e) {}
                }
                line = (String)output.remove(0);
            }
            if (line == null) break;
            if (line.length() == 0 || line.startsWith(" ")) {
                if (!parseFiles) continue;
                parseFiles = false;
                continue;
            }
            if (!parseFiles) {
                parseFiles = true;
            }
            if (!parseFiles) continue;
            if (colWidth < 0) {
                int offset = 20;
                type = line.substring(offset);
                if (type.trim().startsWith("<")) {
                    offset += type.indexOf(">") + 1;
                    type = type.substring(type.indexOf("<"), type.indexOf(">") + 1);
                } else {
                    type = "";
                }
                isDirectory = type.contains("<DIR>");
                isSymLink = type.contains("<SYMLINK>");
                String name = line.substring(offset);
                while (name.substring(0, 1).equals(" ")) {
                    name = name.substring(1);
                    ++offset;
                }
                colWidth = isDirectory || isSymLink ? offset : (name.contains(" ") ? (this.isNumeric(name.substring(0, name.indexOf(" "))) ? offset + name.indexOf(" ") + 1 : offset) : offset);
            }
            if (colWidth <= 0) continue;
            String name = line.substring(colWidth);
            type = line.substring(20, colWidth);
            isDirectory = type.contains("<DIR>");
            isSymLink = type.contains("<SYMLINK>");
            if (isDirectory) {
                if (name.equals(".") || name.equals("..")) continue;
                files.add(name + PathSeparator);
                continue;
            }
            if (isSymLink) {
                String link = name.substring(name.indexOf("[") + 1, name.indexOf("]"));
                name = name.substring(0, name.indexOf("[")).trim();
                if (new java.io.File(link).isDirectory()) {
                    name = name + PathSeparator;
                }
                files.add(name);
                continue;
            }
            files.add(name);
        }
        String[] arr = new String[files.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (String)files.get(i);
        }
        return arr;
    }

    private boolean isNumeric(String str) {
        try {
            if (str.contains(",")) {
                str = str.replace(",", "");
            }
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void useCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Directory) {
            return this.Directory.equals(((Directory)obj).getFile());
        }
        if (obj instanceof java.io.File) {
            if (((java.io.File)obj).isDirectory()) {
                return this.Directory.equals(obj);
            }
            return false;
        }
        return false;
    }

    private List getEvents(String dll) throws Exception {
        if (this.FileSystemWatcher == null) {
            new Thread(new FileSystemWatcher(this, dll)).start();
            this.FileSystemWatcher = this.FileSystemWatcher;
        }
        return events;
    }

    public List getEvents() throws Exception {
        if (isWindows) {
            Jar jar = new Jar(this);
            Jar.Entry entry = jar.getEntry("javaxt.ntfs", "FileSystemWatcher.dll");
            java.io.File dll = entry.getFile();
            if (dll == null && !(dll = new java.io.File(jar.getFile().getParentFile(), "FileSystemWatcher.dll")).exists()) {
                entry.extractFile(dll);
            }
            return this.getEvents(dll.toString());
        }
        return this.getEvents(null);
    }

    public void stop() {
        if (this.FileSystemWatcher != null) {
            this.FileSystemWatcher.stop();
        }
        DirectorySearch.stop();
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    protected void addEvent(String event) {
        new Event(event);
    }

    protected void addEvent(String action, java.io.File file) {
        new Event(action, file);
    }

    private class FileComparer
    implements Comparator {
        private FileComparer() {
        }

        public final int compare(Object a, Object b) {
            String x = a.toString().toUpperCase();
            String y = b.toString().toUpperCase();
            x = x.replace("\\", "/");
            y = y.replace("\\", "/");
            if (x.endsWith("/") && !y.endsWith("/")) {
                return -1;
            }
            if (!x.endsWith("/") && y.endsWith("/")) {
                return 1;
            }
            return x.compareTo(y);
        }
    }

    public class Event {
        private java.io.File file;
        private java.io.File orgFile;
        private java.util.Date date;
        private String action;
        public static final int DELETE = 0;
        public static final int CREATE = 1;
        public static final int RENAME = 2;
        public static final int MODIFY = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String event) {
            block15: {
                if (event != null) {
                    event = event.trim();
                    try {
                        String date = event.substring(1, event.indexOf("]")).trim();
                        String text = event.substring(event.indexOf("]") + 1).trim();
                        String path = text.substring(text.indexOf(" ")).trim();
                        String action = text.substring(0, text.indexOf(" ")).trim();
                        this.date = this.parseDate(date);
                        this.file = new java.io.File(path);
                        this.action = action;
                        boolean updateEvents = true;
                        if (action.equalsIgnoreCase("modify")) {
                            if (this.file.isDirectory() || !this.file.exists()) {
                                updateEvents = false;
                            } else if (Directory.this.LastEvent != null) {
                                if (Directory.this.LastEvent.getFile().equals(this.file) && Directory.this.LastEvent.getDate().equals(this.date)) {
                                    updateEvents = false;
                                }
                                Directory.this.LastEvent = null;
                            } else {
                                Directory.this.LastEvent = this;
                            }
                        }
                        if (action.equalsIgnoreCase("rename")) {
                            updateEvents = false;
                            Directory.this.LastEvent = this;
                        } else if (action.equalsIgnoreCase("renam2") && Directory.this.LastEvent != null) {
                            this.orgFile = Directory.this.LastEvent.getFile();
                            this.action = "Rename";
                            Directory.this.LastEvent = null;
                        }
                        if (!updateEvents) break block15;
                        List list = events;
                        synchronized (list) {
                            events.add(this);
                            events.notifyAll();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String action, java.io.File file) {
            this.date = new java.util.Date();
            this.action = action;
            this.file = file;
            List list = events;
            synchronized (list) {
                events.add(this);
                events.notifyAll();
            }
        }

        private java.util.Date parseDate(String date) {
            try {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getAction() {
            return this.action;
        }

        public java.io.File getFile() {
            return this.file;
        }

        public java.io.File getOriginalFile() {
            return this.orgFile;
        }

        public final int getEventID() {
            if (this.action.equalsIgnoreCase("create")) {
                return 1;
            }
            if (this.action.equalsIgnoreCase("delete")) {
                return 0;
            }
            if (this.action.equalsIgnoreCase("modify")) {
                return 3;
            }
            if (this.action.equalsIgnoreCase("rename")) {
                return 2;
            }
            return -1;
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public String toString() {
            if (this.action.equalsIgnoreCase("rename")) {
                return "[" + this.date.toString() + "] " + this.action + " " + this.orgFile.getPath() + " To " + this.file.getPath();
            }
            return "[" + this.date.toString() + "] " + this.action + " " + this.file.getPath();
        }

        public boolean equals(Object obj) {
            Event event;
            return obj instanceof Event && (event = (Event)obj).getFile().equals(this.file) && event.getDate().equals(this.date) && event.getAction().equals(this.action);
        }
    }
}

