/*
 * Decompiled with CFR 0.152.
 */
package javaxt.ntfs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;

public class LnkParser {
    private File file;

    public LnkParser(String lnk) {
        this(new javaxt.io.File(lnk));
    }

    public LnkParser(File lnk) {
        this(new javaxt.io.File(lnk));
    }

    public LnkParser(javaxt.io.File lnk) {
        if (!lnk.getExtension().equalsIgnoreCase("lnk") || !lnk.exists()) {
            return;
        }
        try {
            int index;
            byte[] loc;
            int i;
            BufferedInputStream in = new BufferedInputStream(lnk.getInputStream());
            int ch = -1;
            byte[] b = new byte[4];
            ch = in.read(b);
            b = new byte[16];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[24];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[4];
            ch = in.read(b);
            b = new byte[8];
            ch = in.read(b);
            int lenShellItemList = in.read();
            in.read(new byte[lenShellItemList]);
            in.read();
            b = new byte[8];
            in.read(b);
            b = new byte[4];
            in.read(b);
            b = new byte[4];
            in.read(b);
            b = new byte[4];
            in.read(b);
            int offsetBasePathName = in.read();
            if (ch < 0) {
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                ch = in.read();
                --offsetBasePathName;
            }
            int offsetNetworkVolumeInfo = ch;
            for (int i3 = 0; i3 < 4; ++i3) {
                ch = in.read();
                --offsetBasePathName;
            }
            int offLocal = ch;
            if (offLocal < 0) {
                return;
            }
            String BasePathName = null;
            if (offsetBasePathName > 0) {
                for (i = 0; i < offsetBasePathName; ++i) {
                    ch = in.read();
                    --offLocal;
                }
                loc = new byte[256];
                index = 0;
                loc[index++] = (byte)ch;
                while ((ch = in.read()) != 0) {
                    loc[index++] = (byte)ch;
                    --offLocal;
                }
                BasePathName = new String(loc);
                BasePathName = BasePathName.trim();
            }
            for (i = 0; i < offLocal - 1; ++i) {
                ch = in.read();
            }
            loc = new byte[256];
            index = 0;
            loc[index++] = (byte)ch;
            while ((ch = in.read()) != 0) {
                loc[index++] = (byte)ch;
            }
            String local = new String(loc);
            local = local.trim();
            this.file = BasePathName != null ? new File(BasePathName, local) : new File(local);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file.toString();
    }

    private int getBit(byte[] data, int pos) {
        int posByte = pos / 8;
        int posBit = pos % 8;
        byte valByte = data[posByte];
        int valInt = valByte >> 8 - (posBit + 1) & 1;
        return valInt;
    }

    private void parseFlags(byte[] data) {
        block9: for (int i = 0; i < data.length * 8; ++i) {
            int val = this.getBit(data, i);
            switch (i) {
                case 0: {
                    if (val == 1) {
                        System.out.println("The shell item id list is present.");
                        continue block9;
                    }
                    System.out.println("The shell item id list is absent.");
                    continue block9;
                }
                case 1: {
                    if (val == 1) {
                        System.out.println("Points to a file or directory.");
                        continue block9;
                    }
                    System.out.println("Points to something else.");
                    continue block9;
                }
                case 2: {
                    if (val == 1) {
                        System.out.println("Has a description string.");
                        continue block9;
                    }
                    System.out.println("No description string.");
                    continue block9;
                }
                case 3: {
                    if (val == 1) {
                        System.out.println("Has a relative path string.");
                        continue block9;
                    }
                    System.out.println("No relative path.");
                    continue block9;
                }
                case 4: {
                    if (val == 1) {
                        System.out.println("Has a working directory.");
                        continue block9;
                    }
                    System.out.println("No working directory.");
                    continue block9;
                }
                case 5: {
                    if (val == 1) {
                        System.out.println("Has command line arguments.");
                        continue block9;
                    }
                    System.out.println("No command line arguments.");
                    continue block9;
                }
                case 6: {
                    if (val == 1) {
                        System.out.println("Has a custom icon.");
                        continue block9;
                    }
                    System.out.println("Has the default icon.");
                    continue block9;
                }
            }
        }
    }

    private void parseFileAttributes(byte[] data) {
        block15: for (int i = 0; i < data.length * 8; ++i) {
            boolean val = this.getBit(data, i) != 0;
            switch (i) {
                case 0: {
                    System.out.println("Target is read only. " + val);
                    continue block15;
                }
                case 1: {
                    System.out.println("Target is hidden. " + val);
                    continue block15;
                }
                case 2: {
                    System.out.println("Target is a system file. " + val);
                    continue block15;
                }
                case 3: {
                    System.out.println("Target is a volume label. " + val);
                    continue block15;
                }
                case 4: {
                    System.out.println("Target is a directory. " + val);
                    continue block15;
                }
                case 5: {
                    System.out.println("Target has been modified since last backup. " + val);
                    continue block15;
                }
                case 6: {
                    System.out.println("Target is encrypted (NTFS EFS) " + val);
                    continue block15;
                }
                case 7: {
                    System.out.println("Target is Normal? " + val);
                    continue block15;
                }
                case 8: {
                    System.out.println("Target is temporary. " + val);
                    continue block15;
                }
                case 9: {
                    System.out.println("Target is a sparse file. " + val);
                    continue block15;
                }
                case 10: {
                    System.out.println("Target has reparse point data. " + val);
                    continue block15;
                }
                case 11: {
                    System.out.println("Target is compressed. " + val);
                    continue block15;
                }
                case 12: {
                    System.out.println("Target is offline. " + val);
                    continue block15;
                }
            }
        }
    }
}

