/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Vector;
import javaxt.sql.Column;
import javaxt.sql.Connection;
import javaxt.sql.Database;
import javaxt.sql.Driver;
import javaxt.sql.Field;
import javaxt.sql.Parser;
import javaxt.sql.Table;
import javaxt.sql.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recordset {
    private ResultSet rs = null;
    private java.sql.Connection Conn = null;
    private Statement stmt = null;
    private int x;
    private String sqlString = null;
    private Connection Connection = null;
    private Value GeneratedKey;
    public int State = 0;
    public boolean EOF = false;
    private Field[] Fields = null;
    public int MaxRecords = 1000000000;
    public int RecordCount;
    public long QueryResponseTime;
    public long EllapsedTime;
    public long MetadataQueryTime;
    private long startTime;
    private long endTime;
    private boolean isReadOnly = true;
    private Integer fetchSize = null;
    private boolean InsertOnUpdate = false;

    public boolean isOpen() {
        if (this.State != 0) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.rs.getClass().getMethod("isClosed", new Class[0]).invoke((Object)this.rs, null) == false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public ResultSet open(String sql, Connection conn) {
        return this.open(sql, conn, true);
    }

    public ResultSet open(String sqlString, Connection Connection2, boolean ReadOnly) {
        this.rs = null;
        this.stmt = null;
        this.State = 0;
        this.EOF = true;
        this.sqlString = sqlString;
        this.Connection = Connection2;
        this.isReadOnly = ReadOnly;
        try {
            int i;
            block46: {
                this.startTime = Calendar.getInstance().getTimeInMillis();
                this.Conn = Connection2.getConnection();
                if (ReadOnly) {
                    try {
                        if (this.fetchSize != null) {
                            this.Conn.setAutoCommit(false);
                        }
                        this.stmt = Connection2.getDatabase().getDriver().equals("DB2") ? this.Conn.createStatement(1003, 1007) : this.Conn.createStatement(1004, 1007);
                        if (this.fetchSize != null) {
                            this.stmt.setFetchSize(this.fetchSize);
                        }
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.State != 1) {
                        try {
                            if (this.fetchSize != null) {
                                this.Conn.setAutoCommit(false);
                            }
                            this.stmt = this.Conn.createStatement();
                            if (this.fetchSize != null) {
                                this.stmt.setFetchSize(this.fetchSize);
                            }
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                        }
                        catch (Exception e) {
                            System.out.println("ERROR Open RecordSet: " + e.toString());
                        }
                    }
                } else {
                    try {
                        if (Connection2.getDatabase().getDriver().equals("SYBASE")) {
                            if (this.fetchSize != null) {
                                this.Conn.setAutoCommit(false);
                            }
                            this.stmt = this.Conn.createStatement(1003, 1008);
                            if (this.fetchSize != null) {
                                this.stmt.setFetchSize(this.fetchSize);
                            }
                            this.rs = this.stmt.executeQuery(sqlString);
                            this.State = 1;
                            break block46;
                        }
                        if (Connection2.getDatabase().getDriver().equals("DB2")) {
                            try {
                                if (this.fetchSize != null) {
                                    this.Conn.setAutoCommit(false);
                                }
                                this.stmt = this.Conn.createStatement(1005, 1008);
                                if (this.fetchSize != null) {
                                    this.stmt.setFetchSize(this.fetchSize);
                                }
                                this.rs = this.stmt.executeQuery(sqlString);
                                this.State = 1;
                            }
                            catch (Exception e) {
                                this.rs = null;
                            }
                            if (this.rs == null) {
                                try {
                                    if (this.fetchSize != null) {
                                        this.Conn.setAutoCommit(false);
                                    }
                                    this.stmt = this.Conn.createStatement(1003, 1008);
                                    if (this.fetchSize != null) {
                                        this.stmt.setFetchSize(this.fetchSize);
                                    }
                                    this.rs = this.stmt.executeQuery(sqlString);
                                    this.State = 1;
                                }
                                catch (Exception e) {}
                            }
                            break block46;
                        }
                        if (this.fetchSize != null) {
                            this.Conn.setAutoCommit(false);
                        }
                        this.stmt = this.Conn.createStatement(1005, 1008);
                        if (this.fetchSize != null) {
                            this.stmt.setFetchSize(this.fetchSize);
                        }
                        this.rs = this.stmt.executeQuery(sqlString);
                        this.State = 1;
                    }
                    catch (Exception e) {
                        System.out.println("ERROR Open RecordSet (RW): " + e.toString());
                    }
                }
            }
            this.endTime = Calendar.getInstance().getTimeInMillis();
            this.QueryResponseTime = this.endTime - this.startTime;
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int cols = rsmd.getColumnCount();
            this.Fields = new Field[cols];
            for (i = 1; i <= cols; ++i) {
                Field Field2 = new Field();
                Field2.Name = rsmd.getColumnName(i);
                try {
                    Field2.Table = rsmd.getTableName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Schema = rsmd.getSchemaName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Type = rsmd.getColumnTypeName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    Field2.Class = rsmd.getColumnClassName(i);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (Field2.Table != null && Field2.Table.trim().length() == 0) {
                    Field2.Table = null;
                }
                if (Field2.Schema != null && Field2.Schema.trim().length() == 0) {
                    Field2.Schema = null;
                }
                if (Field2.Type != null && Field2.Type.trim().length() == 0) {
                    Field2.Type = null;
                }
                if (Field2.Class != null && Field2.Class.trim().length() == 0) {
                    Field2.Class = null;
                }
                this.Fields[i - 1] = Field2;
            }
            this.x = -1;
            if (this.rs != null) {
                if (this.rs.next()) {
                    this.EOF = false;
                    for (i = 1; i <= cols; ++i) {
                        this.Fields[i - 1].Value = new Value(this.rs.getString(i));
                    }
                    ++this.x;
                }
                long mStart = Calendar.getInstance().getTimeInMillis();
                this.updateFields();
                long mEnd = Calendar.getInstance().getTimeInMillis();
                this.MetadataQueryTime = mEnd - mStart;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR Open RecordSet:");
            e.printStackTrace();
        }
        return this.rs;
    }

    public void close() {
        if (this.State == 1) {
            try {
                this.rs.close();
                this.stmt.close();
            }
            catch (Exception e) {
                System.out.println("ERROR Close Recordset: " + e.toString());
            }
        }
        this.endTime = Calendar.getInstance().getTimeInMillis();
        this.EllapsedTime = this.endTime - this.startTime;
    }

    public Database getDatabase() {
        return this.Connection.getDatabase();
    }

    public void setFetchSize(int fetchSize) {
        if (fetchSize > 0) {
            this.fetchSize = fetchSize;
        }
    }

    public Connection getConnection() {
        return this.Connection;
    }

    public void commit() {
        try {
            this.Conn.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNew() {
        if (this.State == 1) {
            try {
                if (this.Connection.getDatabase().getDriver().equals("DB2")) {
                    for (int i = 0; i < this.Fields.length; ++i) {
                        this.Fields[i].Value = null;
                    }
                } else {
                    this.rs.moveToInsertRow();
                }
                this.InsertOnUpdate = true;
            }
            catch (Exception e) {
                System.out.println("AddNew ERROR: " + e.toString());
            }
        }
    }

    public void update() {
        if (this.State == 1) {
            try {
                int i;
                boolean usePreparedStatement = false;
                if (this.Connection.getDatabase().getDriver().equals("DB2")) {
                    usePreparedStatement = true;
                } else if (this.Connection.getDatabase().getDriver().equals("PostgreSQL")) {
                    for (i = 0; i < this.Fields.length; ++i) {
                        Object value = null;
                        if (this.Fields[i].Value != null) {
                            value = this.Fields[i].Value.toObject();
                        }
                        if (value == null || !value.getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        usePreparedStatement = true;
                        this.Fields[i].Value = new Value(this.getGeometry(value));
                        break;
                    }
                }
                if (!usePreparedStatement) {
                    for (i = 0; i < this.Fields.length; ++i) {
                        String FieldName = this.Fields[i].Name;
                        String FieldType = this.Fields[i].Class;
                        Value FieldValue = this.Fields[i].Value;
                        if (!this.Fields[i].RequiresUpdate) continue;
                        if (FieldType.indexOf("String") >= 0) {
                            this.rs.updateString(FieldName, FieldValue.toString());
                        }
                        if (FieldType.indexOf("Integer") >= 0) {
                            this.rs.updateInt(FieldName, (int)FieldValue.toInteger());
                        }
                        if (FieldType.indexOf("Short") >= 0) {
                            this.rs.updateShort(FieldName, (short)FieldValue.toShort());
                        }
                        if (FieldType.indexOf("Long") >= 0) {
                            this.rs.updateLong(FieldName, (long)FieldValue.toLong());
                        }
                        if (FieldType.indexOf("Double") >= 0) {
                            this.rs.updateDouble(FieldName, (double)FieldValue.toDouble());
                        }
                        if (FieldType.indexOf("Timestamp") >= 0) {
                            this.rs.updateTimestamp(FieldName, FieldValue.toTimeStamp());
                        }
                        if (FieldType.indexOf("Date") >= 0) {
                            this.rs.updateDate(FieldName, new Date(FieldValue.toDate().getTime()));
                        }
                        if (FieldType.indexOf("Bool") >= 0) {
                            this.rs.updateBoolean(FieldName, (boolean)FieldValue.toBoolean());
                        }
                        if (FieldValue == null || !FieldValue.toObject().getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) continue;
                        this.rs.updateObject(FieldName, (Object)this.getGeometry(FieldValue));
                    }
                }
                if (this.InsertOnUpdate) {
                    int i2;
                    Vector<String> cols = new Vector<String>();
                    for (int i3 = 0; i3 < this.Fields.length; ++i3) {
                        if (!this.Fields[i3].RequiresUpdate) continue;
                        cols.add(this.Fields[i3].getName());
                    }
                    int numUpdates = cols.size();
                    StringBuffer sql = new StringBuffer();
                    sql.append("INSERT INTO " + this.Fields[0].getTable() + " (");
                    for (i2 = 0; i2 < numUpdates; ++i2) {
                        sql.append((String)cols.get(i2));
                        if (numUpdates <= 1 || i2 >= numUpdates - 1) continue;
                        sql.append(",");
                    }
                    sql.append(") VALUES (");
                    for (i2 = 0; i2 < numUpdates; ++i2) {
                        sql.append("?");
                        if (numUpdates <= 1 || i2 >= numUpdates - 1) continue;
                        sql.append(",");
                    }
                    sql.append(")");
                    PreparedStatement stmt = this.Conn.prepareStatement(sql.toString(), 1);
                    int id = 1;
                    for (int i4 = 0; i4 < this.Fields.length; ++i4) {
                        String FieldType = this.Fields[i4].Class;
                        Value FieldValue = this.Fields[i4].Value;
                        if (!this.Fields[i4].RequiresUpdate) continue;
                        if (FieldType.indexOf("String") >= 0) {
                            stmt.setString(id, FieldValue.toString());
                        }
                        if (FieldType.indexOf("Integer") >= 0) {
                            stmt.setInt(id, FieldValue.toInteger());
                        }
                        if (FieldType.indexOf("Short") >= 0) {
                            stmt.setShort(id, FieldValue.toShort());
                        }
                        if (FieldType.indexOf("Long") >= 0) {
                            stmt.setLong(id, FieldValue.toLong());
                        }
                        if (FieldType.indexOf("Double") >= 0) {
                            stmt.setDouble(id, FieldValue.toDouble());
                        }
                        if (FieldType.indexOf("Timestamp") >= 0) {
                            stmt.setTimestamp(id, FieldValue.toTimeStamp());
                        }
                        if (FieldType.indexOf("Date") >= 0) {
                            stmt.setDate(id, new Date(FieldValue.toDate().getTime()));
                        }
                        if (FieldType.indexOf("Bool") >= 0) {
                            stmt.setBoolean(id, FieldValue.toBoolean());
                        }
                        if (FieldValue != null && FieldValue.toObject().getClass().getPackage().getName().startsWith("javaxt.geospatial.geometry")) {
                            stmt.setObject(id, this.getGeometry(FieldValue));
                        }
                        ++id;
                    }
                    stmt.executeUpdate();
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    if (generatedKeys.next()) {
                        this.GeneratedKey = new Value(generatedKeys.getString(1));
                    }
                    this.InsertOnUpdate = false;
                } else {
                    this.rs.updateRow();
                }
            }
            catch (Exception e) {
                System.out.println("Update ERROR: " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public Value getGeneratedKey() {
        return this.GeneratedKey;
    }

    public Field getField(String FieldName) {
        if (this.Fields != null) {
            String[] arr = FieldName.split("\\.");
            FieldName = arr[arr.length - 1];
            for (int i = 0; i < this.Fields.length; ++i) {
                if (!(arr.length == 3 ? this.Fields[i].Name.equalsIgnoreCase(FieldName) && this.Fields[i].Table.equalsIgnoreCase(arr[1]) && this.Fields[i].Schema.equalsIgnoreCase(arr[0]) : (arr.length == 2 ? this.Fields[i].Name.equalsIgnoreCase(FieldName) && this.Fields[i].Table.equalsIgnoreCase(arr[0]) : this.Fields[i].Name.equalsIgnoreCase(FieldName)))) continue;
                return this.Fields[i];
            }
        }
        return null;
    }

    public Field getField(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i];
        }
        return null;
    }

    public Value getValue(String FieldName) {
        Field field = this.getField(FieldName);
        if (field != null) {
            return field.getValue();
        }
        return new Value(null);
    }

    public Value getValue(int i) {
        if (this.Fields != null && i < this.Fields.length) {
            return this.Fields[i].Value;
        }
        return new Value(null);
    }

    public void setValue(String FieldName, Object FieldValue) {
        if (this.State == 1) {
            for (int i = 0; i < this.Fields.length; ++i) {
                String name = this.Fields[i].Name;
                if (!name.equalsIgnoreCase(FieldName)) continue;
                this.Fields[i].Value = new Value(FieldValue);
                this.Fields[i].RequiresUpdate = true;
                break;
            }
        }
    }

    public void setValue(String FieldName, boolean FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, long FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, int FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public void setValue(String FieldName, double FieldValue) {
        this.setValue(FieldName, "" + FieldValue + "");
    }

    public boolean moveNext() {
        if (this.EOF) {
            return false;
        }
        if (this.x >= this.MaxRecords - 1) {
            this.EOF = true;
            return false;
        }
        try {
            if (this.rs.next()) {
                for (int i = 1; i <= this.Fields.length; ++i) {
                    Field Field2 = this.Fields[i - 1];
                    Field2.Value = new Value(this.rs.getString(i));
                }
                ++this.x;
                return true;
            }
            this.EOF = true;
            return false;
        }
        catch (Exception e) {
            System.out.println("ERROR MoveNext: " + e.toString());
            return false;
        }
    }

    public void move(int numRecords) {
        boolean tryAgain = false;
        try {
            this.rs.absolute(numRecords);
        }
        catch (Exception e) {
            tryAgain = true;
            System.err.println("ERROR Move: " + e.toString());
        }
        try {
            if (tryAgain) {
                int rowPosition = this.rs.getRow();
                while (this.rs.getRow() < numRecords + rowPosition) {
                    this.rs.next();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            for (int i = 1; i <= this.Fields.length; ++i) {
                Field Field2 = this.Fields[i - 1];
                Field2.Value = new Value(this.rs.getString(i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateFields() {
        if (this.Fields == null) {
            return;
        }
        Vector<Table> tables = null;
        block0: for (int i = 0; i < this.Fields.length; ++i) {
            if (this.Fields[i].Table != null && this.Fields[i].Schema != null) continue;
            if (tables == null) {
                tables = new Vector<Table>();
                String[] selectedTables = new Parser(this.sqlString).getTables();
                for (Table table : this.Connection.getDatabase().getTables()) {
                    for (String selectedTable : selectedTables) {
                        if (selectedTable.contains(".")) {
                            selectedTable = selectedTable.substring(selectedTable.indexOf("."));
                        }
                        if (!selectedTable.equalsIgnoreCase(table.getName())) continue;
                        tables.add(table);
                    }
                }
            }
            if (this.Fields[i].Table == null) {
                Column[] columns = this.getColumns(this.Fields[i], tables);
                if (columns == null) continue;
                Column column = columns[0];
                this.Fields[i].Table = column.getTable().getName();
                this.Fields[i].Schema = column.getTable().getSchema();
                continue;
            }
            for (Table table : tables) {
                if (!table.getName().equalsIgnoreCase(this.Fields[i].Table)) continue;
                this.Fields[i].Schema = table.getSchema();
                continue block0;
            }
        }
    }

    private Column[] getColumns(Field field, Vector<Table> tables) {
        Vector<Column> matches = new Vector<Column>();
        for (Table table : tables) {
            for (Column column : table.getColumns()) {
                if (!column.getName().equalsIgnoreCase(field.Name)) continue;
                matches.add(column);
            }
        }
        if (matches.size() == 0) {
            return null;
        }
        if (matches.size() == 1) {
            return new Column[]{(Column)matches.get(0)};
        }
        if (matches.size() > 1) {
            Vector<Column> columns = new Vector<Column>();
            for (int i = 0; i < matches.size(); ++i) {
                Column column = (Column)matches.get(i);
                if (!column.getType().equalsIgnoreCase(field.Type)) continue;
                columns.add(column);
            }
            if (columns.size() == 0) {
                return null;
            }
            Column[] arr = new Column[columns.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (Column)columns.get(i);
            }
            return arr;
        }
        return null;
    }

    public int getRecordCount() {
        try {
            int currRow = this.rs.getRow();
            this.rs.last();
            int size = this.rs.getRow();
            this.rs.absolute(currRow);
            return size;
        }
        catch (Exception e) {
            String sql = new Parser(this.sqlString).setSelect("count(*)");
            Recordset rs = new Recordset();
            rs.open(sql, this.Connection);
            Integer numRecords = rs.getValue(0).toInteger();
            rs.close();
            if (numRecords != null) {
                return numRecords;
            }
            return -1;
        }
    }

    public boolean hasNext() {
        return !this.EOF;
    }

    public Field[] getFields() {
        return this.Fields;
    }

    private String getGeometry(Object FieldValue) {
        String geometryType = FieldValue.getClass().getCanonicalName().toString();
        geometryType = geometryType.substring(geometryType.lastIndexOf(".") + 1).trim().toUpperCase();
        Driver driver = this.Connection.getDatabase().getDriver();
        if (driver.equals("PostgreSQL")) {
            return "ST_GeomFromText('" + FieldValue.toString() + "', 4326)";
        }
        if (driver.equals(Database.SQLServer)) {
            return "STGeomFromText('" + FieldValue.toString() + "', 4326)";
        }
        if (this.Connection.getDatabase().getDriver().equals("DB2")) {
            if (geometryType.equals("LINE")) {
                String line = FieldValue.toString().toUpperCase().replace("LINESTRING", "LINE");
                return "db2GSE.ST_LINE('" + line + "', 2000000000)";
            }
            return "db2GSE.ST_" + geometryType + "('" + FieldValue.toString() + "', 2000000000)";
        }
        return null;
    }
}

