/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    private HashMap<String, List<String>> parameters = new HashMap();
    private String protocol;
    private String host;
    private Integer port;
    private String path;

    public URL(java.net.URL url) {
        this(url.toString());
    }

    public URL(String url) {
        if (url.contains("://")) {
            this.protocol = url.substring(0, url.indexOf("://"));
            url = url.substring(url.indexOf("://") + 3);
        } else if (url.startsWith("jdbc")) {
            this.protocol = url.substring(0, url.indexOf(";"));
            url = url.substring(url.indexOf(";") + 1);
        }
        if (url.contains(";")) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.contains("?")) {
            String query = url.substring(url.indexOf("?") + 1);
            url = url.substring(0, url.indexOf("?"));
            this.parseQueryString(query);
        }
        if (url.contains("/")) {
            this.path = url.substring(url.indexOf("/"));
            url = url.substring(0, url.indexOf("/"));
        }
        if (url.contains(":")) {
            try {
                this.port = Integer.valueOf(url.substring(url.indexOf(":") + 1));
                url = url.substring(0, url.indexOf(":"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.host = url;
    }

    public boolean exists() {
        try {
            URLConnection conn = new java.net.URL(this.toString()).openConnection();
            conn.setConnectTimeout(5000);
            conn.getInputStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void parseQueryString(String query) {
        if (query == null) {
            return;
        }
        try {
            new URLDecoder();
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (Exception e) {
            String[] find = new String[]{"%2C", "%2F", "%3A"};
            String[] replace = new String[]{",", "/", ":"};
            for (int i = 0; i < find.length; ++i) {
                query = query.replace(find[i], replace[i]);
            }
        }
        if (query.startsWith("&")) {
            query = query.substring(1);
        }
        query = query + "&";
        String word = "";
        String c = "";
        for (int i = 0; i < query.length(); ++i) {
            c = query.substring(i, i + 1);
            if (!c.equals("&")) {
                word = word + c;
                continue;
            }
            int x = word.indexOf("=");
            if (x >= 0) {
                String key = word.substring(0, x).toLowerCase();
                String value = word.substring(x + 1);
                List<String> values = this.parameters.get(key);
                if (values == null) {
                    values = new LinkedList<String>();
                }
                values.add(value);
                this.parameters.put(key, values);
            }
            word = "";
        }
    }

    public void setParameter(String key, String value, boolean append) {
        key = key.toLowerCase();
        if (append) {
            List<String> values = this.parameters.get(key);
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                if (!it.next().equalsIgnoreCase(value)) continue;
                append = false;
                break;
            }
            if (append) {
                values.add(value);
                this.parameters.put(key, values);
            }
        } else if (value != null) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.parameters.put(key, values);
        }
    }

    public void setParameter(String key, String value) {
        this.setParameter(key, value, false);
    }

    public String getParameter(String key) {
        StringBuffer str = new StringBuffer();
        List<String> values = this.parameters.get(key.toLowerCase());
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public String getParameter(String[] keys) {
        StringBuffer str = new StringBuffer();
        for (String key : keys) {
            List<String> values = this.parameters.get(key.toLowerCase());
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i) + ",");
            }
        }
        String value = str.toString();
        if (value.endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public HashMap<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String removeParameter(String key) {
        StringBuffer str = new StringBuffer();
        List<String> values = this.parameters.remove(key.toLowerCase());
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        StringBuffer str = new StringBuffer();
        HashSet<String> keys = this.getKeys();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = this.getParameter(key);
            str.append(key + "=" + value);
            if (!it.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void setQueryString(String query) {
        if (query != null) {
            if ((query = query.trim()).startsWith("?")) {
                query = query.substring(1).trim();
            }
            if (query.length() > 0) {
                this.parseQueryString(query);
            }
        }
    }

    public HashSet<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        String host = this.host;
        if (this.port != null && this.port > 0) {
            host = host + ":" + this.port;
        }
        String path = "";
        if (this.getPath() != null) {
            path = this.getPath();
        }
        String query = "";
        if (this.getQueryString() != null) {
            query = "?" + this.getQueryString();
        }
        return this.protocol + "://" + host + path + query;
    }
}

