/*
 * Decompiled with CFR 0.152.
 */
package javaxt.webservices;

import java.io.File;
import java.net.URL;
import javaxt.http.Request;
import javaxt.http.Response;
import javaxt.webservices.wsdl.Method;
import javaxt.webservices.wsdl.Parameter;
import javaxt.webservices.wsdl.Parameters;
import javaxt.webservices.wsdl.Parser;
import javaxt.webservices.wsdl.Service;
import javaxt.xml.DOM;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Soap {
    private Object wsdl;
    private String HttpProxy;

    public Soap(File wsdl) {
        this.wsdl = wsdl;
    }

    public Soap(URL wsdl) {
        this.wsdl = wsdl;
    }

    public Soap(Parser wsdl) {
        this.wsdl = wsdl;
    }

    public void setProxy(String proxyServer) {
        this.HttpProxy = proxyServer;
    }

    private Parser getWSDL() {
        if (this.wsdl instanceof URL) {
            Request request = new Request((URL)this.wsdl);
            if (this.HttpProxy != null) {
                request.setProxy(this.HttpProxy);
            }
            Document xml = request.getResponse().getXML();
            this.wsdl = new Parser(xml);
        } else if (this.wsdl instanceof File) {
            Document xml = new javaxt.io.File((File)this.wsdl).getXML();
            this.wsdl = new Parser(xml);
        }
        return (Parser)this.wsdl;
    }

    public SoapResponse execute(Service service, Method method, Parameters parameters) {
        SoapRequest request = new SoapRequest(service, method, parameters);
        return request.getResponse(this.HttpProxy);
    }

    public SoapResponse execute(String method, String[] parameters) {
        Parser wsdl = this.getWSDL();
        Service service = wsdl.getService(0);
        Method Method2 = wsdl.getMethod(method);
        SoapRequest request = new SoapRequest(service, Method2, parameters);
        return request.getResponse(this.HttpProxy);
    }

    public class SoapResponse {
        Response response;
        private String resultsNode;

        public SoapResponse(Request request, String resultsNode) {
            this.response = request.getResponse();
            this.resultsNode = resultsNode;
        }

        public String getText() throws Exception {
            if (this.response.getStatus() == 200) {
                String ServiceResponse = this.response.getText();
                if (ServiceResponse != null) {
                    if (ServiceResponse.substring(0, 1).equals("<")) {
                        try {
                            Document XMLDoc = DOM.createDocument(ServiceResponse);
                            NodeList Response2 = XMLDoc.getElementsByTagName(this.resultsNode);
                            if (Response2 != null) {
                                if (Response2.getLength() == 0) {
                                    this.resultsNode = this.getResultsNode(ServiceResponse, this.resultsNode);
                                    Response2 = XMLDoc.getElementsByTagName(this.resultsNode);
                                }
                                return DOM.getNodeValue(Response2.item(0));
                            }
                            throw new Exception("Failed to parse SOAP Response. Could not find the " + this.resultsNode + " node. " + "Possibly due to a service exception:" + "\r\n" + ServiceResponse);
                        }
                        catch (Exception e) {
                            throw new Exception("Failed to parse SOAP Response");
                        }
                    }
                    throw new Exception("Invalid SOAP Response. Response does not appear to be xml:\r\n" + ServiceResponse);
                }
                throw new Exception("Invalid SOAP Response.");
            }
            throw new Exception("Invalid SOAP Response: " + this.response.getMessage());
        }

        private String getResultsNode(String ServiceResponse, String resultsNode) {
            resultsNode = ServiceResponse.substring(0, ServiceResponse.toLowerCase().indexOf(resultsNode.toLowerCase()) + resultsNode.length());
            resultsNode = resultsNode.substring(resultsNode.lastIndexOf("<") + 1);
            return resultsNode;
        }
    }

    private class SoapRequest {
        private Request request;
        private String resultsNode;
        private String body;

        private SoapRequest(Service service, Method method, Object parameters) {
            this.resultsNode = method.getResultsNodeName();
            this.request = new Request(service.getURL());
            this.request.addHeader("Content-Type", "text/xml; charset=utf-8");
            this.request.addHeader("Accept", "text/html, text/xml, text/plain");
            String action = method.getSoapAction();
            if (action.length() > 0) {
                this.request.addHeader("SOAPAction", action);
            }
            StringBuffer body = new StringBuffer();
            body.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body>");
            body.append("<" + method.getName() + " xmlns=\"" + service.getNameSpace() + "\">");
            if (parameters instanceof Parameters) {
                body.append(parameters.toString());
            } else if (parameters instanceof String) {
                body.append(parameters);
            } else if (parameters instanceof String[]) {
                String[] values = (String[])parameters;
                Parameter[] params = method.getParameters().getArray();
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        String parameterName = params[i].getName();
                        String parameterValue = values[i];
                        body.append("<" + parameterName + "><![CDATA[" + parameterValue + "]]></" + parameterName + ">");
                    }
                }
            }
            body.append("</" + method.getName() + ">");
            body.append("</soap:Body></soap:Envelope>");
            this.body = body.toString();
        }

        public SoapResponse getResponse(String proxyServer) {
            if (proxyServer != null) {
                this.request.setProxy(proxyServer);
            }
            this.request.write(this.body);
            return new SoapResponse(this.request, this.resultsNode);
        }
    }
}

