/*
 * Decompiled with CFR 0.152.
 */
package javaxt.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javaxt.http.Request;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM {
    private static StringBuffer xmlTree;

    private DOM() {
    }

    public static Document createDocument(URL url) {
        return new Request(url).getResponse().getXML();
    }

    public static Document createDocument(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return DOM.createDocument(new FileInputStream(file));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Document createDocument(String xml) {
        xml = xml.trim();
        String xmlHeader = xml.substring(xml.indexOf("<?"), xml.indexOf("?>"));
        String encoding = "UTF-8";
        if (xmlHeader.contains(" encoding")) {
            encoding = xmlHeader.substring(xmlHeader.indexOf(" encoding") + " encoding".length());
            encoding = encoding.substring(encoding.indexOf("=") + 1);
            while (encoding.substring(0, 1).equals(" ")) {
                encoding = encoding.substring(1);
            }
            if (encoding.substring(0, 1).equals("\"")) {
                encoding = encoding.substring(1);
                encoding = encoding.substring(0, encoding.indexOf("\"")).trim();
            } else {
                encoding = encoding.substring(0, encoding.indexOf(" ")).trim();
            }
        }
        return DOM.createDocument(xml, encoding);
    }

    public static Document createDocument(String xml, String charsetName) {
        xml = xml.trim();
        System.out.println(charsetName);
        try {
            return DOM.createDocument(new ByteArrayInputStream(xml.getBytes(charsetName)));
        }
        catch (Exception e) {
            return DOM.createDocument(new ByteArrayInputStream(xml.getBytes()));
        }
    }

    public static Document createDocument(InputStream is) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(is);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Node getOuterNode(Document doc) {
        NodeList OuterNodes = doc.getChildNodes();
        for (int i = 0; i < OuterNodes.getLength(); ++i) {
            if (OuterNodes.item(i).getNodeType() != 1) continue;
            return OuterNodes.item(i);
        }
        return null;
    }

    public static String getText(Document document) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(bas);
            transformer.transform(source, result);
            return bas.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getText(NodeList nodeList) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String NodeName = node.getNodeName();
            String Attributes = DOM.getAttributes(node);
            ret.append("<" + NodeName + Attributes + ">");
            ret.append(DOM.getNodeValue(node));
            ret.append("</" + NodeName + ">");
        }
        return ret.toString();
    }

    private static String getAttributes(Node node) {
        if (node == null) {
            return "";
        }
        NamedNodeMap attr = node.getAttributes();
        String Attributes = "";
        if (attr != null) {
            for (int j = 0; j < attr.getLength(); ++j) {
                String name = attr.item(j).getNodeName();
                String value = attr.item(j).getTextContent();
                Attributes = Attributes + " " + name + "=\"" + value + "\"";
            }
        }
        return Attributes;
    }

    public static boolean hasChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public static String getAttributeValue(NamedNodeMap attrCollection, String attrName) {
        if (attrCollection != null) {
            for (int i = 0; i < attrCollection.getLength(); ++i) {
                Node node = attrCollection.item(i);
                if (!node.getNodeName().equalsIgnoreCase(attrName)) continue;
                return node.getNodeValue();
            }
        }
        return "";
    }

    public static String getAttributeValue(Node Node2, String AttributeName) {
        return DOM.getAttributeValue(Node2.getAttributes(), AttributeName);
    }

    public static String getNodeValue(Node node) {
        String nodeValue = "";
        if (DOM.hasChildren(node)) {
            xmlTree = new StringBuffer();
            DOM.traverse(node);
            nodeValue = xmlTree.toString();
            xmlTree = null;
        } else {
            nodeValue = node.getTextContent();
        }
        if (nodeValue == null) {
            return "";
        }
        return nodeValue;
    }

    private static void traverse(Node tree) {
        if (tree.getNodeType() == 1) {
            String Attributes = DOM.getAttributes(tree);
            xmlTree.append("<" + tree.getNodeName() + Attributes + ">");
            if (DOM.hasChildren(tree)) {
                NodeList xmlNodeList = tree.getChildNodes();
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    DOM.traverse(xmlNodeList.item(i));
                }
            } else {
                xmlTree.append(tree.getTextContent());
            }
            xmlTree.append("</" + tree.getNodeName() + ">");
        }
    }

    public static NamedNodeMap getDocumentAttributes(Document doc) {
        NodeList Definitions = doc.getChildNodes();
        for (int i = 0; i < Definitions.getLength(); ++i) {
            if (Definitions.item(i).getNodeType() != 1) continue;
            return Definitions.item(i).getAttributes();
        }
        return null;
    }

    public static String getTargetNameSpace(Document doc) {
        NamedNodeMap attr = DOM.getDocumentAttributes(doc);
        return DOM.getAttributeValue(attr, "targetNamespace");
    }

    public static HashMap getNameSpaces(Document doc) {
        HashMap<String, String> Map2 = new HashMap<String, String>();
        NamedNodeMap attr = DOM.getDocumentAttributes(doc);
        if (attr != null) {
            for (int j = 0; j < attr.getLength(); ++j) {
                String name = attr.item(j).getNodeName();
                String value = attr.item(j).getTextContent();
                if (!name.startsWith("xmlns")) continue;
                Map2.put(name, value);
            }
        }
        return Map2;
    }

    public String replaceIllegalChars(String str) {
        str = this.replaceAmpersand(str);
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("\u00c7", "C");
        str = str.replace("\u00e7", "c");
        str = str.replace("\u00d1", "N");
        str = str.replace("\u00f1", "n");
        str = str.replace("\u00de", "");
        str = str.replace("\u00fe", "");
        str = str.replace("\u00dd", "Y");
        str = str.replace("\u00fd", "y");
        str = str.replace("\u00ff", "y");
        str = str.replace("\u00df", "B");
        str = str.replace("\u00c6", "AE");
        str = str.replace("\u00c1", "A");
        str = str.replace("\u00c2", "A");
        str = str.replace("\u00c0", "A");
        str = str.replace("\u00c5", "A");
        str = str.replace("\u00c3", "A");
        str = str.replace("\u00c4", "A");
        str = str.replace("\u00e6", "ae");
        str = str.replace("\u00e1", "a");
        str = str.replace("\u00e2", "a");
        str = str.replace("\u00e0", "a");
        str = str.replace("\u00e5", "a");
        str = str.replace("\u00e3", "a");
        str = str.replace("\u00e4", "a");
        str = str.replace("\u00d0", "D");
        str = str.replace("\u00c9", "E");
        str = str.replace("\u00ca", "E");
        str = str.replace("\u00c8", "E");
        str = str.replace("\u00cb", "E");
        str = str.replace("\u00f0", "o");
        str = str.replace("\u00e9", "e");
        str = str.replace("\u00ea", "e");
        str = str.replace("\u00e8", "e");
        str = str.replace("\u00eb", "e");
        str = str.replace("\u00cd", "I");
        str = str.replace("\u00ce", "I");
        str = str.replace("\u00cc", "I");
        str = str.replace("\u00cf", "I");
        str = str.replace("\u00ed", "i");
        str = str.replace("\u00ee", "i");
        str = str.replace("\u00ec", "i");
        str = str.replace("\u00ef", "i");
        str = str.replace("\u00d3", "O");
        str = str.replace("\u00d4", "O");
        str = str.replace("\u00d2", "O");
        str = str.replace("\u00d8", "O");
        str = str.replace("\u00d5", "O");
        str = str.replace("\u00d6", "O");
        str = str.replace("\u00f3", "o");
        str = str.replace("\u00f4", "o");
        str = str.replace("\u00f2", "o");
        str = str.replace("\u00f8", "o");
        str = str.replace("\u00f5", "o");
        str = str.replace("\u00f6", "o");
        str = str.replace("\u00da", "U");
        str = str.replace("\u00db", "U");
        str = str.replace("\u00d9", "U");
        str = str.replace("\u00dc", "U");
        str = str.replace("\u00fa", "u");
        str = str.replace("\u00fb", "u");
        str = str.replace("\u00f9", "u");
        str = str.replace("\u00fc", "u");
        str = str.replace("\u00ae", "\u00ae");
        str = str.replace("\u00b1", "+/-");
        str = str.replace("\u00b5", "microns");
        str = str.replace("\u00b6", "(P)");
        str = str.replace("\u00b7", "");
        str = str.replace("\u00a2", "cents");
        str = str.replace("\u00a3", "pounds");
        str = str.replace("\u00a5", "yen");
        str = str.replace("\u00bc", "1/4");
        str = str.replace("\u00bd", "1/2");
        str = str.replace("\u00be", "3/4");
        str = str.replace("\u00b9", "(1)");
        str = str.replace("\u00b2", "(2)");
        str = str.replace("\u00b3", "(3)");
        str = str.replace("\u00bf", "?");
        str = str.replace("\u00b0", "deg");
        str = str.replace("\u00a6", "");
        str = str.replace("\u00a7", "");
        str = str.replace("\u00ab", "");
        str = str.replace("\u00bb", "");
        return str;
    }

    private String replaceAmpersand(String strText) {
        if (strText.equals("")) {
            return strText;
        }
        String[] arrText = strText.split("&");
        strText = "";
        for (int i = 0; i < arrText.length; ++i) {
            if (i == this.UBound(arrText)) continue;
            String nextSeg = arrText[i + 1];
            boolean foundColon = false;
            for (int j = 1; j < nextSeg.length() - 1; ++j) {
                String c = nextSeg.substring(j, j + 1);
                if (c.equals(" ") || c.equals("<")) {
                    foundColon = false;
                    break;
                }
                if (!c.equals(";")) continue;
                foundColon = true;
                break;
            }
            strText = foundColon ? strText + arrText[i] + "&" : strText + arrText[i] + "&amp;";
        }
        strText = strText + arrText[this.UBound(arrText)];
        return strText;
    }

    private int UBound(String[] arr) {
        return arr.length - 1;
    }
}

