/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import javaxt.http.Response;

public class Request {
    private URLConnection conn = null;
    private Proxy HttpProxy;
    private URL url;
    private boolean useCache = false;
    private List RequestProperties = new LinkedList();

    public Request(String url) {
        this(url, null);
    }

    public Request(String url, String httpProxy) {
        try {
            this.url = new URL(url);
            this.setProxy(httpProxy);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request(URL url) {
        this(url, null);
    }

    public Request(URL url, String httpProxy) {
        this.url = url;
        this.setProxy(httpProxy);
    }

    public URL getURL() {
        return this.url;
    }

    public Response getResponse() {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        return new Response(this.conn);
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void addHeader(String key, String value) {
        new RequestProperty(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStream output = null;
        try {
            output = this.conn.getOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = payload.read(buf)) != -1) {
                output.write(buf, 0, i);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String payload) {
        if (this.conn == null) {
            this.conn = this.getConnection();
        }
        this.conn.setDoOutput(true);
        OutputStreamWriter output = null;
        try {
            output = new OutputStreamWriter(this.conn.getOutputStream());
            output.write(payload);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private URLConnection getConnection() {
        try {
            URLConnection conn = this.HttpProxy == null || this.isLocalHost(this.url.getHost()) ? this.url.openConnection() : this.url.openConnection(this.HttpProxy);
            conn.setUseCaches(this.useCache);
            for (int i = 0; i < this.RequestProperties.size(); ++i) {
                RequestProperty property = (RequestProperty)this.RequestProperties.get(i);
                conn.setRequestProperty(property.key, property.value);
            }
            return conn;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Proxy setProxy(String proxyHost, int proxyPort) {
        InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
        this.HttpProxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
        return this.HttpProxy;
    }

    public Proxy setProxy(String httpProxy) {
        if (httpProxy != null && httpProxy.length() > 0) {
            String[] arr = httpProxy.split(":");
            String httpHost = arr[0];
            int httpPort = 80;
            if (arr.length > 0) {
                httpPort = Integer.valueOf(arr[1]);
            }
            return this.setProxy(httpHost, httpPort);
        }
        return null;
    }

    public void setProxy(Proxy httpProxy) {
        this.HttpProxy = httpProxy;
    }

    public boolean isProxyAvailable(String proxyHost, int proxyPort) {
        try {
            InetAddress address = InetAddress.getByName(proxyHost);
            System.out.println("Name: " + address.getHostName());
            System.out.println("Addr: " + address.getHostAddress());
            System.out.println("Reach: " + address.isReachable(3000));
            return true;
        }
        catch (UnknownHostException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isLocalHost(String host) {
        return (host = host.toLowerCase()).equals("localhost") || host.equals("127.0.0.1");
    }

    private class RequestProperty {
        private String key;
        private String value;

        public RequestProperty(String key, String value) {
            this.key = key;
            this.value = value;
            Request.this.RequestProperties.add(this);
        }
    }
}

