/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Vector;
import javaxt.sql.Connection;
import javaxt.sql.Driver;
import javaxt.sql.Table;
import javaxt.utils.URL;

public class Database {
    private String name;
    private String host;
    private int port = -1;
    private String username;
    private String password;
    private Driver driver;
    private String url;
    private String props;
    private static Driver[] drivers = new Driver[]{new Driver("SQLServer", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver"), new Driver("DB2", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2"), new Driver("Sybase", "com.sybase.jdbc3.jdbc.SybDriver", "jdbc:sybase"), new Driver("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql"), new Driver("Derby", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby")};
    public static Driver SQLServer = Database.findDriver("SQLServer");
    public static Driver DB2 = Database.findDriver("DB2");
    public static Driver Sybase = Database.findDriver("Sybase");
    public static Driver PostgreSQL = Database.findDriver("PostgreSQL");
    public static Driver Derby = Database.findDriver("Derby");
    private java.sql.Connection Connection = null;
    private java.sql.Driver Driver = null;

    public Database(String name, String host, int port, String username, String password, Driver driver) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.driver = driver;
        this.url = this.getURL();
    }

    public Database(java.sql.Connection conn) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            this.name = conn.getCatalog();
            this.username = dbmd.getUserName();
            URL url = new URL(dbmd.getURL());
            this.host = url.getHost();
            this.port = url.getPort();
            this.driver = Database.findDriver(url.getProtocol());
            this.url = this.getURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Database(String connStr) {
        StringBuffer props = null;
        String[] arrConnStr = connStr.split(";");
        for (int i = 0; i < arrConnStr.length; ++i) {
            if (i == 0) {
                URL url = new URL(arrConnStr[0]);
                this.name = url.getPath();
                this.host = url.getHost();
                this.port = url.getPort();
                this.url = url.toString();
                this.driver = Database.findDriver(url.getProtocol());
                if (!this.name.startsWith("/")) continue;
                this.name = this.name.substring(1);
                continue;
            }
            String[] arrParams = arrConnStr[i].split("=");
            String paramName = arrParams[0].toLowerCase();
            String paramValue = arrParams[1];
            if (paramName.equals("database")) {
                this.name = paramValue;
                continue;
            }
            if (paramName.equals("user")) {
                this.username = paramValue;
                continue;
            }
            if (paramName.equals("password")) {
                this.password = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase("derby.system.home")) {
                System.setProperty("derby.system.home", paramValue);
                continue;
            }
            if (props == null) {
                props = new StringBuffer();
            }
            props.append(arrParams[0] + "=" + arrParams[1] + ";");
        }
        if (props != null) {
            this.props = props.toString();
        }
    }

    public Database() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHost(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setHost(String host) {
        if ((host = host.trim()).contains(":")) {
            try {
                this.host = host.substring(0, host.indexOf(":"));
                this.port = this.cint(host.substring(host.indexOf(":") + 1));
            }
            catch (Exception e) {
                this.host = host;
            }
        } else {
            this.host = host;
        }
    }

    private int cint(String str) {
        return Integer.valueOf(str);
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public void setDriver(String driver) {
        this.driver = Database.findDriver(driver);
    }

    public Driver getDriver() {
        return this.driver;
    }

    private static Driver findDriver(String driverName) {
        for (int i = 0; i < drivers.length; ++i) {
            Driver driver = drivers[i];
            if (!driver.equals(driverName)) continue;
            return driver;
        }
        return null;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionString() {
        String path = this.getURL();
        if (this.username != null) {
            path = path + ";user=" + this.username;
        }
        if (this.password != null) {
            path = path + ";password=" + this.password;
        }
        return path;
    }

    private String getURL() {
        String server = this.host;
        if (this.port > 0) {
            server = server + ":" + this.port;
        }
        if (this.driver.getVendor().equals("Derby")) {
            server = ":" + server;
        }
        String database = "";
        if (this.name != null && this.name.trim().length() > 0) {
            database = this.driver.getVendor().equals("SQLServer") ? ";databaseName=" + this.name : (this.driver.getVendor().equals("Derby") ? ";databaseName=" + this.name : "/" + this.name);
        }
        String path = "";
        path = this.driver.getProtocol() + "://";
        if (this.driver.getVendor().equals("Sybase")) {
            if (!path.toLowerCase().contains("tds:")) {
                path = this.driver.getProtocol() + "Tds:";
            }
        } else if (this.driver.getVendor().equals("Derby")) {
            path = this.driver.getProtocol();
        }
        String properties = "";
        if (this.props != null) {
            properties = ";" + this.props;
        }
        return path + server + database + properties;
    }

    public Connection getConnection() {
        Connection connection = new Connection();
        connection.open(this);
        return connection;
    }

    protected java.sql.Connection connect() throws Exception {
        if (this.Driver == null) {
            System.out.print("Loading Driver...");
            this.Driver = (java.sql.Driver)Class.forName(this.driver.getPackageName()).newInstance();
            System.out.println("Done");
        }
        if (this.Connection == null || this.Connection.isClosed()) {
            System.out.print("Attempting to connect...");
            this.Connection = DriverManager.getConnection(this.getURL(), this.username, this.password);
            System.out.println("Done");
        }
        return this.Connection;
    }

    public Table[] getTables() {
        try {
            Vector<Table> tables = new Vector<Table>();
            DatabaseMetaData dbmd = this.Connection.getMetaData();
            ResultSet rs = dbmd.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                tables.add(new Table(rs, dbmd));
            }
            rs.close();
            Table[] array = new Table[tables.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Table)tables.get(i);
            }
            return array;
        }
        catch (Exception e) {
            Database.printError(e);
            return null;
        }
    }

    public String[] getCatalogs() {
        try {
            Vector<String> catalogs = new Vector<String>();
            DatabaseMetaData dbmd = this.Connection.getMetaData();
            ResultSet rs = dbmd.getCatalogs();
            while (rs.next()) {
                catalogs.add(rs.getString(1));
            }
            rs.close();
            String[] array = new String[catalogs.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (String)catalogs.get(i);
            }
            return array;
        }
        catch (Exception e) {
            Database.printError(e);
            return null;
        }
    }

    public void displayDbProperties() {
        DatabaseMetaData dm = null;
        ResultSet rs = null;
        try {
            if (this.Connection != null) {
                dm = this.Connection.getMetaData();
                System.out.println("Driver Information");
                System.out.println("\tDriver Name: " + dm.getDriverName());
                System.out.println("\tDriver Version: " + dm.getDriverVersion());
                System.out.println("\nDatabase Information ");
                System.out.println("\tDatabase Name: " + dm.getDatabaseProductName());
                System.out.println("\tDatabase Version: " + dm.getDatabaseProductVersion());
                System.out.println("Avalilable Catalogs ");
                rs = dm.getCatalogs();
                while (rs.next()) {
                    System.out.println("\tcatalog: " + rs.getString(1));
                }
                rs.close();
                rs = null;
            } else {
                System.out.println("Error: No active Connection");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dm = null;
    }

    private static void printError(Exception e) {
        System.out.println(e.toString());
        StackTraceElement[] arr = e.getStackTrace();
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i].toString());
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name: " + this.name + "\r\n");
        str.append("Host: " + this.host + "\r\n");
        str.append("Port: " + this.port + "\r\n");
        str.append("UserName: " + this.username + "\r\n");
        str.append("Driver: " + this.driver + "\r\n");
        str.append("URL: " + this.url + "\r\n");
        str.append("ConnStr: " + this.getConnectionString());
        return str.toString();
    }
}

