/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javaxt.utils.string;

public class Parser {
    private HashMap sql = new HashMap();
    private static String[] sqlOperators = new String[]{"IS NULL", "IS NOT NULL", "BETWEEN", "CONTAINS", "LIKE", "<>", "<=", ">=", "=", "<", ">", "IN", "MATCHES", "SOME", "NOT EXISTS"};
    private static String[] sqlKeywords = new String[]{"SELECT", "FROM", "WHERE", "ORDER BY", "GROUP BY", "HAVING"};
    private SelectStatement[] selectStatements = null;
    private WhereStatement[] whereStatements = null;
    private OrderByStatement[] orderByStatements = null;
    private GroupByStatement[] groupByStatements = null;
    private FromStatement fromStatement = null;

    public String getSelectString() {
        return (String)this.sql.get("SELECT");
    }

    public String getFromString() {
        return (String)this.sql.get("FROM");
    }

    public String getWhereString() {
        return (String)this.sql.get("WHERE");
    }

    public String getOrderByString() {
        return (String)this.sql.get("ORDER BY");
    }

    public String getGroupByString() {
        return (String)this.sql.get("GROUP BY");
    }

    public String getHavingString() {
        return (String)this.sql.get("HAVING");
    }

    public Parser(String sql) {
        if (sql == null) {
            return;
        }
        sql = sql.replace("\n", " ");
        sql = sql.replace("\r", " ");
        sql = sql.replace("\t", " ");
        if ((sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        if (sql.length() <= 0) {
            return;
        }
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        boolean insideParenthesis = false;
        int parenthesis = 0;
        String s = sql;
        String c = "";
        Vector<String> keywords = new Vector<String>();
        String t = sql.toUpperCase();
        for (int i = 0; i < sqlKeywords.length; ++i) {
            if (!t.contains(sqlKeywords[i])) continue;
            keywords.add(sqlKeywords[i]);
        }
        String currentKeyword = null;
        String previousKeyword = null;
        StringBuffer phrase = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("\"") && !insideDoubleQuotes) {
                insideDoubleQuotes = true;
            }
            if (c.equals("\"") && insideDoubleQuotes) {
                insideDoubleQuotes = false;
            }
            if (c.equals("'") && !insideSingleQuotes) {
                insideSingleQuotes = true;
            }
            if (c.equals("'") && insideSingleQuotes) {
                insideSingleQuotes = false;
            }
            if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                insideParenthesis = true;
                parenthesis = 0;
            }
            if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                ++parenthesis;
            }
            if (c.equals(")") && insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes && --parenthesis == 0) {
                insideParenthesis = false;
            }
            phrase.append(c);
            if (!(insideDoubleQuotes || insideSingleQuotes || insideParenthesis)) {
                for (int j = 0; j < keywords.size(); ++j) {
                    String str;
                    String keyword = keywords.get(j).toString();
                    if (!keyword.startsWith(c.toUpperCase()) || i + keyword.length() > s.length() || !(str = s.substring(i, i + keyword.length())).equalsIgnoreCase(keyword)) continue;
                    currentKeyword = keyword;
                    String entry = phrase.substring(0, phrase.length() - 1).trim();
                    if (entry.length() > 0) {
                        Object prevStatement = this.sql.get(previousKeyword);
                        if (prevStatement == null) {
                            this.sql.put(previousKeyword, entry);
                        }
                        this.sql.put(currentKeyword, null);
                    }
                    phrase = new StringBuffer();
                    i += keyword.length() - 1;
                    previousKeyword = currentKeyword;
                    keywords.remove(j);
                    break;
                }
            }
            if (i != s.length() - 1 || phrase.toString().trim().equals(s)) continue;
            this.sql.put(previousKeyword, phrase.toString().trim());
        }
    }

    public String toString() {
        String selectClause = this.getSelectString();
        String fromClause = this.getFromString();
        String whereClause = this.getWhereString();
        String orderByClause = this.getOrderByString();
        String groupByClause = this.getGroupByString();
        String havingClause = this.getHavingString();
        if (selectClause == null || fromClause == null) {
            return null;
        }
        if (selectClause.length() <= 0 || fromClause.length() <= 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + selectClause + " FROM " + fromClause);
        if (whereClause != null) {
            sql.append(" WHERE " + whereClause);
        }
        if (orderByClause != null) {
            sql.append(" ORDER BY " + orderByClause);
        }
        if (groupByClause != null) {
            sql.append(" GROUP BY " + groupByClause);
        }
        if (havingClause != null) {
            sql.append(" HAVING " + havingClause);
        }
        return sql.toString();
    }

    public SelectStatement[] getSelectStatements() {
        if (this.selectStatements != null) {
            return this.selectStatements;
        }
        String[] array = this.split(this.getSelectString());
        this.selectStatements = new SelectStatement[array.length];
        for (int i = 0; i < this.selectStatements.length; ++i) {
            this.selectStatements[i] = new SelectStatement(array[i]);
        }
        return this.selectStatements;
    }

    public String[] getSelectedColumns() {
        SelectStatement[] selectStatements = this.getSelectStatements();
        String[] columns = new String[selectStatements.length];
        for (int i = 0; i < selectStatements.length; ++i) {
            SelectStatement statement = selectStatements[i];
            columns[i] = statement.getColumnName();
        }
        return columns;
    }

    private FromStatement getFromStatement() {
        if (this.fromStatement != null) {
            return this.fromStatement;
        }
        String fromClause = this.getFromString();
        fromClause = fromClause.replace("(", " ");
        fromClause = fromClause.replace(")", " ");
        fromClause = fromClause.trim();
        this.fromStatement = new FromStatement(fromClause);
        if (fromClause.toUpperCase().contains("JOIN")) {
            boolean insideSingleQuotes = false;
            boolean insideDoubleQuotes = false;
            String s = fromClause;
            String c = "";
            StringBuffer phrase = new StringBuffer();
            String[] joinTypes = new String[]{"RIGHT OUTER JOIN", "RIGHT INNER JOIN", "FULL OUTER JOIN", "LEFT OUTER JOIN", "LEFT INNER JOIN", "NATURAL JOIN", "RIGHT JOIN", "INNER JOIN", "OUTER JOIN", "CROSS JOIN", "LEFT JOIN", "JOIN"};
            for (int i = 0; i < s.length(); ++i) {
                c = s.substring(i, i + 1);
                if (c.equals("\"") && !insideDoubleQuotes) {
                    insideDoubleQuotes = true;
                }
                if (c.equals("\"") && insideDoubleQuotes) {
                    insideDoubleQuotes = false;
                }
                if (c.equals("'") && !insideSingleQuotes) {
                    insideSingleQuotes = true;
                }
                if (c.equals("'") && insideSingleQuotes) {
                    insideSingleQuotes = false;
                }
                phrase.append(c);
                if (!insideDoubleQuotes && !insideSingleQuotes) {
                    for (int j = 0; j < joinTypes.length; ++j) {
                        String keyword;
                        String joinType = joinTypes[j];
                        if (!joinType.startsWith(c.toUpperCase()) || i + joinType.length() > s.length() || !(keyword = s.substring(i, i + joinType.length())).equalsIgnoreCase(joinType)) continue;
                        String entry = phrase.substring(0, phrase.length() - 1).trim();
                        if (entry.length() <= 0) break;
                        phrase = new StringBuffer();
                        i += keyword.length() - 1;
                        this.fromStatement.addEntry(entry);
                        break;
                    }
                }
                if (i != s.length() - 1 || phrase.toString().trim().equals(s)) continue;
                String entry = phrase.toString().trim();
                this.fromStatement.addEntry(entry);
            }
        } else {
            String[] tables = string.split(fromClause, ",");
            for (int i = 0; i < tables.length; ++i) {
                String tableName = tables[i].trim();
                this.fromStatement.addTable(tableName);
            }
        }
        return this.fromStatement;
    }

    public String[] getTables() {
        return this.getFromStatement().getTables();
    }

    private WhereStatement[] getWhereStatements() {
        if (this.whereStatements != null) {
            return this.whereStatements;
        }
        String whereClause = this.getWhereString();
        if (whereClause == null || whereClause.trim().length() <= 0) {
            return new WhereStatement[0];
        }
        LinkedList<String> list = new LinkedList<String>();
        list.add(whereClause);
        for (int x = 0; x < list.size(); ++x) {
            boolean insideSingleQuotes = false;
            boolean insideDoubleQuotes = false;
            boolean insideParenthesis = false;
            int parenthesis = 0;
            String s = list.get(x).toString().trim();
            String c = "";
            StringBuffer phrase = new StringBuffer();
            for (int i = 0; i < s.length(); ++i) {
                c = s.substring(i, i + 1);
                if (c.equals("\"") && !insideDoubleQuotes) {
                    insideDoubleQuotes = true;
                }
                if (c.equals("\"") && insideDoubleQuotes) {
                    insideDoubleQuotes = false;
                }
                if (c.equals("'") && !insideSingleQuotes) {
                    insideSingleQuotes = true;
                }
                if (c.equals("'") && insideSingleQuotes) {
                    insideSingleQuotes = false;
                }
                if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                    insideParenthesis = true;
                    parenthesis = 0;
                }
                if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                    ++parenthesis;
                }
                if (c.equals(")") && insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes && --parenthesis == 0) {
                    insideParenthesis = false;
                }
                phrase.append(c);
                if (!(insideDoubleQuotes || insideSingleQuotes || insideParenthesis)) {
                    String keyword = null;
                    if (c.equalsIgnoreCase("A") && i + 3 < s.length()) {
                        keyword = s.substring(i, i + 3);
                        if (!keyword.equalsIgnoreCase("AND")) {
                            keyword = null;
                        }
                    } else if (c.equalsIgnoreCase("O") && i + 2 < s.length() && !(keyword = s.substring(i, i + 2)).equalsIgnoreCase("OR")) {
                        keyword = null;
                    }
                    if (keyword != null) {
                        String entry = phrase.substring(0, phrase.length() - 1).trim();
                        if ((entry = this.removeParentheses(entry)).length() > 0) {
                            list.add(entry);
                            phrase = new StringBuffer();
                            i += keyword.length() - 1;
                        }
                    }
                }
                if (i != s.length() - 1 || phrase.toString().trim().equals(s)) continue;
                String entry = phrase.toString().trim();
                entry = this.removeParentheses(entry);
                list.add(entry);
                list.remove(x);
            }
        }
        LinkedList<String> operators = new LinkedList<String>();
        int i = 0;
        while (true) {
            if (i >= sqlOperators.length) break;
            String operator = sqlOperators[i];
            if (whereClause.toUpperCase().contains(operator)) {
                operators.add(operator);
            }
            ++i;
        }
        String[] sqlOperators = new String[operators.size()];
        for (int i2 = 0; i2 < sqlOperators.length; ++i2) {
            sqlOperators[i2] = (String)operators.get(i2);
        }
        WhereStatement[] statements = new WhereStatement[list.size()];
        for (int i3 = 0; i3 < list.size(); ++i3) {
            String entry = list.get(i3).toString();
            statements[i3] = new WhereStatement(entry, sqlOperators);
        }
        this.whereStatements = statements;
        return statements;
    }

    private boolean isExposed(String element) {
        if (string.isNumeric(element)) {
            return false;
        }
        if (element.startsWith("\"") && element.endsWith("\"")) {
            return false;
        }
        return !element.startsWith("'") || !element.endsWith("'");
    }

    public OrderByStatement[] getOrderByStatements() {
        if (this.orderByStatements != null) {
            return this.orderByStatements;
        }
        String[] array = this.split(this.getOrderByString());
        this.orderByStatements = new OrderByStatement[array.length];
        for (int i = 0; i < this.orderByStatements.length; ++i) {
            this.orderByStatements[i] = new OrderByStatement(array[i]);
        }
        return this.orderByStatements;
    }

    public GroupByStatement[] getGroupByStatements() {
        if (this.groupByStatements != null) {
            return this.groupByStatements;
        }
        String[] array = this.split(this.getGroupByString());
        this.groupByStatements = new GroupByStatement[array.length];
        for (int i = 0; i < this.groupByStatements.length; ++i) {
            this.groupByStatements[i] = new GroupByStatement(array[i]);
        }
        return this.groupByStatements;
    }

    protected String[] getExposedDataElements() {
        GroupByStatement[] groupByStatements;
        OrderByStatement[] orderByStatements;
        TreeSet<String> exposedElements = new TreeSet<String>();
        SelectStatement[] selectStatements = this.getSelectStatements();
        for (int i = 0; i < selectStatements.length; ++i) {
            SelectStatement statement = selectStatements[i];
            List list = statement.exposedElements;
            for (int j = 0; j < list.size(); ++j) {
                String element = (String)list.get(j);
                if (element == null) continue;
                exposedElements.add(element);
            }
        }
        for (String exposedElement : this.getFromStatement().exposedElements) {
            exposedElements.add(exposedElement);
        }
        WhereStatement[] whereStatements = this.getWhereStatements();
        if (whereStatements.length > 0) {
            for (int i = 0; i < whereStatements.length; ++i) {
                WhereStatement statement = whereStatements[i];
                List list = statement.exposedColumns;
                for (int j = 0; j < list.size(); ++j) {
                    String element = (String)list.get(j);
                    if (element == null) continue;
                    exposedElements.add(element);
                }
            }
        }
        if ((orderByStatements = this.getOrderByStatements()).length > 0) {
            for (int i = 0; i < orderByStatements.length; ++i) {
                OrderByStatement statement = orderByStatements[i];
                if (!this.isExposed(statement.getColumnName())) continue;
                exposedElements.add(statement.getColumnName());
            }
        }
        if ((groupByStatements = this.getGroupByStatements()).length > 0) {
            for (int i = 0; i < groupByStatements.length; ++i) {
                GroupByStatement statement = groupByStatements[i];
                if (!this.isExposed(statement.getColumnName())) continue;
                exposedElements.add(statement.getColumnName());
            }
        }
        String[] array = new String[exposedElements.size()];
        int i = 0;
        Iterator it = exposedElements.iterator();
        while (it.hasNext()) {
            String exposedElement;
            array[i] = exposedElement = (String)it.next();
            ++i;
        }
        return array;
    }

    protected String addQuotes() {
        GroupByStatement[] groupByStatements;
        OrderByStatement[] orderByStatements;
        String selectClause = this.getSelectString();
        String fromClause = this.getFromString();
        String whereClause = this.getWhereString();
        String orderByClause = this.getOrderByString();
        String groupByClause = this.getGroupByString();
        String havingClause = this.getHavingString();
        HashSet<String> exposedElements = new HashSet<String>();
        SelectStatement[] selectStatements = this.getSelectStatements();
        for (int i = 0; i < selectStatements.length; ++i) {
            SelectStatement statement = selectStatements[i];
            List list = statement.exposedElements;
            for (int j = 0; j < list.size(); ++j) {
                String element = (String)list.get(j);
                if (element == null) continue;
                exposedElements.add(element);
            }
        }
        selectClause = this.addQuotes(exposedElements, selectClause);
        fromClause = this.addQuotes(this.getFromStatement().exposedElements, fromClause);
        WhereStatement[] whereStatements = this.getWhereStatements();
        if (whereStatements.length > 0) {
            exposedElements.clear();
            for (int i = 0; i < whereStatements.length; ++i) {
                WhereStatement statement = whereStatements[i];
                List list = statement.exposedColumns;
                for (int j = 0; j < list.size(); ++j) {
                    String element = (String)list.get(j);
                    if (element == null) continue;
                    exposedElements.add(element);
                }
            }
            whereClause = this.addQuotes(exposedElements, whereClause);
        }
        if ((orderByStatements = this.getOrderByStatements()).length > 0) {
            exposedElements.clear();
            for (int i = 0; i < orderByStatements.length; ++i) {
                OrderByStatement statement = orderByStatements[i];
                if (!this.isExposed(statement.getColumnName())) continue;
                exposedElements.add(statement.getColumnName());
            }
            orderByClause = this.addQuotes(exposedElements, orderByClause);
        }
        if ((groupByStatements = this.getGroupByStatements()).length > 0) {
            exposedElements.clear();
            for (int i = 0; i < groupByStatements.length; ++i) {
                GroupByStatement statement = groupByStatements[i];
                if (!this.isExposed(statement.getColumnName())) continue;
                exposedElements.add(statement.getColumnName());
            }
            groupByClause = this.addQuotes(exposedElements, groupByClause);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT " + selectClause + " FROM " + fromClause);
        if (whereClause != null) {
            sql.append(" WHERE " + whereClause);
        }
        if (orderByClause != null) {
            sql.append(" ORDER BY " + orderByClause);
        }
        if (groupByClause != null) {
            sql.append(" GROUP BY " + groupByClause);
        }
        if (havingClause != null) {
            sql.append(" HAVING " + havingClause);
        }
        return sql.toString();
    }

    private String addQuotes(HashSet exposedElements, String sqlFragment) {
        if (sqlFragment == null) {
            return null;
        }
        if (exposedElements.size() == 0) {
            return sqlFragment;
        }
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        String s = sqlFragment;
        String c = "";
        StringBuffer phrase = new StringBuffer();
        StringBuffer newSQL = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("\"") && !insideDoubleQuotes) {
                insideDoubleQuotes = true;
            }
            if (c.equals("\"") && insideDoubleQuotes) {
                insideDoubleQuotes = false;
            }
            if (c.equals("'") && !insideSingleQuotes) {
                insideSingleQuotes = true;
            }
            if (c.equals("'") && insideSingleQuotes) {
                insideSingleQuotes = false;
            }
            phrase.append(c);
            if (!insideDoubleQuotes && !insideSingleQuotes) {
                Iterator it = exposedElements.iterator();
                while (it.hasNext()) {
                    String str;
                    String exposedElement = (String)it.next();
                    if (exposedElement.length() <= 0 || !c.equalsIgnoreCase(exposedElement.substring(0, 1)) || i + exposedElement.length() > s.length() || !(str = s.substring(i, i + exposedElement.length())).equalsIgnoreCase(exposedElement)) continue;
                    str = phrase.substring(0, phrase.length() - 1);
                    String prevChar = "";
                    String nextChar = "";
                    if (i - 1 >= 0 && i + exposedElement.length() + 1 <= s.length()) {
                        prevChar = s.substring(i - 1, i);
                        nextChar = s.substring(i + exposedElement.length(), i + exposedElement.length() + 1);
                    }
                    if (!this.wrapElement(prevChar, nextChar)) continue;
                    newSQL.append(str + "\"" + exposedElement + "\"");
                    phrase = new StringBuffer();
                    if ((i += exposedElement.length() - 1) + exposedElement.length() > s.length() || s.substring(i + exposedElement.length()).toUpperCase().contains(exposedElement.toUpperCase())) break;
                    exposedElements.remove(exposedElement);
                    it = exposedElements.iterator();
                    break;
                }
            }
            if (i != s.length() - 1 || phrase.toString().trim().equals(s)) continue;
            newSQL.append(phrase.toString());
        }
        return newSQL.toString();
    }

    private boolean wrapElement(String prevChar, String nextChar) {
        return !(!prevChar.equals("") && !prevChar.equals(" ") && !prevChar.equals(")") && !prevChar.equals("(") && !prevChar.equals(",") && !prevChar.equals("=") && !prevChar.equals(">") && !prevChar.equals("<") || !nextChar.equals("") && !nextChar.equals(" ") && !nextChar.equals(")") && !nextChar.equals("(") && !nextChar.equals(",") && !nextChar.equals("=") && !nextChar.equals(">") && !nextChar.equals("<"));
    }

    private String stripFunctions(String str) {
        boolean FunctionsPresent = true;
        if (this.InStr(str, "(") > 0 && this.InStr(str, ")") > 0 && this.InStr(str, "(") < this.InStr(str, ")")) {
            while (FunctionsPresent) {
                str = this.Right(str, this.Len(str) - this.InStrRev(str, "("));
                str = this.Left(str, this.InStrRev(str, ")") - 1);
                if (this.InStr(str = str.trim(), ",") > 0) {
                    str = this.Left(str, this.InStr(str, ",") - 1);
                    str = str.trim();
                }
                if (this.InStr(str, "(") != 0 || this.InStr(str, ")") != 0) continue;
                FunctionsPresent = false;
            }
        }
        return str;
    }

    private int InStr(String str, String ch) {
        return str.indexOf(ch) + 1;
    }

    private int InStrRev(String str, String ch) {
        return str.lastIndexOf(ch) + 1;
    }

    private int Len(String str) {
        return str.length();
    }

    private String Left(String str, int n) {
        return str.substring(0, n);
    }

    private String Right(String str, int n) {
        int iLen = str.length();
        return str.substring(iLen - n, iLen);
    }

    private String removeParentheses(String text) {
        if ((text = text.trim()).startsWith("(") && text.endsWith(")")) {
            boolean insideSingleQuotes = false;
            boolean insideDoubleQuotes = false;
            boolean insideParenthesis = false;
            int parenthesis = 0;
            int gaps = 0;
            String s = text;
            String c = "";
            for (int i = 0; i < s.length(); ++i) {
                String nextString;
                c = s.substring(i, i + 1);
                if (c.equals("\"") && !insideDoubleQuotes) {
                    insideDoubleQuotes = true;
                }
                if (c.equals("\"") && insideDoubleQuotes) {
                    insideDoubleQuotes = false;
                }
                if (c.equals("'") && !insideSingleQuotes) {
                    insideSingleQuotes = true;
                }
                if (c.equals("'") && insideSingleQuotes) {
                    insideSingleQuotes = false;
                }
                if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                    insideParenthesis = true;
                    parenthesis = 0;
                }
                if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                    ++parenthesis;
                }
                if (!c.equals(")") || !insideParenthesis || insideDoubleQuotes || insideSingleQuotes || --parenthesis != 0) continue;
                insideParenthesis = false;
                if (i + 1 >= s.length() || (nextString = s.substring(i + 1).trim()).startsWith("(")) continue;
                ++gaps;
            }
            if (gaps == 0) {
                text = text.substring(1, text.length() - 1).trim();
            }
        }
        return text;
    }

    private String[] split(String statement) {
        if (statement == null || statement.length() <= 0) {
            return new String[0];
        }
        if (!(statement = statement.trim()).contains(",")) {
            return new String[]{statement};
        }
        boolean insideSingleQuotes = false;
        boolean insideDoubleQuotes = false;
        boolean insideParenthesis = false;
        int parenthesis = 0;
        String s = statement + " ";
        String c = "";
        StringBuffer str = new StringBuffer();
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < s.length(); ++i) {
            c = s.substring(i, i + 1);
            if (c.equals("\"") && !insideDoubleQuotes) {
                insideDoubleQuotes = true;
            }
            if (c.equals("\"") && insideDoubleQuotes) {
                insideDoubleQuotes = false;
            }
            if (c.equals("'") && !insideSingleQuotes) {
                insideSingleQuotes = true;
            }
            if (c.equals("'") && insideSingleQuotes) {
                insideSingleQuotes = false;
            }
            if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                insideParenthesis = true;
                parenthesis = 0;
            }
            if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                ++parenthesis;
            }
            if (c.equals(")") && insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes && --parenthesis == 0) {
                insideParenthesis = false;
            }
            str.append(c);
            if (!c.equals(",") && i != s.length() - 1 || insideDoubleQuotes || insideSingleQuotes || insideParenthesis) continue;
            String element = str.substring(0, str.length() - 1).toString().trim();
            list.add(element);
            str = new StringBuffer();
        }
        String[] statements = new String[list.size()];
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = list.get(i).toString();
        }
        return statements;
    }

    public void debug() {
        GroupByStatement[] groupByStatements;
        OrderByStatement[] orderByStatements;
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("Original SQL Statement");
        System.out.println("-----------------------------------------");
        for (int i = 0; i < sqlKeywords.length; ++i) {
            String key = sqlKeywords[i];
            String val = (String)this.sql.get(key);
            if (val == null) continue;
            System.out.println(key.toString());
            System.out.println("   " + val.toString());
        }
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("SELECT Statements");
        System.out.println("-----------------------------------------");
        SelectStatement[] selectStatements = this.getSelectStatements();
        for (int i = 0; i < selectStatements.length; ++i) {
            SelectStatement statement = selectStatements[i];
            System.out.println(statement);
        }
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("Selected Columns");
        System.out.println("-----------------------------------------");
        String[] selectColumns = this.getSelectedColumns();
        for (int i = 0; i < selectColumns.length; ++i) {
            String columnName = selectColumns[i];
            System.out.println(columnName);
        }
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("Selected Tables");
        System.out.println("-----------------------------------------");
        String[] selectTables = this.getTables();
        for (int i = 0; i < selectTables.length; ++i) {
            String tableName = selectTables[i];
            System.out.println(tableName);
        }
        WhereStatement[] whereStatements = this.getWhereStatements();
        if (whereStatements.length > 0) {
            System.out.println();
            System.out.println("-----------------------------------------");
            System.out.println("WHERE Statements");
            System.out.println("-----------------------------------------");
            for (int i = 0; i < whereStatements.length; ++i) {
                WhereStatement statement = whereStatements[i];
                System.out.println(statement.toString() + " \"" + statement.getOperator() + "\"");
            }
        }
        if ((orderByStatements = this.getOrderByStatements()).length > 0) {
            System.out.println();
            System.out.println("-----------------------------------------");
            System.out.println("ORDER BY Statements");
            System.out.println("-----------------------------------------");
            for (int i = 0; i < orderByStatements.length; ++i) {
                OrderByStatement statement = orderByStatements[i];
                System.out.println(statement);
            }
        }
        if ((groupByStatements = this.getGroupByStatements()).length > 0) {
            System.out.println();
            System.out.println("-----------------------------------------");
            System.out.println("GROUP BY Statements");
            System.out.println("-----------------------------------------");
            for (int i = 0; i < groupByStatements.length; ++i) {
                GroupByStatement statement = groupByStatements[i];
                System.out.println(statement);
            }
        }
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("Exposed Tables and Columns");
        System.out.println("-----------------------------------------");
        String[] exposedElements = this.getExposedDataElements();
        for (int i = 0; i < exposedElements.length; ++i) {
            String element = exposedElements[i];
            System.out.println(element);
        }
        System.out.println();
        System.out.println("-----------------------------------------");
        System.out.println("NEW SQL");
        System.out.println("-----------------------------------------");
        System.out.println(this.addQuotes());
    }

    public class GroupByStatement {
        private String statement = null;
        private boolean isExposed = false;

        public GroupByStatement(String groupBy) {
            this.statement = groupBy;
            this.isExposed = Parser.this.isExposed(groupBy);
        }

        public String getColumnName() {
            return this.statement;
        }

        public String toString() {
            return this.statement;
        }
    }

    public class OrderByStatement {
        private String statement = null;
        private String columnName = null;
        private boolean isAscending = true;
        private boolean isExposed = false;

        public OrderByStatement(String orderBy) {
            this.statement = orderBy;
            if (orderBy.toUpperCase().endsWith(" ASC")) {
                this.columnName = orderBy.substring(0, orderBy.length() - 4).trim();
            } else if (orderBy.toUpperCase().endsWith(" DESC")) {
                this.columnName = orderBy.substring(0, orderBy.length() - 5).trim();
                this.isAscending = false;
            } else {
                this.columnName = orderBy;
            }
            this.isExposed = Parser.this.isExposed(this.columnName);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isDescending() {
            return !this.isAscending;
        }

        public boolean isAscending() {
            return this.isAscending;
        }

        public String toString() {
            return this.statement;
        }
    }

    public class WhereStatement {
        private String statement = null;
        private String leftOperand = null;
        private String rightOperand = null;
        private String operator = null;
        private List exposedColumns = new LinkedList();

        public WhereStatement(String statement) {
            this(statement, sqlOperators);
        }

        public WhereStatement(String statement, String[] sqlOperators) {
            this.statement = statement;
            if (statement != null) {
                int i;
                int i2;
                Vector<String> array = new Vector<String>();
                for (i2 = 0; i2 < sqlOperators.length; ++i2) {
                    String sqlOperator = sqlOperators[i2];
                    if (!statement.toUpperCase().contains(sqlOperator)) continue;
                    array.add(sqlOperator);
                }
                sqlOperators = new String[array.size()];
                for (i2 = 0; i2 < sqlOperators.length; ++i2) {
                    sqlOperators[i2] = (String)array.get(i2);
                }
                boolean insideSingleQuotes = false;
                boolean insideDoubleQuotes = false;
                boolean insideParenthesis = false;
                int parenthesis = 0;
                String s = statement;
                String c = "";
                StringBuffer phrase = new StringBuffer();
                LinkedList<String> list = new LinkedList<String>();
                for (i = 0; i < s.length(); ++i) {
                    String entry;
                    c = s.substring(i, i + 1);
                    if (c.equals("\"") && !insideDoubleQuotes) {
                        insideDoubleQuotes = true;
                    }
                    if (c.equals("\"") && insideDoubleQuotes) {
                        insideDoubleQuotes = false;
                    }
                    if (c.equals("'") && !insideSingleQuotes) {
                        insideSingleQuotes = true;
                    }
                    if (c.equals("'") && insideSingleQuotes) {
                        insideSingleQuotes = false;
                    }
                    if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                        insideParenthesis = true;
                        parenthesis = 0;
                    }
                    if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                        ++parenthesis;
                    }
                    if (c.equals(")") && insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes && --parenthesis == 0) {
                        insideParenthesis = false;
                    }
                    phrase.append(c);
                    if (!(insideDoubleQuotes || insideSingleQuotes || insideParenthesis)) {
                        for (int j = 0; j < sqlOperators.length; ++j) {
                            String keyword;
                            String sqlOperator = sqlOperators[j];
                            if (!sqlOperator.toUpperCase().startsWith(c.toUpperCase()) || i + sqlOperator.length() > s.length() || !(keyword = s.substring(i, i + sqlOperator.length())).equalsIgnoreCase(sqlOperator)) continue;
                            String entry2 = phrase.substring(0, phrase.length() - 1).trim();
                            if (entry2.length() <= 0) break;
                            list.add(entry2);
                            phrase = new StringBuffer();
                            i += keyword.length() - 1;
                            this.operator = keyword;
                            this.leftOperand = entry2;
                            break;
                        }
                    }
                    if (i != s.length() - 1 || phrase.toString().trim().equals(s) || (entry = phrase.toString().trim()).length() <= 0) continue;
                    if (!entry.equalsIgnoreCase("null")) {
                        list.add(entry);
                    }
                    this.rightOperand = entry;
                }
                this.exposedColumns = new LinkedList();
                for (i = 0; i < list.size(); ++i) {
                    String entry = (String)list.get(i);
                    if (entry == null || !Parser.this.isExposed(entry = Parser.this.stripFunctions(entry))) continue;
                    this.exposedColumns.add(entry);
                }
            }
        }

        public String getLeftOperand() {
            return this.leftOperand;
        }

        public String getRightOperand() {
            return this.rightOperand;
        }

        public String getOperator() {
            return this.operator;
        }

        public String toString() {
            return this.statement;
        }
    }

    public class FromStatement {
        private String statement = null;
        private HashSet tables = new HashSet();
        private HashSet columns = new HashSet();
        private HashSet exposedElements = new HashSet();

        private FromStatement(String statement) {
            this.statement = statement;
        }

        public void addTable(String tableName) {
            tableName = tableName.trim();
            this.tables.add(tableName);
            if (Parser.this.isExposed(tableName)) {
                this.exposedElements.add(tableName);
            }
        }

        public void addColumn(String columnName) {
            columnName = columnName.trim();
            this.columns.add(columnName);
            if (Parser.this.isExposed(columnName)) {
                this.exposedElements.add(columnName);
            }
        }

        private void addEntry(String entry) {
            String tableName = null;
            String joinCondition = null;
            if (entry.toUpperCase().contains(" ON ")) {
                tableName = entry.substring(0, entry.toUpperCase().indexOf(" ON ")).trim();
                this.addTable(tableName);
                joinCondition = entry.substring(entry.toUpperCase().indexOf(" ON ") + 4).trim();
                WhereStatement statement = new WhereStatement(joinCondition);
                this.addColumn(statement.getLeftOperand());
                this.addColumn(statement.getRightOperand());
            } else {
                tableName = entry;
                this.addTable(tableName);
            }
        }

        public HashSet getExposedElements() {
            return this.exposedElements;
        }

        public String[] getTables() {
            String[] array = new String[this.tables.size()];
            Iterator it = this.tables.iterator();
            int i = 0;
            while (it.hasNext()) {
                String tableName;
                array[i] = tableName = (String)it.next();
                ++i;
            }
            return array;
        }

        public String toString() {
            return this.statement;
        }
    }

    public class SelectStatement {
        private String alias = null;
        private String statement = null;
        private String columnName = null;
        private List exposedElements = new LinkedList();

        public SelectStatement(String statement) {
            this.statement = statement;
            this.columnName = Parser.this.stripFunctions(statement);
            if (statement.toUpperCase().contains("AS")) {
                boolean insideSingleQuotes = false;
                boolean insideDoubleQuotes = false;
                boolean insideParenthesis = false;
                int parenthesis = 0;
                String s = statement;
                String c = "";
                for (int i = 0; i < s.length(); ++i) {
                    String keyword;
                    c = s.substring(i, i + 1);
                    if (c.equals("\"") && !insideDoubleQuotes) {
                        insideDoubleQuotes = true;
                    }
                    if (c.equals("\"") && insideDoubleQuotes) {
                        insideDoubleQuotes = false;
                    }
                    if (c.equals("'") && !insideSingleQuotes) {
                        insideSingleQuotes = true;
                    }
                    if (c.equals("'") && insideSingleQuotes) {
                        insideSingleQuotes = false;
                    }
                    if (c.equals("(") && !insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes) {
                        insideParenthesis = true;
                        parenthesis = 0;
                    }
                    if (c.equals("(") && !insideDoubleQuotes && !insideSingleQuotes) {
                        ++parenthesis;
                    }
                    if (c.equals(")") && insideParenthesis && !insideDoubleQuotes && !insideSingleQuotes && --parenthesis == 0) {
                        insideParenthesis = false;
                    }
                    if (insideDoubleQuotes || insideSingleQuotes || insideParenthesis || !c.equalsIgnoreCase("A") || i + 3 >= s.length() || !(keyword = s.substring(i, i + 2)).equalsIgnoreCase("AS")) continue;
                    String as = s.substring(i + 2);
                    String prevChar = "";
                    String nextChar = "";
                    if (i - 1 >= 0 && i + 3 <= s.length()) {
                        prevChar = s.substring(i - 1, i);
                        nextChar = s.substring(i + 2, i + 3);
                    }
                    if (!prevChar.equals(" ") && !prevChar.equals(")") || !nextChar.equals(" ") && !nextChar.equals("(")) continue;
                    this.alias = Parser.this.removeParentheses(as);
                    this.columnName = Parser.this.stripFunctions(s.substring(0, i - 1).trim());
                }
            }
            String[] elements = new String[]{this.columnName, this.alias};
            for (int i = 0; i < elements.length; ++i) {
                String entry = elements[i];
                if (entry == null) continue;
                if (entry.endsWith("*")) {
                    if (!entry.endsWith(".*")) continue;
                    this.exposedElements.add(entry.substring(0, entry.length() - 2));
                    continue;
                }
                if (entry.startsWith("\"") && entry.endsWith("\"") || entry.startsWith("'") && entry.endsWith("'")) continue;
                this.exposedElements.add(entry);
            }
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            return this.statement;
        }
    }
}

