/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Vector;

public class URL {
    private java.net.URL url = null;
    private Vector Parameters = new Vector();
    private String protocol = null;

    public URL(java.net.URL url) {
        this.url = url;
        this.parseQueryString();
    }

    public URL(String url) {
        if (url.contains("://")) {
            if (url.contains(";")) {
                url = url.substring(0, url.indexOf(";"));
            }
            try {
                this.url = new java.net.URL(url);
            }
            catch (Exception e) {
                try {
                    this.protocol = url.substring(0, url.indexOf("://"));
                    this.url = new java.net.URL("http" + url.substring(url.indexOf("://")));
                }
                catch (Exception exception) {}
            }
        } else {
            this.url = this.createURL(url);
        }
        this.parseQueryString();
    }

    public boolean exists() {
        try {
            URLConnection conn = this.url.openConnection();
            conn.setConnectTimeout(5000);
            conn.getInputStream();
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println("URL not found: " + this.url.toString());
            return false;
        }
    }

    private java.net.URL createURL(String QueryString) {
        try {
            return new java.net.URL("http://tempuri.org/?" + QueryString);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void parseQueryString() {
        String query = this.url.getQuery();
        if (query == null) {
            return;
        }
        try {
            new URLDecoder();
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (Exception e) {
            String[] find = new String[]{"%2C", "%2F", "%3A"};
            String[] replace = new String[]{",", "/", ":"};
            for (int i = 0; i < find.length; ++i) {
                query = query.replace(find[i], replace[i]);
            }
        }
        if (query.startsWith("&")) {
            query = query.substring(1);
        }
        query = query + "&";
        String word = "";
        String c = "";
        for (int i = 0; i < query.length(); ++i) {
            c = query.substring(i, i + 1);
            if (!c.equals("&")) {
                word = word + c;
                continue;
            }
            int x = word.indexOf("=");
            if (x >= 0) {
                String ParameterName = word.substring(0, x);
                String ParameterValue = word.substring(x + 1);
                this.Parameters.add(new Parameter(ParameterName, ParameterValue));
            }
            word = "";
        }
    }

    public String getParameter(String parameterName) {
        String Values2 = "";
        Object[] parameters = this.Parameters.toArray();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = (Parameter)parameters[i];
            if (!parameterName.equalsIgnoreCase(parameter.getName())) continue;
            Values2 = Values2 + parameter.getValue() + ",";
        }
        if (Values2.endsWith(",")) {
            Values2 = Values2.substring(0, Values2.length() - 1);
        }
        return Values2;
    }

    public String getParameter(String[] parameterNames) {
        String Values2 = "";
        Object[] parameters = this.Parameters.toArray();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = (Parameter)parameters[i];
            for (int j = 0; j < parameterNames.length; ++j) {
                if (!parameterNames[j].equalsIgnoreCase(parameter.getName())) continue;
                Values2 = Values2 + parameter.getValue() + ",";
            }
        }
        if (Values2.endsWith(",")) {
            Values2 = Values2.substring(0, Values2.length() - 1);
        }
        return Values2;
    }

    public String getHost() {
        return this.url.getHost();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        return this.url.getProtocol();
    }

    public String getQueryString() {
        return this.url.getQuery();
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String toString() {
        if (this.protocol == null) {
            return this.url.toString();
        }
        String host = this.getHost() + ":" + this.getPort();
        String path = "";
        if (this.getPath() != null) {
            path = this.getPath();
        }
        String query = "";
        if (this.getQueryString() != null) {
            query = "?" + this.getQueryString();
        }
        return this.protocol + "://" + host + path + query;
    }

    private class Parameter {
        private String name = "";
        private String value = "";

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

