/*
 * Decompiled with CFR 0.152.
 */
package javaxt.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javaxt.http.Request;
import javaxt.io.Image;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private URLConnection conn;
    private Request request;

    protected Response(Request request) {
        this.request = request;
        this.conn = request.conn;
    }

    public URL getURL() {
        return this.request.getURL();
    }

    public Map<String, List<String>> getHeaders() {
        return this.request.getResponseHeaders();
    }

    public String[] getHeaders(String headerName) {
        return this.request.getResponseHeaders(headerName);
    }

    public String getHeader(String headerName) {
        return this.request.getResponseHeader(headerName);
    }

    public int getStatus() {
        return this.request.getResponseCode();
    }

    public String getMessage() {
        return this.request.getResponseMessage();
    }

    public String getCharacterEncoding() {
        String contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            for (String str : contentType.split(";")) {
                if (!(str = str.trim()).startsWith("charset=")) continue;
                return str.substring(8).trim();
            }
        }
        return null;
    }

    public InputStream getInputStream() {
        InputStream errorStream = ((HttpURLConnection)this.conn).getErrorStream();
        if (errorStream != null) {
            return errorStream;
        }
        try {
            return this.conn.getInputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getText() {
        String charset = this.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        return this.getText(charset);
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes(true).toString(charsetName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Document getXML() {
        return DOM.createDocument(new ByteArrayInputStream(this.getBytes(true).toByteArray()));
    }

    public Image getImage() {
        return new Image(this.getBytes(true).toByteArray());
    }

    public ByteArrayOutputStream getBytes() {
        return this.getBytes(false);
    }

    public ByteArrayOutputStream getBytes(boolean deflate) {
        InputStream inputStream = this.getInputStream();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        String encoding = this.getHeader("Content-Encoding");
        if (deflate && encoding != null) {
            if (encoding.equalsIgnoreCase("gzip")) {
                GZIPInputStream gzipInputStream = null;
                byte[] buf = new byte[1024];
                try {
                    int len;
                    gzipInputStream = new GZIPInputStream(inputStream);
                    while ((len = gzipInputStream.read(buf)) > 0) {
                        bas.write(buf, 0, len);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    gzipInputStream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    bas.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bas;
            }
        } else {
            byte[] buf = new byte[1024];
            int len = 0;
            try {
                while ((len = inputStream.read(buf, 0, 1024)) > -1) {
                    bas.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                bas.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return bas;
        }
        System.err.println("Unsupported encoding:  " + encoding);
        return null;
    }

    public String toString() {
        Map<String, List<String>> headers = this.request.getResponseHeaders();
        StringBuffer out = new StringBuffer();
        for (String key : headers.keySet()) {
            if (key != null) {
                List<String> list = headers.get(key);
                for (int i = 0; i < list.size(); ++i) {
                    out.append(key + ": " + list.get(i) + "\r\n");
                }
                continue;
            }
            out.append(headers.get(key) + "\r\n");
        }
        out.append("\r\n");
        return out.toString();
    }
}

