/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import javaxt.io.DirectorySearch;
import javaxt.io.File;
import javaxt.io.FileFilter;
import javaxt.io.FileSystemWatcher;
import javaxt.io.Shell;
import javaxt.utils.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
implements Comparable {
    private java.io.File Directory;
    private boolean useCache = false;
    private static List events = new LinkedList();
    private FileSystemWatcher FileSystemWatcher;
    private File.FileAttributes attr;
    public static final String PathSeparator = System.getProperty("file.separator");
    protected static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Event LastEvent = null;

    public Directory(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.Directory = new java.io.File(Path2);
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public Directory(java.io.File File2) {
        this.Directory = File2;
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Directory[] getRootDirectories() {
        directories = new TreeSet<Directory>();
        files = java.io.File.listRoots();
        if (files == null) {
            return new Directory[0];
        }
        for (i = 0; i < files.length; ++i) {
            directories.add(new Directory(files[i]));
        }
        if (javaxt.io.Directory.isWindows) {
            doNetUse = false;
            if (File.loadDLL()) {
                try {
                    drives = File.GetNetworkDrives();
                    if (drives == null) ** GOTO lbl28
                    for (String drive : drives.split("\n")) {
                        if (drive.trim().length() <= 0) continue;
                        arr = drive.split("\t");
                        driveName = arr[0];
                        driveType = arr[1];
                        directories.add(new Directory(driveName));
                    }
                }
                catch (Exception e) {
                    doNetUse = true;
                }
            } else {
                doNetUse = true;
            }
lbl28:
            // 4 sources

            if (doNetUse) {
                cmd = new Shell("net use");
                cmd.run();
                it = cmd.getOutput().iterator();
                parse = false;
                while (it.hasNext() && (line = (String)it.next()) != null) {
                    line = line.trim();
                    if (!parse && line.startsWith("----")) {
                        parse = true;
                        line = (String)it.next();
                        if (line == null) break;
                    }
                    if (!line.contains(":")) continue;
                    line = line.substring(0, line.indexOf(":") + 1);
                    line = line.substring(line.lastIndexOf(" ") + 1);
                    directories.add(new Directory(line.trim()));
                }
            }
        }
        return directories.toArray(new Directory[directories.size()]);
    }

    public boolean exists() {
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                boolean doNetUse = false;
                if (File.loadDLL()) {
                    try {
                        File.GetSharedDrives(path.substring(2));
                        return true;
                    }
                    catch (Exception e) {
                        if (e.getMessage().trim().equals("53")) {
                            return false;
                        }
                        doNetUse = true;
                    }
                } else {
                    doNetUse = true;
                }
                if (doNetUse) {
                    Shell cmd = new Shell("net view " + path);
                    cmd.run();
                    List errors = cmd.getErrors();
                    errors.remove(null);
                    return errors.isEmpty();
                }
            }
        }
        return this.Directory.exists();
    }

    public boolean create() {
        return this.Directory.mkdirs();
    }

    public boolean delete() {
        return this.Directory.delete();
    }

    public String[] copyTo(Directory Destination, boolean Overwrite) {
        int source = this.toString().length();
        String destination = Destination.toString();
        Vector<String> vec = new Vector<String>();
        Directory[] Directories = this.getSubDirectories(true);
        for (int i = 0; i < Directories.length; ++i) {
            new Directory(destination + Directories[i].toString().substring(source)).create();
        }
        File[] Files = this.getFiles(true);
        for (int i = 0; i < Files.length; ++i) {
            String FilePath = Files[i].toString();
            File out = new File(destination + FilePath.substring(source));
            boolean CopiedFile = Files[i].copyTo(out, Overwrite);
            if (CopiedFile) continue;
            vec.add(FilePath);
        }
        Object[] arr = vec.toArray();
        String[] ret = new String[arr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)arr[i];
        }
        return ret;
    }

    public void moveTo(Directory Destination, boolean Overwrite) {
        if (Overwrite) {
            this.Directory.renameTo(Destination.toFile());
        } else if (!Destination.exists()) {
            this.Directory.renameTo(Destination.toFile());
        }
    }

    public void rename(String Name) {
        String path = this.getParentDirectory().getPath() + Name;
        this.Directory.renameTo(new java.io.File(path));
    }

    public String getName() {
        return this.Directory.getName();
    }

    public String getPath() {
        String path = this.Directory.getAbsolutePath();
        if (path.endsWith(java.io.File.separator)) {
            return path;
        }
        return path + java.io.File.separator;
    }

    public java.util.Date getDate() {
        return new Date(this.Directory.lastModified()).getDate();
    }

    public void setDate(java.util.Date lastModified) {
        long t = lastModified.getTime();
        if (this.Directory.lastModified() != t) {
            this.Directory.setLastModified(t);
        }
    }

    public long getSize() {
        return this.Directory.length();
    }

    public boolean isHidden() {
        return this.Directory.isHidden();
    }

    public boolean isLink() {
        return this.getLink() != null;
    }

    public java.io.File getLink() {
        try {
            return this.getFileAttributes().getLink();
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.util.Date getLastModifiedTime() {
        return this.getDate();
    }

    public java.util.Date getCreationTime() {
        try {
            return this.getFileAttributes().getCreationTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.util.Date getLastAccessTime() {
        try {
            return this.getFileAttributes().getLastAccessTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashSet<String> getFlags() {
        try {
            return this.getFileAttributes().getFlags();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public File.FileAttributes getFileAttributes() {
        if (this.attr == null || new java.util.Date().getTime() - this.attr.lastUpdate > 1000L) {
            try {
                this.attr = new File.FileAttributes(this.toString());
            }
            catch (Exception e) {
                this.attr = null;
            }
        }
        return this.attr;
    }

    public Directory getParentDirectory() {
        if (this.Directory.getParentFile() != null) {
            return new Directory(this.Directory.getParentFile());
        }
        return null;
    }

    public java.io.File toFile() {
        return this.Directory;
    }

    public File[] getFiles(Object filter) {
        if (this.Directory.exists()) {
            FileFilter fileFilter = new FileFilter(filter);
            Object[] files = this.listFiles(fileFilter);
            if (files == null) {
                return new File[0];
            }
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                java.io.File file = null;
                file = files[i] instanceof java.io.File ? (java.io.File)files[i] : new java.io.File(files[i].toString());
                if (!file.exists() || !file.isFile()) continue;
                list.add(new File(file));
            }
            Collections.sort(list, new FileComparer(this));
            return list.toArray(new File[list.size()]);
        }
        return new File[0];
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles(Object filter, boolean RecursiveSearch) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, filter, false);
                ArrayList<File> files = new ArrayList<File>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof File)) continue;
                            files.add((File)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Collections.sort(files, new FileComparer(this));
                return files.toArray(new File[files.size()]);
            }
            return this.getFiles(filter);
        }
        return new File[0];
    }

    public File[] getFiles(boolean RecursiveSearch) {
        return this.getFiles(null, RecursiveSearch);
    }

    public Directory[] getSubDirectories() {
        return this.getSubDirectories(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory[] getSubDirectories(boolean RecursiveSearch) {
        if (this.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, null, false);
                ArrayList<Directory> directories = new ArrayList<Directory>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof Directory)) continue;
                            directories.add((Directory)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return directories.toArray(new Directory[directories.size()]);
            }
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                public boolean accept(java.io.File file) {
                    return file.isDirectory();
                }
            };
            Object[] files = this.listFiles(new FileFilter(fileFilter));
            if (files == null) {
                return new Directory[0];
            }
            Directory[] dirs = new Directory[files.length];
            for (int i = 0; i < files.length; ++i) {
                dirs[i] = new Directory(files[i].toString());
            }
            return dirs;
        }
        return new Directory[0];
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean RecursiveSearch) {
        return this.getChildren(RecursiveSearch, null, true);
    }

    public List getChildren(boolean RecursiveSearch, Object filter) {
        return this.getChildren(RecursiveSearch, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren(boolean RecursiveSearch, Object filter, boolean wait) {
        if (this.exists()) {
            if (RecursiveSearch) {
                LinkedList items = new LinkedList();
                if (!this.useCache) {
                    DirectorySearch.deleteCache();
                    FileFilter fileFilter = new FileFilter(filter);
                    long directoryID = Long.valueOf(Calendar.getInstance().getTimeInMillis() + "" + new Random().nextInt(100000));
                    int numThreads = 20;
                    DirectorySearch search = new DirectorySearch(fileFilter, items, directoryID, numThreads);
                    for (int i = 0; i < numThreads; ++i) {
                        Thread t = new Thread(search);
                        t.setName("DirectorySearch_" + directoryID + "-" + i);
                        t.start();
                    }
                    DirectorySearch.updatePool(this);
                    if (wait) {
                        LinkedList linkedList = items;
                        synchronized (linkedList) {
                            while (!items.contains(null)) {
                                try {
                                    items.wait();
                                }
                                catch (InterruptedException e) {
                                    DirectorySearch.stop();
                                    Thread.currentThread().interrupt();
                                    return items;
                                }
                            }
                            items.remove(null);
                            items.notifyAll();
                        }
                        Collections.sort(items, new FileComparer(this));
                    }
                }
                return items;
            }
            LinkedList<Comparable> results = new LinkedList<Comparable>();
            Object[] files = this.listFiles(new FileFilter(filter));
            if (files == null) {
                if (!wait) {
                    results.add(null);
                }
                return results;
            }
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory = false;
                java.io.File file = null;
                if (files[i] instanceof java.io.File) {
                    file = (java.io.File)files[i];
                    isDirectory = file.isDirectory();
                } else {
                    file = new java.io.File(files[i].toString());
                    isDirectory = files[i].toString().replace("\\", "/").endsWith("/");
                }
                if (isDirectory) {
                    results.add(new Directory(file));
                    continue;
                }
                results.add(new File(file));
            }
            Collections.sort(results, new FileComparer(this));
            if (!wait) {
                results.add(null);
            }
            return results;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (!wait) {
            list.add(null);
        }
        return list;
    }

    private java.io.File[] getSharedDrives(String serverName) {
        if (isWindows) {
            if ((serverName = serverName.replace("/", "\\\\")).startsWith("\\\\")) {
                serverName = serverName.substring(2);
            }
            if (serverName.contains("\\")) {
                serverName = serverName.substring(0, serverName.indexOf("\\"));
            }
            boolean doNetView = false;
            if (File.loadDLL()) {
                try {
                    String drives = File.GetSharedDrives(serverName);
                    if (drives != null) {
                        ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                        for (String drive : drives.split("\n")) {
                            if ((drive = drive.trim()).length() <= 0) continue;
                            String[] arr = drive.split("\t");
                            files.add(new java.io.File("\\\\" + serverName + "\\" + arr[0]));
                        }
                        if (files.isEmpty()) {
                            return null;
                        }
                        return files.toArray(new java.io.File[files.size()]);
                    }
                }
                catch (Exception e) {
                    doNetView = true;
                }
            } else {
                doNetView = true;
            }
            if (doNetView) {
                Shell cmd = new Shell("net view " + serverName);
                cmd.run();
                List errors = cmd.getErrors();
                errors.remove(null);
                if (errors.isEmpty()) {
                    String path = "\\\\" + serverName + "\\";
                    Vector<String> output = cmd.getOutput();
                    Vector<String> tmp = new Vector<String>();
                    for (String row : output) {
                        if (row == null || row.trim().length() == 0) continue;
                        tmp.add(row);
                    }
                    output = tmp;
                    tmp = null;
                    ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                    int x = 0;
                    int len = -1;
                    for (String row : output) {
                        if (row.startsWith("---")) {
                            String colHeader = (String)output.get(x - 1);
                            if (colHeader.startsWith("Share name") && colHeader.contains("Type")) {
                                len = colHeader.indexOf("Type");
                            }
                        } else {
                            if (row.startsWith("The command completed successfully.")) break;
                            if (len > 0 && row.length() > len) {
                                String type = row.substring(len);
                                if ((type = type.substring(0, type.indexOf(" "))).equalsIgnoreCase("Disk")) {
                                    files.add(new java.io.File(path + row.substring(0, len).trim()));
                                }
                            }
                        }
                        ++x;
                    }
                    if (files.isEmpty()) {
                        return null;
                    }
                    return files.toArray(new java.io.File[files.size()]);
                }
            }
        }
        return null;
    }

    protected Object[] listFiles() {
        return this.listFiles(null);
    }

    private Object[] listFiles(Object filter) {
        FileFilter fileFilter = filter instanceof FileFilter ? (FileFilter)filter : new FileFilter(filter);
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                java.io.File[] sharedDrives = this.getSharedDrives(path);
                if (sharedDrives != null) {
                    ArrayList<java.io.File> files = new ArrayList<java.io.File>();
                    for (java.io.File file : sharedDrives) {
                        if (!file.exists()) continue;
                        if (fileFilter == null) {
                            files.add(file);
                            continue;
                        }
                        if (!fileFilter.accept(file)) continue;
                        files.add(file);
                    }
                    return files.toArray(new java.io.File[files.size()]);
                }
                return null;
            }
        }
        ArrayList<Object> files = new ArrayList<Object>();
        if (isWindows) {
            path = this.getPath();
            String[] list = this.dir();
            for (int i = 0; i < list.length; ++i) {
                boolean isDirectory = list[i].endsWith("\\");
                if (fileFilter == null || isDirectory) {
                    files.add(path + list[i]);
                    continue;
                }
                if (fileFilter.usesIOFilter()) {
                    java.io.File file = new java.io.File(path + list[i]);
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                    continue;
                }
                if (!fileFilter.accept(list[i])) continue;
                files.add(path + list[i]);
            }
        } else {
            java.io.File[] fs = this.Directory.listFiles();
            if (fs != null) {
                for (int i = 0; i < fs.length; ++i) {
                    java.io.File file = fs[i];
                    if (fileFilter == null) {
                        files.add(file);
                        continue;
                    }
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                }
            }
        }
        if (files.size() < 1) {
            return null;
        }
        Collections.sort(files, new FileComparer(null));
        return files.toArray(new Object[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private String[] dir() {
        files = new ArrayList<String>();
        doDir = false;
        if (File.loadDLL()) {
            try {
                list = File.GetFiles(this.getPath() + "*");
                if (list == null) ** GOTO lbl17
                for (String name : list.split("\n")) {
                    if ((name = name.trim()).length() <= 0 || name.equals(".\\") || name.equals("..\\")) continue;
                    files.add(name);
                }
            }
            catch (Exception e) {
                doDir = true;
            }
        } else {
            doDir = true;
        }
lbl17:
        // 4 sources

        if (doDir) {
            try {
                path = this.getPath();
                if (path.contains(" ")) {
                    path = "\"" + path + "\"";
                }
                cmd = new Shell("cmd.exe /c dir /OG " + path);
                output = cmd.getOutput();
                cmd.run(true);
                parseFiles = false;
                colWidth = -1;
                while (true) {
                    var9_14 = output;
                    synchronized (var9_14) {
                        while (output.isEmpty()) {
                            output.wait();
                        }
                        line = (String)output.remove(0);
                    }
                    if (line != null) {
                        if (line.length() == 0 || line.startsWith(" ")) {
                            if (!parseFiles) continue;
                            parseFiles = false;
                            continue;
                        }
                        if (!parseFiles) {
                            parseFiles = true;
                        }
                        if (!parseFiles) continue;
                        if (colWidth < 0) {
                            offset = 20;
                            type = line.substring(offset);
                            if (type.trim().startsWith("<")) {
                                offset += type.indexOf(">") + 1;
                                type = type.substring(type.indexOf("<"), type.indexOf(">") + 1);
                            } else {
                                type = "";
                            }
                            isDirectory = type.contains("<DIR>");
                            isSymLink = type.contains("<SYMLINK>");
                            isJunction = type.contains("<JUNCTION>");
                            name = line.substring(offset);
                            while (name.substring(0, 1).equals(" ")) {
                                name = name.substring(1);
                                ++offset;
                            }
                            colWidth = isDirectory || isSymLink || isJunction ? offset : (name.contains(" ") ? (this.isNumeric(name.substring(0, name.indexOf(" "))) ? offset + name.indexOf(" ") + 1 : offset) : offset);
                        }
                        if (colWidth <= 0) continue;
                        name = line.substring(colWidth);
                        type = line.substring(20, colWidth);
                        isDirectory = type.contains("<DIR>");
                        isSymLink = type.contains("<SYMLINK>");
                        isJunction = type.contains("<JUNCTION>");
                        if (isDirectory) {
                            if (name.equals(".") || name.equals("..")) continue;
                            files.add(name + javaxt.io.Directory.PathSeparator);
                            continue;
                        }
                        if (isSymLink || isJunction) {
                            file = null;
                            if (name.contains("[") && name.contains("]")) {
                                link = name.substring(name.indexOf("[") + 1, name.indexOf("]"));
                                name = name.substring(0, name.indexOf("[")).trim();
                                file = new java.io.File(link);
                            } else {
                                file = new java.io.File(path, name);
                            }
                            if (file.isDirectory()) {
                                name = name + javaxt.io.Directory.PathSeparator;
                            }
                            files.add(name);
                            continue;
                        }
                        files.add(name);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return files.toArray(new String[files.size()]);
    }

    private boolean isNumeric(String str) {
        try {
            if (str.contains(",")) {
                str = str.replace(",", "");
            }
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void useCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.Directory.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Directory) {
            return this.Directory.equals(((Directory)obj).toFile());
        }
        if (obj instanceof java.io.File) {
            if (((java.io.File)obj).isDirectory()) {
                return this.Directory.equals(obj);
            }
            return false;
        }
        return false;
    }

    public List getEvents() throws Exception {
        if (this.FileSystemWatcher == null) {
            this.FileSystemWatcher = new FileSystemWatcher(this);
            new Thread(this.FileSystemWatcher).start();
        }
        return events;
    }

    public void stop() {
        if (this.FileSystemWatcher != null) {
            this.FileSystemWatcher.stop();
        }
        try {
            DirectorySearch.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    protected void addEvent(String event) {
        new Event(event);
    }

    protected void addEvent(String action, String file) {
        new Event(action, file);
    }

    private class FileComparer
    implements Comparator {
        private int z;

        public FileComparer(Directory dir) {
            this.z = dir == null ? 0 : dir.toString().replace("\\", "/").length();
        }

        public final int compare(Object a, Object b) {
            String dir2;
            String x = a.toString().toUpperCase();
            String y = b.toString().toUpperCase();
            x = x.replace("\\", "/").substring(this.z);
            y = y.replace("\\", "/").substring(this.z);
            if (!x.contains("/") || !y.contains("/")) {
                if (!x.contains("/") && !y.contains("/")) {
                    return x.compareTo(y) * 10000;
                }
                return 100000;
            }
            String dir1 = x.substring(0, x.lastIndexOf("/"));
            if (!dir1.equals(dir2 = y.substring(0, y.lastIndexOf("/")))) {
                return dir1.compareTo(dir2);
            }
            return x.compareTo(y);
        }
    }

    public class Event {
        private String file;
        private String orgFile;
        private java.util.Date date;
        private String action;
        public static final int DELETE = 0;
        public static final int CREATE = 1;
        public static final int RENAME = 2;
        public static final int MODIFY = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String event) {
            block18: {
                if (event != null && (event = event.trim()).length() == 0) {
                    event = null;
                }
                if (event != null) {
                    try {
                        String date = event.substring(1, event.indexOf("]")).trim();
                        String text = event.substring(event.indexOf("]") + 1).trim();
                        String path = text.substring(text.indexOf(" ")).trim();
                        String action = text.substring(0, text.indexOf(" ")).trim();
                        boolean exists = true;
                        boolean isDirectory = false;
                        try {
                            isDirectory = new File.FileAttributes(path).isDirectory();
                        }
                        catch (Exception e) {
                            exists = false;
                        }
                        this.date = this.parseDate(date);
                        this.file = path;
                        this.action = action;
                        boolean updateEvents = true;
                        if (action.equalsIgnoreCase("modify")) {
                            if (isDirectory || !exists) {
                                updateEvents = false;
                            } else if (Directory.this.LastEvent != null) {
                                if (Directory.this.LastEvent.getFile().equals(this.file) && Directory.this.LastEvent.getDate().equals(this.date)) {
                                    updateEvents = false;
                                }
                                Directory.this.LastEvent = null;
                            } else {
                                Directory.this.LastEvent = this;
                            }
                        }
                        if (action.equalsIgnoreCase("rename")) {
                            updateEvents = false;
                            Directory.this.LastEvent = this;
                        } else if (action.equalsIgnoreCase("renam2") && Directory.this.LastEvent != null) {
                            this.orgFile = Directory.this.LastEvent.getFile();
                            this.action = "Rename";
                            Directory.this.LastEvent = null;
                        }
                        if (!updateEvents) break block18;
                        List list = events;
                        synchronized (list) {
                            events.add(this);
                            events.notifyAll();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String action, String file) {
            this.date = new java.util.Date();
            this.action = action;
            this.file = file;
            List list = events;
            synchronized (list) {
                events.add(this);
                events.notifyAll();
            }
        }

        private java.util.Date parseDate(String date) {
            try {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getAction() {
            return this.action;
        }

        public String getFile() {
            return this.file;
        }

        public String getOriginalFile() {
            return this.orgFile;
        }

        public final int getEventID() {
            if (this.action.equalsIgnoreCase("create")) {
                return 1;
            }
            if (this.action.equalsIgnoreCase("delete")) {
                return 0;
            }
            if (this.action.equalsIgnoreCase("modify")) {
                return 3;
            }
            if (this.action.equalsIgnoreCase("rename")) {
                return 2;
            }
            return -1;
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public String toString() {
            if (this.action.equalsIgnoreCase("rename")) {
                return "[" + this.date.toString() + "] " + this.action + " " + this.orgFile + " To " + this.file;
            }
            return "[" + this.date.toString() + "] " + this.action + " " + this.file;
        }

        public boolean equals(Object obj) {
            Event event;
            return obj instanceof Event && (event = (Event)obj).getFile().equals(this.file) && event.getDate().equals(this.date) && event.getAction().equals(this.action);
        }
    }
}

