/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.SQLException;

public class Driver {
    private String vendor;
    private String driver;
    private String protocol;
    private java.sql.Driver Driver = null;
    private static Driver[] drivers = new Driver[]{new Driver("SQLServer", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver"), new Driver("DB2", "com.ibm.db2.jcc.DB2Driver", "jdbc:db2"), new Driver("Sybase", "com.sybase.jdbc3.jdbc.SybDriver", "jdbc:sybase"), new Driver("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql"), new Driver("Derby", "org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby"), new Driver("SQLite", "org.sqlite.JDBC", "jdbc:sqlite"), new Driver("Microsoft Access", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)}"), new Driver("FrontBase", "com.frontbase.jdbc.FBJDriver", "jdbc:FrontBase"), new Driver("Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli"), new Driver("Cache", "com.intersys.jdbc.CacheDriver", "jdbc:Cache"), new Driver("microsoft", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft"), new Driver("Mimer", "com.mimer.jdbc.Driver", "jdbc:mimer"), new Driver("MySQL", "com.mysql.jdbc.Driver", "jdbc:mysql"), new Driver("Teradata", "com.ncr.teradata.TeraDriver", "jdbc:teradata"), new Driver("Pervasive", "com.pervasive.jdbc.v2.Driver", "jdbc:pervasive"), new Driver("Pointbase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase"), new Driver("pointbase micro", "com.pointbase.me.jdbc.jdbcDriver", "jdbc:pointbase:micro"), new Driver("Daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "jdbc:daffodil"), new Driver("daffodilDB", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "jdbc:daffodilDB"), new Driver("JTDS", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds"), new Driver("Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle"), new Driver("derby net", "org.apache.derby.jdbc.ClientDriver", "jdbc:derby:net"), new Driver("Firebird", "org.firebirdsql.jdbc.FBDriver", "jdbc:firebirdsql"), new Driver("H2", "org.h2.Driver", "jdbc:h2"), new Driver("HyperSQL", "org.hsqldb.jdbcDriver", "jdbc:hsqldb"), new Driver("odbc", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc")};
    public static Driver SQLServer = javaxt.sql.Driver.findDriver("SQLServer");
    public static Driver DB2 = javaxt.sql.Driver.findDriver("DB2");
    public static Driver Sybase = javaxt.sql.Driver.findDriver("Sybase");
    public static Driver PostgreSQL = javaxt.sql.Driver.findDriver("PostgreSQL");
    public static Driver Derby = javaxt.sql.Driver.findDriver("Derby");
    public static Driver SQLite = javaxt.sql.Driver.findDriver("SQLite");
    public static Driver Access = javaxt.sql.Driver.findDriver("Microsoft Access");
    public static Driver FrontBase = javaxt.sql.Driver.findDriver("FrontBase");
    public static Driver Informix = javaxt.sql.Driver.findDriver("Informix");
    public static Driver Cache = javaxt.sql.Driver.findDriver("Cache");
    public static Driver Mimer = javaxt.sql.Driver.findDriver("Mimer");
    public static Driver MySQL = javaxt.sql.Driver.findDriver("MySQL");
    public static Driver Teradata = javaxt.sql.Driver.findDriver("Teradata");
    public static Driver Pervasive = javaxt.sql.Driver.findDriver("Pervasive");
    public static Driver Pointbase = javaxt.sql.Driver.findDriver("Pointbase");
    public static Driver Daffodil = javaxt.sql.Driver.findDriver("Daffodil");
    public static Driver JTDS = javaxt.sql.Driver.findDriver("JTDS");
    public static Driver Oracle = javaxt.sql.Driver.findDriver("Oracle");
    public static Driver Firebird = javaxt.sql.Driver.findDriver("Firebird");
    public static Driver H2 = javaxt.sql.Driver.findDriver("H2");
    public static Driver HyperSQL = javaxt.sql.Driver.findDriver("HyperSQL");
    public static Driver ODBC = javaxt.sql.Driver.findDriver("odbc");

    public Driver(String vendor, String driver, String protocol) {
        this.vendor = vendor;
        this.driver = driver;
        this.protocol = protocol;
    }

    public Driver(java.sql.Driver driver) {
        String className;
        this.driver = className = driver.getClass().getCanonicalName();
        this.Driver = driver;
        Driver d = javaxt.sql.Driver.findDriver(className);
        if (d != null) {
            this.vendor = d.vendor;
            this.protocol = d.protocol;
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getClassName() {
        return this.driver;
    }

    public String getVendor() {
        return this.vendor;
    }

    public java.sql.Driver load() throws SQLException {
        if (this.Driver == null) {
            try {
                this.Driver = (java.sql.Driver)Class.forName(this.driver).newInstance();
            }
            catch (Exception e) {
                throw new SQLException("Failed to load driver " + this.driver, e);
            }
        }
        return this.Driver;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Driver) {
            Driver driver = (Driver)obj;
            return driver.getClassName().equalsIgnoreCase(this.getClassName()) && driver.getProtocol().toLowerCase().startsWith(this.getProtocol()) && driver.getVendor().equalsIgnoreCase(this.getVendor());
        }
        if (obj instanceof String) {
            String driverName = obj.toString();
            return driverName.equalsIgnoreCase(this.getClassName()) || driverName.toLowerCase().startsWith(this.getProtocol().toLowerCase()) || driverName.equalsIgnoreCase(this.getVendor());
        }
        return false;
    }

    public static Driver findDriver(String driverName) {
        for (Driver driver : drivers) {
            if (!driver.equals(driverName)) continue;
            return driver;
        }
        if (driverName.contains(".")) {
            try {
                return new Driver((java.sql.Driver)Class.forName(driverName).newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        return this.getVendor();
    }
}

