/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import javaxt.io.DirectorySearch;
import javaxt.io.File;
import javaxt.io.FileFilter;
import javaxt.io.FileSystemWatcher;
import javaxt.io.Shell;
import javaxt.utils.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
implements Comparable {
    private java.io.File Directory;
    private boolean useCache = false;
    private static List events = new LinkedList();
    private FileSystemWatcher FileSystemWatcher;
    public static final String PathSeparator = System.getProperty("file.separator");
    protected static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    private Event LastEvent = null;

    public Directory(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.Directory = new java.io.File(Path2);
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public Directory(java.io.File File2) {
        this.Directory = File2;
        if (this.Directory.exists() && !this.Directory.isDirectory()) {
            this.Directory = this.Directory.getParentFile();
        }
    }

    public static Directory[] getRootDirectories() {
        TreeSet<Directory> directories = new TreeSet<Directory>();
        java.io.File[] files = java.io.File.listRoots();
        if (files == null) {
            return new Directory[0];
        }
        for (int i = 0; i < files.length; ++i) {
            directories.add(new Directory(files[i]));
        }
        if (isWindows) {
            String line;
            Shell cmd = new Shell("net use");
            cmd.run();
            Iterator it = cmd.getOutput().iterator();
            boolean parse = false;
            while (it.hasNext() && (line = (String)it.next()) != null) {
                line = line.trim();
                if (!parse && line.startsWith("----")) {
                    parse = true;
                    line = (String)it.next();
                    if (line == null) break;
                }
                if (!line.contains(":")) continue;
                line = line.substring(0, line.indexOf(":") + 1);
                line = line.substring(line.lastIndexOf(" ") + 1);
                directories.add(new Directory(line.trim()));
            }
        }
        return directories.toArray(new Directory[directories.size()]);
    }

    public boolean exists() {
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                Shell cmd = new Shell("net view " + path);
                cmd.run();
                List errors = cmd.getErrors();
                errors.remove(null);
                return errors.isEmpty();
            }
        }
        return this.Directory.exists();
    }

    public boolean create() {
        return this.Directory.mkdirs();
    }

    public boolean delete() {
        return this.Directory.delete();
    }

    public String[] copyTo(Directory Destination, boolean Overwrite) {
        int source = this.toString().length();
        String destination = Destination.toString();
        Vector<String> vec = new Vector<String>();
        Directory[] Directories = this.getSubDirectories(true);
        for (int i = 0; i < Directories.length; ++i) {
            new Directory(destination + Directories[i].toString().substring(source)).create();
        }
        File[] Files = this.getFiles(true);
        for (int i = 0; i < Files.length; ++i) {
            String FilePath = Files[i].toString();
            File out = new File(destination + FilePath.substring(source));
            boolean CopiedFile = Files[i].copyTo(out, Overwrite);
            if (CopiedFile) continue;
            vec.add(FilePath);
        }
        Object[] arr = vec.toArray();
        String[] ret = new String[arr.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)arr[i];
        }
        return ret;
    }

    public void moveTo(Directory Destination, boolean Overwrite) {
        if (Overwrite) {
            this.Directory.renameTo(Destination.toFile());
        } else if (!Destination.exists()) {
            this.Directory.renameTo(Destination.toFile());
        }
    }

    public void rename(String Name) {
        String path = this.getParentDirectory().getPath() + Name;
        this.Directory.renameTo(new java.io.File(path));
    }

    public String getName() {
        return this.Directory.getName();
    }

    public String getPath() {
        String path = "";
        try {
            path = this.Directory.getCanonicalPath().toString();
        }
        catch (Exception e) {
            path = this.Directory.toString();
        }
        if (path.endsWith(java.io.File.separator)) {
            return path;
        }
        return path + java.io.File.separator;
    }

    public java.util.Date getDate() {
        return new Date(this.Directory.lastModified()).getDate();
    }

    public void setDate(java.util.Date lastModified) {
        long t = lastModified.getTime();
        if (this.Directory.lastModified() != t) {
            this.Directory.setLastModified(t);
        }
    }

    public long getSize() {
        return this.Directory.length();
    }

    public boolean isHidden() {
        return this.Directory.isHidden();
    }

    public boolean isLink() {
        return new File(this).isLink();
    }

    public java.io.File getLink() {
        return new File(this).getLink();
    }

    public java.util.Date getLastModifiedTime() {
        return this.getDate();
    }

    public java.util.Date getCreationTime() {
        return new File(this).getCreationTime();
    }

    public java.util.Date getLastAccessTime() {
        return new File(this).getLastAccessTime();
    }

    public java.util.Date getLastWriteTime() {
        return new File(this).getLastWriteTime();
    }

    public HashSet<String> getFlags() {
        return new File(this).getFlags();
    }

    public File.FileAttributes getFileAttributes() throws Exception {
        return new File(this).getFileAttributes();
    }

    public Directory getParentDirectory() {
        if (this.Directory.getParentFile() != null) {
            return new Directory(this.Directory.getParentFile());
        }
        return null;
    }

    public java.io.File toFile() {
        return this.Directory;
    }

    public File[] getFiles(Object filter) {
        if (this.Directory.exists()) {
            FileFilter fileFilter = new FileFilter(filter);
            Object[] files = this.listFiles(fileFilter);
            if (files == null) {
                return new File[0];
            }
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < files.length; ++i) {
                java.io.File file = null;
                file = files[i] instanceof java.io.File ? (java.io.File)files[i] : new java.io.File(files[i].toString());
                if (!file.exists() || !file.isFile()) continue;
                list.add(new File(file));
            }
            Collections.sort(list, new FileComparer(this));
            return list.toArray(new File[list.size()]);
        }
        return new File[0];
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getFiles(Object filter, boolean RecursiveSearch) {
        if (this.Directory.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, filter, false);
                ArrayList<File> files = new ArrayList<File>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof File)) continue;
                            files.add((File)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                Collections.sort(files, new FileComparer(this));
                return files.toArray(new File[files.size()]);
            }
            return this.getFiles(filter);
        }
        return new File[0];
    }

    public File[] getFiles(boolean RecursiveSearch) {
        return this.getFiles(null, RecursiveSearch);
    }

    public Directory[] getSubDirectories() {
        return this.getSubDirectories(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory[] getSubDirectories(boolean RecursiveSearch) {
        if (this.exists()) {
            if (RecursiveSearch) {
                List items = this.getChildren(true, null, false);
                ArrayList<Directory> directories = new ArrayList<Directory>();
                try {
                    while (true) {
                        Object item;
                        List list = items;
                        synchronized (list) {
                            while (items.isEmpty()) {
                                items.wait();
                            }
                            item = items.remove(0);
                            items.notifyAll();
                        }
                        if (item != null) {
                            if (!(item instanceof Directory)) continue;
                            directories.add((Directory)item);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return directories.toArray(new Directory[directories.size()]);
            }
            java.io.FileFilter fileFilter = new java.io.FileFilter(){

                public boolean accept(java.io.File file) {
                    return file.isDirectory();
                }
            };
            Object[] files = this.listFiles(new FileFilter(fileFilter));
            if (files == null) {
                return new Directory[0];
            }
            Directory[] dirs = new Directory[files.length];
            for (int i = 0; i < files.length; ++i) {
                dirs[i] = new Directory(files[i].toString());
            }
            return dirs;
        }
        return new Directory[0];
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean RecursiveSearch) {
        return this.getChildren(RecursiveSearch, null, true);
    }

    public List getChildren(boolean RecursiveSearch, Object filter) {
        return this.getChildren(RecursiveSearch, filter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren(boolean RecursiveSearch, Object filter, boolean wait) {
        if (this.exists()) {
            if (RecursiveSearch) {
                LinkedList items = new LinkedList();
                if (!this.useCache) {
                    DirectorySearch.deleteCache();
                    FileFilter fileFilter = new FileFilter(filter);
                    long directoryID = Long.valueOf(Calendar.getInstance().getTimeInMillis() + "" + new Random().nextInt(100000));
                    int numThreads = 20;
                    DirectorySearch search = new DirectorySearch(fileFilter, items, directoryID, numThreads);
                    for (int i = 0; i < numThreads; ++i) {
                        Thread t = new Thread(search);
                        t.setName("DirectorySearch_" + directoryID + "-" + i);
                        t.start();
                    }
                    DirectorySearch.updatePool(this);
                    if (wait) {
                        LinkedList linkedList = items;
                        synchronized (linkedList) {
                            while (!items.contains(null)) {
                                try {
                                    items.wait();
                                }
                                catch (InterruptedException e) {
                                    DirectorySearch.stop();
                                    Thread.currentThread().interrupt();
                                    return items;
                                }
                            }
                            items.remove(null);
                            items.notifyAll();
                        }
                        Collections.sort(items, new FileComparer(this));
                    }
                }
                return items;
            }
            LinkedList<Comparable> results = new LinkedList<Comparable>();
            Object[] files = this.listFiles(new FileFilter(filter));
            if (files == null) {
                if (!wait) {
                    results.add(null);
                }
                return results;
            }
            for (int i = 0; i < files.length; ++i) {
                boolean isDirectory = false;
                java.io.File file = null;
                if (files[i] instanceof java.io.File) {
                    file = (java.io.File)files[i];
                    isDirectory = file.isDirectory();
                } else {
                    file = new java.io.File(files[i].toString());
                    isDirectory = files[i].toString().replace("\\", "/").endsWith("/");
                }
                if (isDirectory) {
                    results.add(new Directory(file));
                    continue;
                }
                results.add(new File(file));
            }
            Collections.sort(results, new FileComparer(this));
            if (!wait) {
                results.add(null);
            }
            return results;
        }
        LinkedList<Object> list = new LinkedList<Object>();
        if (!wait) {
            list.add(null);
        }
        return list;
    }

    protected Object[] listFiles() {
        return this.listFiles(null);
    }

    private Object[] listFiles(Object filter) {
        FileFilter fileFilter = filter instanceof FileFilter ? (FileFilter)filter : new FileFilter(filter);
        String path = this.Directory.toString();
        if (isWindows && path.startsWith("\\\\")) {
            if (path.endsWith(PathSeparator)) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.substring(2).contains(PathSeparator)) {
                Shell cmd = new Shell("net view " + path);
                cmd.run();
                List errors = cmd.getErrors();
                errors.remove(null);
                if (errors.isEmpty()) {
                    path = path + PathSeparator;
                    Vector<String> output = cmd.getOutput();
                    Vector<String> tmp = new Vector<String>();
                    for (String row : output) {
                        if (row == null || row.trim().length() == 0) continue;
                        tmp.add(row);
                    }
                    output = tmp;
                    tmp = null;
                    Vector<java.io.File> files = new Vector<java.io.File>();
                    int x = 0;
                    int len = -1;
                    for (String row : output) {
                        java.io.File file;
                        String colHeader;
                        if (row.startsWith("---") && (colHeader = (String)output.get(x - 1)).startsWith("Share name") && colHeader.contains("Type")) {
                            len = colHeader.indexOf("Type");
                        }
                        if (len > 0 && row.length() > len && (file = new java.io.File(row = path + row.substring(0, len).trim())).exists()) {
                            if (fileFilter == null) {
                                files.add(new java.io.File(row));
                            } else if (fileFilter.accept(file)) {
                                files.add(new java.io.File(row));
                            }
                        }
                        if (row.startsWith("The command completed successfully.")) break;
                        ++x;
                    }
                    Object[] arr = new java.io.File[files.size()];
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = (java.io.File)files.get(i);
                    }
                    return arr;
                }
            }
        }
        ArrayList<Object> files = new ArrayList<Object>();
        path = this.getPath();
        String[] list = null;
        if (isWindows) {
            list = this.dir();
            if (list == null) {
                return null;
            }
            for (int i = 0; i < list.length; ++i) {
                boolean isDirectory = list[i].endsWith("\\");
                if (fileFilter == null || isDirectory) {
                    files.add(path + list[i]);
                    continue;
                }
                if (fileFilter.usesIOFilter()) {
                    java.io.File file = new java.io.File(path + list[i]);
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                    continue;
                }
                if (!fileFilter.accept(list[i])) continue;
                files.add(path + list[i]);
            }
        } else {
            java.io.File[] fs = this.Directory.listFiles();
            if (fs != null) {
                for (int i = 0; i < fs.length; ++i) {
                    java.io.File file = fs[i];
                    if (fileFilter == null) {
                        files.add(file);
                        continue;
                    }
                    if (!fileFilter.accept(file)) continue;
                    files.add(file);
                }
            }
        }
        if (files.size() < 1) {
            return null;
        }
        Collections.sort(files, new FileComparer(null));
        return files.toArray(new Object[files.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ls() {
        ArrayList<String> files = new ArrayList<String>();
        try {
            String path = this.getPath();
            String[] params = new String[]{"ls", "-ap", path};
            Shell cmd = new Shell(params);
            List output = cmd.getOutput();
            cmd.run(true);
            while (true) {
                String line;
                List list = output;
                synchronized (list) {
                    while (output.isEmpty()) {
                        output.wait();
                    }
                    line = (String)output.remove(0);
                }
                if (line != null) {
                    if ((line = line.trim()).length() <= 0 || line.equals("./") || line.equals("../")) continue;
                    files.add(line);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        String[] arr = new String[files.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (String)files.get(i);
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] dir() {
        ArrayList<String> files = new ArrayList<String>();
        try {
            String path = this.getPath();
            if (path.contains(" ")) {
                path = "\"" + path + "\"";
            }
            Shell cmd = new Shell("cmd.exe /c dir /OG " + path);
            List output = cmd.getOutput();
            cmd.run(true);
            boolean parseFiles = false;
            int colWidth = -1;
            while (true) {
                String line;
                List list = output;
                synchronized (list) {
                    while (output.isEmpty()) {
                        output.wait();
                    }
                    line = (String)output.remove(0);
                }
                if (line != null) {
                    boolean isJunction;
                    boolean isSymLink;
                    boolean isDirectory;
                    String type;
                    if (line.length() == 0 || line.startsWith(" ")) {
                        if (!parseFiles) continue;
                        parseFiles = false;
                        continue;
                    }
                    if (!parseFiles) {
                        parseFiles = true;
                    }
                    if (!parseFiles) continue;
                    if (colWidth < 0) {
                        int offset = 20;
                        type = line.substring(offset);
                        if (type.trim().startsWith("<")) {
                            offset += type.indexOf(">") + 1;
                            type = type.substring(type.indexOf("<"), type.indexOf(">") + 1);
                        } else {
                            type = "";
                        }
                        isDirectory = type.contains("<DIR>");
                        isSymLink = type.contains("<SYMLINK>");
                        isJunction = type.contains("<JUNCTION>");
                        String name = line.substring(offset);
                        while (name.substring(0, 1).equals(" ")) {
                            name = name.substring(1);
                            ++offset;
                        }
                        colWidth = isDirectory || isSymLink || isJunction ? offset : (name.contains(" ") ? (this.isNumeric(name.substring(0, name.indexOf(" "))) ? offset + name.indexOf(" ") + 1 : offset) : offset);
                    }
                    if (colWidth <= 0) continue;
                    String name = line.substring(colWidth);
                    type = line.substring(20, colWidth);
                    isDirectory = type.contains("<DIR>");
                    isSymLink = type.contains("<SYMLINK>");
                    isJunction = type.contains("<JUNCTION>");
                    if (isDirectory) {
                        if (name.equals(".") || name.equals("..")) continue;
                        files.add(name + PathSeparator);
                        continue;
                    }
                    if (isSymLink || isJunction) {
                        java.io.File file = null;
                        if (name.contains("[") && name.contains("]")) {
                            String link = name.substring(name.indexOf("[") + 1, name.indexOf("]"));
                            name = name.substring(0, name.indexOf("[")).trim();
                            file = new java.io.File(link);
                        } else {
                            file = new java.io.File(path, name);
                        }
                        if (file.isDirectory()) {
                            name = name + PathSeparator;
                        }
                        files.add(name);
                        continue;
                    }
                    files.add(name);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        String[] arr = new String[files.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (String)files.get(i);
        }
        return arr;
    }

    private boolean isNumeric(String str) {
        try {
            if (str.contains(",")) {
                str = str.replace(",", "");
            }
            Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void useCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.Directory.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Directory) {
            return this.Directory.equals(((Directory)obj).toFile());
        }
        if (obj instanceof java.io.File) {
            if (((java.io.File)obj).isDirectory()) {
                return this.Directory.equals(obj);
            }
            return false;
        }
        return false;
    }

    public List getEvents() throws Exception {
        if (this.FileSystemWatcher == null) {
            new Thread(new FileSystemWatcher(this)).start();
            this.FileSystemWatcher = this.FileSystemWatcher;
        }
        return events;
    }

    public void stop() {
        if (this.FileSystemWatcher != null) {
            this.FileSystemWatcher.stop();
        }
        DirectorySearch.stop();
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    protected void addEvent(String event) {
        new Event(event);
    }

    protected void addEvent(String action, java.io.File file) {
        new Event(action, file);
    }

    private class FileComparer
    implements Comparator {
        private int z;

        public FileComparer(Directory dir) {
            this.z = dir == null ? 0 : dir.toString().replace("\\", "/").length();
        }

        public final int compare(Object a, Object b) {
            String dir2;
            String x = a.toString().toUpperCase();
            String y = b.toString().toUpperCase();
            x = x.replace("\\", "/").substring(this.z);
            y = y.replace("\\", "/").substring(this.z);
            if (!x.contains("/") || !y.contains("/")) {
                if (!x.contains("/") && !y.contains("/")) {
                    return x.compareTo(y) * 10000;
                }
                return 100000;
            }
            String dir1 = x.substring(0, x.lastIndexOf("/"));
            if (!dir1.equals(dir2 = y.substring(0, y.lastIndexOf("/")))) {
                return dir1.compareTo(dir2);
            }
            return x.compareTo(y);
        }
    }

    public class Event {
        private java.io.File file;
        private java.io.File orgFile;
        private java.util.Date date;
        private String action;
        public static final int DELETE = 0;
        public static final int CREATE = 1;
        public static final int RENAME = 2;
        public static final int MODIFY = 3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String event) {
            block15: {
                if (event != null) {
                    event = event.trim();
                    try {
                        String date = event.substring(1, event.indexOf("]")).trim();
                        String text = event.substring(event.indexOf("]") + 1).trim();
                        String path = text.substring(text.indexOf(" ")).trim();
                        String action = text.substring(0, text.indexOf(" ")).trim();
                        this.date = this.parseDate(date);
                        this.file = new java.io.File(path);
                        this.action = action;
                        boolean updateEvents = true;
                        if (action.equalsIgnoreCase("modify")) {
                            if (this.file.isDirectory() || !this.file.exists()) {
                                updateEvents = false;
                            } else if (Directory.this.LastEvent != null) {
                                if (Directory.this.LastEvent.getFile().equals(this.file) && Directory.this.LastEvent.getDate().equals(this.date)) {
                                    updateEvents = false;
                                }
                                Directory.this.LastEvent = null;
                            } else {
                                Directory.this.LastEvent = this;
                            }
                        }
                        if (action.equalsIgnoreCase("rename")) {
                            updateEvents = false;
                            Directory.this.LastEvent = this;
                        } else if (action.equalsIgnoreCase("renam2") && Directory.this.LastEvent != null) {
                            this.orgFile = Directory.this.LastEvent.getFile();
                            this.action = "Rename";
                            Directory.this.LastEvent = null;
                        }
                        if (!updateEvents) break block15;
                        List list = events;
                        synchronized (list) {
                            events.add(this);
                            events.notifyAll();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Event(String action, java.io.File file) {
            this.date = new java.util.Date();
            this.action = action;
            this.file = file;
            List list = events;
            synchronized (list) {
                events.add(this);
                events.notifyAll();
            }
        }

        private java.util.Date parseDate(String date) {
            try {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy").parse(date);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getAction() {
            return this.action;
        }

        public java.io.File getFile() {
            return this.file;
        }

        public java.io.File getOriginalFile() {
            return this.orgFile;
        }

        public final int getEventID() {
            if (this.action.equalsIgnoreCase("create")) {
                return 1;
            }
            if (this.action.equalsIgnoreCase("delete")) {
                return 0;
            }
            if (this.action.equalsIgnoreCase("modify")) {
                return 3;
            }
            if (this.action.equalsIgnoreCase("rename")) {
                return 2;
            }
            return -1;
        }

        public java.util.Date getDate() {
            return this.date;
        }

        public String toString() {
            if (this.action.equalsIgnoreCase("rename")) {
                return "[" + this.date.toString() + "] " + this.action + " " + this.orgFile.getPath() + " To " + this.file.getPath();
            }
            return "[" + this.date.toString() + "] " + this.action + " " + this.file.getPath();
        }

        public boolean equals(Object obj) {
            Event event;
            return obj instanceof Event && (event = (Event)obj).getFile().equals(this.file) && event.getDate().equals(this.date) && event.getAction().equals(this.action);
        }
    }
}

