/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javaxt.io.Directory;
import javaxt.io.Image;
import javaxt.io.Jar;
import javaxt.io.Shell;
import javaxt.utils.Date;
import javaxt.xml.DOM;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Comparable {
    private java.io.File File;
    public final String PathSeparator = System.getProperty("file.separator");
    public final String LineSeperator = System.getProperty("line.separator");
    private static final boolean isWindows = Directory.isWindows;
    private int bufferSize = 0x100000;
    private static final boolean isFreeBSD = System.getProperty("os.name").toLowerCase().contains("freebsd");
    private static Boolean dllLoaded;
    private static final SimpleDateFormat ftFormatter;

    public File(String Path2) {
        if (Path2.startsWith("\"") && Path2.endsWith("\"")) {
            Path2 = Path2.substring(1, Path2.length() - 1);
        }
        this.File = new java.io.File(Path2);
    }

    public File(java.io.File File2) {
        if (File2.isDirectory()) {
            // empty if block
        }
        this.File = File2;
    }

    public File(java.io.File Parent, String Child) {
        this(new java.io.File(Parent, Child));
    }

    public File(Directory Parent, String Child) {
        this(new java.io.File(Parent.toFile(), Child));
    }

    public File(String Parent, String Child) {
        this(new java.io.File(new Directory(Parent).toFile(), Child));
    }

    protected File(Directory directory) {
        this.File = directory.toFile();
    }

    public String getName() {
        if (this.File != null) {
            return this.File.getName();
        }
        return "";
    }

    public String getName(boolean IncludeFileExtension) {
        String FileExt;
        String FileName = this.getName();
        if (!IncludeFileExtension && (FileExt = this.getExtension()).length() > 0) {
            FileName = FileName.substring(0, FileName.length() - (FileExt.length() + 1));
        }
        return FileName;
    }

    public String getPath() {
        if (this.File != null) {
            String path = "";
            try {
                path = this.File.getParentFile().getCanonicalPath().toString();
            }
            catch (Exception e) {
                path = this.File.getParentFile().toString();
            }
            if (!path.endsWith(this.PathSeparator)) {
                path = path + this.PathSeparator;
            }
            return path;
        }
        return "";
    }

    public Directory getDirectory() {
        return this.getParentDirectory();
    }

    public Directory getParentDirectory() {
        if (this.File != null) {
            return new Directory(this.getPath());
        }
        return null;
    }

    public java.io.File toFile() {
        return this.File;
    }

    public String getExtension() {
        String FileName = this.getName();
        if (FileName.contains(".")) {
            return FileName.substring(FileName.lastIndexOf(".") + 1, FileName.length());
        }
        return "";
    }

    public long getSize() {
        if (this.File != null) {
            return this.File.length();
        }
        return 0L;
    }

    public java.util.Date getDate() {
        if (this.File != null) {
            return new Date(this.File.lastModified()).getDate();
        }
        return null;
    }

    public void setDate(java.util.Date lastModified) {
        if (this.File != null) {
            long t = lastModified.getTime();
            if (this.File.lastModified() != t) {
                this.File.setLastModified(t);
            }
        }
    }

    public boolean exists() {
        if (this.File != null && this.File.isFile()) {
            return this.File.exists();
        }
        return false;
    }

    public boolean isHidden() {
        if (this.File != null) {
            return this.File.isHidden();
        }
        return false;
    }

    public boolean isReadOnly() {
        if (this.File != null) {
            return !this.File.canWrite();
        }
        return true;
    }

    public boolean isExecutable() {
        if (this.File != null) {
            String[] arr = System.getProperty("java.version").split("\\.");
            if (Integer.valueOf(arr[0]) == 1 && Integer.valueOf(arr[1]) < 6) {
                return false;
            }
            try {
                return (Boolean)this.File.getClass().getMethod("canExecute", new Class[0]).invoke((Object)this.File, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public boolean isLink() {
        if (this.File == null || !this.File.exists()) {
            return false;
        }
        if (this.getExtension().equalsIgnoreCase("lnk")) {
            return new LnkParser(this).getFile() != null;
        }
        if (isWindows) {
            HashSet<String> flags = this.getFlags();
            if (flags != null) {
                return flags.contains("REPARSE_POINT");
            }
        } else {
            try {
                return !this.File.getCanonicalFile().equals(this.File.getAbsoluteFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public java.io.File getLink() {
        if (this.File == null || !this.File.exists()) {
            return null;
        }
        if (this.getExtension().equalsIgnoreCase("lnk")) {
            return new LnkParser(this).getFile();
        }
        if (isWindows) {
            try {
                java.io.File link;
                if (javaxt.io.File.loadDLL() && (link = new java.io.File(javaxt.io.File.GetTarget(this.File.toString()))).exists()) {
                    return link;
                }
            }
            catch (Exception e) {}
        } else {
            try {
                if (!this.File.getCanonicalFile().equals(this.File.getAbsoluteFile())) {
                    return this.File.getCanonicalFile();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean delete() {
        if (this.File != null) {
            return this.File.delete();
        }
        return false;
    }

    public void setBufferSize(int numBytes) {
        this.bufferSize = numBytes;
    }

    public File moveTo(Directory Destination) {
        java.io.File Dir = Destination.toFile();
        Dir.mkdirs();
        File newFile = new File(Dir, this.File.getName());
        this.File.renameTo(newFile.toFile());
        this.File = newFile.toFile();
        return newFile;
    }

    public boolean copyTo(Directory Destination, boolean Overwrite) {
        File Output = new File(Destination, this.File.getName());
        return this.copyTo(Output, Overwrite);
    }

    public boolean copyTo(File Destination, boolean Overwrite) {
        System.out.println(Destination);
        if (!this.File.exists()) {
            return false;
        }
        if (Destination.exists() && !Overwrite) {
            return false;
        }
        if (this.File.equals(Destination.toFile())) {
            return false;
        }
        Destination.getParentDirectory().create();
        try {
            FileInputStream input = new FileInputStream(this.File);
            FileOutputStream output = new FileOutputStream(Destination.toFile());
            ReadableByteChannel inputChannel = Channels.newChannel(input);
            WritableByteChannel outputChannel = Channels.newChannel(output);
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSize);
            while (inputChannel.read(buffer) != -1) {
                buffer.flip();
                outputChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outputChannel.write(buffer);
            }
            inputChannel.close();
            outputChannel.close();
            Destination.toFile().setLastModified(this.File.lastModified());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public File rename(String FileName) {
        if (FileName != null && (FileName = FileName.trim()).length() > 0 && this.File != null) {
            File newFile = new File(this.getPath() + FileName);
            this.File.renameTo(newFile.toFile());
            this.File = newFile.toFile();
            return newFile;
        }
        return this;
    }

    public BufferedWriter getBufferedWriter(String charsetName) {
        try {
            this.File.getParentFile().mkdirs();
            if (charsetName == null) {
                return new BufferedWriter(new FileWriter(this.File));
            }
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.File), charsetName));
        }
        catch (Exception e) {
            return null;
        }
    }

    public BufferedReader getBufferedReader() {
        if (this.File.exists()) {
            try {
                return new BufferedReader(new FileReader(this.File));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedReader getBufferedReader(String charsetName) {
        if (this.File.exists()) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), charsetName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BufferedImage getBufferedImage() {
        Image img = this.getImage();
        if (img != null) {
            return img.getBufferedImage();
        }
        return null;
    }

    public Image getImage() {
        if (this.File.exists()) {
            return new Image(this.File);
        }
        return null;
    }

    public String getText() {
        try {
            return this.getText("UTF-8");
        }
        catch (Exception e) {
            try {
                return this.getBytes().toString();
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    public String getText(String charsetName) {
        try {
            return this.getBytes().toString(charsetName);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Document getXML() {
        try {
            return DOM.createDocument(this.getInputStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ByteArrayOutputStream getBytes() {
        if (this.File.exists()) {
            try {
                FileInputStream InputStream2 = new FileInputStream(this.File);
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                byte[] b = new byte[this.bufferSize];
                int x = 0;
                while ((x = InputStream2.read(b, 0, this.bufferSize)) > -1) {
                    bas.write(b, 0, x);
                }
                bas.close();
                InputStream2.close();
                return bas;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void write(ByteArrayOutputStream bas) {
        this.write(bas.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes) {
        if (this.File != null) {
            FileOutputStream output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new FileOutputStream(this.File);
                output.write(bytes);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream input) {
        if (this.File != null) {
            FileOutputStream output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new FileOutputStream(this.File);
                byte[] buf = new byte[this.bufferSize];
                int i = 0;
                while ((i = input.read(buf)) != -1) {
                    output.write(buf, 0, i);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(String Text2) {
        this.write(Text2, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String Text2, String charsetName) {
        if (this.File != null) {
            Writer output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = charsetName == null ? new BufferedWriter(new FileWriter(this.File)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.File), charsetName));
                output.write(Text2);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(Document xml) {
        this.write(DOM.getText(xml), xml.getXmlEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String[] Content) {
        if (this.File != null) {
            Writer output = null;
            try {
                this.File.getParentFile().mkdirs();
                output = new BufferedWriter(new FileWriter(this.File));
                for (int i = 0; i < Content.length - 1; ++i) {
                    output.write(Content[i] + this.LineSeperator);
                }
                output.write(Content[Content.length - 1]);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(BufferedImage Image2) {
        if (this.File != null) {
            try {
                this.File.getParentFile().mkdirs();
                BufferedImage rendImage = Image2;
                ImageIO.write((RenderedImage)rendImage, this.getExtension(), this.File);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String MapPath(String RelPath) {
        String currDir = this.getPath();
        if (!(currDir = currDir.replace("\\", "/")).endsWith("/")) {
            currDir = currDir + "/";
        }
        RelPath = RelPath.replace("\\", "/");
        String[] arrRelPath = RelPath.split("/");
        String[] arrAbsPath = currDir.split("/");
        int x = -1;
        RelPath = "";
        String Dir = "";
        for (int i = 0; i < arrRelPath.length; ++i) {
            Dir = arrRelPath[i];
            if (Dir.equals("..")) {
                ++x;
                continue;
            }
            if (Dir.equals(".")) continue;
            RelPath = RelPath + "\\" + arrRelPath[i];
        }
        Dir = "";
        boolean ubound = false;
        for (int i = 0; i < arrAbsPath.length - (x + 1); ++i) {
            Dir = Dir + arrAbsPath[i] + "\\";
        }
        Dir = Dir.substring(0, Dir.length() - 1);
        Dir = Dir + RelPath.replace("/", "\\");
        Dir = Dir.replace("\\", this.PathSeparator);
        return Dir;
    }

    public FileInputStream getInputStream() throws IOException {
        return new FileInputStream(this.File);
    }

    public FileOutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.File);
    }

    public String toString() {
        return this.File.toString();
    }

    public int hashCode() {
        return this.File.hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.getPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof File) {
            return this.File.equals(((File)obj).toFile());
        }
        if (obj instanceof java.io.File && ((java.io.File)obj).isFile()) {
            return this.File.equals(obj);
        }
        return false;
    }

    private boolean isValidPath(String PathToFile) {
        if (PathToFile == null) {
            return false;
        }
        if (PathToFile.length() < 1) {
            return false;
        }
        if (this.File.isDirectory()) {
            return false;
        }
        String FileName = this.File.getName();
        if (FileName.length() < 1) {
            return false;
        }
        if (FileName.length() > 260) {
            return false;
        }
        PathToFile = this.File.toString();
        PathToFile = PathToFile.replace("\\", "/");
        String[] Path2 = PathToFile.split("/");
        String[] arr = new String[]{"/", "?", "<", ">", "\\", ":", "*", "|", "\""};
        for (int i = 0; i < Path2.length; ++i) {
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j].equals(":") && i == 0 & Path2[i].length() == 2 || !Path2[i].contains(arr[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String getContentType() {
        if (this.extensionEquals("css")) {
            return "text/css";
        }
        if (this.extensionEquals("dtd")) {
            return "text/plain";
        }
        if (this.extensionEquals("htm,html")) {
            return "text/html";
        }
        if (this.extensionEquals("java")) {
            return "text/plain";
        }
        if (this.extensionEquals("js")) {
            return "text/javascript";
        }
        if (this.extensionEquals("txt")) {
            return "text/plain";
        }
        if (this.extensionEquals("bmp")) {
            return "image/bmp";
        }
        if (this.extensionEquals("gif")) {
            return "image/gif";
        }
        if (this.extensionEquals("jp2,j2c,j2k,jpx")) {
            return "image/jp2";
        }
        if (this.extensionEquals("jpg,jpe,jpeg,jfif,pjpeg,pjp")) {
            return "image/jpeg";
        }
        if (this.extensionEquals("png")) {
            return "image/png";
        }
        if (this.extensionEquals("psd")) {
            return "image/x-photoshop";
        }
        if (this.extensionEquals("rgb")) {
            return "image/x-rgb";
        }
        if (this.extensionEquals("tif,tiff")) {
            return "image/tiff";
        }
        if (this.extensionEquals("xbm")) {
            return "image/x-xbitmap";
        }
        if (this.extensionEquals("xpm")) {
            return "image/x-xpixmap";
        }
        if (this.extensionEquals("ico")) {
            return "image/vnd.microsoft.icon";
        }
        if (this.extensionEquals("doc,dot")) {
            return "application/msword";
        }
        if (this.extensionEquals("xls,xlw,xla,xlc,xlm,xlt,xll")) {
            return "application/vnd.ms-excel";
        }
        if (this.extensionEquals("ppt,pps,pot")) {
            return "application/vnd.ms-powerpoint";
        }
        if (this.extensionEquals("mdb")) {
            return "application/x-msaccess";
        }
        if (this.extensionEquals("mpp")) {
            return "application/vnd.ms-project";
        }
        if (this.extensionEquals("pub")) {
            return "application/x-mspublisher";
        }
        if (this.extensionEquals("wmz")) {
            return "application/x-ms-wmz";
        }
        if (this.extensionEquals("wmd")) {
            return "application/x-ms-wmd";
        }
        if (this.extensionEquals("ai,eps,ps")) {
            return "application/postscript";
        }
        if (this.extensionEquals("gz")) {
            return "application/x-gzip";
        }
        if (this.extensionEquals("pdf")) {
            return "application/pdf";
        }
        if (this.extensionEquals("xml")) {
            return "application/xml";
        }
        if (this.extensionEquals("z")) {
            return "application/x-compress";
        }
        if (this.extensionEquals("zip")) {
            return "application/zip";
        }
        if (this.extensionEquals("mid,midi")) {
            return "audio/x-midi";
        }
        if (this.extensionEquals("mp1,mp2,mp3,mpa,mpega")) {
            return "audio/x-mpeg";
        }
        if (this.extensionEquals("ra,ram")) {
            return "audio/x-pn-realaudio";
        }
        if (this.extensionEquals("wav")) {
            return "audio/x-wav";
        }
        if (this.extensionEquals("wma")) {
            return "audio/x-ms-wma";
        }
        if (this.extensionEquals("wax")) {
            return "audio/x-ms-wax";
        }
        if (this.extensionEquals("wmv")) {
            return "audio/x-ms-wmv";
        }
        if (this.extensionEquals("asf,asx")) {
            return "video/x-ms-asf";
        }
        if (this.extensionEquals("avi")) {
            return "video/msvideo";
        }
        if (this.extensionEquals("mov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("mpe,mpeg,mpg")) {
            return "video/mpeg";
        }
        if (this.extensionEquals("mpv2")) {
            return "video/mpeg2";
        }
        if (this.extensionEquals("qt,mov,moov")) {
            return "video/quicktime";
        }
        if (this.extensionEquals("wvx")) {
            return "video/x-ms-wvx";
        }
        if (this.extensionEquals("wm")) {
            return "video/x-ms-wm";
        }
        if (this.extensionEquals("wmx")) {
            return "video/x-ms-wmx";
        }
        return "application/octet-stream";
    }

    private boolean extensionEquals(String FileExtension) {
        String ext = this.getExtension();
        String[] arr = FileExtension.split(",");
        for (int i = 0; i < arr.length; ++i) {
            String str = arr[i].trim();
            if (!str.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }

    public java.util.Date getLastModifiedTime() {
        return this.getDate();
    }

    public java.util.Date getCreationTime() {
        try {
            return this.getFileAttributes().getCreationTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.util.Date getLastAccessTime() {
        try {
            return this.getFileAttributes().getLastAccessTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.util.Date getLastWriteTime() {
        try {
            return this.getFileAttributes().getLastWriteTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HashSet<String> getFlags() {
        try {
            return this.getFileAttributes().getFlags();
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    public FileAttributes getFileAttributes() throws Exception {
        return new FileAttributes(this);
    }

    protected static synchronized boolean loadDLL() {
        if (isWindows) {
            if (dllLoaded == null) {
                String jvmPlatform = System.getProperty("os.arch");
                String dllName = null;
                if (jvmPlatform.equalsIgnoreCase("x86")) {
                    dllName = "javaxt-core.dll";
                } else if (jvmPlatform.equalsIgnoreCase("amd64")) {
                    dllName = "javaxt-core64.dll";
                } else {
                    dllLoaded = false;
                    return dllLoaded;
                }
                Jar jar = new Jar(Jar.class);
                Jar.Entry entry = jar.getEntry(null, dllName);
                java.io.File dll = entry.getFile();
                if (dll == null && !(dll = new java.io.File(jar.getFile().getParentFile(), dllName)).exists()) {
                    entry.extractFile(dll);
                }
                try {
                    System.load(dll.toString());
                    dllLoaded = true;
                    return dllLoaded;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return dllLoaded;
        }
        return false;
    }

    private static native long[] GetFileAttributesEx(String var0) throws Exception;

    private static native String GetTarget(String var0) throws Exception;

    static {
        ftFormatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    }

    public class LnkParser {
        private java.io.File file;

        public LnkParser(String lnk) {
            this(new File(lnk));
        }

        public LnkParser(java.io.File lnk) {
            this(new File(lnk));
        }

        public LnkParser(File lnk) {
            if (!lnk.getExtension().equalsIgnoreCase("lnk") || !lnk.exists()) {
                return;
            }
            try {
                int index;
                byte[] loc;
                int i;
                BufferedInputStream in = new BufferedInputStream(lnk.getInputStream());
                int ch = -1;
                byte[] b = new byte[4];
                ch = in.read(b);
                b = new byte[16];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[24];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[4];
                ch = in.read(b);
                b = new byte[8];
                ch = in.read(b);
                int lenShellItemList = in.read();
                in.read(new byte[lenShellItemList]);
                in.read();
                b = new byte[8];
                in.read(b);
                b = new byte[4];
                in.read(b);
                b = new byte[4];
                in.read(b);
                b = new byte[4];
                in.read(b);
                int offsetBasePathName = in.read();
                if (ch < 0) {
                    return;
                }
                for (int i2 = 0; i2 < 4; ++i2) {
                    ch = in.read();
                    --offsetBasePathName;
                }
                int offsetNetworkVolumeInfo = ch;
                for (int i3 = 0; i3 < 4; ++i3) {
                    ch = in.read();
                    --offsetBasePathName;
                }
                int offLocal = ch;
                if (offLocal < 0) {
                    return;
                }
                String BasePathName = null;
                if (offsetBasePathName > 0) {
                    for (i = 0; i < offsetBasePathName; ++i) {
                        ch = in.read();
                        --offLocal;
                    }
                    loc = new byte[256];
                    index = 0;
                    loc[index++] = (byte)ch;
                    while ((ch = in.read()) != 0) {
                        loc[index++] = (byte)ch;
                        --offLocal;
                    }
                    BasePathName = new String(loc);
                    BasePathName = BasePathName.trim();
                }
                for (i = 0; i < offLocal - 1; ++i) {
                    ch = in.read();
                }
                loc = new byte[256];
                index = 0;
                loc[index++] = (byte)ch;
                while ((ch = in.read()) != 0) {
                    loc[index++] = (byte)ch;
                }
                String local = new String(loc);
                local = local.trim();
                this.file = BasePathName != null ? new java.io.File(BasePathName, local) : new java.io.File(local);
                if (!this.file.exists()) {
                    this.file = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public java.io.File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.toString();
        }

        private int getBit(byte[] data, int pos) {
            int posByte = pos / 8;
            int posBit = pos % 8;
            byte valByte = data[posByte];
            int valInt = valByte >> 8 - (posBit + 1) & 1;
            return valInt;
        }

        private void parseFlags(byte[] data) {
            block9: for (int i = 0; i < data.length * 8; ++i) {
                int val = this.getBit(data, i);
                switch (i) {
                    case 0: {
                        if (val == 1) {
                            System.out.println("The shell item id list is present.");
                            continue block9;
                        }
                        System.out.println("The shell item id list is absent.");
                        continue block9;
                    }
                    case 1: {
                        if (val == 1) {
                            System.out.println("Points to a file or directory.");
                            continue block9;
                        }
                        System.out.println("Points to something else.");
                        continue block9;
                    }
                    case 2: {
                        if (val == 1) {
                            System.out.println("Has a description string.");
                            continue block9;
                        }
                        System.out.println("No description string.");
                        continue block9;
                    }
                    case 3: {
                        if (val == 1) {
                            System.out.println("Has a relative path string.");
                            continue block9;
                        }
                        System.out.println("No relative path.");
                        continue block9;
                    }
                    case 4: {
                        if (val == 1) {
                            System.out.println("Has a working directory.");
                            continue block9;
                        }
                        System.out.println("No working directory.");
                        continue block9;
                    }
                    case 5: {
                        if (val == 1) {
                            System.out.println("Has command line arguments.");
                            continue block9;
                        }
                        System.out.println("No command line arguments.");
                        continue block9;
                    }
                    case 6: {
                        if (val == 1) {
                            System.out.println("Has a custom icon.");
                            continue block9;
                        }
                        System.out.println("Has the default icon.");
                        continue block9;
                    }
                }
            }
        }

        private void parseFileAttributes(byte[] data) {
            block15: for (int i = 0; i < data.length * 8; ++i) {
                boolean val = this.getBit(data, i) != 0;
                switch (i) {
                    case 0: {
                        System.out.println("Target is read only. " + val);
                        continue block15;
                    }
                    case 1: {
                        System.out.println("Target is hidden. " + val);
                        continue block15;
                    }
                    case 2: {
                        System.out.println("Target is a system file. " + val);
                        continue block15;
                    }
                    case 3: {
                        System.out.println("Target is a volume label. " + val);
                        continue block15;
                    }
                    case 4: {
                        System.out.println("Target is a directory. " + val);
                        continue block15;
                    }
                    case 5: {
                        System.out.println("Target has been modified since last backup. " + val);
                        continue block15;
                    }
                    case 6: {
                        System.out.println("Target is encrypted (NTFS EFS) " + val);
                        continue block15;
                    }
                    case 7: {
                        System.out.println("Target is Normal? " + val);
                        continue block15;
                    }
                    case 8: {
                        System.out.println("Target is temporary. " + val);
                        continue block15;
                    }
                    case 9: {
                        System.out.println("Target is a sparse file. " + val);
                        continue block15;
                    }
                    case 10: {
                        System.out.println("Target has reparse point data. " + val);
                        continue block15;
                    }
                    case 11: {
                        System.out.println("Target is compressed. " + val);
                        continue block15;
                    }
                    case 12: {
                        System.out.println("Target is offline. " + val);
                        continue block15;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileAttributes {
        private long dwFileAttributes;
        private java.util.Date ftCreationTime;
        private java.util.Date ftLastAccessTime;
        private java.util.Date ftLastWriteTime;
        private long nFileSizeHigh;
        private long nFileSizeLow;
        private HashSet<String> flags = new HashSet();
        private static final int FILE_ATTRIBUTE_READONLY = 1;
        private static final int FILE_ATTRIBUTE_HIDDEN = 2;
        private static final int FILE_ATTRIBUTE_SYSTEM = 4;
        private static final int FILE_ATTRIBUTE_DIRECTORY = 16;
        private static final int FILE_ATTRIBUTE_ARCHIVE = 32;
        private static final int FILE_ATTRIBUTE_DEVICE = 64;
        private static final int FILE_ATTRIBUTE_NORMAL = 128;
        private static final int FILE_ATTRIBUTE_TEMPORARY = 256;
        private static final int FILE_ATTRIBUTE_SPARSE_FILE = 512;
        private static final int FILE_ATTRIBUTE_REPARSE_POINT = 1024;
        private static final int FILE_ATTRIBUTE_COMPRESSED = 2048;
        private static final int FILE_ATTRIBUTE_OFFLINE = 4096;
        private static final int FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 8192;
        private static final int FILE_ATTRIBUTE_ENCRYPTED = 16384;
        private static final int FILE_ATTRIBUTE_VIRTUAL = 65536;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private FileAttributes(File file2) throws Exception {
            if (!file2.exists()) {
                throw new Exception("File not found.");
            }
            if (isWindows) {
                if (!javaxt.io.File.loadDLL()) throw new Exception("Failed to load javaxt-core.dll.");
                long[] attributes = javaxt.io.File.GetFileAttributesEx(file2.toString());
                this.dwFileAttributes = attributes[0];
                this.ftCreationTime = ftFormatter.parse(attributes[1] + "");
                this.ftLastAccessTime = ftFormatter.parse(attributes[2] + "");
                this.ftLastWriteTime = ftFormatter.parse(attributes[3] + "");
                this.nFileSizeHigh = attributes[4];
                this.nFileSizeLow = attributes[5];
                if (this.bitand(this.dwFileAttributes, 1L) == 1L) {
                    this.flags.add("READONLY");
                }
                if (this.bitand(this.dwFileAttributes, 2L) == 2L) {
                    this.flags.add("HIDDEN");
                }
                if (this.bitand(this.dwFileAttributes, 4L) == 4L) {
                    this.flags.add("SYSTEM");
                }
                if (this.bitand(this.dwFileAttributes, 16L) == 16L) {
                    this.flags.add("DIRECTORY");
                }
                if (this.bitand(this.dwFileAttributes, 32L) == 32L) {
                    this.flags.add("ARCHIVE");
                }
                if (this.bitand(this.dwFileAttributes, 64L) == 64L) {
                    this.flags.add("DEVICE");
                }
                if (this.bitand(this.dwFileAttributes, 128L) == 128L) {
                    this.flags.add("NORMAL");
                }
                if (this.bitand(this.dwFileAttributes, 256L) == 256L) {
                    this.flags.add("TEMPORARY");
                }
                if (this.bitand(this.dwFileAttributes, 512L) == 512L) {
                    this.flags.add("SPARSE_FILE");
                }
                if (this.bitand(this.dwFileAttributes, 1024L) == 1024L) {
                    this.flags.add("REPARSE_POINT");
                }
                if (this.bitand(this.dwFileAttributes, 2048L) == 2048L) {
                    this.flags.add("COMPRESSED");
                }
                if (this.bitand(this.dwFileAttributes, 4096L) == 4096L) {
                    this.flags.add("OFFLINE");
                }
                if (this.bitand(this.dwFileAttributes, 8192L) == 8192L) {
                    this.flags.add("NOT_CONTENT_INDEXED");
                }
                if (this.bitand(this.dwFileAttributes, 16384L) == 16384L) {
                    this.flags.add("ENCRYPTED");
                }
                if (this.bitand(this.dwFileAttributes, 65536L) != 65536L) return;
                this.flags.add("VIRTUAL");
                return;
            } else {
                this.ftLastWriteTime = file2.getDate();
                String[] params = new String[]{"ls", "-lau", "--full-time", file2.toString()};
                Shell cmd = new Shell(params);
                cmd.run();
                Iterator it = cmd.getOutput().iterator();
                if (it.hasNext()) {
                    this.ftLastAccessTime = this.parseDate((String)it.next());
                }
                if (!isFreeBSD) return;
                params = new String[]{"ls", "-laU", "--full-time", file2.toString()};
                cmd = new Shell(params);
                cmd.run();
                it = cmd.getOutput().iterator();
                if (!it.hasNext()) return;
                this.ftCreationTime = this.parseDate((String)it.next());
            }
        }

        private java.util.Date parseDate(String line) {
            if (line != null) {
                String[] arr = line.split(" ");
                String date = arr[5] + " " + arr[6] + " " + arr[7];
                try {
                    return new Date(date, "yyyy-MM-dd HH:mm:ss.SSS z").getDate();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }

        public java.util.Date getCreationTime() {
            return this.ftCreationTime;
        }

        public java.util.Date getLastAccessTime() {
            return this.ftLastAccessTime;
        }

        public java.util.Date getLastWriteTime() {
            return this.ftLastWriteTime;
        }

        public HashSet<String> getFlags() {
            return this.flags;
        }

        private long bitand(long Number1, long Number2) {
            try {
                return Number1 & Number2;
            }
            catch (Exception e) {
                return -1L;
            }
        }
    }
}

