/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image {
    private BufferedImage bufferedImage = null;
    private ArrayList corners = null;
    private float outputQuality = 1.0f;
    private Graphics2D g2d = null;
    public static String[] InputFormats = Image.getFormats(ImageIO.getReaderFormatNames());
    public static String[] OutputFormats = Image.getFormats(ImageIO.getWriterFormatNames());
    private IIOMetadata metadata;
    private HashMap<Integer, Object> exif;
    private HashMap<Integer, Object> iptc;
    private HashMap<Integer, Object> gps;

    public Image(String PathToImageFile) {
        this(new File(PathToImageFile));
    }

    public Image(File File2) {
        this.createBufferedImage(File2);
    }

    public Image(InputStream InputStream2) {
        this.createBufferedImage(InputStream2);
    }

    public Image(byte[] byteArray) {
        this(new ByteArrayInputStream(byteArray));
    }

    public Image(int width, int height) {
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.g2d = this.getGraphics();
    }

    public Image(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public Image(RenderedImage img) {
        if (img instanceof BufferedImage) {
            this.bufferedImage = (BufferedImage)img;
        } else {
            ColorModel cm = img.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(img.getWidth(), img.getHeight());
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = img.getPropertyNames();
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    properties.put(keys[i], img.getProperty(keys[i]));
                }
            }
            BufferedImage result = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            img.copyData(raster);
            this.bufferedImage = result;
        }
    }

    public Image(String text, String fontName, int fontSize, int r, int g, int b) {
        this(text, new Font(fontName, 0, fontSize), r, g, b);
    }

    public Image(String text, Font font, int r, int g, int b) {
        Graphics2D t = new BufferedImage(1, 1, 2).createGraphics();
        t.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fm = t.getFontMetrics(font);
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        int descent = fm.getDescent();
        t.dispose();
        this.bufferedImage = new BufferedImage(width, height, 2);
        this.g2d = this.bufferedImage.createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = 1.0f;
        this.g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.setFont(font);
        this.g2d.drawString(text, 0, height - descent);
    }

    public void setBackgroundColor(int r, int g, int b) {
        int imageType = this.bufferedImage.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bi = new BufferedImage(width, height, imageType);
        Graphics2D g2d = bi.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setColor(new Color(r, g, b));
        g2d.fillRect(0, 0, width, height);
        BufferedImage img = this.bufferedImage;
        g2d.drawImage((java.awt.Image)img, 0, 0, null);
        this.bufferedImage = bi;
        g2d.dispose();
    }

    public String[] getInputFormats() {
        return Image.getFormats(ImageIO.getReaderFormatNames());
    }

    public String[] getOutputFormats() {
        return Image.getFormats(ImageIO.getWriterFormatNames());
    }

    private static String[] getFormats(String[] inputFormats) {
        HashSet<String> formats = new HashSet<String>();
        for (int i = 0; i < inputFormats.length; ++i) {
            String format = inputFormats[i].toUpperCase();
            if (format.contains("JPEG") && format.contains("2000")) {
                formats.add("JP2");
                formats.add("J2C");
                formats.add("J2K");
                formats.add("JPX");
                continue;
            }
            formats.add(format);
        }
        inputFormats = formats.toArray(new String[formats.size()]);
        Collections.sort(Arrays.asList(inputFormats));
        return inputFormats;
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    private Graphics2D getGraphics() {
        if (this.g2d == null) {
            this.g2d = this.bufferedImage.createGraphics();
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return this.g2d;
    }

    public void addText(String text, int x, int y) {
        this.addText(text, x, y, new Font("SansSerif", 0, 12), 0, 0, 0);
    }

    public void addText(String text, int x, int y, String fontName, int fontSize, int r, int g, int b) {
        this.addText(text, x, y, new Font(fontName, 0, fontSize), r, g, b);
    }

    public void addText(String text, int x, int y, Font font, int r, int g, int b) {
        this.g2d = this.getGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setColor(new Color(r, g, b));
        this.g2d.setFont(font);
        this.g2d.drawString(text, x, y);
    }

    public void addPoint(int x, int y, int r, int g, int b) {
        this.setColor(x, y, new Color(r, g, b));
    }

    public void setColor(int x, int y, Color color) {
        this.g2d = this.getGraphics();
        Color org = this.g2d.getColor();
        this.g2d.setColor(color);
        this.g2d.fillRect(x, y, 1, 1);
        this.g2d.setColor(org);
    }

    public Color getColor(int x, int y) {
        int pixel = this.bufferedImage.getRGB(x, y);
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new Color(red, green, blue, alpha);
    }

    public void addImage(BufferedImage in, int x, int y, boolean expand) {
        int x2 = 0;
        int y2 = 0;
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        if (expand) {
            if (x < 0) {
                if (in.getWidth() > (w += -x)) {
                    w += in.getWidth() - w;
                }
                x2 = -x;
                x = 0;
            } else if (x > w) {
                w = w + (x - w) + in.getWidth();
            } else if (x + in.getWidth() > w) {
                w += x + in.getWidth() - w;
            }
            if (y < 0) {
                if (in.getHeight() > (h += -y)) {
                    h += in.getHeight() - h;
                }
                y2 = -y;
                y = 0;
            } else if (y > h) {
                h = h + (y - h) + in.getHeight();
            } else if (y + in.getHeight() > h) {
                h += y + in.getHeight() - h;
            }
        }
        if (w > this.bufferedImage.getWidth() || h > this.bufferedImage.getHeight()) {
            int imageType = this.bufferedImage.getType();
            if (imageType == 0 || imageType == 12) {
                imageType = 2;
            }
            BufferedImage bi = new BufferedImage(w, h, imageType);
            Graphics2D g2d = bi.createGraphics();
            BufferedImage img = this.bufferedImage;
            g2d.drawImage((java.awt.Image)img, x2, y2, null);
            img = in;
            g2d.drawImage((java.awt.Image)img, x, y, null);
            this.bufferedImage = bi;
        } else {
            Graphics2D g2d = this.bufferedImage.createGraphics();
            BufferedImage img = in;
            g2d.drawImage((java.awt.Image)img, x, y, null);
            g2d.dispose();
        }
    }

    public void addImage(Image in, int x, int y, boolean expand) {
        this.addImage(in.getBufferedImage(), x, y, expand);
    }

    private void createBufferedImage(File file) {
        try {
            this.createBufferedImage(new FileInputStream(file));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBufferedImage(InputStream input) {
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(input);
            Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
            if (!iter.hasNext()) {
                return;
            }
            ImageReader reader = iter.next();
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(stream, true, true);
            try {
                this.bufferedImage = reader.read(0, param);
                this.metadata = reader.getImageMetadata(0);
            }
            finally {
                reader.dispose();
                stream.close();
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rotate(double Degrees) {
        int maxY;
        int maxX;
        int width = this.getWidth();
        int height = this.getHeight();
        int cx = width / 2;
        int cy = height / 2;
        int[] corners = new int[]{0, 0, width, 0, width, height, 0, height};
        int minX = maxX = cx;
        int minY = maxY = cy;
        double theta = Math.toRadians(Degrees);
        for (int i = 0; i < corners.length; i += 2) {
            int x = (int)Math.round(Math.cos(theta) * (double)(corners[i] - cx) - Math.sin(theta) * (double)(corners[i + 1] - cy) + (double)cx);
            int y = (int)Math.round(Math.sin(theta) * (double)(corners[i] - cx) + Math.cos(theta) * (double)(corners[i + 1] - cy) + (double)cy);
            if (x > maxX) {
                maxX = x;
            }
            if (x < minX) {
                minX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (y >= minY) continue;
            minY = y;
        }
        cx -= minX;
        cy -= minY;
        BufferedImage result = new BufferedImage(maxX - minX, maxY - minY, 2);
        Graphics2D g2d = result.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform xform = new AffineTransform();
        xform.rotate(theta, cx, cy);
        g2d.setTransform(xform);
        g2d.drawImage((java.awt.Image)this.bufferedImage, -minX, -minY, null);
        g2d.dispose();
        this.bufferedImage = result;
        result = null;
        xform = null;
    }

    public void rotateClockwise() {
        this.rotate(90.0);
    }

    public void rotateCounterClockwise() {
        this.rotate(-90.0);
    }

    public void rotate() {
        try {
            Integer orientation = (Integer)this.getExifTags().get(274);
            switch (orientation) {
                case 1: {
                    return;
                }
                case 2: {
                    this.flip();
                    break;
                }
                case 3: {
                    this.rotate(180.0);
                    break;
                }
                case 4: {
                    this.flip();
                    this.rotate(180.0);
                    break;
                }
                case 5: {
                    this.flip();
                    this.rotate(270.0);
                    break;
                }
                case 6: {
                    this.rotate(90.0);
                    break;
                }
                case 7: {
                    this.flip();
                    this.rotate(90.0);
                    break;
                }
                case 8: {
                    this.rotate(270.0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWidth(int Width) {
        double ratio = (double)Width / (double)this.getWidth();
        double dw = (double)this.getWidth() * ratio;
        double dh = (double)this.getHeight() * ratio;
        int outputWidth = (int)Math.round(dw);
        int outputHeight = (int)Math.round(dh);
        this.resize(outputWidth, outputHeight);
    }

    public void setHeight(int Height) {
        double ratio = (double)Height / (double)this.getHeight();
        double dw = (double)this.getWidth() * ratio;
        double dh = (double)this.getHeight() * ratio;
        int outputWidth = (int)Math.round(dw);
        int outputHeight = (int)Math.round(dh);
        this.resize(outputWidth, outputHeight);
    }

    public void resize(int Width, int Height) {
        this.resize(Width, Height, false);
    }

    public void resize(int Width, int Height, boolean maintainRatio) {
        int outputWidth = Width;
        int outputHeight = Height;
        int width = this.getWidth();
        int height = this.getHeight();
        if (maintainRatio) {
            double ratio = 0.0;
            ratio = width > height ? (double)Width / (double)width : (double)Height / (double)height;
            double dw = (double)width * ratio;
            double dh = (double)height * ratio;
            outputWidth = (int)Math.round(dw);
            outputHeight = (int)Math.round(dh);
            if (outputWidth > width || outputHeight > height) {
                outputWidth = width;
                outputHeight = height;
            }
        }
        java.awt.Image outputImage = this.bufferedImage.getScaledInstance(outputWidth, outputHeight, 16);
        BufferedImage bi = new BufferedImage(outputWidth, outputHeight, this.getImageType());
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(outputImage, 0, 0, null);
        g2d.dispose();
        this.bufferedImage = bi;
        outputImage = null;
        bi = null;
        g2d = null;
    }

    public void setCorners(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        Skew skew = new Skew(this.bufferedImage);
        this.bufferedImage = skew.setCorners(x0, y0, x1, y1, x2, y2, x3, y3);
        if (this.corners == null) {
            this.corners = new ArrayList();
        } else {
            this.corners.clear();
        }
        this.corners.add(Float.valueOf(x0));
        this.corners.add(Float.valueOf(y0));
        this.corners.add(Float.valueOf(x1));
        this.corners.add(Float.valueOf(y1));
        this.corners.add(Float.valueOf(x2));
        this.corners.add(Float.valueOf(y2));
        this.corners.add(Float.valueOf(x3));
        this.corners.add(Float.valueOf(y3));
    }

    public float[] getCorners() {
        if (this.corners == null) {
            float w = this.getWidth();
            float h = this.getHeight();
            this.corners = new ArrayList();
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(w));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(w));
            this.corners.add(Float.valueOf(h));
            this.corners.add(Float.valueOf(0.0f));
            this.corners.add(Float.valueOf(h));
        }
        Object[] arr = this.corners.toArray();
        float[] ret = new float[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Float f = (Float)arr[i];
            ret[i] = f.floatValue();
        }
        return ret;
    }

    public void sharpen() {
        int width = this.getWidth();
        int height = this.getHeight();
        Kernel kernel = new Kernel(3, 3, new float[]{0.0f, -0.2f, 0.0f, -0.2f, 1.8f, -0.2f, 0.0f, -0.2f, 0.0f});
        BufferedImage out = new BufferedImage(width, height, this.getImageType());
        ConvolveOp op = new ConvolveOp(kernel);
        out = op.filter(this.bufferedImage, out);
        BufferedImage overlay = out.getSubimage(2, 2, width - 4, height - 4);
        Graphics2D g2d = this.bufferedImage.createGraphics();
        g2d.drawImage((java.awt.Image)overlay, 2, 2, null);
        g2d.dispose();
    }

    public void desaturate() {
        this.bufferedImage = this.desaturate(this.bufferedImage);
    }

    public void desaturate(double percent) {
        float alpha = (float)percent;
        BufferedImage overlay = this.desaturate(this.bufferedImage);
        Graphics2D g2d = this.bufferedImage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((java.awt.Image)overlay, 0, 0, null);
        g2d.dispose();
    }

    private BufferedImage desaturate(BufferedImage in) {
        BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), this.getImageType(in));
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return op.filter(in, out);
    }

    public void setOpacity(double percent) {
        if (percent > 1.0) {
            percent /= 100.0;
        }
        float alpha = (float)percent;
        int imageType = this.bufferedImage.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage out = new BufferedImage(this.getWidth(), this.getHeight(), imageType);
        Graphics2D g2d = out.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
        g2d.dispose();
        this.bufferedImage = out;
    }

    public void flip() {
        BufferedImage out = new BufferedImage(this.getWidth(), this.getHeight(), this.getImageType());
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-this.bufferedImage.getWidth(), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 3);
        this.bufferedImage = op.filter(this.bufferedImage, out);
    }

    public void crop(int x, int y, int width, int height) {
        this.bufferedImage = this.bufferedImage.getSubimage(x, y, width, height);
    }

    public Image copy() {
        return new Image(this.bufferedImage);
    }

    public Image copyRect(int x, int y, int width, int height) {
        return new Image(this.bufferedImage.getSubimage(x, y, width, height));
    }

    public void trim() {
        this.trim(0, 0, 0);
    }

    public void trim(int r, int g, int b) {
        int y;
        int x;
        int x2;
        int y2;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        block0: for (y2 = 0; y2 < this.bufferedImage.getHeight(); ++y2) {
            for (x2 = 0; x2 < this.bufferedImage.getWidth(); ++x2) {
                if (!this.hasColor(this.bufferedImage.getRGB(x2, y2), r, g, b)) continue;
                bottom = y2;
                continue block0;
            }
        }
        block2: for (y2 = this.bufferedImage.getHeight() - 1; y2 > -1; --y2) {
            for (x2 = 0; x2 < this.bufferedImage.getWidth(); ++x2) {
                if (!this.hasColor(this.bufferedImage.getRGB(x2, y2), r, g, b)) continue;
                top = y2;
                continue block2;
            }
        }
        block4: for (x = 0; x < this.bufferedImage.getWidth(); ++x) {
            for (y = 0; y < this.bufferedImage.getHeight(); ++y) {
                if (!this.hasColor(this.bufferedImage.getRGB(x, y), r, g, b)) continue;
                right = x;
                continue block4;
            }
        }
        block6: for (x = this.bufferedImage.getWidth() - 1; x > -1; --x) {
            for (y = 0; y < this.bufferedImage.getHeight(); ++y) {
                if (!this.hasColor(this.bufferedImage.getRGB(x, y), r, g, b)) continue;
                left = x;
                continue block6;
            }
        }
        this.bufferedImage = left == right || top == bottom ? new BufferedImage(1, 1, 2) : this.bufferedImage.getSubimage(left, top, right - left, bottom - top);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public java.awt.Image getImage() {
        return this.getBufferedImage();
    }

    public RenderedImage getRenderedImage() {
        return this.getBufferedImage();
    }

    public BufferedImage getBufferedImage(int width, int height, boolean maintainRatio) {
        Image image = new Image(this.getBufferedImage());
        image.resize(width, height, maintainRatio);
        return image.getBufferedImage();
    }

    public byte[] getByteArray() {
        return this.getByteArray("jpeg");
    }

    public byte[] getByteArray(String format) {
        byte[] rgb = null;
        if ((format = format.toLowerCase()).startsWith("image/")) {
            format = format.substring(format.indexOf("/") + 1);
        }
        try {
            if (this.isJPEG(format)) {
                rgb = this.getJPEGByteArray(this.outputQuality);
            } else {
                ByteArrayOutputStream bas = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.bufferedImage, format.toLowerCase(), bas);
                rgb = bas.toByteArray();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rgb;
    }

    public void saveAs(String PathToImageFile) {
        this.saveAs(new File(PathToImageFile));
    }

    public void saveAs(File OutputFile) {
        try {
            OutputFile.getParentFile().mkdirs();
            String FileExtension = this.getExtension(OutputFile.getName()).toLowerCase();
            if (this.isJPEG(FileExtension)) {
                FileOutputStream output = new FileOutputStream(OutputFile);
                output.write(this.getJPEGByteArray(this.outputQuality));
                output.close();
            } else {
                BufferedImage rendImage = this.bufferedImage;
                if (this.isJPEG2000(FileExtension)) {
                    ImageIO.write((RenderedImage)rendImage, "JPEG 2000", OutputFile);
                } else {
                    ImageIO.write((RenderedImage)rendImage, FileExtension, OutputFile);
                }
                Object var3_5 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOutputQuality(double percentage) {
        float q;
        if (percentage > 1.0 && percentage <= 100.0) {
            percentage /= 100.0;
        }
        if ((q = (float)percentage) == 1.0f) {
            q = 1.2f;
        }
        if (q >= 0.0f && q <= 1.2f) {
            this.outputQuality = q;
        }
    }

    private boolean isJPEG(String FileExtension) {
        return (FileExtension = FileExtension.trim().toLowerCase()).equals("jpg") || FileExtension.equals("jpeg") || FileExtension.equals("jpe");
    }

    private boolean isJPEG2000(String FileExtension) {
        return (FileExtension = FileExtension.trim().toLowerCase()).equals("jp2") || FileExtension.equals("jpc") || FileExtension.equals("j2k") || FileExtension.equals("jpx");
    }

    private byte[] getJPEGByteArray(float outputQuality) throws IOException {
        if (outputQuality >= 0.0f && outputQuality <= 1.2f) {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            BufferedImage bi = this.bufferedImage;
            int t = this.bufferedImage.getTransparency();
            if (t == 3) {
                bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                Graphics2D biContext = bi.createGraphics();
                biContext.drawImage((java.awt.Image)this.bufferedImage, 0, 0, null);
            }
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)bas);
            JPEGEncodeParam params = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bi);
            params.setQuality(outputQuality, true);
            params.setHorizontalSubsampling(0, 2);
            params.setVerticalSubsampling(0, 2);
            encoder.encode(bi, params);
            bas.flush();
            return bas.toByteArray();
        }
        return this.getByteArray();
    }

    private int getImageType() {
        return this.getImageType(this.bufferedImage);
    }

    private int getImageType(BufferedImage bufferedImage) {
        int i = bufferedImage.getType();
        if (i <= 0) {
            i = 2;
        }
        return i;
    }

    private String getExtension(String FileName) {
        if (FileName.contains(".")) {
            return FileName.substring(FileName.lastIndexOf(".") + 1, FileName.length());
        }
        return "";
    }

    private boolean hasColor(int pixel, int red, int green, int blue) {
        int a = pixel >> 24 & 0xFF;
        int r = pixel >> 16 & 0xFF;
        int g = pixel >> 8 & 0xFF;
        int b = pixel & 0xFF;
        return (r != red || g != green || b != blue) && a != 0;
    }

    public boolean equals(Object obj) {
        Image image;
        if (obj != null && obj instanceof Image && (image = (Image)obj).getWidth() == this.getWidth() && image.getHeight() == this.getHeight()) {
            for (int i = 0; i < image.getWidth(); ++i) {
                for (int j = 0; j < image.getHeight(); ++j) {
                    if (image.getColor(i, j).equals(this.getColor(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public IIOMetadata getIIOMetadata() {
        return this.metadata;
    }

    public void setIIOMetadata(IIOMetadata metadata) {
        this.metadata = metadata;
        this.iptc = null;
        this.exif = null;
        this.gps = null;
    }

    public byte[] getIptcData() {
        return (byte[])this.getUnknownTags(237)[0].getUserObject();
    }

    public HashMap<Integer, Object> getIptcTags() {
        if (this.iptc == null) {
            this.iptc = new HashMap();
            for (IIOMetadataNode marker : this.getUnknownTags(237)) {
                byte[] iptcData = (byte[])marker.getUserObject();
                HashMap<Integer, Object> tags = new MetadataParser(iptcData, 237).getTags("IPTC");
                this.iptc.putAll(tags);
            }
        }
        return this.iptc;
    }

    public byte[] getExifData() {
        return (byte[])this.getUnknownTags(225)[0].getUserObject();
    }

    public HashMap<Integer, Object> getExifTags() {
        if (this.exif == null) {
            this.parseExif();
        }
        return this.exif;
    }

    public HashMap<Integer, Object> getGpsTags() {
        if (this.gps == null) {
            this.parseExif();
        }
        return this.gps;
    }

    private void parseExif() {
        this.exif = new HashMap();
        this.gps = new HashMap();
        for (IIOMetadataNode marker : this.getUnknownTags(225)) {
            byte[] exifData = (byte[])marker.getUserObject();
            MetadataParser metadataParser = new MetadataParser(exifData, 225);
            HashMap<Integer, Object> exif = metadataParser.getTags("EXIF");
            HashMap<Integer, Object> gps = metadataParser.getTags("GPS");
            if (exif != null) {
                this.exif.putAll(exif);
            }
            if (gps != null) {
                this.gps.putAll(gps);
            }
            metadataParser = null;
        }
    }

    public double[] getGPSCoordinate() {
        this.getExifTags();
        try {
            Double lat = this.getCoordinate((String)this.gps.get(2));
            Double lon = this.getCoordinate((String)this.gps.get(4));
            String latRef = (String)this.gps.get(1);
            String lonRef = (String)this.gps.get(3);
            if (!latRef.equalsIgnoreCase("N")) {
                lat = -lat.doubleValue();
            }
            if (!lonRef.equalsIgnoreCase("E")) {
                lon = -lon.doubleValue();
            }
            return new double[]{lon, lat};
        }
        catch (Exception e) {
            return null;
        }
    }

    private double getCoordinate(String RationalArray) {
        String[] arr = RationalArray.substring(1, RationalArray.length() - 1).split(",");
        String[] deg = arr[0].trim().split("/");
        String[] min = arr[1].trim().split("/");
        String[] sec = arr[2].trim().split("/");
        double degNumerator = Double.parseDouble(deg[0]);
        double degDenominator = 1.0;
        try {
            degDenominator = Double.parseDouble(deg[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        double minNumerator = Double.parseDouble(min[0]);
        double minDenominator = 1.0;
        try {
            minDenominator = Double.parseDouble(min[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        double secNumerator = Double.parseDouble(sec[0]);
        double secDenominator = 1.0;
        try {
            secDenominator = Double.parseDouble(sec[1]);
        }
        catch (Exception e) {
            // empty catch block
        }
        double m = 0.0;
        if (degDenominator != 0.0 || degNumerator != 0.0) {
            m = degNumerator / degDenominator;
        }
        if (minDenominator != 0.0 || minNumerator != 0.0) {
            m += minNumerator / minDenominator / 60.0;
        }
        if (secDenominator != 0.0 || secNumerator != 0.0) {
            m += secNumerator / secDenominator / 3600.0;
        }
        return m;
    }

    public String getGPSDatum() {
        this.getExifTags();
        return (String)this.gps.get(18);
    }

    public IIOMetadataNode[] getUnknownTags(int MarkerTag) {
        ArrayList<IIOMetadataNode> markers = new ArrayList<IIOMetadataNode>();
        if (this.metadata != null) {
            for (String name : this.metadata.getMetadataFormatNames()) {
                Node[] unknownNodes;
                IIOMetadataNode node = (IIOMetadataNode)this.metadata.getAsTree(name);
                for (Node unknownNode : unknownNodes = Image.getElementsByTagName("unknown", node)) {
                    try {
                        int marker = Integer.parseInt(Image.getAttributeValue(unknownNode.getAttributes(), "MarkerTag"));
                        if (marker != MarkerTag) continue;
                        markers.add((IIOMetadataNode)unknownNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return markers.toArray(new IIOMetadataNode[markers.size()]);
    }

    public IIOMetadataNode[] getMetadataByTagName(String tagName) {
        ArrayList<IIOMetadataNode> tags = new ArrayList<IIOMetadataNode>();
        if (this.metadata != null) {
            for (String name : this.metadata.getMetadataFormatNames()) {
                Node[] unknownNodes;
                IIOMetadataNode node = (IIOMetadataNode)this.metadata.getAsTree(name);
                for (Node unknownNode : unknownNodes = Image.getElementsByTagName(tagName, node)) {
                    tags.add((IIOMetadataNode)unknownNode);
                }
            }
        }
        return tags.toArray(new IIOMetadataNode[tags.size()]);
    }

    private static Node[] getElementsByTagName(String tagName, Node node) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Image.getElementsByTagName(tagName, node, nodes);
        return nodes.toArray(new Node[nodes.size()]);
    }

    private static void getElementsByTagName(String tagName, Node node, ArrayList<Node> nodes) {
        if (node != null && node.getNodeType() == 1) {
            String nodeName = node.getNodeName().trim();
            if (nodeName.contains(":") && !tagName.contains(":")) {
                nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
            }
            if (nodeName.equalsIgnoreCase(tagName)) {
                nodes.add(node);
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Image.getElementsByTagName(tagName, childNodes.item(i), nodes);
            }
        }
    }

    public static String getAttributeValue(NamedNodeMap attrCollection, String attrName) {
        if (attrCollection != null) {
            for (int i = 0; i < attrCollection.getLength(); ++i) {
                Node node = attrCollection.item(i);
                if (!node.getNodeName().equalsIgnoreCase(attrName)) continue;
                return node.getNodeValue();
            }
        }
        return "";
    }

    private class Skew {
        public static final int ZERO = 0;
        public static final int CLAMP = 1;
        public static final int WRAP = 2;
        public static final int NEAREST_NEIGHBOUR = 0;
        public static final int BILINEAR = 1;
        protected int edgeAction = 0;
        protected int interpolation = 1;
        protected Rectangle transformedSpace;
        protected Rectangle originalSpace;
        private float x0;
        private float y0;
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float x3;
        private float y3;
        private float dx1;
        private float dy1;
        private float dx2;
        private float dy2;
        private float dx3;
        private float dy3;
        private float A;
        private float B;
        private float C;
        private float D;
        private float E;
        private float F;
        private float G;
        private float H;
        private float I;
        private BufferedImage src;
        private BufferedImage dst;

        public Skew(BufferedImage src) {
            this.src = src;
            this.dst = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }

        public Skew(Image src) {
            this(src.getBufferedImage());
        }

        public BufferedImage setCorners(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
            float a13;
            float a23;
            float a32;
            float a22;
            float a12;
            float a31;
            float a21;
            float a11;
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
            this.dx1 = x1 - x2;
            this.dy1 = y1 - y2;
            this.dx2 = x3 - x2;
            this.dy2 = y3 - y2;
            this.dx3 = x0 - x1 + x2 - x3;
            this.dy3 = y0 - y1 + y2 - y3;
            if (this.dx3 == 0.0f && this.dy3 == 0.0f) {
                a11 = x1 - x0;
                a21 = x2 - x1;
                a31 = x0;
                a12 = y1 - y0;
                a22 = y2 - y1;
                a32 = y0;
                a23 = 0.0f;
                a13 = 0.0f;
            } else {
                a13 = (this.dx3 * this.dy2 - this.dx2 * this.dy3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
                a23 = (this.dx1 * this.dy3 - this.dy1 * this.dx3) / (this.dx1 * this.dy2 - this.dy1 * this.dx2);
                a11 = x1 - x0 + a13 * x1;
                a21 = x3 - x0 + a23 * x3;
                a31 = x0;
                a12 = y1 - y0 + a13 * y1;
                a22 = y3 - y0 + a23 * y3;
                a32 = y0;
            }
            this.A = a22 - a32 * a23;
            this.B = a31 * a23 - a21;
            this.C = a21 * a32 - a31 * a22;
            this.D = a32 * a13 - a12;
            this.E = a11 - a31 * a13;
            this.F = a31 * a12 - a11 * a32;
            this.G = a12 * a23 - a22 * a13;
            this.H = a21 * a13 - a11 * a23;
            this.I = a11 * a22 - a21 * a12;
            return this.filter(this.src, this.dst);
        }

        protected void transformSpace(Rectangle rect) {
            rect.x = (int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3));
            rect.y = (int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3));
            rect.width = (int)Math.max(Math.max(this.x0, this.x1), Math.max(this.x2, this.x3)) - rect.x;
            rect.height = (int)Math.max(Math.max(this.y0, this.y1), Math.max(this.y2, this.y3)) - rect.y;
        }

        public float getOriginX() {
            return this.x0 - (float)((int)Math.min(Math.min(this.x0, this.x1), Math.min(this.x2, this.x3)));
        }

        public float getOriginY() {
            return this.y0 - (float)((int)Math.min(Math.min(this.y0, this.y1), Math.min(this.y2, this.y3)));
        }

        private BufferedImage filter(BufferedImage src, BufferedImage dst) {
            int width = src.getWidth();
            int height = src.getHeight();
            this.originalSpace = new Rectangle(0, 0, width, height);
            this.transformedSpace = new Rectangle(0, 0, width, height);
            this.transformSpace(this.transformedSpace);
            if (dst == null) {
                ColorModel dstCM = src.getColorModel();
                dst = new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(this.transformedSpace.width, this.transformedSpace.height), dstCM.isAlphaPremultiplied(), null);
            }
            int[] inPixels = this.getRGB(src, 0, 0, width, height, null);
            if (this.interpolation == 0) {
                return this.filterPixelsNN(dst, width, height, inPixels, this.transformedSpace);
            }
            int srcWidth = width;
            int srcHeight = height;
            int srcWidth1 = width - 1;
            int srcHeight1 = height - 1;
            int outWidth = this.transformedSpace.width;
            int outHeight = this.transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = this.transformedSpace.x;
            int outY = this.transformedSpace.y;
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    int se;
                    int sw;
                    int ne;
                    int nw;
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)Math.floor(out[0]);
                    int srcY = (int)Math.floor(out[1]);
                    float xWeight = out[0] - (float)srcX;
                    float yWeight = out[1] - (float)srcY;
                    if (srcX >= 0 && srcX < srcWidth1 && srcY >= 0 && srcY < srcHeight1) {
                        int i = srcWidth * srcY + srcX;
                        nw = inPixels[i];
                        ne = inPixels[i + 1];
                        sw = inPixels[i + srcWidth];
                        se = inPixels[i + srcWidth + 1];
                    } else {
                        nw = this.getPixel(inPixels, srcX, srcY, srcWidth, srcHeight);
                        ne = this.getPixel(inPixels, srcX + 1, srcY, srcWidth, srcHeight);
                        sw = this.getPixel(inPixels, srcX, srcY + 1, srcWidth, srcHeight);
                        se = this.getPixel(inPixels, srcX + 1, srcY + 1, srcWidth, srcHeight);
                    }
                    outPixels[x] = this.bilinearInterpolate(xWeight, yWeight, nw, ne, sw, se);
                }
                this.setRGB(dst, 0, y, this.transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        private final int getPixel(int[] pixels, int x, int y, int width, int height) {
            if (x < 0 || x >= width || y < 0 || y >= height) {
                switch (this.edgeAction) {
                    default: {
                        return 0;
                    }
                    case 2: {
                        return pixels[this.mod(y, height) * width + this.mod(x, width)];
                    }
                    case 1: 
                }
                return pixels[this.clamp(y, 0, height - 1) * width + this.clamp(x, 0, width - 1)];
            }
            return pixels[y * width + x];
        }

        protected BufferedImage filterPixelsNN(BufferedImage dst, int width, int height, int[] inPixels, Rectangle transformedSpace) {
            int srcWidth = width;
            int srcHeight = height;
            int outWidth = transformedSpace.width;
            int outHeight = transformedSpace.height;
            int[] outPixels = new int[outWidth];
            int outX = transformedSpace.x;
            int outY = transformedSpace.y;
            int[] rgb = new int[4];
            float[] out = new float[2];
            for (int y = 0; y < outHeight; ++y) {
                for (int x = 0; x < outWidth; ++x) {
                    this.transformInverse(outX + x, outY + y, out);
                    int srcX = (int)out[0];
                    int srcY = (int)out[1];
                    if (out[0] < 0.0f || srcX >= srcWidth || out[1] < 0.0f || srcY >= srcHeight) {
                        int p;
                        switch (this.edgeAction) {
                            default: {
                                p = 0;
                                break;
                            }
                            case 2: {
                                p = inPixels[this.mod(srcY, srcHeight) * srcWidth + this.mod(srcX, srcWidth)];
                                break;
                            }
                            case 1: {
                                p = inPixels[this.clamp(srcY, 0, srcHeight - 1) * srcWidth + this.clamp(srcX, 0, srcWidth - 1)];
                            }
                        }
                        outPixels[x] = p;
                        continue;
                    }
                    int i = srcWidth * srcY + srcX;
                    rgb[0] = inPixels[i];
                    outPixels[x] = inPixels[i];
                }
                this.setRGB(dst, 0, y, transformedSpace.width, 1, outPixels);
            }
            return dst;
        }

        protected void transformInverse(int x, int y, float[] out) {
            out[0] = (float)this.originalSpace.width * (this.A * (float)x + this.B * (float)y + this.C) / (this.G * (float)x + this.H * (float)y + this.I);
            out[1] = (float)this.originalSpace.height * (this.D * (float)x + this.E * (float)y + this.F) / (this.G * (float)x + this.H * (float)y + this.I);
        }

        public int[] getRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                return (int[])image.getRaster().getDataElements(x, y, width, height, pixels);
            }
            return image.getRGB(x, y, width, height, pixels, 0, width);
        }

        public void setRGB(BufferedImage image, int x, int y, int width, int height, int[] pixels) {
            int type = image.getType();
            if (type == 2 || type == 1) {
                image.getRaster().setDataElements(x, y, width, height, pixels);
            } else {
                image.setRGB(x, y, width, height, pixels, 0, width);
            }
        }

        private float clamp(float x, float a, float b) {
            return x < a ? a : (x > b ? b : x);
        }

        private int clamp(int x, int a, int b) {
            return x < a ? a : (x > b ? b : x);
        }

        private double mod(double a, double b) {
            int n;
            if ((a -= (double)(n = (int)(a / b)) * b) < 0.0) {
                return a + b;
            }
            return a;
        }

        private float mod(float a, float b) {
            int n;
            if ((a -= (float)(n = (int)(a / b)) * b) < 0.0f) {
                return a + b;
            }
            return a;
        }

        private int mod(int a, int b) {
            int n;
            if ((a -= (n = a / b) * b) < 0) {
                return a + b;
            }
            return a;
        }

        private int bilinearInterpolate(float x, float y, int nw, int ne, int sw, int se) {
            int a0 = nw >> 24 & 0xFF;
            int r0 = nw >> 16 & 0xFF;
            int g0 = nw >> 8 & 0xFF;
            int b0 = nw & 0xFF;
            int a1 = ne >> 24 & 0xFF;
            int r1 = ne >> 16 & 0xFF;
            int g1 = ne >> 8 & 0xFF;
            int b1 = ne & 0xFF;
            int a2 = sw >> 24 & 0xFF;
            int r2 = sw >> 16 & 0xFF;
            int g2 = sw >> 8 & 0xFF;
            int b2 = sw & 0xFF;
            int a3 = se >> 24 & 0xFF;
            int r3 = se >> 16 & 0xFF;
            int g3 = se >> 8 & 0xFF;
            int b3 = se & 0xFF;
            float cx = 1.0f - x;
            float cy = 1.0f - y;
            float m0 = cx * (float)a0 + x * (float)a1;
            float m1 = cx * (float)a2 + x * (float)a3;
            int a = (int)(cy * m0 + y * m1);
            m0 = cx * (float)r0 + x * (float)r1;
            m1 = cx * (float)r2 + x * (float)r3;
            int r = (int)(cy * m0 + y * m1);
            m0 = cx * (float)g0 + x * (float)g1;
            m1 = cx * (float)g2 + x * (float)g3;
            int g = (int)(cy * m0 + y * m1);
            m0 = cx * (float)b0 + x * (float)b1;
            m1 = cx * (float)b2 + x * (float)b3;
            int b = (int)(cy * m0 + y * m1);
            return a << 24 | r << 16 | g << 8 | b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MetadataParser {
        private final int[] bytesPerFormat = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
        private final int NUM_FORMATS = 12;
        private final int FMT_BYTE = 1;
        private final int FMT_STRING = 2;
        private final int FMT_USHORT = 3;
        private final int FMT_ULONG = 4;
        private final int FMT_URATIONAL = 5;
        private final int FMT_SBYTE = 6;
        private final int FMT_SSHORT = 8;
        private final int FMT_SLONG = 9;
        private final int FMT_SRATIONAL = 10;
        private byte[] data = null;
        private boolean intelOrder = false;
        private final int TAG_EXIF_OFFSET = 34665;
        private final int TAG_INTEROP_OFFSET = 40965;
        private final int TAG_GPS_OFFSET = 34853;
        private final int TAG_USERCOMMENT = 37510;
        private HashMap<String, HashMap<Integer, Object>> tags = new HashMap();

        public MetadataParser(byte[] data, int marker) {
            switch (marker) {
                case 237: {
                    this.parseIptc(data);
                    break;
                }
                case 225: {
                    this.parseExif(data);
                }
            }
            data = null;
        }

        private void parseIptc(byte[] iptcData) {
            HashMap<Integer, String> tags = new HashMap<Integer, String>();
            this.tags.put("IPTC", tags);
            this.data = iptcData;
            int offset = 0;
            while (offset < this.data.length) {
                if (this.data[offset] == 28) {
                    int tagByteCount;
                    byte tagType;
                    byte directoryType;
                    ++offset;
                    try {
                        directoryType = this.data[offset++];
                        tagType = this.data[offset++];
                        tagByteCount = this.get16u(offset);
                    }
                    catch (Exception e) {
                        return;
                    }
                    int tagIdentifier = tagType | directoryType << 8;
                    String str = "";
                    if (tagByteCount >= 1 && tagByteCount <= this.data.length - (offset += 2)) {
                        try {
                            str = new String(this.data, offset, tagByteCount, "UTF-8");
                            offset += tagByteCount;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    tags.put(tagIdentifier, str);
                    continue;
                }
                ++offset;
            }
        }

        public void parseExif(byte[] exifData) {
            HashMap<Integer, Object> tags;
            block7: {
                tags = new HashMap<Integer, Object>();
                this.tags.put("EXIF", tags);
                try {
                    String dataStr = new String(exifData, 0, 8, "UTF-8");
                    if (exifData.length <= 4 || !"Exif".equals(dataStr.substring(0, 4))) {
                        return;
                    }
                    String byteOrderMarker = dataStr.substring(6, 8);
                    if ("II".equals(byteOrderMarker)) {
                        this.intelOrder = true;
                        break block7;
                    }
                    if ("MM".equals(byteOrderMarker)) {
                        this.intelOrder = false;
                        break block7;
                    }
                    return;
                }
                catch (Exception e) {
                    return;
                }
            }
            this.data = exifData;
            int checkValue = this.get16u(8);
            if (checkValue != 42) {
                this.data = null;
                return;
            }
            if (this.data == null) {
                return;
            }
            int firstOffset = this.get32u(10);
            this.processExifDir(6 + firstOffset, 6, tags);
        }

        public HashMap<Integer, Object> getTags(String dir) {
            return this.tags.get(dir);
        }

        private void processExifDir(int dirStart, int offsetBase, HashMap<Integer, Object> tags) {
            if (dirStart >= this.data.length) {
                return;
            }
            int numEntries = this.get16u(dirStart);
            block10: for (int de = 0; de < numEntries; ++de) {
                int dirOffset = dirStart + 2 + 12 * de;
                int tag = this.get16u(dirOffset);
                int format = this.get16u(dirOffset + 2);
                int components = this.get32u(dirOffset + 4);
                if (format < 0 || format > 12) {
                    return;
                }
                int byteCount = components * this.bytesPerFormat[format];
                int valueOffset = dirOffset + 8;
                if (byteCount > 4) {
                    int offsetVal = this.get32u(dirOffset + 8);
                    valueOffset = offsetBase + offsetVal;
                }
                if (tag == 34665 || tag == 40965 || tag == 34853) {
                    String dirName = "";
                    switch (tag) {
                        case 34665: {
                            dirName = "EXIF";
                            break;
                        }
                        case 40965: {
                            dirName = "EXIF";
                            break;
                        }
                        case 34853: {
                            dirName = "GPS";
                        }
                    }
                    tags = this.tags.get(dirName);
                    if (tags == null) {
                        tags = new HashMap();
                        this.tags.put(dirName, tags);
                    }
                    int subdirOffset = this.get32u(valueOffset);
                    this.processExifDir(offsetBase + subdirOffset, offsetBase, tags);
                    continue;
                }
                switch (format) {
                    case 2: {
                        String value = this.getString(valueOffset, byteCount);
                        if (value == null) continue block10;
                        tags.put(tag, value);
                        continue block10;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: {
                        tags.put(tag, (int)this.getDouble(format, valueOffset));
                        continue block10;
                    }
                    case 5: 
                    case 10: {
                        if (components > 1) {
                            StringBuffer str = new StringBuffer();
                            str.append("[");
                            for (int i = 0; i < components; ++i) {
                                str.append(this.getRational(valueOffset + 8 * i));
                                if (i >= components - 1) continue;
                                str.append(",");
                            }
                            str.append("]");
                            tags.put(tag, str.toString());
                            continue block10;
                        }
                        tags.put(tag, this.getRational(valueOffset));
                        continue block10;
                    }
                    default: {
                        byte[] result = this.getUndefined(valueOffset, byteCount);
                        if (result == null) continue block10;
                        tags.put(tag, result);
                    }
                }
            }
        }

        private String getRational(int offset) {
            int num = this.get32s(offset);
            int den = this.get32s(offset + 4);
            String result = "";
            if (num % 10 == 0 && den % 10 == 0) {
                num /= 10;
                den /= 10;
            }
            if (num % 5 == 0 && den % 5 == 0) {
                num /= 5;
                den /= 5;
            }
            if (num % 3 == 0 && den % 3 == 0) {
                num /= 3;
                den /= 3;
            }
            if (num % 2 == 0 && den % 2 == 0) {
                num /= 2;
                den /= 2;
            }
            result = den == 0 ? "0" : (den == 1 ? "" + num : "" + num + "/" + den);
            return result;
        }

        private int get16s(int offset) {
            int lo;
            int hi;
            if (this.intelOrder) {
                hi = this.data[offset + 1];
                lo = this.data[offset];
            } else {
                hi = this.data[offset];
                lo = this.data[offset + 1];
            }
            return ((hi &= 0xFF) << 8) + (lo &= 0xFF);
        }

        private int get16u(int offset) {
            int value = this.get16s(offset);
            return value & 0xFFFF;
        }

        private int get32s(int offset) {
            int n4;
            int n3;
            int n2;
            int n1;
            if (this.intelOrder) {
                n1 = this.data[offset + 3] & 0xFF;
                n2 = this.data[offset + 2] & 0xFF;
                n3 = this.data[offset + 1] & 0xFF;
                n4 = this.data[offset] & 0xFF;
            } else {
                n1 = this.data[offset] & 0xFF;
                n2 = this.data[offset + 1] & 0xFF;
                n3 = this.data[offset + 2] & 0xFF;
                n4 = this.data[offset + 3] & 0xFF;
            }
            return (n1 << 24) + (n2 << 16) + (n3 << 8) + n4;
        }

        private int get32u(int offset) {
            return this.get32s(offset);
        }

        private byte[] getUndefined(int offset, int length) {
            return Arrays.copyOfRange(this.data, offset, offset + length);
        }

        private String getString(int offset, int length) {
            try {
                return new String(this.data, offset, length, "UTF-8").trim();
            }
            catch (Exception e) {
                return null;
            }
        }

        private double getDouble(int format, int offset) {
            switch (format) {
                case 6: {
                    return this.data[offset];
                }
                case 1: {
                    byte iValue = this.data[offset];
                    return iValue & 0xFF;
                }
                case 3: {
                    return this.get16u(offset);
                }
                case 4: {
                    return this.get32u(offset);
                }
                case 5: 
                case 10: {
                    int num = this.get32s(offset);
                    int den = this.get32s(offset + 4);
                    if (den == 0) {
                        return 0.0;
                    }
                    return (double)num / (double)den;
                }
                case 8: {
                    return this.get16s(offset);
                }
                case 9: {
                    return this.get32s(offset);
                }
            }
            return 0.0;
        }
    }
}

