/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javaxt.io.Directory;
import javaxt.io.File;

public class Jar {
    private java.io.File file;
    private Package Package;

    public Jar(Object object) {
        this(object.getClass());
    }

    public Jar(Class Class2) {
        this(Class2.getPackage());
    }

    public Jar(Package Package2) {
        this.Package = Package2;
        String path = Package2.getName().replace(".", "/");
        String url = this.getClass().getClassLoader().getResource(path).toString();
        url = url.replace(" ", "%20");
        try {
            URI uri = new URI(url);
            if (uri.getPath() == null) {
                path = uri.toString();
                if (path.startsWith("jar:file:")) {
                    path = path.substring(path.indexOf("file:/"));
                    if ((path = path.substring(0, path.toLowerCase().indexOf(".jar") + 4)).startsWith("file://")) {
                        path = "C:/" + path.substring(path.indexOf("file:/") + 7);
                        path = "/" + new URI(path).getPath();
                    } else {
                        path = new URI(path).getPath();
                    }
                    this.file = new java.io.File(path);
                }
            } else {
                this.file = new java.io.File(uri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Jar(java.io.File file) {
        this.file = file;
    }

    public java.io.File getFile() {
        return this.file;
    }

    public Manifest getManifest() {
        try {
            Entry entry = this.getEntry("META-INF", "MANIFEST.MF");
            if (entry != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(entry.getBytes());
                Manifest manifest = new Manifest(is);
                is.close();
                return manifest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getVersion() {
        String fileName;
        Attributes attributes = this.getManifest().getMainAttributes();
        if (attributes != null) {
            for (Attributes.Name name : attributes.keySet()) {
                String keyword = name.toString();
                if (!keyword.equals("Implementation-Version") && !keyword.equals("Bundle-Version")) continue;
                return (String)attributes.get(name);
            }
        }
        if ((fileName = this.file.getName().substring(0, this.file.getName().lastIndexOf("."))).contains(".")) {
            String string2 = fileName.substring(0, fileName.indexOf("."));
            int delimiter = string2.lastIndexOf("-");
            if (string2.indexOf("_") > delimiter) {
                delimiter = string2.indexOf("_");
            }
            String string3 = string2.substring(delimiter + 1, fileName.indexOf("."));
            String minorVersion = fileName.substring(fileName.indexOf("."));
            return string3 + minorVersion;
        }
        return null;
    }

    public Entry[] getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try {
            if (this.file.isDirectory()) {
                Directory dir = new Directory(this.file);
                List items = dir.getChildren(true);
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof File)) continue;
                    entries.add(new Entry(((File)item).toFile()));
                }
            } else {
                ZipInputStream in = new ZipInputStream(new FileInputStream(this.file));
                ZipEntry zipEntry = null;
                while ((zipEntry = in.getNextEntry()) != null) {
                    entries.add(new Entry(zipEntry));
                }
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry getEntry(String Entry2) {
        return this.getEntry(this.Package.getName(), Entry2);
    }

    public Entry getEntry(String Package2, String Entry2) {
        try {
            if (this.file.isDirectory()) {
                return new Entry(new java.io.File(this.file, Entry2));
            }
            if (Package2 != null && (Package2 = Package2.trim()).length() == 0) {
                Package2 = null;
            }
            if (Package2 != null) {
                if (Package2.contains(".")) {
                    Package2 = Package2.replace(".", "/");
                }
                Entry2 = Package2 + "/" + Entry2;
            }
            ZipInputStream in = new ZipInputStream(new FileInputStream(this.file));
            ZipEntry zipEntry = null;
            while ((zipEntry = in.getNextEntry()) != null) {
                if (!zipEntry.getName().equalsIgnoreCase(Entry2)) continue;
                Entry entry = new Entry(zipEntry);
                in.close();
                return entry;
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Entry getEntry(Class Class2) {
        String ClassName = Class2.getName();
        String PackageName = Class2.getPackage().getName();
        ClassName = ClassName.substring(PackageName.length() + 1);
        return this.getEntry(PackageName, ClassName + ".class");
    }

    public String toString() {
        return this.file.toString();
    }

    public class Entry {
        private ZipEntry zipEntry = null;
        private java.io.File fileEntry = null;

        private Entry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        private Entry(java.io.File fileEntry) {
            this.fileEntry = fileEntry;
        }

        public java.io.File getFile() {
            return this.fileEntry;
        }

        public byte[] getBytes() {
            try {
                ZipFile zip = new ZipFile(Jar.this.file);
                if (this.fileEntry == null) {
                    DataInputStream is = new DataInputStream(zip.getInputStream(this.zipEntry));
                    int bufferSize = 1024;
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    byte[] b = new byte[bufferSize];
                    int x = 0;
                    while ((x = is.read(b, 0, bufferSize)) > -1) {
                        bas.write(b, 0, x);
                    }
                    bas.close();
                    zip.close();
                    return bas.toByteArray();
                }
                byte[] b = new byte[(int)this.fileEntry.length()];
                DataInputStream is = new DataInputStream(new FileInputStream(this.fileEntry));
                is.readFully(b, 0, b.length);
                is.close();
                zip.close();
                return b;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void extractFile(java.io.File destination) {
            try {
                if (this.fileEntry == null) {
                    FileOutputStream out = new FileOutputStream(destination);
                    ZipInputStream in = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = in.getNextEntry()) != null) {
                        int len;
                        if (!zipEntry.getName().equals(this.zipEntry.getName())) continue;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        break block2;
                    }
                    in.close();
                    out.close();
                } else if (destination.isFile()) {
                    new File(this.fileEntry).copyTo(new File(destination), false);
                } else {
                    new File(this.fileEntry).copyTo(new Directory(destination), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setText(String text) {
            try {
                if (this.fileEntry == null) {
                    ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                    ByteArrayInputStream byteInput = new ByteArrayInputStream(text.getBytes());
                    ZipOutputStream zipOutput = new ZipOutputStream(byteOutput);
                    ZipInputStream zipInput = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipInput.getNextEntry()) != null) {
                        int len;
                        byte[] buf;
                        if (zipEntry.getName().equals(this.zipEntry.getName())) {
                            zipOutput.putNextEntry(new ZipEntry(this.zipEntry.getName()));
                            buf = new byte[1024];
                            while ((len = byteInput.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                            }
                            byteInput.close();
                        } else {
                            zipOutput.putNextEntry(zipEntry);
                            buf = new byte[1024];
                            while ((len = zipInput.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                            }
                        }
                        zipInput.closeEntry();
                        zipOutput.closeEntry();
                    }
                    zipInput.close();
                    zipOutput.close();
                    FileOutputStream fos = new FileOutputStream(Jar.this.file);
                    fos.write(byteOutput.toByteArray());
                    fos.close();
                    byteOutput.close();
                } else {
                    new File(this.fileEntry).write(text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getText() {
            try {
                if (this.fileEntry == null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ZipInputStream in = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = in.getNextEntry()) != null) {
                        int len;
                        if (!zipEntry.getName().equals(this.zipEntry.getName())) continue;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        break block2;
                    }
                    in.close();
                    return out.toString();
                }
                return new File(this.fileEntry).getText();
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return this.getText();
        }
    }
}

