/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javaxt.utils.string;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Date {
    private Locale currentLocale = Locale.getDefault();
    private TimeZone timeZone;
    private java.util.Date currDate;
    public static final String INTERVAL_MILLISECONDS = "S";
    public static final String INTERVAL_SECONDS = "s";
    public static final String INTERVAL_MINUTES = "m";
    public static final String INTERVAL_HOURS = "h";
    public static final String INTERVAL_DAYS = "d";
    public static final String INTERVAL_WEEKS = "w";
    public static final String INTERVAL_MONTHS = "m";
    public static final String INTERVAL_YEARS = "y";
    private static final HashMap<String, String> timezones;
    private static final String[] SupportedFormats;

    public Date() {
        this.currDate = new java.util.Date();
    }

    public Date(java.util.Date date) {
        this.currDate = date;
    }

    public Date(Calendar calendar) {
        this.currDate = calendar.getTime();
    }

    public Date(long milliseconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(milliseconds);
        this.currDate = cal.getTime();
    }

    public Date(String date) throws ParseException {
        try {
            if (date.length() >= "1976-06-07T13:02".length() && date.substring(10, 11).equalsIgnoreCase("T")) {
                date = date.replace("T", " ");
            }
            for (String format : SupportedFormats) {
                if (date.endsWith("Z") && format.endsWith("Z")) {
                    date = date.substring(0, date.length() - 1) + "UTC";
                }
                try {
                    this.currDate = this.parseDate(date, format);
                    return;
                }
                catch (ParseException e) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ParseException("Failed to parse date: " + date, 0);
    }

    public Date(String date, String format) throws ParseException {
        this.currDate = this.parseDate(date, format);
    }

    public void setDate(String date, String format) throws ParseException {
        this.currDate = this.parseDate(date, format);
    }

    public void setDate(java.util.Date date) {
        this.currDate = date;
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    private java.util.Date parseDate(String date, String format) throws ParseException {
        if (date != null && (date = date.trim()).length() == 0) {
            date = null;
        }
        if (date == null) {
            throw new ParseException("Date is null.", 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, this.currentLocale);
        if (this.timeZone != null) {
            formatter.setTimeZone(this.timeZone);
        }
        java.util.Date d = formatter.parse(date);
        this.timeZone = formatter.getTimeZone();
        return d;
    }

    public void setTimeZone(String timeZone, boolean preserveTimeStamp) {
        TimeZone timezone = Date.getTimeZone(timeZone);
        if (timezone == null) {
            return;
        }
        if (preserveTimeStamp) {
            String z1 = this.FormatDate(this.currDate, "z");
            SimpleDateFormat dateFormat = new SimpleDateFormat("z", this.currentLocale);
            dateFormat.setTimeZone(timezone);
            String z2 = dateFormat.format(this.currDate);
            String d = this.FormatDate(this.currDate, "yyyy-MM-dd HH:mm:ss.SSS z").replace(z1, z2);
            try {
                this.currDate = this.parseDate(d, "yyyy-MM-dd HH:mm:ss.SSS z");
            }
            catch (ParseException e) {}
        } else {
            this.timeZone = timezone;
        }
    }

    public void setTimeZone(String timeZone) {
        this.setTimeZone(timeZone, false);
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return;
        }
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int hashCode() {
        return this.currDate.hashCode();
    }

    public String toString() {
        return this.toString("EEE MMM dd HH:mm:ss z yyyy");
    }

    public String toString(String format) {
        SimpleDateFormat currFormatter = new SimpleDateFormat(format, this.currentLocale);
        if (this.timeZone != null) {
            currFormatter.setTimeZone(this.timeZone);
        }
        return currFormatter.format(this.currDate);
    }

    public String toString(String format, TimeZone timeZone) {
        SimpleDateFormat currFormatter = new SimpleDateFormat(format, this.currentLocale);
        if (timeZone != null) {
            currFormatter.setTimeZone(timeZone);
        }
        return currFormatter.format(this.currDate);
    }

    public long toLong() {
        Date d = this.clone();
        d.setTimeZone("UTC");
        return Long.parseLong(d.toString("yyyyMMddHHmmssSSS"));
    }

    public Date clone() {
        Date d = new Date(this.currDate.getTime());
        d.setTimeZone(this.getTimeZone());
        return d;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).getDate().equals(this.currDate);
        }
        if (obj instanceof java.util.Date) {
            return ((java.util.Date)obj).equals(this.currDate);
        }
        if (obj instanceof String) {
            try {
                return new Date((String)obj).equals(this.currDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return false;
    }

    private String FormatDate(java.util.Date date, String OutputFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(OutputFormat, this.currentLocale);
        if (this.timeZone != null) {
            formatter.setTimeZone(this.timeZone);
        }
        return formatter.format(date);
    }

    public long compareTo(Date date, String units) {
        return this.DateDiff(this.currDate, date.getDate(), units);
    }

    public long compareTo(java.util.Date date, String units) {
        return this.DateDiff(this.currDate, date, units);
    }

    private long DateDiff(java.util.Date date1, java.util.Date date2, String interval) {
        double div = 1.0;
        if (interval.equals(INTERVAL_MILLISECONDS) || interval.toLowerCase().startsWith("sec")) {
            div = 1000.0;
        }
        if (interval.equals("m") || interval.toLowerCase().startsWith("min")) {
            div = 60000.0;
        }
        if (interval.equals("H") || interval.toLowerCase().startsWith(INTERVAL_HOURS)) {
            div = 3600000.0;
        }
        if (interval.equals(INTERVAL_DAYS) || interval.toLowerCase().startsWith(INTERVAL_DAYS)) {
            div = 8.64E7;
        }
        if (interval.equals(INTERVAL_WEEKS) || interval.toLowerCase().startsWith(INTERVAL_WEEKS)) {
            div = 6.048E8;
        }
        if (interval.equals("M") || interval.toLowerCase().startsWith("mon")) {
            div = 2.592E9;
        }
        if (interval.equals(INTERVAL_YEARS) || interval.toLowerCase().startsWith(INTERVAL_YEARS)) {
            div = 3.1536E10;
        }
        long d1 = date1.getTime();
        long d2 = date2.getTime();
        int i2 = (int)Math.abs((double)(d1 - d2) / div);
        if (date2.after(date1)) {
            i2 = -i2;
        }
        return i2;
    }

    public boolean isBefore(String date) throws ParseException {
        return this.isBefore(new Date(date));
    }

    public boolean isBefore(Date Date2) {
        return this.currDate.before(Date2.getDate());
    }

    public boolean isAfter(String date) throws ParseException {
        return this.isAfter(new Date(date));
    }

    public boolean isAfter(Date Date2) {
        return this.currDate.after(Date2.getDate());
    }

    public java.util.Date add(int amount, String units) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currDate);
        int div = 0;
        if (units.equals(INTERVAL_MILLISECONDS) || units.toLowerCase().startsWith("sec")) {
            div = 14;
        } else if (units.equals("m") || units.toLowerCase().startsWith("min")) {
            div = 12;
        } else if (units.equals("H") || units.toLowerCase().startsWith(INTERVAL_HOURS)) {
            div = 11;
        } else if (units.equals(INTERVAL_DAYS) || units.toLowerCase().startsWith(INTERVAL_DAYS)) {
            div = 6;
        } else if (units.equals(INTERVAL_WEEKS) || units.toLowerCase().startsWith(INTERVAL_WEEKS)) {
            div = 3;
        } else if (units.equals("M") || units.toLowerCase().startsWith("mon")) {
            div = 2;
        } else if (units.equals(INTERVAL_YEARS) || units.toLowerCase().startsWith(INTERVAL_YEARS)) {
            div = 1;
        }
        cal.add(div, amount);
        this.currDate = cal.getTime();
        return this.currDate;
    }

    public java.util.Date getDate() {
        return this.currDate;
    }

    public long getTime() {
        return this.getCalendar().getTimeInMillis();
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.currDate);
        if (this.timeZone != null) {
            cal.setTimeZone(this.timeZone);
        }
        return cal;
    }

    public String getWeekdayName() {
        return this.FormatDate(this.currDate, "EEEEEE");
    }

    public String getMonthName() {
        return this.FormatDate(this.currDate, "MMMMMM");
    }

    public int getDayOfWeek() {
        return Integer.valueOf(this.FormatDate(this.currDate, "F"));
    }

    public int getWeekInMonth() {
        return Integer.valueOf(this.FormatDate(this.currDate, "W"));
    }

    public int getDayInYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, "D"));
    }

    public int getWeekInYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_WEEKS));
    }

    public int getYear() {
        return Integer.valueOf(this.FormatDate(this.currDate, "yyyy"));
    }

    public int getMonth() {
        return Integer.valueOf(this.FormatDate(this.currDate, "MM"));
    }

    public int getDay() {
        return Integer.valueOf(this.FormatDate(this.currDate, "dd"));
    }

    public int getHour() {
        return Integer.valueOf(this.FormatDate(this.currDate, "HH"));
    }

    public int getMinute() {
        return Integer.valueOf(this.FormatDate(this.currDate, "m"));
    }

    public int getSecond() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_SECONDS));
    }

    public int getMilliSecond() {
        return Integer.valueOf(this.FormatDate(this.currDate, INTERVAL_MILLISECONDS));
    }

    public boolean hasTimeStamp() {
        return Date.hasTimeStamp(this.getDate());
    }

    private static boolean hasTimeStamp(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        int ms = cal.get(14);
        return hour > 0 || min > 0 || sec > 0 || ms > 0;
    }

    public static List sortDates(List dates) {
        while (dates.contains(null)) {
            dates.remove(null);
        }
        Collections.sort(dates, new DateComparer());
        return dates;
    }

    public static TimeZone getTimeZone(String timezone) {
        if (timezone == null) {
            return null;
        }
        if ((timezone = timezone.trim()).length() == 0) {
            return null;
        }
        if ((timezone = timezone.toUpperCase()).startsWith("UTC+") || timezone.startsWith("UTC-")) {
            timezone = "GMT" + timezone.substring(3);
        } else if ((timezone.startsWith("AMERICA/") || timezone.startsWith("AFRICA/") || timezone.startsWith("EUROPE/") || timezone.startsWith("ASIA/") || timezone.startsWith("AUSTRALIA/") || timezone.startsWith("PACIFIC/") || timezone.startsWith("ATLANTIC/") || timezone.startsWith("INDIAN/")) && timezone.contains(" ")) {
            timezone = timezone.replace(" ", "_");
        }
        if (timezones.containsKey(timezone)) {
            return TimeZone.getTimeZone(timezones.get(timezone));
        }
        return null;
    }

    public static HashMap<String, String> getTimeZones() {
        return timezones;
    }

    static {
        String[][] kvp;
        timezones = new HashMap();
        SupportedFormats = new String[]{"EEE, d MMM yyyy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM d HH:mm:ss z yyyy", "EEE MMM dd HH:mm:ss yyyy", "EEE MMM d HH:mm:ss yyyy", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss", "yyyy:MM:dd HH:mm:ss", "yyyy-MM-dd-HH:mm:ss.SSS", "yyyy-MM-dd-HH:mm:ss", "dd-MMM-yyyy h:mm:ss a", "dd-MMM-yy h:mm:ss a", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm", "yyyy-MM-dd", "dd-MMM-yy", "dd-MMM-yyyy", "MMMMMM d, yyyy", "M/d/yy h:mm:ss a", "M/d/yy h:mm a", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy HH:mm", "M/d/yy", "MM/dd/yyyy", "M/d/yyyy", "yyyyMMddHHmmssSSS", "yyyyMMddHHmmss", "yyyyMMdd"};
        timezones.put("EDT", "EST5EDT");
        timezones.put("CDT", "CST6CDT");
        timezones.put("MDT", "MST7MDT");
        timezones.put("PDT", "PST8PDT");
        for (String id : TimeZone.getAvailableIDs()) {
            TimeZone timezone = TimeZone.getTimeZone(id);
            timezones.put(id.toUpperCase(), id);
            String shortName = timezone.getDisplayName(true, 0);
            if (!timezones.containsKey(shortName)) {
                timezones.put(shortName.toUpperCase(), id);
            }
            double offset = timezone.getRawOffset();
            String str = offset / 3600000.0 + "";
            int h = Integer.parseInt(str.substring(0, str.indexOf(".")));
            double m = Double.parseDouble("0." + str.substring(str.indexOf(".") + 1)) * 60.0;
            String gmt = "GMT" + (h > -1 ? "+" : "-") + String.format("%02d", h < 0 ? -h : h) + ":" + String.format("%02d", (int)string.round(m, 0));
            if (timezones.containsKey(gmt)) continue;
            timezones.put(gmt, gmt);
        }
        for (String[] pair : kvp = new String[][]{{"(UTC+13:00) Nuku'alofa", "Tonga Standard Time", "Pacific/Tongatapu"}, {"(UTC+12:00) Petropavlovsk-Kamchatsky", "Kamchatka Standard Time", "Asia/Kamchatka"}, {"(UTC+12:00) Fiji, Marshall Is.", "Fiji Standard Time", "Pacific/Fiji"}, {"(UTC+12:00) Auckland, Wellington", "New Zealand Standard Time", "Pacific/Auckland"}, {"(UTC+11:00) Magadan, Solomon Is., New Caledonia", "Central Pacific Standard Time", "Pacific/Guadalcanal"}, {"(UTC+10:00) Vladivostok", "Vladivostok Standard Time", "Asia/Vladivostok"}, {"(UTC+10:00) Hobart", "Tasmania Standard Time", "Australia/Hobart"}, {"(UTC+10:00) Guam, Port Moresby", "West Pacific Standard Time", "Pacific/Port_Moresby"}, {"(UTC+10:00) Canberra, Melbourne, Sydney", "AUS Eastern Standard Time", "Australia/Sydney"}, {"(UTC+10:00) Brisbane", "E. Australia Standard Time", "Australia/Brisbane"}, {"(UTC+09:30) Darwin", "AUS Central Standard Time", "Australia/Darwin"}, {"(UTC+09:30) Adelaide", "Cen. Australia Standard Time", "Australia/Adelaide"}, {"(UTC+09:00) Yakutsk", "Yakutsk Standard Time", "Asia/Yakutsk"}, {"(UTC+09:00) Seoul", "Korea Standard Time", "Asia/Seoul"}, {"(UTC+09:00) Osaka, Sapporo, Tokyo", "Tokyo Standard Time", "Asia/Tokyo"}, {"(UTC+08:00) Taipei", "Taipei Standard Time", "Asia/Taipei"}, {"(UTC+08:00) Perth", "W. Australia Standard Time", "Australia/Perth"}, {"(UTC+08:00) Kuala Lumpur, Singapore", "Singapore Standard Time", "Asia/Singapore"}, {"(UTC+08:00) Irkutsk, Ulaan Bataar", "North Asia East Standard Time", "Asia/Irkutsk"}, {"(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi", "China Standard Time", "Asia/Shanghai"}, {"(UTC+07:00) Krasnoyarsk", "North Asia Standard Time", "Asia/Krasnoyarsk"}, {"(UTC+07:00) Bangkok, Hanoi, Jakarta", "SE Asia Standard Time", "Asia/Bangkok"}, {"(UTC+06:30) Yangon (Rangoon)", "Myanmar Standard Time", "Asia/Rangoon"}, {"(UTC+06:00) Astana, Dhaka", "Central Asia Standard Time", "Asia/Almaty"}, {"(UTC+06:00) Almaty, Novosibirsk", "N. Central Asia Standard Time", "Asia/Novosibirsk"}, {"(UTC+05:45) Kathmandu", "Nepal Standard Time", "Asia/Katmandu"}, {"(UTC+05:30) Sri Jayawardenepura", "Sri Lanka Standard Time", "Asia/Colombo"}, {"(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi", "India Standard Time", "Asia/Calcutta"}, {"(UTC+05:00) Tashkent", "West Asia Standard Time", "Asia/Tashkent"}, {"(UTC+05:00) Islamabad, Karachi", "Pakistan Standard Time", "Asia/Karachi"}, {"(UTC+05:00) Ekaterinburg", "Ekaterinburg Standard Time", "Asia/Yekaterinburg"}, {"(UTC+04:30) Kabul", "Afghanistan Standard Time", "Asia/Kabul"}, {"(UTC+04:00) Yerevan", "Caucasus Standard Time", "Asia/Yerevan"}, {"(UTC+04:00) Port Louis", "Mauritius Standard Time", "Indian/Mauritius"}, {"(UTC+04:00) Baku", "Azerbaijan Standard Time", "Asia/Baku"}, {"(UTC+04:00) Abu Dhabi, Muscat", "Arabian Standard Time", "Asia/Dubai"}, {"(UTC+03:30) Tehran", "Iran Standard Time", "Asia/Tehran"}, {"(UTC+03:00) Tbilisi", "Georgian Standard Time", "Asia/Tbilisi"}, {"(UTC+03:00) Nairobi", "E. Africa Standard Time", "Africa/Nairobi"}, {"(UTC+03:00) Moscow, St. Petersburg, Volgograd", "Russian Standard Time", "Europe/Moscow"}, {"(UTC+03:00) Kuwait, Riyadh", "Arab Standard Time", "Asia/Riyadh"}, {"(UTC+03:00) Baghdad", "Arabic Standard Time", "Asia/Baghdad"}, {"(UTC+02:00) Windhoek", "Namibia Standard Time", "Africa/Windhoek"}, {"(UTC+02:00) Minsk", "E. Europe Standard Time", "Europe/Minsk"}, {"(UTC+02:00) Jerusalem", "Israel Standard Time", "Asia/Jerusalem"}, {"(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius", "FLE Standard Time", "Europe/Kiev"}, {"(UTC+02:00) Harare, Pretoria", "South Africa Standard Time", "Africa/Johannesburg"}, {"(UTC+02:00) Cairo", "Egypt Standard Time", "Africa/Cairo"}, {"(UTC+02:00) Beirut", "Middle East Standard Time", "Asia/Beirut"}, {"(UTC+02:00) Athens, Bucharest, Istanbul", "GTB Standard Time", "Europe/Istanbul"}, {"(UTC+02:00) Amman", "Jordan Standard Time", "Asia/Amman"}, {"(UTC+01:00) West Central Africa", "W. Central Africa Standard Time", "Africa/Lagos"}, {"(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb", "Central European Standard Time", "Europe/Warsaw"}, {"(UTC+01:00) Brussels, Copenhagen, Madrid, Paris", "Romance Standard Time", "Europe/Paris"}, {"(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague", "Central Europe Standard Time", "Europe/Budapest"}, {"(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna", "W. Europe Standard Time", "Europe/Berlin"}, {"(UTC) Monrovia, Reykjavik", "Greenwich Standard Time", "Atlantic/Reykjavik"}, {"(UTC) Dublin, Edinburgh, Lisbon, London", "GMT Standard Time", "Europe/London"}, {"(UTC) Coordinated Universal Time", "UTC", "UTC"}, {"(UTC) Casablanca", "Morocco Standard Time", "Africa/Casablanca"}, {"(UTC-12:00) International Date Line West", "Dateline Standard Time", "Etc/GMT+12"}, {"(UTC-11:00) Midway Island, Samoa", "Samoa Standard Time", "Pacific/Apia"}, {"(UTC-10:00) Hawaii", "Hawaiian Standard Time", "Pacific/Honolulu"}, {"(UTC-09:00) Alaska", "Alaskan Standard Time", "America/Anchorage"}, {"(UTC-08:00) Tijuana, Baja California", "Pacific Standard Time (Mexico)", "America/Tijuana"}, {"(UTC-08:00) Pacific Time (US & Canada)", "Pacific Standard Time", "America/Los_Angeles"}, {"(UTC-07:00) Mountain Time (US & Canada)", "Mountain Standard Time", "America/Denver"}, {"(UTC-07:00) Chihuahua, La Paz, Mazatlan", "Mountain Standard Time (Mexico)", "America/Chihuahua"}, {"(UTC-07:00) Arizona", "US Mountain Standard Time", "America/Phoenix"}, {"(UTC-06:00) Saskatchewan", "Canada Central Standard Time", "America/Regina"}, {"(UTC-06:00) Guadalajara, Mexico City, Monterrey", "Central Standard Time (Mexico)", "America/Mexico_City"}, {"(UTC-06:00) Central Time (US & Canada)", "Central Standard Time", "America/Chicago"}, {"(UTC-06:00) Central America", "Central America Standard Time", "America/Guatemala"}, {"(UTC-05:00) Indiana (East)", "US Eastern Standard Time", "America/Indianapolis"}, {"(UTC-05:00) Eastern Time (US & Canada)", "Eastern Standard Time", "America/New_York"}, {"(UTC-05:00) Bogota, Lima, Quito", "SA Pacific Standard Time", "America/Bogota"}, {"(UTC-04:30) Caracas", "Venezuela Standard Time", "America/Caracas"}, {"(UTC-04:00) Santiago", "Pacific SA Standard Time", "America/Santiago"}, {"(UTC-04:00) Manaus", "Central Brazilian Standard Time", "America/Cuiaba"}, {"(UTC-04:00) Georgetown, La Paz, San Juan", "SA Western Standard Time", "America/La_Paz"}, {"(UTC-04:00) Atlantic Time (Canada)", "Atlantic Standard Time", "America/Halifax"}, {"(UTC-04:00) Asuncion", "Paraguay Standard Time", "America/Asuncion"}, {"(UTC-03:30) Newfoundland", "Newfoundland Standard Time", "America/St_Johns"}, {"(UTC-03:00) Montevideo", "Montevideo Standard Time", "America/Montevideo"}, {"(UTC-03:00) Greenland", "Greenland Standard Time", "America/Godthab"}, {"(UTC-03:00) Cayenne", "SA Eastern Standard Time", "America/Cayenne"}, {"(UTC-03:00) Buenos Aires", "Argentina Standard Time", "America/Buenos_Aires"}, {"(UTC-03:00) Brasilia", "E. South America Standard Time", "America/Sao_Paulo"}, {"(UTC-02:00) Mid-Atlantic", "Mid-Atlantic Standard Time", "Etc/GMT+2"}, {"(UTC-01:00) Cape Verde Is.", "Cape Verde Standard Time", "Atlantic/Cape_Verde"}, {"(UTC-01:00) Azores", "Azores Standard Time", "Atlantic/Azores"}}) {
            timezones.put(pair[0].toUpperCase(), pair[2]);
            timezones.put(pair[1].toUpperCase(), pair[2]);
        }
    }

    private static class DateComparer
    implements Comparator {
        private DateComparer() {
        }

        public final int compare(Object a, Object b) {
            Long y;
            if (a == null || b == null) {
                return -1;
            }
            java.util.Date d1 = null;
            java.util.Date d2 = null;
            if (a instanceof java.util.Date) {
                d1 = (java.util.Date)a;
            } else if (a instanceof Date) {
                d1 = ((Date)a).getDate();
            }
            if (b instanceof java.util.Date) {
                d2 = (java.util.Date)b;
            } else if (b instanceof Date) {
                d2 = ((Date)b).getDate();
            }
            if (d1 == null || d2 == null) {
                return -1;
            }
            Long x = d1.getTime();
            int result = x.compareTo(y = Long.valueOf(d2.getTime()));
            if (result != 0) {
                Calendar c1 = Calendar.getInstance();
                c1.setTime(d1);
                Calendar c2 = Calendar.getInstance();
                c2.setTime(d2);
                if (c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5)) {
                    if (Date.hasTimeStamp(d1) && !Date.hasTimeStamp(d2)) {
                        result = -1;
                    } else if (!Date.hasTimeStamp(d1) && Date.hasTimeStamp(d2)) {
                        result = 1;
                    }
                }
            }
            return result;
        }
    }
}

