/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.net.URI;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    private HashMap<String, List<String>> parameters;
    private String protocol;
    private String host;
    private Integer port;
    private String path;

    public URL(java.net.URL url) {
        this(url.toString());
    }

    public URL(String url) {
        url = url.trim();
        this.parameters = new HashMap();
        if (url.contains("://")) {
            this.protocol = url.substring(0, url.indexOf("://"));
            url = url.substring(url.indexOf("://") + 3);
        } else if (url.startsWith("jdbc")) {
            this.protocol = url.substring(0, url.indexOf(";"));
            url = url.substring(url.indexOf(";") + 1);
        }
        if (url.contains("?")) {
            String query = url.substring(url.indexOf("?") + 1);
            url = url.substring(0, url.indexOf("?"));
            this.parameters = URL.parseQueryString(query);
        } else if (url.contains(";")) {
            url = url.substring(0, url.indexOf(";"));
        }
        if (url.contains("/")) {
            this.path = url.substring(url.indexOf("/"));
            url = url.substring(0, url.indexOf("/"));
        }
        if (url.contains(":")) {
            try {
                this.port = Integer.valueOf(url.substring(url.indexOf(":") + 1));
                url = url.substring(0, url.indexOf(":"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.host = url;
    }

    public boolean exists() {
        try {
            URLConnection conn = new java.net.URL(this.toString()).openConnection();
            conn.setConnectTimeout(5000);
            conn.getInputStream();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static HashMap<String, List<String>> parseQueryString(String query) {
        int i;
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (query == null) {
            return parameters;
        }
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (Exception e) {
            String[] find = new String[]{"%2C", "%2F", "%3A"};
            String[] replace = new String[]{",", "/", ":"};
            for (i = 0; i < find.length; ++i) {
                query = query.replace(find[i], replace[i]);
            }
        }
        boolean amp = query.contains("&amp;");
        if (amp) {
            query = query.replace("&amp;", "&");
        }
        if (query.startsWith("&")) {
            query = query.substring(1);
        }
        query = query + "&";
        StringBuffer word = new StringBuffer();
        String c = "";
        for (i = 0; i < query.length(); ++i) {
            c = query.substring(i, i + 1);
            if (!c.equals("&")) {
                word.append(c);
                continue;
            }
            int x = word.indexOf("=");
            if (x >= 0) {
                List<String> values;
                String key = word.substring(0, x).toLowerCase();
                String value = word.substring(x + 1);
                if (amp && value.contains(";")) {
                    value = value.substring(0, value.indexOf(";"));
                }
                if ((values = parameters.get(key)) == null) {
                    values = new LinkedList<String>();
                }
                values.add(value);
                parameters.put(key, values);
            } else {
                parameters.put(word.toString(), null);
            }
            word = new StringBuffer();
        }
        return parameters;
    }

    public void setParameter(String key, String value, boolean append) {
        key = key.toLowerCase();
        if (append) {
            List<String> values = this.parameters.get(key);
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                if (!it.next().equalsIgnoreCase(value)) continue;
                append = false;
                break;
            }
            if (append) {
                values.add(value);
                this.parameters.put(key, values);
            }
        } else if (value != null) {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.parameters.put(key, values);
        }
    }

    public void setParameter(String key, String value) {
        this.setParameter(key, value, false);
    }

    public String getParameter(String key) {
        StringBuffer str = new StringBuffer();
        List<String> values = this.parameters.get(key.toLowerCase());
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public String getParameter(String[] keys) {
        StringBuffer str = new StringBuffer();
        for (String key : keys) {
            List<String> values = this.parameters.get(key.toLowerCase());
            if (values == null) continue;
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i) + ",");
            }
        }
        String value = str.toString();
        if (value.endsWith(",")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    public HashMap<String, List<String>> getParameters() {
        return this.parameters;
    }

    public String removeParameter(String key) {
        StringBuffer str = new StringBuffer();
        List<String> values = this.parameters.remove(key.toLowerCase());
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                str.append(values.get(i));
                if (i >= values.size() - 1) continue;
                str.append(",");
            }
            return str.toString();
        }
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host.contains(":")) {
            this.port = Integer.valueOf(host.substring(host.indexOf(":") + 1));
            host = host.substring(0, host.indexOf(":"));
        }
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        StringBuffer str = new StringBuffer();
        HashSet<String> keys = this.getKeys();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = this.getParameter(key);
            if (value.length() == 0 && this.parameters.get(key.toLowerCase()) == null) {
                value = null;
            }
            str.append(key);
            if (value != null) {
                str.append("=" + value);
            }
            if (!it.hasNext()) continue;
            str.append("&");
        }
        return str.toString();
    }

    public void setQueryString(String query) {
        if (query == null) {
            this.parameters = new HashMap();
        } else {
            if ((query = query.trim()).startsWith("?")) {
                query = query.substring(1).trim();
            }
            if (query.length() > 0) {
                this.parameters = URL.parseQueryString(query);
            }
        }
    }

    public HashSet<String> getKeys() {
        HashSet<String> keys = new HashSet<String>();
        Iterator<String> it = this.parameters.keySet().iterator();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path != null && !(path = path.trim()).startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public String toString() {
        String query;
        String host = this.host;
        if (this.port != null && this.port > 0) {
            host = host + ":" + this.port;
        }
        String path = "";
        if (this.getPath() != null) {
            path = this.getPath();
        }
        if ((query = this.getQueryString()).length() > 0) {
            query = "?" + query;
        }
        return this.protocol + "://" + host + path + query;
    }

    public java.net.URL toURL() {
        java.net.URL url = null;
        try {
            Integer port = this.port;
            if (port == null) {
                if (this.protocol.equalsIgnoreCase("http")) {
                    port = 80;
                } else if (this.protocol.equalsIgnoreCase("https")) {
                    port = 443;
                } else if (this.protocol.equalsIgnoreCase("ftp")) {
                    port = 23;
                } else {
                    try {
                        port = new java.net.URL(this.protocol + "://" + this.host).getPort();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            url = new URI(this.protocol, null, this.host, port, this.path, null, null).toURL();
            HashSet<String> keys = this.getKeys();
            Iterator<String> it = keys.iterator();
            if (it.hasNext()) {
                StringBuffer str = new StringBuffer();
                while (it.hasNext()) {
                    String key = it.next();
                    String value = this.getParameter(key);
                    if (value.length() == 0 && this.parameters.get(key.toLowerCase()) == null) {
                        value = null;
                    }
                    str.append(URLEncoder.encode(key, "UTF-8"));
                    if (value != null) {
                        str.append("=" + URLEncoder.encode(value, "UTF-8"));
                    }
                    if (!it.hasNext()) continue;
                    str.append("&");
                }
                url = new java.net.URL(url.toString() + "?" + str.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }
}

