/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import javaxt.utils.Date;

public class Value {
    private Object value = null;

    public Value(Object value) {
        this.value = value;
    }

    public Object toObject() {
        return this.value;
    }

    public Integer toInteger() {
        if (this.value == null) {
            return null;
        }
        try {
            return Integer.valueOf(this.prepNumber(this.value + ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Short toShort() {
        if (this.value == null) {
            return null;
        }
        try {
            return Short.valueOf(this.prepNumber(this.value + ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double toDouble() {
        if (this.value == null) {
            return null;
        }
        try {
            return Double.valueOf(this.prepNumber(this.value + ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long toLong() {
        if (this.value == null) {
            return null;
        }
        try {
            return Long.valueOf(this.prepNumber(this.value + ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigDecimal toBigDecimal() {
        if (this.value == null) {
            return null;
        }
        try {
            return BigDecimal.valueOf(this.toDouble());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Float toFloat() {
        if (this.value == null) {
            return null;
        }
        try {
            return Float.valueOf(this.prepNumber(this.value + ""));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date toDate() {
        if (this.value != null) {
            if (this.value instanceof Timestamp) {
                Timestamp ts = (Timestamp)this.value;
                return new Date(ts.getTime());
            }
            if (this.value instanceof java.util.Date) {
                return new Date((java.util.Date)this.value);
            }
            if (this.value instanceof Calendar) {
                return new Date((Calendar)this.value);
            }
            try {
                return new Date(this.value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public byte[] toByteArray() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.value);
            out.flush();
            out.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Boolean toBoolean() {
        if (this.value != null) {
            String value = this.value.toString().toLowerCase().trim();
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
            if (value.equals("yes")) {
                return true;
            }
            if (value.equals("no")) {
                return false;
            }
            if (value.equals("y")) {
                return true;
            }
            if (value.equals("n")) {
                return false;
            }
            if (value.equals("t")) {
                return true;
            }
            if (value.equals("f")) {
                return false;
            }
            if (value.equals("1")) {
                return true;
            }
            if (value.equals("0")) {
                return false;
            }
        }
        return null;
    }

    public boolean isNumeric() {
        return this.toDouble() != null;
    }

    public boolean isArray() {
        return this.value != null && this.value.getClass().isArray();
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            obj = ((Value)obj).toObject();
        }
        if (obj == null) {
            return this.value == null;
        }
        if (this.value == null) {
            return false;
        }
        return obj.equals(this.value);
    }

    private String prepNumber(String value) {
        if ((value = value.trim()).startsWith("$")) {
            value = value.substring(1).trim();
        } else if (value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
        }
        value = value.replace(",", "");
        return value;
    }
}

