/*
 * Decompiled with CFR 0.152.
 */
package javaxt.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import javaxt.sql.Column;
import javaxt.sql.Key;

public class Table
implements Comparable {
    private DatabaseMetaData dbmd = null;
    private String Name;
    private String Description;
    private String Schema;
    private String Catalog;

    protected Table(ResultSet rs, DatabaseMetaData dbmd) {
        try {
            this.Name = rs.getString("TABLE_NAME");
            this.Description = rs.getString("REMARKS");
            this.Catalog = rs.getString("TABLE_CAT");
            this.Schema = rs.getString("TABLE_SCHEM");
            this.dbmd = dbmd;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Table() {
    }

    public String getName() {
        return this.Name;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getSchema() {
        return this.Schema;
    }

    public String getCatalog() {
        return this.Catalog;
    }

    public Column[] getColumns() {
        try {
            ArrayList<Column> columns = new ArrayList<Column>();
            Key[] Keys = this.getPrimaryKeys();
            Key[] FKeys = this.getForeignKeys();
            ResultSet rs = this.dbmd.getColumns(this.Catalog, this.Schema, this.Name, null);
            while (rs.next()) {
                int i;
                Column column = new Column(rs, this);
                if (Keys != null) {
                    for (i = 0; i < Keys.length; ++i) {
                        if (!column.getName().equals(Keys[i].Name)) continue;
                        column.setIsPrimaryKey(true);
                    }
                }
                if (FKeys != null) {
                    for (i = 0; i < FKeys.length; ++i) {
                        if (!column.getName().equals(FKeys[i].Name)) continue;
                        column.setForeignKey(FKeys[i]);
                    }
                }
                columns.add(column);
            }
            rs.close();
            return columns.toArray(new Column[columns.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key[] getPrimaryKeys() {
        try {
            ArrayList<Key> keys = new ArrayList<Key>();
            ResultSet rs = this.dbmd.getPrimaryKeys(this.Catalog, this.Schema, this.Name);
            while (rs.next()) {
                Key key = new Key();
                key.Name = rs.getString("PK_NAME");
                key.Table = new Table();
                key.Table.Name = rs.getString("TABLE_NAME");
                key.Table.Catalog = rs.getString("TABLE_CAT");
                key.Table.Schema = rs.getString("TABLE_SCHEM");
                key.Column = rs.getString("COLUMN_NAME");
                keys.add(key);
            }
            rs.close();
            rs = null;
            return keys.toArray(new Key[keys.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key[] getForeignKeys() {
        try {
            ArrayList<Key> keys = new ArrayList<Key>();
            ResultSet rs = this.dbmd.getImportedKeys(this.Catalog, this.Schema, this.Name);
            while (rs.next()) {
                Key Key2 = new Key();
                Key2.Name = rs.getString("FKCOLUMN_NAME");
                Key2.Table = new Table();
                Key2.Table.Name = rs.getString("PKTABLE_NAME");
                Key2.Table.Catalog = rs.getString("PKTABLE_CAT");
                Key2.Table.Schema = rs.getString("PKTABLE_SCHEM");
                Key2.Column = rs.getString("PKCOLUMN_NAME");
                keys.add(Key2);
            }
            rs.close();
            rs = null;
            return keys.toArray(new Key[keys.size()]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        return -obj.toString().compareTo(this.toString());
    }
}

