/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javaxt.io.Directory;
import javaxt.io.File;

public class Jar {
    private java.io.File file;
    private Package Package;

    public Jar(Object object) {
        this(object.getClass());
    }

    public Jar(Class Class2) {
        ArrayList<URL> urls;
        this.Package = Class2.getPackage();
        String path = Class2.getName();
        if (path != null) {
            path = path.replace(".", "/") + ".class";
        }
        if ((urls = Jar.getResource(path, Class2.getClassLoader())).size() == 1) {
            this.file = Jar.getFile(urls.get(0));
        }
    }

    public Jar(Package Package2) {
        this.Package = Package2;
        String path = Package2.getName().replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (URL url : Jar.getResource(path, classLoader)) {
            this.file = Jar.getFile(url);
            if (this.file == null) continue;
            break;
        }
    }

    public Jar(java.io.File file) {
        this.file = file;
    }

    public static Jar[] getJars(Package Package2) {
        return Jar.getJars(Package2.getName());
    }

    public static Jar[] getJars(String packageName) {
        ArrayList<Jar> jars = new ArrayList<Jar>();
        String path = packageName.replace(".", "/");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (URL url : Jar.getResource(path, classLoader)) {
            java.io.File file = Jar.getFile(url);
            if (file == null) continue;
            jars.add(new Jar(file));
        }
        return jars.toArray(new Jar[jars.size()]);
    }

    public java.io.File getFile() {
        return this.file;
    }

    public Manifest getManifest() {
        try {
            Entry entry = this.getEntry("META-INF", "MANIFEST.MF");
            if (entry != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(entry.getBytes());
                Manifest manifest = new Manifest(is);
                is.close();
                return manifest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getVersion() {
        String fileName;
        Attributes attributes = this.getManifest().getMainAttributes();
        if (attributes != null) {
            for (Attributes.Name name : attributes.keySet()) {
                String keyword = name.toString();
                if (!keyword.equals("Implementation-Version") && !keyword.equals("Bundle-Version")) continue;
                return (String)attributes.get(name);
            }
        }
        if ((fileName = this.file.getName().substring(0, this.file.getName().lastIndexOf("."))).contains(".")) {
            String string2 = fileName.substring(0, fileName.indexOf("."));
            int delimiter = string2.lastIndexOf("-");
            if (string2.indexOf("_") > delimiter) {
                delimiter = string2.indexOf("_");
            }
            String string3 = string2.substring(delimiter + 1, fileName.indexOf("."));
            String minorVersion = fileName.substring(fileName.indexOf("."));
            return string3 + minorVersion;
        }
        return null;
    }

    public Entry[] getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try {
            if (this.file.isDirectory()) {
                Directory dir = new Directory(this.file);
                List items = dir.getChildren(true);
                for (int i = 0; i < items.size(); ++i) {
                    Object item = items.get(i);
                    if (!(item instanceof File)) continue;
                    entries.add(new Entry(((File)item).toFile()));
                }
            } else {
                ZipInputStream in = new ZipInputStream(new FileInputStream(this.file));
                ZipEntry zipEntry = null;
                while ((zipEntry = in.getNextEntry()) != null) {
                    entries.add(new Entry(zipEntry));
                }
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry getEntry(String Entry2) {
        return this.getEntry(this.Package.getName(), Entry2);
    }

    public Entry getEntry(String Package2, String Entry2) {
        block9: {
            ZipInputStream in = null;
            try {
                if (this.file.isDirectory()) {
                    return new Entry(new java.io.File(this.file, Entry2));
                }
                if (Package2 != null && (Package2 = Package2.trim()).length() == 0) {
                    Package2 = null;
                }
                if (Package2 != null) {
                    if (Package2.contains(".")) {
                        Package2 = Package2.replace(".", "/");
                    }
                    Entry2 = Package2 + "/" + Entry2;
                }
                in = new ZipInputStream(new FileInputStream(this.file));
                ZipEntry zipEntry = null;
                while ((zipEntry = in.getNextEntry()) != null) {
                    if (!zipEntry.getName().equalsIgnoreCase(Entry2)) continue;
                    Entry entry = new Entry(zipEntry);
                    in.close();
                    return entry;
                }
                in.close();
            }
            catch (Exception e) {
                if (in == null) break block9;
                try {
                    in.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Entry getEntry(Class Class2) {
        String ClassName = Class2.getName();
        String PackageName = Class2.getPackage().getName();
        ClassName = ClassName.substring(PackageName.length() + 1);
        return this.getEntry(PackageName, ClassName + ".class");
    }

    public String toString() {
        return this.file.toString();
    }

    private static ArrayList<URL> getResource(String path, ClassLoader cl) {
        ArrayList<URL> arr = new ArrayList<URL>();
        try {
            int x = 0;
            while (cl != null || (cl = Thread.currentThread().getContextClassLoader()) != null || (cl = ClassLoader.getSystemClassLoader()) != null) {
                Enumeration<URL> en = cl.getResources(path);
                if (en.hasMoreElements()) {
                    while (en.hasMoreElements()) {
                        URL url = en.nextElement();
                        arr.add(url);
                    }
                } else if (cl.getParent() == null || !cl.getParent().equals(cl)) {
                    cl = cl.getParent();
                    if (++x != 50) continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    private static java.io.File getFile(URL url) {
        block8: {
            if (url != null) {
                try {
                    URI uri = new URI(url.toString().replace(" ", "%20"));
                    if (uri.getPath() == null) {
                        String path = uri.toString();
                        if (path.startsWith("jar:file:")) {
                            path = path.substring(path.indexOf("file:/"));
                            if ((path = path.substring(0, path.toLowerCase().indexOf(".jar") + 4)).startsWith("file://")) {
                                path = "C:/" + path.substring(path.indexOf("file:/") + 7);
                                path = "/" + new URI(path).getPath();
                            } else {
                                path = new URI(path).getPath();
                            }
                            return new java.io.File(path);
                        }
                        if (path.startsWith("jar:http")) {
                            path = path.substring(path.indexOf("http"));
                            String string2 = path.substring(0, path.toLowerCase().indexOf(".jar") + 4);
                        }
                        break block8;
                    }
                    return new java.io.File(uri);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public class Entry {
        private ZipEntry zipEntry = null;
        private java.io.File fileEntry = null;

        private Entry(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        private Entry(java.io.File fileEntry) {
            this.fileEntry = fileEntry;
        }

        public String getName() {
            if (this.fileEntry == null) {
                return this.zipEntry.getName();
            }
            return this.fileEntry.getName();
        }

        public Date getDate() {
            if (this.fileEntry == null) {
                return new Date(this.zipEntry.getTime());
            }
            return new Date(this.fileEntry.lastModified());
        }

        public long checksum() {
            if (this.fileEntry == null) {
                return this.zipEntry.getCrc();
            }
            return new File(this.fileEntry).checksum();
        }

        public java.io.File getFile() {
            return this.fileEntry;
        }

        public long getSize() {
            if (this.fileEntry == null) {
                return this.zipEntry.getSize();
            }
            return this.fileEntry.length();
        }

        public byte[] getBytes() {
            ZipFile zip = null;
            try {
                if (this.fileEntry == null) {
                    zip = new ZipFile(Jar.this.file);
                    DataInputStream is = new DataInputStream(zip.getInputStream(this.zipEntry));
                    int bufferSize = 1024;
                    ByteArrayOutputStream bas = new ByteArrayOutputStream();
                    byte[] b = new byte[bufferSize];
                    int x = 0;
                    while ((x = is.read(b, 0, bufferSize)) > -1) {
                        bas.write(b, 0, x);
                    }
                    bas.close();
                    zip.close();
                    return bas.toByteArray();
                }
                return new File(this.fileEntry).getBytes().toByteArray();
            }
            catch (Exception e) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        public void extractFile(java.io.File destination) {
            try {
                if (this.fileEntry == null) {
                    destination.getParentFile().mkdirs();
                    FileOutputStream out = new FileOutputStream(destination);
                    ZipInputStream in = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = in.getNextEntry()) != null) {
                        int len;
                        if (!zipEntry.getName().equals(this.zipEntry.getName())) continue;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        break block2;
                    }
                    in.close();
                    out.close();
                } else if (destination.isFile()) {
                    new File(this.fileEntry).copyTo(new File(destination), false);
                } else {
                    new File(this.fileEntry).copyTo(new Directory(destination), false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setText(String text) {
            try {
                if (this.fileEntry == null) {
                    ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                    ByteArrayInputStream byteInput = new ByteArrayInputStream(text.getBytes());
                    ZipOutputStream zipOutput = new ZipOutputStream(byteOutput);
                    ZipInputStream zipInput = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = zipInput.getNextEntry()) != null) {
                        int len;
                        byte[] buf;
                        if (zipEntry.getName().equals(this.zipEntry.getName())) {
                            zipOutput.putNextEntry(new ZipEntry(this.zipEntry.getName()));
                            buf = new byte[1024];
                            while ((len = byteInput.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                            }
                            byteInput.close();
                        } else {
                            zipOutput.putNextEntry(zipEntry);
                            buf = new byte[1024];
                            while ((len = zipInput.read(buf)) > 0) {
                                zipOutput.write(buf, 0, len);
                            }
                        }
                        zipInput.closeEntry();
                        zipOutput.closeEntry();
                    }
                    zipInput.close();
                    zipOutput.close();
                    FileOutputStream fos = new FileOutputStream(Jar.this.file);
                    fos.write(byteOutput.toByteArray());
                    fos.close();
                    byteOutput.close();
                } else {
                    new File(this.fileEntry).write(text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getText() {
            return this.getText("UTF-8");
        }

        public String getText(String charsetName) {
            try {
                if (this.fileEntry == null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ZipInputStream in = new ZipInputStream(new FileInputStream(Jar.this.file));
                    ZipEntry zipEntry = null;
                    while ((zipEntry = in.getNextEntry()) != null) {
                        int len;
                        if (!zipEntry.getName().equals(this.zipEntry.getName())) continue;
                        byte[] buf = new byte[1024];
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        break block2;
                    }
                    in.close();
                    return out.toString(charsetName);
                }
                return new File(this.fileEntry).getText(charsetName);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return this.getName();
        }
    }
}

