/*
 * Decompiled with CFR 0.152.
 */
package javaxt.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javaxt.io.File;

public class Shell {
    private java.io.File executable;
    private String[] inputs;
    private List<String> output = new LinkedList<String>();
    private List<String> errors = new LinkedList<String>();
    private long startTime;
    private long ellapsedTime;
    private Process process;

    public Shell(java.io.File executable, String[] parameters) {
        this.executable = executable;
        this.ellapsedTime = -1L;
        if (parameters == null) {
            parameters = new String[]{};
        }
        this.inputs = new String[parameters.length + 1];
        this.inputs[0] = executable.toString();
        for (int i = 0; i < parameters.length; ++i) {
            this.inputs[i + 1] = parameters[i];
        }
    }

    public Shell(File executable, String[] parameters) {
        this(executable.toFile(), parameters);
    }

    public Shell(String cmd) {
        int i;
        this.executable = null;
        this.ellapsedTime = -1L;
        String[] arr = cmd.trim().split(" ");
        Vector<String> parameters = new Vector<String>();
        for (i = 0; i < arr.length; ++i) {
            String str = arr[i].trim();
            if (str.length() <= 0) continue;
            parameters.add(str);
        }
        this.inputs = new String[parameters.size()];
        for (i = 0; i < parameters.size(); ++i) {
            this.inputs[i] = (String)parameters.get(i);
        }
        java.io.File file = new java.io.File(this.inputs[0]);
        if (file.exists() && file.isFile()) {
            this.executable = file;
        }
    }

    public Shell(String[] cmdarray) {
        this.executable = null;
        this.ellapsedTime = -1L;
        this.inputs = cmdarray;
        java.io.File file = new java.io.File(this.inputs[0]);
        if (file.exists() && file.isFile()) {
            this.executable = file;
        }
    }

    public List getOutput() {
        return this.output;
    }

    public List getErrors() {
        return this.errors;
    }

    public void run() {
        try {
            this.run(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run(boolean throwExceptions) throws IOException, InterruptedException {
        this.ellapsedTime = -1L;
        this.startTime = new Date().getTime();
        try {
            Runtime runtime = Runtime.getRuntime();
            this.process = this.executable != null ? runtime.exec(this.inputs, null, this.executable.getParentFile()) : runtime.exec(this.inputs);
            StreamReader s1 = new StreamReader(this.output, this.process.getInputStream());
            StreamReader s2 = new StreamReader(this.errors, this.process.getErrorStream());
            s1.start();
            s2.start();
            this.process.waitFor();
            s1.join();
            s2.join();
            this.cleanUp();
        }
        catch (IOException e) {
            if (throwExceptions) {
                throw e;
            }
            return;
        }
        catch (InterruptedException e) {
            if (throwExceptions) {
                throw e;
            }
            return;
        }
        this.ellapsedTime = new Date().getTime() - this.startTime;
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
            this.cleanUp();
            this.ellapsedTime = new Date().getTime() - this.startTime;
        }
    }

    private void cleanUp() {
        try {
            this.process.getInputStream().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.process.getErrorStream().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.process.getOutputStream().close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.process = null;
    }

    public long getEllapsedTime() {
        return this.ellapsedTime;
    }

    private class StreamReader
    implements Runnable {
        List list;
        InputStream is;
        Thread thread;

        public StreamReader(List list, InputStream is) {
            this.list = list;
            this.is = is;
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            try {
                String s;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((s = br.readLine()) != null) {
                    if (this.list == null) continue;
                    this.list.add(s);
                }
                this.list.add(null);
                this.is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

