/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Compiler {
    public static Class compile(String className, String src) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
        ArrayList<CharSequenceJavaFileObject> jfiles = new ArrayList<CharSequenceJavaFileObject>();
        jfiles.add(new CharSequenceJavaFileObject(className, src));
        compiler.getTask(null, fileManager, null, null, null, jfiles).call();
        return fileManager.getClassLoader(null).loadClass(className);
    }

    private static class ClassFileManager
    extends ForwardingJavaFileManager {
        private JavaClassObject jclassObject;

        public ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    byte[] b = ClassFileManager.this.jclassObject.getBytes();
                    return super.defineClass(name, ClassFileManager.this.jclassObject.getBytes(), 0, b.length);
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            this.jclassObject = new JavaClassObject(className, kind);
            return this.jclassObject;
        }
    }

    private static class JavaClassObject
    extends SimpleJavaFileObject {
        protected final ByteArrayOutputStream bos = new ByteArrayOutputStream();

        public JavaClassObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }
    }

    private static class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        private CharSequence content;

        public CharSequenceJavaFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.content = content;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }
    }
}

