/*
 * Decompiled with CFR 0.152.
 */
package javaxt.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Generator<T>
implements Iterable<T> {
    private static final Object DONE = new Object();
    private static final Object EMPTY = new Object();
    private Object drop = EMPTY;
    private Thread th = null;

    public abstract void run();

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    private synchronized Object take() {
        while (this.drop == EMPTY) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        Object temp = this.drop;
        if (this.drop != DONE) {
            this.drop = EMPTY;
        }
        this.notifyAll();
        return temp;
    }

    private synchronized void put(Object value) {
        if (this.drop == DONE) {
            throw new IllegalStateException();
        }
        if (this.drop != EMPTY) {
            throw new IllegalStateException();
        }
        this.drop = value;
        this.notifyAll();
        while (this.drop != EMPTY) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected void yield(T value) {
        this.put(value);
    }

    public synchronized void done() {
        if (this.drop == DONE) {
            throw new IllegalStateException();
        }
        if (this.drop != EMPTY) {
            throw new IllegalStateException();
        }
        this.drop = DONE;
        this.notifyAll();
    }

    private class Iter
    implements Iterator<T>,
    Runnable {
        private Object next = Generator.access$000();

        public Iter() {
            if (Generator.this.th != null) {
                throw new IllegalStateException("Can not run coroutine twice");
            }
            Generator.this.th = new Thread(this);
            Generator.this.th.setDaemon(true);
            Generator.this.th.start();
        }

        @Override
        public void run() {
            Generator.this.run();
            Generator.this.done();
        }

        @Override
        public boolean hasNext() {
            if (this.next == EMPTY) {
                this.next = Generator.this.take();
            }
            return this.next != DONE;
        }

        @Override
        public T next() {
            if (this.next == EMPTY) {
                this.next = Generator.this.take();
            }
            if (this.next == DONE) {
                throw new NoSuchElementException();
            }
            Object temp = this.next;
            this.next = EMPTY;
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void finalize() throws Throwable {
            Generator.this.th.stop();
        }
    }
}

